/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPackageVersionReadmeRequest extends CodeartifactRequest implements
        ToCopyableBuilder<GetPackageVersionReadmeRequest.Builder, GetPackageVersionReadmeRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(GetPackageVersionReadmeRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()).build();

    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainOwner").getter(getter(GetPackageVersionReadmeRequest::domainOwner))
            .setter(setter(Builder::domainOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain-owner").build()).build();

    private static final SdkField<String> REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repository").getter(getter(GetPackageVersionReadmeRequest::repository))
            .setter(setter(Builder::repository))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("repository").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(GetPackageVersionReadmeRequest::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("format").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(GetPackageVersionReadmeRequest::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("namespace").build()).build();

    private static final SdkField<String> PACKAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("package")
            .getter(getter(GetPackageVersionReadmeRequest::packageValue)).setter(setter(Builder::packageValue))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("package").build()).build();

    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("packageVersion").getter(getter(GetPackageVersionReadmeRequest::packageVersion))
            .setter(setter(Builder::packageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            DOMAIN_OWNER_FIELD, REPOSITORY_FIELD, FORMAT_FIELD, NAMESPACE_FIELD, PACKAGE_FIELD, PACKAGE_VERSION_FIELD));

    private final String domain;

    private final String domainOwner;

    private final String repository;

    private final String format;

    private final String namespace;

    private final String packageValue;

    private final String packageVersion;

    private GetPackageVersionReadmeRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainOwner = builder.domainOwner;
        this.repository = builder.repository;
        this.format = builder.format;
        this.namespace = builder.namespace;
        this.packageValue = builder.packageValue;
        this.packageVersion = builder.packageVersion;
    }

    /**
     * <p>
     * The name of the domain that contains the repository that contains the package version with the requested readme
     * file.
     * </p>
     * 
     * @return The name of the domain that contains the repository that contains the package version with the requested
     *         readme file.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
     * </p>
     * 
     * @return The 12-digit account number of the AWS account that owns the domain. It does not include dashes or
     *         spaces.
     */
    public final String domainOwner() {
        return domainOwner;
    }

    /**
     * <p>
     * The repository that contains the package with the requested readme file.
     * </p>
     * 
     * @return The repository that contains the package with the requested readme file.
     */
    public final String repository() {
        return repository;
    }

    /**
     * <p>
     * A format that specifies the type of the package version with the requested readme file. The valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>npm</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pypi</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>maven</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link PackageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return A format that specifies the type of the package version with the requested readme file. The valid values
     *         are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>npm</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pypi</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>maven</code>
     *         </p>
     *         </li>
     * @see PackageFormat
     */
    public final PackageFormat format() {
        return PackageFormat.fromValue(format);
    }

    /**
     * <p>
     * A format that specifies the type of the package version with the requested readme file. The valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>npm</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pypi</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>maven</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link PackageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return A format that specifies the type of the package version with the requested readme file. The valid values
     *         are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>npm</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pypi</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>maven</code>
     *         </p>
     *         </li>
     * @see PackageFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The namespace of the package. The package component that specifies its namespace depends on its type. For
     * example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The namespace of a Maven package is its <code>groupId</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The namespace of an npm package is its <code>scope</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * A Python package does not contain a corresponding component, so Python packages do not have a namespace.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The namespace of the package. The package component that specifies its namespace depends on its type. For
     *         example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The namespace of a Maven package is its <code>groupId</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The namespace of an npm package is its <code>scope</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A Python package does not contain a corresponding component, so Python packages do not have a namespace.
     *         </p>
     *         </li>
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the package version that contains the requested readme file.
     * </p>
     * 
     * @return The name of the package version that contains the requested readme file.
     */
    public final String packageValue() {
        return packageValue;
    }

    /**
     * <p>
     * A string that contains the package version (for example, <code>3.5.2</code>).
     * </p>
     * 
     * @return A string that contains the package version (for example, <code>3.5.2</code>).
     */
    public final String packageVersion() {
        return packageVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(repository());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(packageValue());
        hashCode = 31 * hashCode + Objects.hashCode(packageVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPackageVersionReadmeRequest)) {
            return false;
        }
        GetPackageVersionReadmeRequest other = (GetPackageVersionReadmeRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(domainOwner(), other.domainOwner())
                && Objects.equals(repository(), other.repository()) && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(namespace(), other.namespace()) && Objects.equals(packageValue(), other.packageValue())
                && Objects.equals(packageVersion(), other.packageVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPackageVersionReadmeRequest").add("Domain", domain()).add("DomainOwner", domainOwner())
                .add("Repository", repository()).add("Format", formatAsString()).add("Namespace", namespace())
                .add("Package", packageValue()).add("PackageVersion", packageVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "domainOwner":
            return Optional.ofNullable(clazz.cast(domainOwner()));
        case "repository":
            return Optional.ofNullable(clazz.cast(repository()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "package":
            return Optional.ofNullable(clazz.cast(packageValue()));
        case "packageVersion":
            return Optional.ofNullable(clazz.cast(packageVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPackageVersionReadmeRequest, T> g) {
        return obj -> g.apply((GetPackageVersionReadmeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPackageVersionReadmeRequest> {
        /**
         * <p>
         * The name of the domain that contains the repository that contains the package version with the requested
         * readme file.
         * </p>
         * 
         * @param domain
         *        The name of the domain that contains the repository that contains the package version with the
         *        requested readme file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
         * </p>
         * 
         * @param domainOwner
         *        The 12-digit account number of the AWS account that owns the domain. It does not include dashes or
         *        spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainOwner(String domainOwner);

        /**
         * <p>
         * The repository that contains the package with the requested readme file.
         * </p>
         * 
         * @param repository
         *        The repository that contains the package with the requested readme file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repository(String repository);

        /**
         * <p>
         * A format that specifies the type of the package version with the requested readme file. The valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>npm</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pypi</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>maven</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param format
         *        A format that specifies the type of the package version with the requested readme file. The valid
         *        values are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>npm</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pypi</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>maven</code>
         *        </p>
         *        </li>
         * @see PackageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageFormat
         */
        Builder format(String format);

        /**
         * <p>
         * A format that specifies the type of the package version with the requested readme file. The valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>npm</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pypi</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>maven</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param format
         *        A format that specifies the type of the package version with the requested readme file. The valid
         *        values are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>npm</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pypi</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>maven</code>
         *        </p>
         *        </li>
         * @see PackageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageFormat
         */
        Builder format(PackageFormat format);

        /**
         * <p>
         * The namespace of the package. The package component that specifies its namespace depends on its type. For
         * example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The namespace of a Maven package is its <code>groupId</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The namespace of an npm package is its <code>scope</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * A Python package does not contain a corresponding component, so Python packages do not have a namespace.
         * </p>
         * </li>
         * </ul>
         * 
         * @param namespace
         *        The namespace of the package. The package component that specifies its namespace depends on its type.
         *        For example: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The namespace of a Maven package is its <code>groupId</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The namespace of an npm package is its <code>scope</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A Python package does not contain a corresponding component, so Python packages do not have a
         *        namespace.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the package version that contains the requested readme file.
         * </p>
         * 
         * @param packageValue
         *        The name of the package version that contains the requested readme file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageValue(String packageValue);

        /**
         * <p>
         * A string that contains the package version (for example, <code>3.5.2</code>).
         * </p>
         * 
         * @param packageVersion
         *        A string that contains the package version (for example, <code>3.5.2</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVersion(String packageVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeartifactRequest.BuilderImpl implements Builder {
        private String domain;

        private String domainOwner;

        private String repository;

        private String format;

        private String namespace;

        private String packageValue;

        private String packageVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPackageVersionReadmeRequest model) {
            super(model);
            domain(model.domain);
            domainOwner(model.domainOwner);
            repository(model.repository);
            format(model.format);
            namespace(model.namespace);
            packageValue(model.packageValue);
            packageVersion(model.packageVersion);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getDomainOwner() {
            return domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        public final String getRepository() {
            return repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(PackageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getPackageValue() {
            return packageValue;
        }

        @Override
        public final Builder packageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public final void setPackageValue(String packageValue) {
            this.packageValue = packageValue;
        }

        public final String getPackageVersion() {
            return packageVersion;
        }

        @Override
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPackageVersionReadmeRequest build() {
            return new GetPackageVersionReadmeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
