/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the external connection of a repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RepositoryExternalConnectionInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<RepositoryExternalConnectionInfo.Builder, RepositoryExternalConnectionInfo> {
    private static final SdkField<String> EXTERNAL_CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalConnectionName").getter(getter(RepositoryExternalConnectionInfo::externalConnectionName))
            .setter(setter(Builder::externalConnectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalConnectionName").build())
            .build();

    private static final SdkField<String> PACKAGE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("packageFormat").getter(getter(RepositoryExternalConnectionInfo::packageFormatAsString))
            .setter(setter(Builder::packageFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageFormat").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(RepositoryExternalConnectionInfo::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EXTERNAL_CONNECTION_NAME_FIELD, PACKAGE_FORMAT_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String externalConnectionName;

    private final String packageFormat;

    private final String status;

    private RepositoryExternalConnectionInfo(BuilderImpl builder) {
        this.externalConnectionName = builder.externalConnectionName;
        this.packageFormat = builder.packageFormat;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the external connection associated with a repository.
     * </p>
     * 
     * @return The name of the external connection associated with a repository.
     */
    public final String externalConnectionName() {
        return externalConnectionName;
    }

    /**
     * <p>
     * The package format associated with a repository's external connection. The valid package formats are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>npm</code>: A Node Package Manager (npm) package.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pypi</code>: A Python Package Index (PyPI) package.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packageFormat}
     * will return {@link PackageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #packageFormatAsString}.
     * </p>
     * 
     * @return The package format associated with a repository's external connection. The valid package formats are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>npm</code>: A Node Package Manager (npm) package.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pypi</code>: A Python Package Index (PyPI) package.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR
     *         file.
     *         </p>
     *         </li>
     * @see PackageFormat
     */
    public final PackageFormat packageFormat() {
        return PackageFormat.fromValue(packageFormat);
    }

    /**
     * <p>
     * The package format associated with a repository's external connection. The valid package formats are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>npm</code>: A Node Package Manager (npm) package.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pypi</code>: A Python Package Index (PyPI) package.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packageFormat}
     * will return {@link PackageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #packageFormatAsString}.
     * </p>
     * 
     * @return The package format associated with a repository's external connection. The valid package formats are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>npm</code>: A Node Package Manager (npm) package.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pypi</code>: A Python Package Index (PyPI) package.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR
     *         file.
     *         </p>
     *         </li>
     * @see PackageFormat
     */
    public final String packageFormatAsString() {
        return packageFormat;
    }

    /**
     * <p>
     * The status of the external connection of a repository. There is one valid value, <code>Available</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExternalConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the external connection of a repository. There is one valid value, <code>Available</code>.
     * @see ExternalConnectionStatus
     */
    public final ExternalConnectionStatus status() {
        return ExternalConnectionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the external connection of a repository. There is one valid value, <code>Available</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExternalConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the external connection of a repository. There is one valid value, <code>Available</code>.
     * @see ExternalConnectionStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(externalConnectionName());
        hashCode = 31 * hashCode + Objects.hashCode(packageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryExternalConnectionInfo)) {
            return false;
        }
        RepositoryExternalConnectionInfo other = (RepositoryExternalConnectionInfo) obj;
        return Objects.equals(externalConnectionName(), other.externalConnectionName())
                && Objects.equals(packageFormatAsString(), other.packageFormatAsString())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RepositoryExternalConnectionInfo").add("ExternalConnectionName", externalConnectionName())
                .add("PackageFormat", packageFormatAsString()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "externalConnectionName":
            return Optional.ofNullable(clazz.cast(externalConnectionName()));
        case "packageFormat":
            return Optional.ofNullable(clazz.cast(packageFormatAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositoryExternalConnectionInfo, T> g) {
        return obj -> g.apply((RepositoryExternalConnectionInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RepositoryExternalConnectionInfo> {
        /**
         * <p>
         * The name of the external connection associated with a repository.
         * </p>
         * 
         * @param externalConnectionName
         *        The name of the external connection associated with a repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalConnectionName(String externalConnectionName);

        /**
         * <p>
         * The package format associated with a repository's external connection. The valid package formats are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>npm</code>: A Node Package Manager (npm) package.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pypi</code>: A Python Package Index (PyPI) package.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR
         * file.
         * </p>
         * </li>
         * </ul>
         * 
         * @param packageFormat
         *        The package format associated with a repository's external connection. The valid package formats are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>npm</code>: A Node Package Manager (npm) package.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pypi</code>: A Python Package Index (PyPI) package.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a
         *        JAR file.
         *        </p>
         *        </li>
         * @see PackageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageFormat
         */
        Builder packageFormat(String packageFormat);

        /**
         * <p>
         * The package format associated with a repository's external connection. The valid package formats are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>npm</code>: A Node Package Manager (npm) package.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pypi</code>: A Python Package Index (PyPI) package.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR
         * file.
         * </p>
         * </li>
         * </ul>
         * 
         * @param packageFormat
         *        The package format associated with a repository's external connection. The valid package formats are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>npm</code>: A Node Package Manager (npm) package.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pypi</code>: A Python Package Index (PyPI) package.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a
         *        JAR file.
         *        </p>
         *        </li>
         * @see PackageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageFormat
         */
        Builder packageFormat(PackageFormat packageFormat);

        /**
         * <p>
         * The status of the external connection of a repository. There is one valid value, <code>Available</code>.
         * </p>
         * 
         * @param status
         *        The status of the external connection of a repository. There is one valid value,
         *        <code>Available</code>.
         * @see ExternalConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExternalConnectionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the external connection of a repository. There is one valid value, <code>Available</code>.
         * </p>
         * 
         * @param status
         *        The status of the external connection of a repository. There is one valid value,
         *        <code>Available</code>.
         * @see ExternalConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExternalConnectionStatus
         */
        Builder status(ExternalConnectionStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String externalConnectionName;

        private String packageFormat;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryExternalConnectionInfo model) {
            externalConnectionName(model.externalConnectionName);
            packageFormat(model.packageFormat);
            status(model.status);
        }

        public final String getExternalConnectionName() {
            return externalConnectionName;
        }

        public final void setExternalConnectionName(String externalConnectionName) {
            this.externalConnectionName = externalConnectionName;
        }

        @Override
        @Transient
        public final Builder externalConnectionName(String externalConnectionName) {
            this.externalConnectionName = externalConnectionName;
            return this;
        }

        public final String getPackageFormat() {
            return packageFormat;
        }

        public final void setPackageFormat(String packageFormat) {
            this.packageFormat = packageFormat;
        }

        @Override
        @Transient
        public final Builder packageFormat(String packageFormat) {
            this.packageFormat = packageFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder packageFormat(PackageFormat packageFormat) {
            this.packageFormat(packageFormat == null ? null : packageFormat.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ExternalConnectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public RepositoryExternalConnectionInfo build() {
            return new RepositoryExternalConnectionInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
