/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRepositoryRequest extends CodeartifactRequest implements
        ToCopyableBuilder<CreateRepositoryRequest.Builder, CreateRepositoryRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(CreateRepositoryRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()).build();

    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainOwner").getter(getter(CreateRepositoryRequest::domainOwner)).setter(setter(Builder::domainOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain-owner").build()).build();

    private static final SdkField<String> REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repository").getter(getter(CreateRepositoryRequest::repository)).setter(setter(Builder::repository))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("repository").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateRepositoryRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<UpstreamRepository>> UPSTREAMS_FIELD = SdkField
            .<List<UpstreamRepository>> builder(MarshallingType.LIST)
            .memberName("upstreams")
            .getter(getter(CreateRepositoryRequest::upstreams))
            .setter(setter(Builder::upstreams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreams").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpstreamRepository> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpstreamRepository::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateRepositoryRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            DOMAIN_OWNER_FIELD, REPOSITORY_FIELD, DESCRIPTION_FIELD, UPSTREAMS_FIELD, TAGS_FIELD));

    private final String domain;

    private final String domainOwner;

    private final String repository;

    private final String description;

    private final List<UpstreamRepository> upstreams;

    private final List<Tag> tags;

    private CreateRepositoryRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainOwner = builder.domainOwner;
        this.repository = builder.repository;
        this.description = builder.description;
        this.upstreams = builder.upstreams;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the domain that contains the created repository.
     * </p>
     * 
     * @return The name of the domain that contains the created repository.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
     * </p>
     * 
     * @return The 12-digit account number of the AWS account that owns the domain. It does not include dashes or
     *         spaces.
     */
    public final String domainOwner() {
        return domainOwner;
    }

    /**
     * <p>
     * The name of the repository to create.
     * </p>
     * 
     * @return The name of the repository to create.
     */
    public final String repository() {
        return repository;
    }

    /**
     * <p>
     * A description of the created repository.
     * </p>
     * 
     * @return A description of the created repository.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Upstreams property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUpstreams() {
        return upstreams != null && !(upstreams instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of upstream repositories to associate with the repository. The order of the upstream repositories in the
     * list determines their priority order when AWS CodeArtifact looks for a requested package version. For more
     * information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with
     * upstream repositories</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpstreams} method.
     * </p>
     * 
     * @return A list of upstream repositories to associate with the repository. The order of the upstream repositories
     *         in the list determines their priority order when AWS CodeArtifact looks for a requested package version.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream
     *         repositories</a>.
     */
    public final List<UpstreamRepository> upstreams() {
        return upstreams;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more tag key-value pairs for the repository.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return One or more tag key-value pairs for the repository.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(repository());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasUpstreams() ? upstreams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRepositoryRequest)) {
            return false;
        }
        CreateRepositoryRequest other = (CreateRepositoryRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(domainOwner(), other.domainOwner())
                && Objects.equals(repository(), other.repository()) && Objects.equals(description(), other.description())
                && hasUpstreams() == other.hasUpstreams() && Objects.equals(upstreams(), other.upstreams())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRepositoryRequest").add("Domain", domain()).add("DomainOwner", domainOwner())
                .add("Repository", repository()).add("Description", description())
                .add("Upstreams", hasUpstreams() ? upstreams() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "domainOwner":
            return Optional.ofNullable(clazz.cast(domainOwner()));
        case "repository":
            return Optional.ofNullable(clazz.cast(repository()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "upstreams":
            return Optional.ofNullable(clazz.cast(upstreams()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRepositoryRequest, T> g) {
        return obj -> g.apply((CreateRepositoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRepositoryRequest> {
        /**
         * <p>
         * The name of the domain that contains the created repository.
         * </p>
         * 
         * @param domain
         *        The name of the domain that contains the created repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
         * </p>
         * 
         * @param domainOwner
         *        The 12-digit account number of the AWS account that owns the domain. It does not include dashes or
         *        spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainOwner(String domainOwner);

        /**
         * <p>
         * The name of the repository to create.
         * </p>
         * 
         * @param repository
         *        The name of the repository to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repository(String repository);

        /**
         * <p>
         * A description of the created repository.
         * </p>
         * 
         * @param description
         *        A description of the created repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of upstream repositories to associate with the repository. The order of the upstream repositories in
         * the list determines their priority order when AWS CodeArtifact looks for a requested package version. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream
         * repositories</a>.
         * </p>
         * 
         * @param upstreams
         *        A list of upstream repositories to associate with the repository. The order of the upstream
         *        repositories in the list determines their priority order when AWS CodeArtifact looks for a requested
         *        package version. For more information, see <a
         *        href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream
         *        repositories</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upstreams(Collection<UpstreamRepository> upstreams);

        /**
         * <p>
         * A list of upstream repositories to associate with the repository. The order of the upstream repositories in
         * the list determines their priority order when AWS CodeArtifact looks for a requested package version. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream
         * repositories</a>.
         * </p>
         * 
         * @param upstreams
         *        A list of upstream repositories to associate with the repository. The order of the upstream
         *        repositories in the list determines their priority order when AWS CodeArtifact looks for a requested
         *        package version. For more information, see <a
         *        href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream
         *        repositories</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upstreams(UpstreamRepository... upstreams);

        /**
         * <p>
         * A list of upstream repositories to associate with the repository. The order of the upstream repositories in
         * the list determines their priority order when AWS CodeArtifact looks for a requested package version. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream
         * repositories</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<UpstreamRepository>.Builder}
         * avoiding the need to create one manually via {@link List<UpstreamRepository>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UpstreamRepository>.Builder#build()} is called immediately
         * and its result is passed to {@link #upstreams(List<UpstreamRepository>)}.
         * 
         * @param upstreams
         *        a consumer that will call methods on {@link List<UpstreamRepository>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #upstreams(List<UpstreamRepository>)
         */
        Builder upstreams(Consumer<UpstreamRepository.Builder>... upstreams);

        /**
         * <p>
         * One or more tag key-value pairs for the repository.
         * </p>
         * 
         * @param tags
         *        One or more tag key-value pairs for the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * One or more tag key-value pairs for the repository.
         * </p>
         * 
         * @param tags
         *        One or more tag key-value pairs for the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * One or more tag key-value pairs for the repository.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeartifactRequest.BuilderImpl implements Builder {
        private String domain;

        private String domainOwner;

        private String repository;

        private String description;

        private List<UpstreamRepository> upstreams = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRepositoryRequest model) {
            super(model);
            domain(model.domain);
            domainOwner(model.domainOwner);
            repository(model.repository);
            description(model.description);
            upstreams(model.upstreams);
            tags(model.tags);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getDomainOwner() {
            return domainOwner;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final String getRepository() {
            return repository;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<UpstreamRepository.Builder> getUpstreams() {
            List<UpstreamRepository.Builder> result = UpstreamRepositoryListCopier.copyToBuilder(this.upstreams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpstreams(Collection<UpstreamRepository.BuilderImpl> upstreams) {
            this.upstreams = UpstreamRepositoryListCopier.copyFromBuilder(upstreams);
        }

        @Override
        public final Builder upstreams(Collection<UpstreamRepository> upstreams) {
            this.upstreams = UpstreamRepositoryListCopier.copy(upstreams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder upstreams(UpstreamRepository... upstreams) {
            upstreams(Arrays.asList(upstreams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder upstreams(Consumer<UpstreamRepository.Builder>... upstreams) {
            upstreams(Stream.of(upstreams).map(c -> UpstreamRepository.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRepositoryRequest build() {
            return new CreateRepositoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
