/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the package origin configuration of a package.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackageOriginConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PackageOriginConfiguration.Builder, PackageOriginConfiguration> {
    private static final SdkField<PackageOriginRestrictions> RESTRICTIONS_FIELD = SdkField
            .<PackageOriginRestrictions> builder(MarshallingType.SDK_POJO).memberName("restrictions")
            .getter(getter(PackageOriginConfiguration::restrictions)).setter(setter(Builder::restrictions))
            .constructor(PackageOriginRestrictions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restrictions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESTRICTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final PackageOriginRestrictions restrictions;

    private PackageOriginConfiguration(BuilderImpl builder) {
        this.restrictions = builder.restrictions;
    }

    /**
     * <p>
     * A <code>PackageOriginRestrictions</code> object that contains information about the upstream and publish package
     * origin configuration for the package.
     * </p>
     * 
     * @return A <code>PackageOriginRestrictions</code> object that contains information about the upstream and publish
     *         package origin configuration for the package.
     */
    public final PackageOriginRestrictions restrictions() {
        return restrictions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(restrictions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageOriginConfiguration)) {
            return false;
        }
        PackageOriginConfiguration other = (PackageOriginConfiguration) obj;
        return Objects.equals(restrictions(), other.restrictions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackageOriginConfiguration").add("Restrictions", restrictions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restrictions":
            return Optional.ofNullable(clazz.cast(restrictions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageOriginConfiguration, T> g) {
        return obj -> g.apply((PackageOriginConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackageOriginConfiguration> {
        /**
         * <p>
         * A <code>PackageOriginRestrictions</code> object that contains information about the upstream and publish
         * package origin configuration for the package.
         * </p>
         * 
         * @param restrictions
         *        A <code>PackageOriginRestrictions</code> object that contains information about the upstream and
         *        publish package origin configuration for the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restrictions(PackageOriginRestrictions restrictions);

        /**
         * <p>
         * A <code>PackageOriginRestrictions</code> object that contains information about the upstream and publish
         * package origin configuration for the package.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageOriginRestrictions.Builder}
         * avoiding the need to create one manually via {@link PackageOriginRestrictions#builder()}.
         *
         * When the {@link Consumer} completes, {@link PackageOriginRestrictions.Builder#build()} is called immediately
         * and its result is passed to {@link #restrictions(PackageOriginRestrictions)}.
         * 
         * @param restrictions
         *        a consumer that will call methods on {@link PackageOriginRestrictions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restrictions(PackageOriginRestrictions)
         */
        default Builder restrictions(Consumer<PackageOriginRestrictions.Builder> restrictions) {
            return restrictions(PackageOriginRestrictions.builder().applyMutation(restrictions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PackageOriginRestrictions restrictions;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageOriginConfiguration model) {
            restrictions(model.restrictions);
        }

        public final PackageOriginRestrictions.Builder getRestrictions() {
            return restrictions != null ? restrictions.toBuilder() : null;
        }

        public final void setRestrictions(PackageOriginRestrictions.BuilderImpl restrictions) {
            this.restrictions = restrictions != null ? restrictions.build() : null;
        }

        @Override
        public final Builder restrictions(PackageOriginRestrictions restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        @Override
        public PackageOriginConfiguration build() {
            return new PackageOriginConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
