/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutPackageOriginConfigurationResponse extends CodeartifactResponse implements
        ToCopyableBuilder<PutPackageOriginConfigurationResponse.Builder, PutPackageOriginConfigurationResponse> {
    private static final SdkField<PackageOriginConfiguration> ORIGIN_CONFIGURATION_FIELD = SdkField
            .<PackageOriginConfiguration> builder(MarshallingType.SDK_POJO).memberName("originConfiguration")
            .getter(getter(PutPackageOriginConfigurationResponse::originConfiguration))
            .setter(setter(Builder::originConfiguration)).constructor(PackageOriginConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGIN_CONFIGURATION_FIELD));

    private final PackageOriginConfiguration originConfiguration;

    private PutPackageOriginConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.originConfiguration = builder.originConfiguration;
    }

    /**
     * <p>
     * A <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginConfiguration.html">
     * PackageOriginConfiguration</a> object that describes the origin configuration set for the package. It contains a
     * <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html">
     * PackageOriginRestrictions</a> object that describes how new versions of the package can be introduced to the
     * repository.
     * </p>
     * 
     * @return A <a
     *         href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginConfiguration.html"
     *         >PackageOriginConfiguration</a> object that describes the origin configuration set for the package. It
     *         contains a <a
     *         href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html"
     *         >PackageOriginRestrictions</a> object that describes how new versions of the package can be introduced to
     *         the repository.
     */
    public final PackageOriginConfiguration originConfiguration() {
        return originConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(originConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPackageOriginConfigurationResponse)) {
            return false;
        }
        PutPackageOriginConfigurationResponse other = (PutPackageOriginConfigurationResponse) obj;
        return Objects.equals(originConfiguration(), other.originConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutPackageOriginConfigurationResponse").add("OriginConfiguration", originConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "originConfiguration":
            return Optional.ofNullable(clazz.cast(originConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutPackageOriginConfigurationResponse, T> g) {
        return obj -> g.apply((PutPackageOriginConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutPackageOriginConfigurationResponse> {
        /**
         * <p>
         * A <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginConfiguration.html">
         * PackageOriginConfiguration</a> object that describes the origin configuration set for the package. It
         * contains a <a
         * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html"
         * >PackageOriginRestrictions</a> object that describes how new versions of the package can be introduced to the
         * repository.
         * </p>
         * 
         * @param originConfiguration
         *        A <a href=
         *        "https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginConfiguration.html"
         *        >PackageOriginConfiguration</a> object that describes the origin configuration set for the package. It
         *        contains a <a href=
         *        "https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html"
         *        >PackageOriginRestrictions</a> object that describes how new versions of the package can be introduced
         *        to the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originConfiguration(PackageOriginConfiguration originConfiguration);

        /**
         * <p>
         * A <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginConfiguration.html">
         * PackageOriginConfiguration</a> object that describes the origin configuration set for the package. It
         * contains a <a
         * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html"
         * >PackageOriginRestrictions</a> object that describes how new versions of the package can be introduced to the
         * repository.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageOriginConfiguration.Builder}
         * avoiding the need to create one manually via {@link PackageOriginConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link PackageOriginConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #originConfiguration(PackageOriginConfiguration)}.
         * 
         * @param originConfiguration
         *        a consumer that will call methods on {@link PackageOriginConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #originConfiguration(PackageOriginConfiguration)
         */
        default Builder originConfiguration(Consumer<PackageOriginConfiguration.Builder> originConfiguration) {
            return originConfiguration(PackageOriginConfiguration.builder().applyMutation(originConfiguration).build());
        }
    }

    static final class BuilderImpl extends CodeartifactResponse.BuilderImpl implements Builder {
        private PackageOriginConfiguration originConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutPackageOriginConfigurationResponse model) {
            super(model);
            originConfiguration(model.originConfiguration);
        }

        public final PackageOriginConfiguration.Builder getOriginConfiguration() {
            return originConfiguration != null ? originConfiguration.toBuilder() : null;
        }

        public final void setOriginConfiguration(PackageOriginConfiguration.BuilderImpl originConfiguration) {
            this.originConfiguration = originConfiguration != null ? originConfiguration.build() : null;
        }

        @Override
        public final Builder originConfiguration(PackageOriginConfiguration originConfiguration) {
            this.originConfiguration = originConfiguration;
            return this;
        }

        @Override
        public PutPackageOriginConfigurationResponse build() {
            return new PutPackageOriginConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
