/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.codeartifact.model.AssociateExternalConnectionRequest;
import software.amazon.awssdk.services.codeartifact.model.AssociateExternalConnectionResponse;
import software.amazon.awssdk.services.codeartifact.model.CopyPackageVersionsRequest;
import software.amazon.awssdk.services.codeartifact.model.CopyPackageVersionsResponse;
import software.amazon.awssdk.services.codeartifact.model.CreateDomainRequest;
import software.amazon.awssdk.services.codeartifact.model.CreateDomainResponse;
import software.amazon.awssdk.services.codeartifact.model.CreateRepositoryRequest;
import software.amazon.awssdk.services.codeartifact.model.CreateRepositoryResponse;
import software.amazon.awssdk.services.codeartifact.model.DeleteDomainPermissionsPolicyRequest;
import software.amazon.awssdk.services.codeartifact.model.DeleteDomainPermissionsPolicyResponse;
import software.amazon.awssdk.services.codeartifact.model.DeleteDomainRequest;
import software.amazon.awssdk.services.codeartifact.model.DeleteDomainResponse;
import software.amazon.awssdk.services.codeartifact.model.DeletePackageVersionsRequest;
import software.amazon.awssdk.services.codeartifact.model.DeletePackageVersionsResponse;
import software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryPermissionsPolicyRequest;
import software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryPermissionsPolicyResponse;
import software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryRequest;
import software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryResponse;
import software.amazon.awssdk.services.codeartifact.model.DescribeDomainRequest;
import software.amazon.awssdk.services.codeartifact.model.DescribeDomainResponse;
import software.amazon.awssdk.services.codeartifact.model.DescribePackageRequest;
import software.amazon.awssdk.services.codeartifact.model.DescribePackageResponse;
import software.amazon.awssdk.services.codeartifact.model.DescribePackageVersionRequest;
import software.amazon.awssdk.services.codeartifact.model.DescribePackageVersionResponse;
import software.amazon.awssdk.services.codeartifact.model.DescribeRepositoryRequest;
import software.amazon.awssdk.services.codeartifact.model.DescribeRepositoryResponse;
import software.amazon.awssdk.services.codeartifact.model.DisassociateExternalConnectionRequest;
import software.amazon.awssdk.services.codeartifact.model.DisassociateExternalConnectionResponse;
import software.amazon.awssdk.services.codeartifact.model.DisposePackageVersionsRequest;
import software.amazon.awssdk.services.codeartifact.model.DisposePackageVersionsResponse;
import software.amazon.awssdk.services.codeartifact.model.GetAuthorizationTokenRequest;
import software.amazon.awssdk.services.codeartifact.model.GetAuthorizationTokenResponse;
import software.amazon.awssdk.services.codeartifact.model.GetDomainPermissionsPolicyRequest;
import software.amazon.awssdk.services.codeartifact.model.GetDomainPermissionsPolicyResponse;
import software.amazon.awssdk.services.codeartifact.model.GetPackageVersionAssetRequest;
import software.amazon.awssdk.services.codeartifact.model.GetPackageVersionAssetResponse;
import software.amazon.awssdk.services.codeartifact.model.GetPackageVersionReadmeRequest;
import software.amazon.awssdk.services.codeartifact.model.GetPackageVersionReadmeResponse;
import software.amazon.awssdk.services.codeartifact.model.GetRepositoryEndpointRequest;
import software.amazon.awssdk.services.codeartifact.model.GetRepositoryEndpointResponse;
import software.amazon.awssdk.services.codeartifact.model.GetRepositoryPermissionsPolicyRequest;
import software.amazon.awssdk.services.codeartifact.model.GetRepositoryPermissionsPolicyResponse;
import software.amazon.awssdk.services.codeartifact.model.ListDomainsRequest;
import software.amazon.awssdk.services.codeartifact.model.ListDomainsResponse;
import software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsRequest;
import software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsResponse;
import software.amazon.awssdk.services.codeartifact.model.ListPackageVersionDependenciesRequest;
import software.amazon.awssdk.services.codeartifact.model.ListPackageVersionDependenciesResponse;
import software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsRequest;
import software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsResponse;
import software.amazon.awssdk.services.codeartifact.model.ListPackagesRequest;
import software.amazon.awssdk.services.codeartifact.model.ListPackagesResponse;
import software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainRequest;
import software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainResponse;
import software.amazon.awssdk.services.codeartifact.model.ListRepositoriesRequest;
import software.amazon.awssdk.services.codeartifact.model.ListRepositoriesResponse;
import software.amazon.awssdk.services.codeartifact.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codeartifact.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codeartifact.model.PutDomainPermissionsPolicyRequest;
import software.amazon.awssdk.services.codeartifact.model.PutDomainPermissionsPolicyResponse;
import software.amazon.awssdk.services.codeartifact.model.PutPackageOriginConfigurationRequest;
import software.amazon.awssdk.services.codeartifact.model.PutPackageOriginConfigurationResponse;
import software.amazon.awssdk.services.codeartifact.model.PutRepositoryPermissionsPolicyRequest;
import software.amazon.awssdk.services.codeartifact.model.PutRepositoryPermissionsPolicyResponse;
import software.amazon.awssdk.services.codeartifact.model.TagResourceRequest;
import software.amazon.awssdk.services.codeartifact.model.TagResourceResponse;
import software.amazon.awssdk.services.codeartifact.model.UntagResourceRequest;
import software.amazon.awssdk.services.codeartifact.model.UntagResourceResponse;
import software.amazon.awssdk.services.codeartifact.model.UpdatePackageVersionsStatusRequest;
import software.amazon.awssdk.services.codeartifact.model.UpdatePackageVersionsStatusResponse;
import software.amazon.awssdk.services.codeartifact.model.UpdateRepositoryRequest;
import software.amazon.awssdk.services.codeartifact.model.UpdateRepositoryResponse;
import software.amazon.awssdk.services.codeartifact.paginators.ListDomainsPublisher;
import software.amazon.awssdk.services.codeartifact.paginators.ListPackageVersionAssetsPublisher;
import software.amazon.awssdk.services.codeartifact.paginators.ListPackageVersionsPublisher;
import software.amazon.awssdk.services.codeartifact.paginators.ListPackagesPublisher;
import software.amazon.awssdk.services.codeartifact.paginators.ListRepositoriesInDomainPublisher;
import software.amazon.awssdk.services.codeartifact.paginators.ListRepositoriesPublisher;

/**
 * Service client for accessing CodeArtifact asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * CodeArtifact is a fully managed artifact repository compatible with language-native package managers and build tools
 * such as npm, Apache Maven, pip, and dotnet. You can use CodeArtifact to share packages with development teams and
 * pull packages. Packages can be pulled from both public and CodeArtifact repositories. You can also create an upstream
 * relationship between a CodeArtifact repository and another repository, which effectively merges their contents from
 * the point of view of a package manager client.
 * </p>
 * <p>
 * <b>CodeArtifact Components</b>
 * </p>
 * <p>
 * Use the information in this guide to help you work with the following CodeArtifact components:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>Repository</b>: A CodeArtifact repository contains a set of <a
 * href="https://docs.aws.amazon.com/codeartifact/latest/ug/welcome.html#welcome-concepts-package-version">package
 * versions</a>, each of which maps to a set of assets, or files. Repositories are polyglot, so a single repository can
 * contain packages of any supported type. Each repository exposes endpoints for fetching and publishing packages using
 * tools like the <b> <code>npm</code> </b> CLI, the Maven CLI (<b> <code>mvn</code> </b>), Python CLIs (<b>
 * <code>pip</code> </b> and <code>twine</code>), and NuGet CLIs (<code>nuget</code> and <code>dotnet</code>).
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Domain</b>: Repositories are aggregated into a higher-level entity known as a <i>domain</i>. All package assets
 * and metadata are stored in the domain, but are consumed through repositories. A given package asset, such as a Maven
 * JAR file, is stored once per domain, no matter how many repositories it's present in. All of the assets and metadata
 * in a domain are encrypted with the same customer master key (CMK) stored in Key Management Service (KMS).
 * </p>
 * <p>
 * Each repository is a member of a single domain and can't be moved to a different domain.
 * </p>
 * <p>
 * The domain allows organizational policy to be applied across multiple repositories, such as which accounts can access
 * repositories in the domain, and which public repositories can be used as sources of packages.
 * </p>
 * <p>
 * Although an organization can have multiple domains, we recommend a single production domain that contains all
 * published artifacts so that teams can find and share packages across their organization.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Package</b>: A <i>package</i> is a bundle of software and the metadata required to resolve dependencies and
 * install the software. CodeArtifact supports <a
 * href="https://docs.aws.amazon.com/codeartifact/latest/ug/using-npm.html">npm</a>, <a
 * href="https://docs.aws.amazon.com/codeartifact/latest/ug/using-python.html">PyPI</a>, <a
 * href="https://docs.aws.amazon.com/codeartifact/latest/ug/using-maven">Maven</a>, and <a
 * href="https://docs.aws.amazon.com/codeartifact/latest/ug/using-nuget">NuGet</a> package formats.
 * </p>
 * <p>
 * In CodeArtifact, a package consists of:
 * </p>
 * <ul>
 * <li>
 * <p>
 * A <i>name</i> (for example, <code>webpack</code> is the name of a popular npm package)
 * </p>
 * </li>
 * <li>
 * <p>
 * An optional namespace (for example, <code>@types</code> in <code>@types/node</code>)
 * </p>
 * </li>
 * <li>
 * <p>
 * A set of versions (for example, <code>1.0.0</code>, <code>1.0.1</code>, <code>1.0.2</code>, etc.)
 * </p>
 * </li>
 * <li>
 * <p>
 * Package-level metadata (for example, npm tags)
 * </p>
 * </li>
 * </ul>
 * </li>
 * <li>
 * <p>
 * <b>Package version</b>: A version of a package, such as <code>@types/node 12.6.9</code>. The version number format
 * and semantics vary for different package formats. For example, npm package versions must conform to the <a
 * href="https://semver.org/">Semantic Versioning specification</a>. In CodeArtifact, a package version consists of the
 * version identifier, metadata at the package version level, and a set of assets.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Upstream repository</b>: One repository is <i>upstream</i> of another when the package versions in it can be
 * accessed from the repository endpoint of the downstream repository, effectively merging the contents of the two
 * repositories from the point of view of a client. CodeArtifact allows creating an upstream relationship between two
 * repositories.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Asset</b>: An individual file stored in CodeArtifact associated with a package version, such as an npm
 * <code>.tgz</code> file or Maven POM and JAR files.
 * </p>
 * </li>
 * </ul>
 * <p>
 * CodeArtifact supports these operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>AssociateExternalConnection</code>: Adds an existing external connection to a repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>CopyPackageVersions</code>: Copies package versions from one repository to another repository in the same
 * domain.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>CreateDomain</code>: Creates a domain
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>CreateRepository</code>: Creates a CodeArtifact repository in a domain.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DeleteDomain</code>: Deletes a domain. You cannot delete a domain that contains repositories.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DeleteDomainPermissionsPolicy</code>: Deletes the resource policy that is set on a domain.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DeletePackageVersions</code>: Deletes versions of a package. After a package has been deleted, it can be
 * republished, but its assets and metadata cannot be restored because they have been permanently removed from storage.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DeleteRepository</code>: Deletes a repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DeleteRepositoryPermissionsPolicy</code>: Deletes the resource policy that is set on a repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DescribeDomain</code>: Returns a <code>DomainDescription</code> object that contains information about the
 * requested domain.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DescribePackage</code>: Returns a <a
 * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDescription.html"
 * >PackageDescription</a> object that contains details about a package.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DescribePackageVersion</code>: Returns a <a
 * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html"
 * >PackageVersionDescription</a> object that contains details about a package version.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DescribeRepository</code>: Returns a <code>RepositoryDescription</code> object that contains detailed
 * information about the requested repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DisposePackageVersions</code>: Disposes versions of a package. A package version with the status
 * <code>Disposed</code> cannot be restored because they have been permanently removed from storage.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DisassociateExternalConnection</code>: Removes an existing external connection from a repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>GetAuthorizationToken</code>: Generates a temporary authorization token for accessing repositories in the
 * domain. The token expires the authorization period has passed. The default authorization period is 12 hours and can
 * be customized to any length with a maximum of 12 hours.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>GetDomainPermissionsPolicy</code>: Returns the policy of a resource that is attached to the specified domain.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>GetPackageVersionAsset</code>: Returns the contents of an asset that is in a package version.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>GetPackageVersionReadme</code>: Gets the readme file or descriptive text for a package version.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>GetRepositoryEndpoint</code>: Returns the endpoint of a repository for a specific package format. A repository
 * has one endpoint for each package format:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>maven</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>npm</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>nuget</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>pypi</code>
 * </p>
 * </li>
 * </ul>
 * </li>
 * <li>
 * <p>
 * <code>GetRepositoryPermissionsPolicy</code>: Returns the resource policy that is set on a repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ListDomains</code>: Returns a list of <code>DomainSummary</code> objects. Each returned
 * <code>DomainSummary</code> object contains information about a domain.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ListPackages</code>: Lists the packages in a repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ListPackageVersionAssets</code>: Lists the assets for a given package version.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ListPackageVersionDependencies</code>: Returns a list of the direct dependencies for a package version.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ListPackageVersions</code>: Returns a list of package versions for a specified package in a repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ListRepositories</code>: Returns a list of repositories owned by the Amazon Web Services account that called
 * this method.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ListRepositoriesInDomain</code>: Returns a list of the repositories in a domain.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>PutDomainPermissionsPolicy</code>: Attaches a resource policy to a domain.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>PutPackageOriginConfiguration</code>: Sets the package origin configuration for a package, which determine how
 * new versions of the package can be added to a specific repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>PutRepositoryPermissionsPolicy</code>: Sets the resource policy on a repository that specifies permissions to
 * access it.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>UpdatePackageVersionsStatus</code>: Updates the status of one or more versions of a package.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>UpdateRepository</code>: Updates the properties of a repository.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CodeartifactAsyncClient extends SdkClient {
    String SERVICE_NAME = "codeartifact";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "codeartifact";

    /**
     * Create a {@link CodeartifactAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CodeartifactAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CodeartifactAsyncClient}.
     */
    static CodeartifactAsyncClientBuilder builder() {
        return new DefaultCodeartifactAsyncClientBuilder();
    }

    /**
     * <p>
     * Adds an existing external connection to a repository. One external connection is allowed per repository.
     * </p>
     * <note>
     * <p>
     * A repository can have one or more upstream repositories, or an external connection.
     * </p>
     * </note>
     *
     * @param associateExternalConnectionRequest
     * @return A Java Future containing the result of the AssociateExternalConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ServiceQuotaExceededException The operation did not succeed because it would have exceeded a service
     *         limit for your account.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.AssociateExternalConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/AssociateExternalConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateExternalConnectionResponse> associateExternalConnection(
            AssociateExternalConnectionRequest associateExternalConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an existing external connection to a repository. One external connection is allowed per repository.
     * </p>
     * <note>
     * <p>
     * A repository can have one or more upstream repositories, or an external connection.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateExternalConnectionRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateExternalConnectionRequest#builder()}
     * </p>
     *
     * @param associateExternalConnectionRequest
     *        A {@link Consumer} that will call methods on {@link AssociateExternalConnectionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AssociateExternalConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ServiceQuotaExceededException The operation did not succeed because it would have exceeded a service
     *         limit for your account.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.AssociateExternalConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/AssociateExternalConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateExternalConnectionResponse> associateExternalConnection(
            Consumer<AssociateExternalConnectionRequest.Builder> associateExternalConnectionRequest) {
        return associateExternalConnection(AssociateExternalConnectionRequest.builder()
                .applyMutation(associateExternalConnectionRequest).build());
    }

    /**
     * <p>
     * Copies package versions from one repository to another repository in the same domain.
     * </p>
     * <note>
     * <p>
     * You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
     * </p>
     * </note>
     *
     * @param copyPackageVersionsRequest
     * @return A Java Future containing the result of the CopyPackageVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ServiceQuotaExceededException The operation did not succeed because it would have exceeded a service
     *         limit for your account.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.CopyPackageVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/CopyPackageVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CopyPackageVersionsResponse> copyPackageVersions(
            CopyPackageVersionsRequest copyPackageVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies package versions from one repository to another repository in the same domain.
     * </p>
     * <note>
     * <p>
     * You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyPackageVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link CopyPackageVersionsRequest#builder()}
     * </p>
     *
     * @param copyPackageVersionsRequest
     *        A {@link Consumer} that will call methods on {@link CopyPackageVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CopyPackageVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ServiceQuotaExceededException The operation did not succeed because it would have exceeded a service
     *         limit for your account.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.CopyPackageVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/CopyPackageVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CopyPackageVersionsResponse> copyPackageVersions(
            Consumer<CopyPackageVersionsRequest.Builder> copyPackageVersionsRequest) {
        return copyPackageVersions(CopyPackageVersionsRequest.builder().applyMutation(copyPackageVersionsRequest).build());
    }

    /**
     * <p>
     * Creates a domain. CodeArtifact <i>domains</i> make it easier to manage multiple repositories across an
     * organization. You can use a domain to apply permissions across many repositories owned by different Amazon Web
     * Services accounts. An asset is stored only once in a domain, even if it's in multiple repositories.
     * </p>
     * <p>
     * Although you can have multiple domains, we recommend a single production domain that contains all published
     * artifacts so that your development teams can find and share packages. You can use a second pre-production domain
     * to test changes to the production domain configuration.
     * </p>
     *
     * @param createDomainRequest
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ServiceQuotaExceededException The operation did not succeed because it would have exceeded a service
     *         limit for your account.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDomainResponse> createDomain(CreateDomainRequest createDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a domain. CodeArtifact <i>domains</i> make it easier to manage multiple repositories across an
     * organization. You can use a domain to apply permissions across many repositories owned by different Amazon Web
     * Services accounts. An asset is stored only once in a domain, even if it's in multiple repositories.
     * </p>
     * <p>
     * Although you can have multiple domains, we recommend a single production domain that contains all published
     * artifacts so that your development teams can find and share packages. You can use a second pre-production domain
     * to test changes to the production domain configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDomainRequest#builder()}
     * </p>
     *
     * @param createDomainRequest
     *        A {@link Consumer} that will call methods on {@link CreateDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ServiceQuotaExceededException The operation did not succeed because it would have exceeded a service
     *         limit for your account.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDomainResponse> createDomain(Consumer<CreateDomainRequest.Builder> createDomainRequest) {
        return createDomain(CreateDomainRequest.builder().applyMutation(createDomainRequest).build());
    }

    /**
     * <p>
     * Creates a repository.
     * </p>
     *
     * @param createRepositoryRequest
     * @return A Java Future containing the result of the CreateRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ServiceQuotaExceededException The operation did not succeed because it would have exceeded a service
     *         limit for your account.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.CreateRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/CreateRepository" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateRepositoryResponse> createRepository(CreateRepositoryRequest createRepositoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRepositoryRequest.Builder} avoiding the need
     * to create one manually via {@link CreateRepositoryRequest#builder()}
     * </p>
     *
     * @param createRepositoryRequest
     *        A {@link Consumer} that will call methods on {@link CreateRepositoryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ServiceQuotaExceededException The operation did not succeed because it would have exceeded a service
     *         limit for your account.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.CreateRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/CreateRepository" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateRepositoryResponse> createRepository(
            Consumer<CreateRepositoryRequest.Builder> createRepositoryRequest) {
        return createRepository(CreateRepositoryRequest.builder().applyMutation(createRepositoryRequest).build());
    }

    /**
     * <p>
     * Deletes a domain. You cannot delete a domain that contains repositories. If you want to delete a domain with
     * repositories, first delete its repositories.
     * </p>
     *
     * @param deleteDomainRequest
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDomainResponse> deleteDomain(DeleteDomainRequest deleteDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a domain. You cannot delete a domain that contains repositories. If you want to delete a domain with
     * repositories, first delete its repositories.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDomainRequest#builder()}
     * </p>
     *
     * @param deleteDomainRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDomainResponse> deleteDomain(Consumer<DeleteDomainRequest.Builder> deleteDomainRequest) {
        return deleteDomain(DeleteDomainRequest.builder().applyMutation(deleteDomainRequest).build());
    }

    /**
     * <p>
     * Deletes the resource policy set on a domain.
     * </p>
     *
     * @param deleteDomainPermissionsPolicyRequest
     * @return A Java Future containing the result of the DeleteDomainPermissionsPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.DeleteDomainPermissionsPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeleteDomainPermissionsPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDomainPermissionsPolicyResponse> deleteDomainPermissionsPolicy(
            DeleteDomainPermissionsPolicyRequest deleteDomainPermissionsPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the resource policy set on a domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainPermissionsPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteDomainPermissionsPolicyRequest#builder()}
     * </p>
     *
     * @param deleteDomainPermissionsPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDomainPermissionsPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteDomainPermissionsPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.DeleteDomainPermissionsPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeleteDomainPermissionsPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDomainPermissionsPolicyResponse> deleteDomainPermissionsPolicy(
            Consumer<DeleteDomainPermissionsPolicyRequest.Builder> deleteDomainPermissionsPolicyRequest) {
        return deleteDomainPermissionsPolicy(DeleteDomainPermissionsPolicyRequest.builder()
                .applyMutation(deleteDomainPermissionsPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes one or more versions of a package. A deleted package version cannot be restored in your repository. If
     * you want to remove a package version from your repository and be able to restore it later, set its status to
     * <code>Archived</code>. Archived packages cannot be downloaded from a repository and don't show up with list
     * package APIs (for example, <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html"
     * >ListackageVersions</a>), but you can restore them using <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_UpdatePackageVersionsStatus.html"
     * >UpdatePackageVersionsStatus</a>.
     * </p>
     *
     * @param deletePackageVersionsRequest
     * @return A Java Future containing the result of the DeletePackageVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.DeletePackageVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeletePackageVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePackageVersionsResponse> deletePackageVersions(
            DeletePackageVersionsRequest deletePackageVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more versions of a package. A deleted package version cannot be restored in your repository. If
     * you want to remove a package version from your repository and be able to restore it later, set its status to
     * <code>Archived</code>. Archived packages cannot be downloaded from a repository and don't show up with list
     * package APIs (for example, <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html"
     * >ListackageVersions</a>), but you can restore them using <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_UpdatePackageVersionsStatus.html"
     * >UpdatePackageVersionsStatus</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePackageVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePackageVersionsRequest#builder()}
     * </p>
     *
     * @param deletePackageVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DeletePackageVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePackageVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.DeletePackageVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeletePackageVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePackageVersionsResponse> deletePackageVersions(
            Consumer<DeletePackageVersionsRequest.Builder> deletePackageVersionsRequest) {
        return deletePackageVersions(DeletePackageVersionsRequest.builder().applyMutation(deletePackageVersionsRequest).build());
    }

    /**
     * <p>
     * Deletes a repository.
     * </p>
     *
     * @param deleteRepositoryRequest
     * @return A Java Future containing the result of the DeleteRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.DeleteRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeleteRepository" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteRepositoryResponse> deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRepositoryRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteRepositoryRequest#builder()}
     * </p>
     *
     * @param deleteRepositoryRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRepositoryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.DeleteRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeleteRepository" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteRepositoryResponse> deleteRepository(
            Consumer<DeleteRepositoryRequest.Builder> deleteRepositoryRequest) {
        return deleteRepository(DeleteRepositoryRequest.builder().applyMutation(deleteRepositoryRequest).build());
    }

    /**
     * <p>
     * Deletes the resource policy that is set on a repository. After a resource policy is deleted, the permissions
     * allowed and denied by the deleted policy are removed. The effect of deleting a resource policy might not be
     * immediate.
     * </p>
     * <important>
     * <p>
     * Use <code>DeleteRepositoryPermissionsPolicy</code> with caution. After a policy is deleted, Amazon Web Services
     * users, roles, and accounts lose permissions to perform the repository actions granted by the deleted policy.
     * </p>
     * </important>
     *
     * @param deleteRepositoryPermissionsPolicyRequest
     * @return A Java Future containing the result of the DeleteRepositoryPermissionsPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.DeleteRepositoryPermissionsPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeleteRepositoryPermissionsPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRepositoryPermissionsPolicyResponse> deleteRepositoryPermissionsPolicy(
            DeleteRepositoryPermissionsPolicyRequest deleteRepositoryPermissionsPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the resource policy that is set on a repository. After a resource policy is deleted, the permissions
     * allowed and denied by the deleted policy are removed. The effect of deleting a resource policy might not be
     * immediate.
     * </p>
     * <important>
     * <p>
     * Use <code>DeleteRepositoryPermissionsPolicy</code> with caution. After a policy is deleted, Amazon Web Services
     * users, roles, and accounts lose permissions to perform the repository actions granted by the deleted policy.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRepositoryPermissionsPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRepositoryPermissionsPolicyRequest#builder()}
     * </p>
     *
     * @param deleteRepositoryPermissionsPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRepositoryPermissionsPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteRepositoryPermissionsPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.DeleteRepositoryPermissionsPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DeleteRepositoryPermissionsPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRepositoryPermissionsPolicyResponse> deleteRepositoryPermissionsPolicy(
            Consumer<DeleteRepositoryPermissionsPolicyRequest.Builder> deleteRepositoryPermissionsPolicyRequest) {
        return deleteRepositoryPermissionsPolicy(DeleteRepositoryPermissionsPolicyRequest.builder()
                .applyMutation(deleteRepositoryPermissionsPolicyRequest).build());
    }

    /**
     * <p>
     * Returns a <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainDescription.html">
     * DomainDescription</a> object that contains information about the requested domain.
     * </p>
     *
     * @param describeDomainRequest
     * @return A Java Future containing the result of the DescribeDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.DescribeDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DescribeDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDomainResponse> describeDomain(DescribeDomainRequest describeDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainDescription.html">
     * DomainDescription</a> object that contains information about the requested domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeDomainRequest#builder()}
     * </p>
     *
     * @param describeDomainRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.DescribeDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DescribeDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDomainResponse> describeDomain(Consumer<DescribeDomainRequest.Builder> describeDomainRequest) {
        return describeDomain(DescribeDomainRequest.builder().applyMutation(describeDomainRequest).build());
    }

    /**
     * <p>
     * Returns a <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDescription.html">
     * PackageDescription</a> object that contains information about the requested package.
     * </p>
     *
     * @param describePackageRequest
     * @return A Java Future containing the result of the DescribePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.DescribePackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DescribePackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePackageResponse> describePackage(DescribePackageRequest describePackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDescription.html">
     * PackageDescription</a> object that contains information about the requested package.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePackageRequest.Builder} avoiding the need
     * to create one manually via {@link DescribePackageRequest#builder()}
     * </p>
     *
     * @param describePackageRequest
     *        A {@link Consumer} that will call methods on {@link DescribePackageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.DescribePackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DescribePackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePackageResponse> describePackage(
            Consumer<DescribePackageRequest.Builder> describePackageRequest) {
        return describePackage(DescribePackageRequest.builder().applyMutation(describePackageRequest).build());
    }

    /**
     * <p>
     * Returns a <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html"
     * >PackageVersionDescription</a> object that contains information about the requested package version.
     * </p>
     *
     * @param describePackageVersionRequest
     * @return A Java Future containing the result of the DescribePackageVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.DescribePackageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DescribePackageVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePackageVersionResponse> describePackageVersion(
            DescribePackageVersionRequest describePackageVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html"
     * >PackageVersionDescription</a> object that contains information about the requested package version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePackageVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePackageVersionRequest#builder()}
     * </p>
     *
     * @param describePackageVersionRequest
     *        A {@link Consumer} that will call methods on {@link DescribePackageVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePackageVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.DescribePackageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DescribePackageVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePackageVersionResponse> describePackageVersion(
            Consumer<DescribePackageVersionRequest.Builder> describePackageVersionRequest) {
        return describePackageVersion(DescribePackageVersionRequest.builder().applyMutation(describePackageVersionRequest)
                .build());
    }

    /**
     * <p>
     * Returns a <code>RepositoryDescription</code> object that contains detailed information about the requested
     * repository.
     * </p>
     *
     * @param describeRepositoryRequest
     * @return A Java Future containing the result of the DescribeRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.DescribeRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DescribeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRepositoryResponse> describeRepository(DescribeRepositoryRequest describeRepositoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a <code>RepositoryDescription</code> object that contains detailed information about the requested
     * repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRepositoryRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRepositoryRequest#builder()}
     * </p>
     *
     * @param describeRepositoryRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRepositoryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.DescribeRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DescribeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRepositoryResponse> describeRepository(
            Consumer<DescribeRepositoryRequest.Builder> describeRepositoryRequest) {
        return describeRepository(DescribeRepositoryRequest.builder().applyMutation(describeRepositoryRequest).build());
    }

    /**
     * <p>
     * Removes an existing external connection from a repository.
     * </p>
     *
     * @param disassociateExternalConnectionRequest
     * @return A Java Future containing the result of the DisassociateExternalConnection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ServiceQuotaExceededException The operation did not succeed because it would have exceeded a service
     *         limit for your account.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.DisassociateExternalConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DisassociateExternalConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateExternalConnectionResponse> disassociateExternalConnection(
            DisassociateExternalConnectionRequest disassociateExternalConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an existing external connection from a repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateExternalConnectionRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateExternalConnectionRequest#builder()}
     * </p>
     *
     * @param disassociateExternalConnectionRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateExternalConnectionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateExternalConnection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ServiceQuotaExceededException The operation did not succeed because it would have exceeded a service
     *         limit for your account.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.DisassociateExternalConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DisassociateExternalConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateExternalConnectionResponse> disassociateExternalConnection(
            Consumer<DisassociateExternalConnectionRequest.Builder> disassociateExternalConnectionRequest) {
        return disassociateExternalConnection(DisassociateExternalConnectionRequest.builder()
                .applyMutation(disassociateExternalConnectionRequest).build());
    }

    /**
     * <p>
     * Deletes the assets in package versions and sets the package versions' status to <code>Disposed</code>. A disposed
     * package version cannot be restored in your repository because its assets are deleted.
     * </p>
     * <p>
     * To view all disposed package versions in a repository, use <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html"
     * >ListPackageVersions</a> and set the <a href=
     * "https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html#API_ListPackageVersions_RequestSyntax"
     * >status</a> parameter to <code>Disposed</code>.
     * </p>
     * <p>
     * To view information about a disposed package version, use <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DescribePackageVersion.html"
     * >DescribePackageVersion</a>.
     * </p>
     *
     * @param disposePackageVersionsRequest
     * @return A Java Future containing the result of the DisposePackageVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.DisposePackageVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DisposePackageVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisposePackageVersionsResponse> disposePackageVersions(
            DisposePackageVersionsRequest disposePackageVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the assets in package versions and sets the package versions' status to <code>Disposed</code>. A disposed
     * package version cannot be restored in your repository because its assets are deleted.
     * </p>
     * <p>
     * To view all disposed package versions in a repository, use <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html"
     * >ListPackageVersions</a> and set the <a href=
     * "https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html#API_ListPackageVersions_RequestSyntax"
     * >status</a> parameter to <code>Disposed</code>.
     * </p>
     * <p>
     * To view information about a disposed package version, use <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DescribePackageVersion.html"
     * >DescribePackageVersion</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisposePackageVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link DisposePackageVersionsRequest#builder()}
     * </p>
     *
     * @param disposePackageVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DisposePackageVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisposePackageVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.DisposePackageVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/DisposePackageVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisposePackageVersionsResponse> disposePackageVersions(
            Consumer<DisposePackageVersionsRequest.Builder> disposePackageVersionsRequest) {
        return disposePackageVersions(DisposePackageVersionsRequest.builder().applyMutation(disposePackageVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Generates a temporary authorization token for accessing repositories in the domain. This API requires the
     * <code>codeartifact:GetAuthorizationToken</code> and <code>sts:GetServiceBearerToken</code> permissions. For more
     * information about authorization tokens, see <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/ug/tokens-authentication.html">CodeArtifact authentication
     * and tokens</a>.
     * </p>
     * <note>
     * <p>
     * CodeArtifact authorization tokens are valid for a period of 12 hours when created with the <code>login</code>
     * command. You can call <code>login</code> periodically to refresh the token. When you create an authorization
     * token with the <code>GetAuthorizationToken</code> API, you can set a custom authorization period, up to a maximum
     * of 12 hours, with the <code>durationSeconds</code> parameter.
     * </p>
     * <p>
     * The authorization period begins after <code>login</code> or <code>GetAuthorizationToken</code> is called. If
     * <code>login</code> or <code>GetAuthorizationToken</code> is called while assuming a role, the token lifetime is
     * independent of the maximum session duration of the role. For example, if you call <code>sts assume-role</code>
     * and specify a session duration of 15 minutes, then generate a CodeArtifact authorization token, the token will be
     * valid for the full authorization period even though this is longer than the 15-minute session duration.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html">Using IAM Roles</a> for more
     * information on controlling session duration.
     * </p>
     * </note>
     *
     * @param getAuthorizationTokenRequest
     * @return A Java Future containing the result of the GetAuthorizationToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.GetAuthorizationToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetAuthorizationToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAuthorizationTokenResponse> getAuthorizationToken(
            GetAuthorizationTokenRequest getAuthorizationTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a temporary authorization token for accessing repositories in the domain. This API requires the
     * <code>codeartifact:GetAuthorizationToken</code> and <code>sts:GetServiceBearerToken</code> permissions. For more
     * information about authorization tokens, see <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/ug/tokens-authentication.html">CodeArtifact authentication
     * and tokens</a>.
     * </p>
     * <note>
     * <p>
     * CodeArtifact authorization tokens are valid for a period of 12 hours when created with the <code>login</code>
     * command. You can call <code>login</code> periodically to refresh the token. When you create an authorization
     * token with the <code>GetAuthorizationToken</code> API, you can set a custom authorization period, up to a maximum
     * of 12 hours, with the <code>durationSeconds</code> parameter.
     * </p>
     * <p>
     * The authorization period begins after <code>login</code> or <code>GetAuthorizationToken</code> is called. If
     * <code>login</code> or <code>GetAuthorizationToken</code> is called while assuming a role, the token lifetime is
     * independent of the maximum session duration of the role. For example, if you call <code>sts assume-role</code>
     * and specify a session duration of 15 minutes, then generate a CodeArtifact authorization token, the token will be
     * valid for the full authorization period even though this is longer than the 15-minute session duration.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html">Using IAM Roles</a> for more
     * information on controlling session duration.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAuthorizationTokenRequest.Builder} avoiding the
     * need to create one manually via {@link GetAuthorizationTokenRequest#builder()}
     * </p>
     *
     * @param getAuthorizationTokenRequest
     *        A {@link Consumer} that will call methods on {@link GetAuthorizationTokenRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAuthorizationToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.GetAuthorizationToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetAuthorizationToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAuthorizationTokenResponse> getAuthorizationToken(
            Consumer<GetAuthorizationTokenRequest.Builder> getAuthorizationTokenRequest) {
        return getAuthorizationToken(GetAuthorizationTokenRequest.builder().applyMutation(getAuthorizationTokenRequest).build());
    }

    /**
     * <p>
     * Returns the resource policy attached to the specified domain.
     * </p>
     * <note>
     * <p>
     * The policy is a resource-based policy, not an identity-based policy. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html">Identity-based
     * policies and resource-based policies </a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     *
     * @param getDomainPermissionsPolicyRequest
     * @return A Java Future containing the result of the GetDomainPermissionsPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.GetDomainPermissionsPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetDomainPermissionsPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDomainPermissionsPolicyResponse> getDomainPermissionsPolicy(
            GetDomainPermissionsPolicyRequest getDomainPermissionsPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the resource policy attached to the specified domain.
     * </p>
     * <note>
     * <p>
     * The policy is a resource-based policy, not an identity-based policy. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html">Identity-based
     * policies and resource-based policies </a> in the <i>IAM User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainPermissionsPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link GetDomainPermissionsPolicyRequest#builder()}
     * </p>
     *
     * @param getDomainPermissionsPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetDomainPermissionsPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDomainPermissionsPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.GetDomainPermissionsPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetDomainPermissionsPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDomainPermissionsPolicyResponse> getDomainPermissionsPolicy(
            Consumer<GetDomainPermissionsPolicyRequest.Builder> getDomainPermissionsPolicyRequest) {
        return getDomainPermissionsPolicy(GetDomainPermissionsPolicyRequest.builder()
                .applyMutation(getDomainPermissionsPolicyRequest).build());
    }

    /**
     * <p>
     * Returns an asset (or file) that is in a package. For example, for a Maven package version, use
     * <code>GetPackageVersionAsset</code> to download a <code>JAR</code> file, a <code>POM</code> file, or any other
     * assets in the package version.
     * </p>
     *
     * @param getPackageVersionAssetRequest
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows '
     *        <p>
     *        The binary file, or asset, that is downloaded.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.GetPackageVersionAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetPackageVersionAsset"
     *      target="_top">AWS API Documentation</a>
     */
    default <ReturnT> CompletableFuture<ReturnT> getPackageVersionAsset(
            GetPackageVersionAssetRequest getPackageVersionAssetRequest,
            AsyncResponseTransformer<GetPackageVersionAssetResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an asset (or file) that is in a package. For example, for a Maven package version, use
     * <code>GetPackageVersionAsset</code> to download a <code>JAR</code> file, a <code>POM</code> file, or any other
     * assets in the package version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPackageVersionAssetRequest.Builder} avoiding the
     * need to create one manually via {@link GetPackageVersionAssetRequest#builder()}
     * </p>
     *
     * @param getPackageVersionAssetRequest
     *        A {@link Consumer} that will call methods on {@link GetPackageVersionAssetRequest.Builder} to create a
     *        request.
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows '
     *        <p>
     *        The binary file, or asset, that is downloaded.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.GetPackageVersionAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetPackageVersionAsset"
     *      target="_top">AWS API Documentation</a>
     */
    default <ReturnT> CompletableFuture<ReturnT> getPackageVersionAsset(
            Consumer<GetPackageVersionAssetRequest.Builder> getPackageVersionAssetRequest,
            AsyncResponseTransformer<GetPackageVersionAssetResponse, ReturnT> asyncResponseTransformer) {
        return getPackageVersionAsset(GetPackageVersionAssetRequest.builder().applyMutation(getPackageVersionAssetRequest)
                .build(), asyncResponseTransformer);
    }

    /**
     * <p>
     * Returns an asset (or file) that is in a package. For example, for a Maven package version, use
     * <code>GetPackageVersionAsset</code> to download a <code>JAR</code> file, a <code>POM</code> file, or any other
     * assets in the package version.
     * </p>
     *
     * @param getPackageVersionAssetRequest
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        The binary file, or asset, that is downloaded.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.GetPackageVersionAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetPackageVersionAsset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPackageVersionAssetResponse> getPackageVersionAsset(
            GetPackageVersionAssetRequest getPackageVersionAssetRequest, Path destinationPath) {
        return getPackageVersionAsset(getPackageVersionAssetRequest, AsyncResponseTransformer.toFile(destinationPath));
    }

    /**
     * <p>
     * Returns an asset (or file) that is in a package. For example, for a Maven package version, use
     * <code>GetPackageVersionAsset</code> to download a <code>JAR</code> file, a <code>POM</code> file, or any other
     * assets in the package version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPackageVersionAssetRequest.Builder} avoiding the
     * need to create one manually via {@link GetPackageVersionAssetRequest#builder()}
     * </p>
     *
     * @param getPackageVersionAssetRequest
     *        A {@link Consumer} that will call methods on {@link GetPackageVersionAssetRequest.Builder} to create a
     *        request.
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        The binary file, or asset, that is downloaded.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.GetPackageVersionAsset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetPackageVersionAsset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPackageVersionAssetResponse> getPackageVersionAsset(
            Consumer<GetPackageVersionAssetRequest.Builder> getPackageVersionAssetRequest, Path destinationPath) {
        return getPackageVersionAsset(GetPackageVersionAssetRequest.builder().applyMutation(getPackageVersionAssetRequest)
                .build(), destinationPath);
    }

    /**
     * <p>
     * Gets the readme file or descriptive text for a package version. For packages that do not contain a readme file,
     * CodeArtifact extracts a description from a metadata file. For example, from the <code>&lt;description&gt;</code>
     * element in the <code>pom.xml</code> file of a Maven package.
     * </p>
     * <p>
     * The returned text might contain formatting. For example, it might contain formatting for Markdown or
     * reStructuredText.
     * </p>
     *
     * @param getPackageVersionReadmeRequest
     * @return A Java Future containing the result of the GetPackageVersionReadme operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.GetPackageVersionReadme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetPackageVersionReadme"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPackageVersionReadmeResponse> getPackageVersionReadme(
            GetPackageVersionReadmeRequest getPackageVersionReadmeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the readme file or descriptive text for a package version. For packages that do not contain a readme file,
     * CodeArtifact extracts a description from a metadata file. For example, from the <code>&lt;description&gt;</code>
     * element in the <code>pom.xml</code> file of a Maven package.
     * </p>
     * <p>
     * The returned text might contain formatting. For example, it might contain formatting for Markdown or
     * reStructuredText.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPackageVersionReadmeRequest.Builder} avoiding
     * the need to create one manually via {@link GetPackageVersionReadmeRequest#builder()}
     * </p>
     *
     * @param getPackageVersionReadmeRequest
     *        A {@link Consumer} that will call methods on {@link GetPackageVersionReadmeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetPackageVersionReadme operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.GetPackageVersionReadme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetPackageVersionReadme"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPackageVersionReadmeResponse> getPackageVersionReadme(
            Consumer<GetPackageVersionReadmeRequest.Builder> getPackageVersionReadmeRequest) {
        return getPackageVersionReadme(GetPackageVersionReadmeRequest.builder().applyMutation(getPackageVersionReadmeRequest)
                .build());
    }

    /**
     * <p>
     * Returns the endpoint of a repository for a specific package format. A repository has one endpoint for each
     * package format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>maven</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>npm</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>nuget</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pypi</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param getRepositoryEndpointRequest
     * @return A Java Future containing the result of the GetRepositoryEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.GetRepositoryEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetRepositoryEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRepositoryEndpointResponse> getRepositoryEndpoint(
            GetRepositoryEndpointRequest getRepositoryEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the endpoint of a repository for a specific package format. A repository has one endpoint for each
     * package format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>maven</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>npm</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>nuget</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pypi</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRepositoryEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link GetRepositoryEndpointRequest#builder()}
     * </p>
     *
     * @param getRepositoryEndpointRequest
     *        A {@link Consumer} that will call methods on {@link GetRepositoryEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRepositoryEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.GetRepositoryEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetRepositoryEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRepositoryEndpointResponse> getRepositoryEndpoint(
            Consumer<GetRepositoryEndpointRequest.Builder> getRepositoryEndpointRequest) {
        return getRepositoryEndpoint(GetRepositoryEndpointRequest.builder().applyMutation(getRepositoryEndpointRequest).build());
    }

    /**
     * <p>
     * Returns the resource policy that is set on a repository.
     * </p>
     *
     * @param getRepositoryPermissionsPolicyRequest
     * @return A Java Future containing the result of the GetRepositoryPermissionsPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.GetRepositoryPermissionsPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetRepositoryPermissionsPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRepositoryPermissionsPolicyResponse> getRepositoryPermissionsPolicy(
            GetRepositoryPermissionsPolicyRequest getRepositoryPermissionsPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the resource policy that is set on a repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRepositoryPermissionsPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link GetRepositoryPermissionsPolicyRequest#builder()}
     * </p>
     *
     * @param getRepositoryPermissionsPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetRepositoryPermissionsPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetRepositoryPermissionsPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.GetRepositoryPermissionsPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/GetRepositoryPermissionsPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRepositoryPermissionsPolicyResponse> getRepositoryPermissionsPolicy(
            Consumer<GetRepositoryPermissionsPolicyRequest.Builder> getRepositoryPermissionsPolicyRequest) {
        return getRepositoryPermissionsPolicy(GetRepositoryPermissionsPolicyRequest.builder()
                .applyMutation(getRepositoryPermissionsPolicyRequest).build());
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html"
     * >DomainSummary</a> objects for all domains owned by the Amazon Web Services account that makes this call. Each
     * returned <code>DomainSummary</code> object contains information about a domain.
     * </p>
     *
     * @param listDomainsRequest
     * @return A Java Future containing the result of the ListDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDomainsResponse> listDomains(ListDomainsRequest listDomainsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html"
     * >DomainSummary</a> objects for all domains owned by the Amazon Web Services account that makes this call. Each
     * returned <code>DomainSummary</code> object contains information about a domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     * </p>
     *
     * @param listDomainsRequest
     *        A {@link Consumer} that will call methods on {@link ListDomainsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDomainsResponse> listDomains(Consumer<ListDomainsRequest.Builder> listDomainsRequest) {
        return listDomains(ListDomainsRequest.builder().applyMutation(listDomainsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html"
     * >DomainSummary</a> objects for all domains owned by the Amazon Web Services account that makes this call. Each
     * returned <code>DomainSummary</code> object contains information about a domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDomains(software.amazon.awssdk.services.codeartifact.model.ListDomainsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeartifact.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeartifact.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codeartifact.model.ListDomainsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codeartifact.model.ListDomainsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.codeartifact.model.ListDomainsRequest)} operation.</b>
     * </p>
     *
     * @param listDomainsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainsPublisher listDomainsPaginator(ListDomainsRequest listDomainsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html"
     * >DomainSummary</a> objects for all domains owned by the Amazon Web Services account that makes this call. Each
     * returned <code>DomainSummary</code> object contains information about a domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDomains(software.amazon.awssdk.services.codeartifact.model.ListDomainsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeartifact.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeartifact.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codeartifact.model.ListDomainsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codeartifact.model.ListDomainsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.codeartifact.model.ListDomainsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     * </p>
     *
     * @param listDomainsRequest
     *        A {@link Consumer} that will call methods on {@link ListDomainsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainsPublisher listDomainsPaginator(Consumer<ListDomainsRequest.Builder> listDomainsRequest) {
        return listDomainsPaginator(ListDomainsRequest.builder().applyMutation(listDomainsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html">AssetSummary</a>
     * objects for assets in a package version.
     * </p>
     *
     * @param listPackageVersionAssetsRequest
     * @return A Java Future containing the result of the ListPackageVersionAssets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListPackageVersionAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackageVersionAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPackageVersionAssetsResponse> listPackageVersionAssets(
            ListPackageVersionAssetsRequest listPackageVersionAssetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html">AssetSummary</a>
     * objects for assets in a package version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackageVersionAssetsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPackageVersionAssetsRequest#builder()}
     * </p>
     *
     * @param listPackageVersionAssetsRequest
     *        A {@link Consumer} that will call methods on {@link ListPackageVersionAssetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPackageVersionAssets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListPackageVersionAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackageVersionAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPackageVersionAssetsResponse> listPackageVersionAssets(
            Consumer<ListPackageVersionAssetsRequest.Builder> listPackageVersionAssetsRequest) {
        return listPackageVersionAssets(ListPackageVersionAssetsRequest.builder().applyMutation(listPackageVersionAssetsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html">AssetSummary</a>
     * objects for assets in a package version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPackageVersionAssets(software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeartifact.paginators.ListPackageVersionAssetsPublisher publisher = client.listPackageVersionAssetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeartifact.paginators.ListPackageVersionAssetsPublisher publisher = client.listPackageVersionAssetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackageVersionAssets(software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPackageVersionAssetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListPackageVersionAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackageVersionAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPackageVersionAssetsPublisher listPackageVersionAssetsPaginator(
            ListPackageVersionAssetsRequest listPackageVersionAssetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html">AssetSummary</a>
     * objects for assets in a package version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPackageVersionAssets(software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeartifact.paginators.ListPackageVersionAssetsPublisher publisher = client.listPackageVersionAssetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeartifact.paginators.ListPackageVersionAssetsPublisher publisher = client.listPackageVersionAssetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackageVersionAssets(software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackageVersionAssetsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPackageVersionAssetsRequest#builder()}
     * </p>
     *
     * @param listPackageVersionAssetsRequest
     *        A {@link Consumer} that will call methods on {@link ListPackageVersionAssetsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListPackageVersionAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackageVersionAssets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPackageVersionAssetsPublisher listPackageVersionAssetsPaginator(
            Consumer<ListPackageVersionAssetsRequest.Builder> listPackageVersionAssetsRequest) {
        return listPackageVersionAssetsPaginator(ListPackageVersionAssetsRequest.builder()
                .applyMutation(listPackageVersionAssetsRequest).build());
    }

    /**
     * <p>
     * Returns the direct dependencies for a package version. The dependencies are returned as <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html"
     * >PackageDependency</a> objects. CodeArtifact extracts the dependencies for a package version from the metadata
     * file for the package format (for example, the <code>package.json</code> file for npm packages and the
     * <code>pom.xml</code> file for Maven). Any package version dependencies that are not listed in the configuration
     * file are not returned.
     * </p>
     *
     * @param listPackageVersionDependenciesRequest
     * @return A Java Future containing the result of the ListPackageVersionDependencies operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListPackageVersionDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackageVersionDependencies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPackageVersionDependenciesResponse> listPackageVersionDependencies(
            ListPackageVersionDependenciesRequest listPackageVersionDependenciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the direct dependencies for a package version. The dependencies are returned as <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html"
     * >PackageDependency</a> objects. CodeArtifact extracts the dependencies for a package version from the metadata
     * file for the package format (for example, the <code>package.json</code> file for npm packages and the
     * <code>pom.xml</code> file for Maven). Any package version dependencies that are not listed in the configuration
     * file are not returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackageVersionDependenciesRequest.Builder}
     * avoiding the need to create one manually via {@link ListPackageVersionDependenciesRequest#builder()}
     * </p>
     *
     * @param listPackageVersionDependenciesRequest
     *        A {@link Consumer} that will call methods on {@link ListPackageVersionDependenciesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListPackageVersionDependencies operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListPackageVersionDependencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackageVersionDependencies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPackageVersionDependenciesResponse> listPackageVersionDependencies(
            Consumer<ListPackageVersionDependenciesRequest.Builder> listPackageVersionDependenciesRequest) {
        return listPackageVersionDependencies(ListPackageVersionDependenciesRequest.builder()
                .applyMutation(listPackageVersionDependenciesRequest).build());
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html"
     * >PackageVersionSummary</a> objects for package versions in a repository that match the request parameters.
     * </p>
     *
     * @param listPackageVersionsRequest
     * @return A Java Future containing the result of the ListPackageVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListPackageVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackageVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPackageVersionsResponse> listPackageVersions(
            ListPackageVersionsRequest listPackageVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html"
     * >PackageVersionSummary</a> objects for package versions in a repository that match the request parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackageVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPackageVersionsRequest#builder()}
     * </p>
     *
     * @param listPackageVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPackageVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPackageVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListPackageVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackageVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPackageVersionsResponse> listPackageVersions(
            Consumer<ListPackageVersionsRequest.Builder> listPackageVersionsRequest) {
        return listPackageVersions(ListPackageVersionsRequest.builder().applyMutation(listPackageVersionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html"
     * >PackageVersionSummary</a> objects for package versions in a repository that match the request parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPackageVersions(software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeartifact.paginators.ListPackageVersionsPublisher publisher = client.listPackageVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeartifact.paginators.ListPackageVersionsPublisher publisher = client.listPackageVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackageVersions(software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPackageVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListPackageVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackageVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPackageVersionsPublisher listPackageVersionsPaginator(ListPackageVersionsRequest listPackageVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html"
     * >PackageVersionSummary</a> objects for package versions in a repository that match the request parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPackageVersions(software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeartifact.paginators.ListPackageVersionsPublisher publisher = client.listPackageVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeartifact.paginators.ListPackageVersionsPublisher publisher = client.listPackageVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackageVersions(software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackageVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPackageVersionsRequest#builder()}
     * </p>
     *
     * @param listPackageVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPackageVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListPackageVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackageVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPackageVersionsPublisher listPackageVersionsPaginator(
            Consumer<ListPackageVersionsRequest.Builder> listPackageVersionsRequest) {
        return listPackageVersionsPaginator(ListPackageVersionsRequest.builder().applyMutation(listPackageVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html">PackageSummary</a>
     * objects for packages in a repository that match the request parameters.
     * </p>
     *
     * @param listPackagesRequest
     * @return A Java Future containing the result of the ListPackages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPackagesResponse> listPackages(ListPackagesRequest listPackagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html">PackageSummary</a>
     * objects for packages in a repository that match the request parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPackagesRequest#builder()}
     * </p>
     *
     * @param listPackagesRequest
     *        A {@link Consumer} that will call methods on {@link ListPackagesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListPackages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPackagesResponse> listPackages(Consumer<ListPackagesRequest.Builder> listPackagesRequest) {
        return listPackages(ListPackagesRequest.builder().applyMutation(listPackagesRequest).build());
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html">PackageSummary</a>
     * objects for packages in a repository that match the request parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPackages(software.amazon.awssdk.services.codeartifact.model.ListPackagesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeartifact.paginators.ListPackagesPublisher publisher = client.listPackagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeartifact.paginators.ListPackagesPublisher publisher = client.listPackagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codeartifact.model.ListPackagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codeartifact.model.ListPackagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackages(software.amazon.awssdk.services.codeartifact.model.ListPackagesRequest)} operation.</b>
     * </p>
     *
     * @param listPackagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPackagesPublisher listPackagesPaginator(ListPackagesRequest listPackagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html">PackageSummary</a>
     * objects for packages in a repository that match the request parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPackages(software.amazon.awssdk.services.codeartifact.model.ListPackagesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeartifact.paginators.ListPackagesPublisher publisher = client.listPackagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeartifact.paginators.ListPackagesPublisher publisher = client.listPackagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codeartifact.model.ListPackagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codeartifact.model.ListPackagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackages(software.amazon.awssdk.services.codeartifact.model.ListPackagesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPackagesRequest#builder()}
     * </p>
     *
     * @param listPackagesRequest
     *        A {@link Consumer} that will call methods on {@link ListPackagesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPackagesPublisher listPackagesPaginator(Consumer<ListPackagesRequest.Builder> listPackagesRequest) {
        return listPackagesPaginator(ListPackagesRequest.builder().applyMutation(listPackagesRequest).build());
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html"
     * >RepositorySummary</a> objects. Each <code>RepositorySummary</code> contains information about a repository in
     * the specified Amazon Web Services account and that matches the input parameters.
     * </p>
     *
     * @param listRepositoriesRequest
     * @return A Java Future containing the result of the ListRepositories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListRepositories" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListRepositoriesResponse> listRepositories(ListRepositoriesRequest listRepositoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html"
     * >RepositorySummary</a> objects. Each <code>RepositorySummary</code> contains information about a repository in
     * the specified Amazon Web Services account and that matches the input parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRepositoriesRequest.Builder} avoiding the need
     * to create one manually via {@link ListRepositoriesRequest#builder()}
     * </p>
     *
     * @param listRepositoriesRequest
     *        A {@link Consumer} that will call methods on {@link ListRepositoriesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRepositories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListRepositories" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListRepositoriesResponse> listRepositories(
            Consumer<ListRepositoriesRequest.Builder> listRepositoriesRequest) {
        return listRepositories(ListRepositoriesRequest.builder().applyMutation(listRepositoriesRequest).build());
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html"
     * >RepositorySummary</a> objects. Each <code>RepositorySummary</code> contains information about a repository in
     * the specified domain and that matches the input parameters.
     * </p>
     *
     * @param listRepositoriesInDomainRequest
     * @return A Java Future containing the result of the ListRepositoriesInDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListRepositoriesInDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListRepositoriesInDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRepositoriesInDomainResponse> listRepositoriesInDomain(
            ListRepositoriesInDomainRequest listRepositoriesInDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html"
     * >RepositorySummary</a> objects. Each <code>RepositorySummary</code> contains information about a repository in
     * the specified domain and that matches the input parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRepositoriesInDomainRequest.Builder} avoiding
     * the need to create one manually via {@link ListRepositoriesInDomainRequest#builder()}
     * </p>
     *
     * @param listRepositoriesInDomainRequest
     *        A {@link Consumer} that will call methods on {@link ListRepositoriesInDomainRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListRepositoriesInDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListRepositoriesInDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListRepositoriesInDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRepositoriesInDomainResponse> listRepositoriesInDomain(
            Consumer<ListRepositoriesInDomainRequest.Builder> listRepositoriesInDomainRequest) {
        return listRepositoriesInDomain(ListRepositoriesInDomainRequest.builder().applyMutation(listRepositoriesInDomainRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html"
     * >RepositorySummary</a> objects. Each <code>RepositorySummary</code> contains information about a repository in
     * the specified domain and that matches the input parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRepositoriesInDomain(software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeartifact.paginators.ListRepositoriesInDomainPublisher publisher = client.listRepositoriesInDomainPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeartifact.paginators.ListRepositoriesInDomainPublisher publisher = client.listRepositoriesInDomainPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRepositoriesInDomain(software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRepositoriesInDomainRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListRepositoriesInDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListRepositoriesInDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRepositoriesInDomainPublisher listRepositoriesInDomainPaginator(
            ListRepositoriesInDomainRequest listRepositoriesInDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html"
     * >RepositorySummary</a> objects. Each <code>RepositorySummary</code> contains information about a repository in
     * the specified domain and that matches the input parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRepositoriesInDomain(software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeartifact.paginators.ListRepositoriesInDomainPublisher publisher = client.listRepositoriesInDomainPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeartifact.paginators.ListRepositoriesInDomainPublisher publisher = client.listRepositoriesInDomainPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRepositoriesInDomain(software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRepositoriesInDomainRequest.Builder} avoiding
     * the need to create one manually via {@link ListRepositoriesInDomainRequest#builder()}
     * </p>
     *
     * @param listRepositoriesInDomainRequest
     *        A {@link Consumer} that will call methods on {@link ListRepositoriesInDomainRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListRepositoriesInDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListRepositoriesInDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRepositoriesInDomainPublisher listRepositoriesInDomainPaginator(
            Consumer<ListRepositoriesInDomainRequest.Builder> listRepositoriesInDomainRequest) {
        return listRepositoriesInDomainPaginator(ListRepositoriesInDomainRequest.builder()
                .applyMutation(listRepositoriesInDomainRequest).build());
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html"
     * >RepositorySummary</a> objects. Each <code>RepositorySummary</code> contains information about a repository in
     * the specified Amazon Web Services account and that matches the input parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRepositories(software.amazon.awssdk.services.codeartifact.model.ListRepositoriesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeartifact.paginators.ListRepositoriesPublisher publisher = client.listRepositoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeartifact.paginators.ListRepositoriesPublisher publisher = client.listRepositoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codeartifact.model.ListRepositoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codeartifact.model.ListRepositoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRepositories(software.amazon.awssdk.services.codeartifact.model.ListRepositoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRepositoriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListRepositories" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRepositoriesPublisher listRepositoriesPaginator(ListRepositoriesRequest listRepositoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html"
     * >RepositorySummary</a> objects. Each <code>RepositorySummary</code> contains information about a repository in
     * the specified Amazon Web Services account and that matches the input parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRepositories(software.amazon.awssdk.services.codeartifact.model.ListRepositoriesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeartifact.paginators.ListRepositoriesPublisher publisher = client.listRepositoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeartifact.paginators.ListRepositoriesPublisher publisher = client.listRepositoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codeartifact.model.ListRepositoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codeartifact.model.ListRepositoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRepositories(software.amazon.awssdk.services.codeartifact.model.ListRepositoriesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRepositoriesRequest.Builder} avoiding the need
     * to create one manually via {@link ListRepositoriesRequest#builder()}
     * </p>
     *
     * @param listRepositoriesRequest
     *        A {@link Consumer} that will call methods on {@link ListRepositoriesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListRepositories" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRepositoriesPublisher listRepositoriesPaginator(Consumer<ListRepositoriesRequest.Builder> listRepositoriesRequest) {
        return listRepositoriesPaginator(ListRepositoriesRequest.builder().applyMutation(listRepositoriesRequest).build());
    }

    /**
     * <p>
     * Gets information about Amazon Web Services tags for a specified Amazon Resource Name (ARN) in CodeArtifact.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about Amazon Web Services tags for a specified Amazon Resource Name (ARN) in CodeArtifact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Sets a resource policy on a domain that specifies permissions to access it.
     * </p>
     * <p>
     * When you call <code>PutDomainPermissionsPolicy</code>, the resource policy on the domain is ignored when
     * evaluting permissions. This ensures that the owner of a domain cannot lock themselves out of the domain, which
     * would prevent them from being able to update the resource policy.
     * </p>
     *
     * @param putDomainPermissionsPolicyRequest
     * @return A Java Future containing the result of the PutDomainPermissionsPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ServiceQuotaExceededException The operation did not succeed because it would have exceeded a service
     *         limit for your account.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.PutDomainPermissionsPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/PutDomainPermissionsPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutDomainPermissionsPolicyResponse> putDomainPermissionsPolicy(
            PutDomainPermissionsPolicyRequest putDomainPermissionsPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets a resource policy on a domain that specifies permissions to access it.
     * </p>
     * <p>
     * When you call <code>PutDomainPermissionsPolicy</code>, the resource policy on the domain is ignored when
     * evaluting permissions. This ensures that the owner of a domain cannot lock themselves out of the domain, which
     * would prevent them from being able to update the resource policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDomainPermissionsPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link PutDomainPermissionsPolicyRequest#builder()}
     * </p>
     *
     * @param putDomainPermissionsPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutDomainPermissionsPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutDomainPermissionsPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ServiceQuotaExceededException The operation did not succeed because it would have exceeded a service
     *         limit for your account.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.PutDomainPermissionsPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/PutDomainPermissionsPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutDomainPermissionsPolicyResponse> putDomainPermissionsPolicy(
            Consumer<PutDomainPermissionsPolicyRequest.Builder> putDomainPermissionsPolicyRequest) {
        return putDomainPermissionsPolicy(PutDomainPermissionsPolicyRequest.builder()
                .applyMutation(putDomainPermissionsPolicyRequest).build());
    }

    /**
     * <p>
     * Sets the package origin configuration for a package.
     * </p>
     * <p>
     * The package origin configuration determines how new versions of a package can be added to a repository. You can
     * allow or block direct publishing of new package versions, or ingestion and retaining of new package versions from
     * an external connection or upstream source. For more information about package origin controls and configuration,
     * see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/package-origin-controls.html">Editing package
     * origin controls</a> in the <i>CodeArtifact User Guide</i>.
     * </p>
     * <p>
     * <code>PutPackageOriginConfiguration</code> can be called on a package that doesn't yet exist in the repository.
     * When called on a package that does not exist, a package is created in the repository with no versions and the
     * requested restrictions are set on the package. This can be used to preemptively block ingesting or retaining any
     * versions from external connections or upstream repositories, or to block publishing any versions of the package
     * into the repository before connecting any package managers or publishers to the repository.
     * </p>
     *
     * @param putPackageOriginConfigurationRequest
     * @return A Java Future containing the result of the PutPackageOriginConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.PutPackageOriginConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/PutPackageOriginConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutPackageOriginConfigurationResponse> putPackageOriginConfiguration(
            PutPackageOriginConfigurationRequest putPackageOriginConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the package origin configuration for a package.
     * </p>
     * <p>
     * The package origin configuration determines how new versions of a package can be added to a repository. You can
     * allow or block direct publishing of new package versions, or ingestion and retaining of new package versions from
     * an external connection or upstream source. For more information about package origin controls and configuration,
     * see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/package-origin-controls.html">Editing package
     * origin controls</a> in the <i>CodeArtifact User Guide</i>.
     * </p>
     * <p>
     * <code>PutPackageOriginConfiguration</code> can be called on a package that doesn't yet exist in the repository.
     * When called on a package that does not exist, a package is created in the repository with no versions and the
     * requested restrictions are set on the package. This can be used to preemptively block ingesting or retaining any
     * versions from external connections or upstream repositories, or to block publishing any versions of the package
     * into the repository before connecting any package managers or publishers to the repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutPackageOriginConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutPackageOriginConfigurationRequest#builder()}
     * </p>
     *
     * @param putPackageOriginConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutPackageOriginConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutPackageOriginConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.PutPackageOriginConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/PutPackageOriginConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutPackageOriginConfigurationResponse> putPackageOriginConfiguration(
            Consumer<PutPackageOriginConfigurationRequest.Builder> putPackageOriginConfigurationRequest) {
        return putPackageOriginConfiguration(PutPackageOriginConfigurationRequest.builder()
                .applyMutation(putPackageOriginConfigurationRequest).build());
    }

    /**
     * <p>
     * Sets the resource policy on a repository that specifies permissions to access it.
     * </p>
     * <p>
     * When you call <code>PutRepositoryPermissionsPolicy</code>, the resource policy on the repository is ignored when
     * evaluting permissions. This ensures that the owner of a repository cannot lock themselves out of the repository,
     * which would prevent them from being able to update the resource policy.
     * </p>
     *
     * @param putRepositoryPermissionsPolicyRequest
     * @return A Java Future containing the result of the PutRepositoryPermissionsPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ServiceQuotaExceededException The operation did not succeed because it would have exceeded a service
     *         limit for your account.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.PutRepositoryPermissionsPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/PutRepositoryPermissionsPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRepositoryPermissionsPolicyResponse> putRepositoryPermissionsPolicy(
            PutRepositoryPermissionsPolicyRequest putRepositoryPermissionsPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the resource policy on a repository that specifies permissions to access it.
     * </p>
     * <p>
     * When you call <code>PutRepositoryPermissionsPolicy</code>, the resource policy on the repository is ignored when
     * evaluting permissions. This ensures that the owner of a repository cannot lock themselves out of the repository,
     * which would prevent them from being able to update the resource policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRepositoryPermissionsPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link PutRepositoryPermissionsPolicyRequest#builder()}
     * </p>
     *
     * @param putRepositoryPermissionsPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutRepositoryPermissionsPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutRepositoryPermissionsPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ServiceQuotaExceededException The operation did not succeed because it would have exceeded a service
     *         limit for your account.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.PutRepositoryPermissionsPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/PutRepositoryPermissionsPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRepositoryPermissionsPolicyResponse> putRepositoryPermissionsPolicy(
            Consumer<PutRepositoryPermissionsPolicyRequest.Builder> putRepositoryPermissionsPolicyRequest) {
        return putRepositoryPermissionsPolicy(PutRepositoryPermissionsPolicyRequest.builder()
                .applyMutation(putRepositoryPermissionsPolicyRequest).build());
    }

    /**
     * <p>
     * Adds or updates tags for a resource in CodeArtifact.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ServiceQuotaExceededException The operation did not succeed because it would have exceeded a service
     *         limit for your account.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates tags for a resource in CodeArtifact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ServiceQuotaExceededException The operation did not succeed because it would have exceeded a service
     *         limit for your account.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource in CodeArtifact.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource in CodeArtifact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the status of one or more versions of a package. Using <code>UpdatePackageVersionsStatus</code>, you can
     * update the status of package versions to <code>Archived</code>, <code>Published</code>, or <code>Unlisted</code>.
     * To set the status of a package version to <code>Disposed</code>, use <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DisposePackageVersions.html"
     * >DisposePackageVersions</a>.
     * </p>
     *
     * @param updatePackageVersionsStatusRequest
     * @return A Java Future containing the result of the UpdatePackageVersionsStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.UpdatePackageVersionsStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/UpdatePackageVersionsStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePackageVersionsStatusResponse> updatePackageVersionsStatus(
            UpdatePackageVersionsStatusRequest updatePackageVersionsStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the status of one or more versions of a package. Using <code>UpdatePackageVersionsStatus</code>, you can
     * update the status of package versions to <code>Archived</code>, <code>Published</code>, or <code>Unlisted</code>.
     * To set the status of a package version to <code>Disposed</code>, use <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DisposePackageVersions.html"
     * >DisposePackageVersions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePackageVersionsStatusRequest.Builder}
     * avoiding the need to create one manually via {@link UpdatePackageVersionsStatusRequest#builder()}
     * </p>
     *
     * @param updatePackageVersionsStatusRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePackageVersionsStatusRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdatePackageVersionsStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.UpdatePackageVersionsStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/UpdatePackageVersionsStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePackageVersionsStatusResponse> updatePackageVersionsStatus(
            Consumer<UpdatePackageVersionsStatusRequest.Builder> updatePackageVersionsStatusRequest) {
        return updatePackageVersionsStatus(UpdatePackageVersionsStatusRequest.builder()
                .applyMutation(updatePackageVersionsStatusRequest).build());
    }

    /**
     * <p>
     * Update the properties of a repository.
     * </p>
     *
     * @param updateRepositoryRequest
     * @return A Java Future containing the result of the UpdateRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ServiceQuotaExceededException The operation did not succeed because it would have exceeded a service
     *         limit for your account.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.UpdateRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/UpdateRepository" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateRepositoryResponse> updateRepository(UpdateRepositoryRequest updateRepositoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the properties of a repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRepositoryRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateRepositoryRequest#builder()}
     * </p>
     *
     * @param updateRepositoryRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRepositoryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException The operation did not succeed because of an unauthorized access attempt.</li>
     *         <li>ConflictException The operation did not succeed because prerequisites are not met.</li>
     *         <li>InternalServerException The operation did not succeed because of an error that occurred inside
     *         CodeArtifact.</li>
     *         <li>ResourceNotFoundException The operation did not succeed because the resource requested is not found
     *         in the service.</li>
     *         <li>ServiceQuotaExceededException The operation did not succeed because it would have exceeded a service
     *         limit for your account.</li>
     *         <li>ThrottlingException The operation did not succeed because too many requests are sent to the service.</li>
     *         <li>ValidationException The operation did not succeed because a parameter in the request was sent with an
     *         invalid value.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeartifactException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeartifactAsyncClient.UpdateRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/UpdateRepository" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateRepositoryResponse> updateRepository(
            Consumer<UpdateRepositoryRequest.Builder> updateRepositoryRequest) {
        return updateRepository(UpdateRepositoryRequest.builder().applyMutation(updateRepositoryRequest).build());
    }
}
