/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublishPackageVersionRequest extends CodeartifactRequest implements
        ToCopyableBuilder<PublishPackageVersionRequest.Builder, PublishPackageVersionRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(PublishPackageVersionRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()).build();

    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainOwner").getter(getter(PublishPackageVersionRequest::domainOwner))
            .setter(setter(Builder::domainOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain-owner").build()).build();

    private static final SdkField<String> REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repository").getter(getter(PublishPackageVersionRequest::repository))
            .setter(setter(Builder::repository))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("repository").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(PublishPackageVersionRequest::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("format").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(PublishPackageVersionRequest::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("namespace").build()).build();

    private static final SdkField<String> PACKAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("package")
            .getter(getter(PublishPackageVersionRequest::packageValue)).setter(setter(Builder::packageValue))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("package").build()).build();

    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("packageVersion").getter(getter(PublishPackageVersionRequest::packageVersion))
            .setter(setter(Builder::packageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("version").build()).build();

    private static final SdkField<String> ASSET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetName").getter(getter(PublishPackageVersionRequest::assetName)).setter(setter(Builder::assetName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("asset").build()).build();

    private static final SdkField<String> ASSET_SHA256_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetSHA256").getter(getter(PublishPackageVersionRequest::assetSHA256))
            .setter(setter(Builder::assetSHA256))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-content-sha256").build())
            .build();

    private static final SdkField<Boolean> UNFINISHED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("unfinished").getter(getter(PublishPackageVersionRequest::unfinished))
            .setter(setter(Builder::unfinished))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("unfinished").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            DOMAIN_OWNER_FIELD, REPOSITORY_FIELD, FORMAT_FIELD, NAMESPACE_FIELD, PACKAGE_FIELD, PACKAGE_VERSION_FIELD,
            ASSET_NAME_FIELD, ASSET_SHA256_FIELD, UNFINISHED_FIELD));

    private final String domain;

    private final String domainOwner;

    private final String repository;

    private final String format;

    private final String namespace;

    private final String packageValue;

    private final String packageVersion;

    private final String assetName;

    private final String assetSHA256;

    private final Boolean unfinished;

    private PublishPackageVersionRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainOwner = builder.domainOwner;
        this.repository = builder.repository;
        this.format = builder.format;
        this.namespace = builder.namespace;
        this.packageValue = builder.packageValue;
        this.packageVersion = builder.packageVersion;
        this.assetName = builder.assetName;
        this.assetSHA256 = builder.assetSHA256;
        this.unfinished = builder.unfinished;
    }

    /**
     * <p>
     * The name of the domain that contains the repository that contains the package version to publish.
     * </p>
     * 
     * @return The name of the domain that contains the repository that contains the package version to publish.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
     * </p>
     * 
     * @return The 12-digit account number of the AWS account that owns the domain. It does not include dashes or
     *         spaces.
     */
    public final String domainOwner() {
        return domainOwner;
    }

    /**
     * <p>
     * The name of the repository that the package version will be published to.
     * </p>
     * 
     * @return The name of the repository that the package version will be published to.
     */
    public final String repository() {
        return repository;
    }

    /**
     * <p>
     * A format that specifies the type of the package version with the requested asset file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link PackageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return A format that specifies the type of the package version with the requested asset file.
     * @see PackageFormat
     */
    public final PackageFormat format() {
        return PackageFormat.fromValue(format);
    }

    /**
     * <p>
     * A format that specifies the type of the package version with the requested asset file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link PackageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return A format that specifies the type of the package version with the requested asset file.
     * @see PackageFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The namespace of the package version to publish.
     * </p>
     * 
     * @return The namespace of the package version to publish.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the package version to publish.
     * </p>
     * 
     * @return The name of the package version to publish.
     */
    public final String packageValue() {
        return packageValue;
    }

    /**
     * <p>
     * The package version to publish (for example, <code>3.5.2</code>).
     * </p>
     * 
     * @return The package version to publish (for example, <code>3.5.2</code>).
     */
    public final String packageVersion() {
        return packageVersion;
    }

    /**
     * <p>
     * The name of the asset to publish. Asset names can include Unicode letters and numbers, and the following special
     * characters: <code>~ ! @ ^ &amp; ( ) - ` _ + [ ] { } ; , . `</code>
     * </p>
     * 
     * @return The name of the asset to publish. Asset names can include Unicode letters and numbers, and the following
     *         special characters: <code>~ ! @ ^ &amp; ( ) - ` _ + [ ] { } ; , . `</code>
     */
    public final String assetName() {
        return assetName;
    }

    /**
     * <p>
     * The SHA256 hash of the <code>assetContent</code> to publish. This value must be calculated by the caller and
     * provided with the request.
     * </p>
     * <p>
     * This value is used as an integrity check to verify that the <code>assetContent</code> has not changed after it
     * was originally sent.
     * </p>
     * 
     * @return The SHA256 hash of the <code>assetContent</code> to publish. This value must be calculated by the caller
     *         and provided with the request.</p>
     *         <p>
     *         This value is used as an integrity check to verify that the <code>assetContent</code> has not changed
     *         after it was originally sent.
     */
    public final String assetSHA256() {
        return assetSHA256;
    }

    /**
     * <p>
     * Specifies whether the package version should remain in the <code>unfinished</code> state. If omitted, the package
     * version status will be set to <code>Published</code> (see <a href=
     * "https://docs.aws.amazon.com/codeartifact/latest/ug/packages-overview.html#package-version-status.html#package-version-status"
     * >Package version status</a> in the <i>CodeArtifact User Guide</i>).
     * </p>
     * <p>
     * Valid values: <code>unfinished</code>
     * </p>
     * 
     * @return Specifies whether the package version should remain in the <code>unfinished</code> state. If omitted, the
     *         package version status will be set to <code>Published</code> (see <a href=
     *         "https://docs.aws.amazon.com/codeartifact/latest/ug/packages-overview.html#package-version-status.html#package-version-status"
     *         >Package version status</a> in the <i>CodeArtifact User Guide</i>).</p>
     *         <p>
     *         Valid values: <code>unfinished</code>
     */
    public final Boolean unfinished() {
        return unfinished;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(repository());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(packageValue());
        hashCode = 31 * hashCode + Objects.hashCode(packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(assetName());
        hashCode = 31 * hashCode + Objects.hashCode(assetSHA256());
        hashCode = 31 * hashCode + Objects.hashCode(unfinished());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishPackageVersionRequest)) {
            return false;
        }
        PublishPackageVersionRequest other = (PublishPackageVersionRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(domainOwner(), other.domainOwner())
                && Objects.equals(repository(), other.repository()) && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(namespace(), other.namespace()) && Objects.equals(packageValue(), other.packageValue())
                && Objects.equals(packageVersion(), other.packageVersion()) && Objects.equals(assetName(), other.assetName())
                && Objects.equals(assetSHA256(), other.assetSHA256()) && Objects.equals(unfinished(), other.unfinished());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PublishPackageVersionRequest").add("Domain", domain()).add("DomainOwner", domainOwner())
                .add("Repository", repository()).add("Format", formatAsString()).add("Namespace", namespace())
                .add("Package", packageValue()).add("PackageVersion", packageVersion()).add("AssetName", assetName())
                .add("AssetSHA256", assetSHA256()).add("Unfinished", unfinished()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "domainOwner":
            return Optional.ofNullable(clazz.cast(domainOwner()));
        case "repository":
            return Optional.ofNullable(clazz.cast(repository()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "package":
            return Optional.ofNullable(clazz.cast(packageValue()));
        case "packageVersion":
            return Optional.ofNullable(clazz.cast(packageVersion()));
        case "assetName":
            return Optional.ofNullable(clazz.cast(assetName()));
        case "assetSHA256":
            return Optional.ofNullable(clazz.cast(assetSHA256()));
        case "unfinished":
            return Optional.ofNullable(clazz.cast(unfinished()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublishPackageVersionRequest, T> g) {
        return obj -> g.apply((PublishPackageVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactRequest.Builder, SdkPojo, CopyableBuilder<Builder, PublishPackageVersionRequest> {
        /**
         * <p>
         * The name of the domain that contains the repository that contains the package version to publish.
         * </p>
         * 
         * @param domain
         *        The name of the domain that contains the repository that contains the package version to publish.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
         * </p>
         * 
         * @param domainOwner
         *        The 12-digit account number of the AWS account that owns the domain. It does not include dashes or
         *        spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainOwner(String domainOwner);

        /**
         * <p>
         * The name of the repository that the package version will be published to.
         * </p>
         * 
         * @param repository
         *        The name of the repository that the package version will be published to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repository(String repository);

        /**
         * <p>
         * A format that specifies the type of the package version with the requested asset file.
         * </p>
         * 
         * @param format
         *        A format that specifies the type of the package version with the requested asset file.
         * @see PackageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageFormat
         */
        Builder format(String format);

        /**
         * <p>
         * A format that specifies the type of the package version with the requested asset file.
         * </p>
         * 
         * @param format
         *        A format that specifies the type of the package version with the requested asset file.
         * @see PackageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageFormat
         */
        Builder format(PackageFormat format);

        /**
         * <p>
         * The namespace of the package version to publish.
         * </p>
         * 
         * @param namespace
         *        The namespace of the package version to publish.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the package version to publish.
         * </p>
         * 
         * @param packageValue
         *        The name of the package version to publish.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageValue(String packageValue);

        /**
         * <p>
         * The package version to publish (for example, <code>3.5.2</code>).
         * </p>
         * 
         * @param packageVersion
         *        The package version to publish (for example, <code>3.5.2</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVersion(String packageVersion);

        /**
         * <p>
         * The name of the asset to publish. Asset names can include Unicode letters and numbers, and the following
         * special characters: <code>~ ! @ ^ &amp; ( ) - ` _ + [ ] { } ; , . `</code>
         * </p>
         * 
         * @param assetName
         *        The name of the asset to publish. Asset names can include Unicode letters and numbers, and the
         *        following special characters: <code>~ ! @ ^ &amp; ( ) - ` _ + [ ] { } ; , . `</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetName(String assetName);

        /**
         * <p>
         * The SHA256 hash of the <code>assetContent</code> to publish. This value must be calculated by the caller and
         * provided with the request.
         * </p>
         * <p>
         * This value is used as an integrity check to verify that the <code>assetContent</code> has not changed after
         * it was originally sent.
         * </p>
         * 
         * @param assetSHA256
         *        The SHA256 hash of the <code>assetContent</code> to publish. This value must be calculated by the
         *        caller and provided with the request.</p>
         *        <p>
         *        This value is used as an integrity check to verify that the <code>assetContent</code> has not changed
         *        after it was originally sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetSHA256(String assetSHA256);

        /**
         * <p>
         * Specifies whether the package version should remain in the <code>unfinished</code> state. If omitted, the
         * package version status will be set to <code>Published</code> (see <a href=
         * "https://docs.aws.amazon.com/codeartifact/latest/ug/packages-overview.html#package-version-status.html#package-version-status"
         * >Package version status</a> in the <i>CodeArtifact User Guide</i>).
         * </p>
         * <p>
         * Valid values: <code>unfinished</code>
         * </p>
         * 
         * @param unfinished
         *        Specifies whether the package version should remain in the <code>unfinished</code> state. If omitted,
         *        the package version status will be set to <code>Published</code> (see <a href=
         *        "https://docs.aws.amazon.com/codeartifact/latest/ug/packages-overview.html#package-version-status.html#package-version-status"
         *        >Package version status</a> in the <i>CodeArtifact User Guide</i>).</p>
         *        <p>
         *        Valid values: <code>unfinished</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unfinished(Boolean unfinished);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeartifactRequest.BuilderImpl implements Builder {
        private String domain;

        private String domainOwner;

        private String repository;

        private String format;

        private String namespace;

        private String packageValue;

        private String packageVersion;

        private String assetName;

        private String assetSHA256;

        private Boolean unfinished;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishPackageVersionRequest model) {
            super(model);
            domain(model.domain);
            domainOwner(model.domainOwner);
            repository(model.repository);
            format(model.format);
            namespace(model.namespace);
            packageValue(model.packageValue);
            packageVersion(model.packageVersion);
            assetName(model.assetName);
            assetSHA256(model.assetSHA256);
            unfinished(model.unfinished);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getDomainOwner() {
            return domainOwner;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final String getRepository() {
            return repository;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(PackageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getPackageValue() {
            return packageValue;
        }

        public final void setPackageValue(String packageValue) {
            this.packageValue = packageValue;
        }

        @Override
        public final Builder packageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public final String getPackageVersion() {
            return packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final String getAssetName() {
            return assetName;
        }

        public final void setAssetName(String assetName) {
            this.assetName = assetName;
        }

        @Override
        public final Builder assetName(String assetName) {
            this.assetName = assetName;
            return this;
        }

        public final String getAssetSHA256() {
            return assetSHA256;
        }

        public final void setAssetSHA256(String assetSHA256) {
            this.assetSHA256 = assetSHA256;
        }

        @Override
        public final Builder assetSHA256(String assetSHA256) {
            this.assetSHA256 = assetSHA256;
            return this;
        }

        public final Boolean getUnfinished() {
            return unfinished;
        }

        public final void setUnfinished(Boolean unfinished) {
            this.unfinished = unfinished;
        }

        @Override
        public final Builder unfinished(Boolean unfinished) {
            this.unfinished = unfinished;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PublishPackageVersionRequest build() {
            return new PublishPackageVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
