/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPackageGroupsResponse extends CodeartifactResponse implements
        ToCopyableBuilder<ListPackageGroupsResponse.Builder, ListPackageGroupsResponse> {
    private static final SdkField<List<PackageGroupSummary>> PACKAGE_GROUPS_FIELD = SdkField
            .<List<PackageGroupSummary>> builder(MarshallingType.LIST)
            .memberName("packageGroups")
            .getter(getter(ListPackageGroupsResponse::packageGroups))
            .setter(setter(Builder::packageGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PackageGroupSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PackageGroupSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPackageGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_GROUPS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<PackageGroupSummary> packageGroups;

    private final String nextToken;

    private ListPackageGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.packageGroups = builder.packageGroups;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PackageGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPackageGroups() {
        return packageGroups != null && !(packageGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of package groups in the requested domain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPackageGroups} method.
     * </p>
     * 
     * @return The list of package groups in the requested domain.
     */
    public final List<PackageGroupSummary> packageGroups() {
        return packageGroups;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPackageGroups() ? packageGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPackageGroupsResponse)) {
            return false;
        }
        ListPackageGroupsResponse other = (ListPackageGroupsResponse) obj;
        return hasPackageGroups() == other.hasPackageGroups() && Objects.equals(packageGroups(), other.packageGroups())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPackageGroupsResponse").add("PackageGroups", hasPackageGroups() ? packageGroups() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "packageGroups":
            return Optional.ofNullable(clazz.cast(packageGroups()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPackageGroupsResponse, T> g) {
        return obj -> g.apply((ListPackageGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPackageGroupsResponse> {
        /**
         * <p>
         * The list of package groups in the requested domain.
         * </p>
         * 
         * @param packageGroups
         *        The list of package groups in the requested domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageGroups(Collection<PackageGroupSummary> packageGroups);

        /**
         * <p>
         * The list of package groups in the requested domain.
         * </p>
         * 
         * @param packageGroups
         *        The list of package groups in the requested domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageGroups(PackageGroupSummary... packageGroups);

        /**
         * <p>
         * The list of package groups in the requested domain.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codeartifact.model.PackageGroupSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.codeartifact.model.PackageGroupSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codeartifact.model.PackageGroupSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #packageGroups(List<PackageGroupSummary>)}.
         * 
         * @param packageGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codeartifact.model.PackageGroupSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageGroups(java.util.Collection<PackageGroupSummary>)
         */
        Builder packageGroups(Consumer<PackageGroupSummary.Builder>... packageGroups);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeartifactResponse.BuilderImpl implements Builder {
        private List<PackageGroupSummary> packageGroups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPackageGroupsResponse model) {
            super(model);
            packageGroups(model.packageGroups);
            nextToken(model.nextToken);
        }

        public final List<PackageGroupSummary.Builder> getPackageGroups() {
            List<PackageGroupSummary.Builder> result = PackageGroupSummaryListCopier.copyToBuilder(this.packageGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPackageGroups(Collection<PackageGroupSummary.BuilderImpl> packageGroups) {
            this.packageGroups = PackageGroupSummaryListCopier.copyFromBuilder(packageGroups);
        }

        @Override
        public final Builder packageGroups(Collection<PackageGroupSummary> packageGroups) {
            this.packageGroups = PackageGroupSummaryListCopier.copy(packageGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageGroups(PackageGroupSummary... packageGroups) {
            packageGroups(Arrays.asList(packageGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageGroups(Consumer<PackageGroupSummary.Builder>... packageGroups) {
            packageGroups(Stream.of(packageGroups).map(c -> PackageGroupSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPackageGroupsResponse build() {
            return new ListPackageGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
