/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a package dependency.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackageDependency implements SdkPojo, Serializable,
        ToCopyableBuilder<PackageDependency.Builder, PackageDependency> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(PackageDependency::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final SdkField<String> PACKAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("package")
            .getter(getter(PackageDependency::packageValue)).setter(setter(Builder::packageValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("package").build()).build();

    private static final SdkField<String> DEPENDENCY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dependencyType").getter(getter(PackageDependency::dependencyType))
            .setter(setter(Builder::dependencyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependencyType").build()).build();

    private static final SdkField<String> VERSION_REQUIREMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionRequirement").getter(getter(PackageDependency::versionRequirement))
            .setter(setter(Builder::versionRequirement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionRequirement").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD,
            PACKAGE_FIELD, DEPENDENCY_TYPE_FIELD, VERSION_REQUIREMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String namespace;

    private final String packageValue;

    private final String dependencyType;

    private final String versionRequirement;

    private PackageDependency(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.packageValue = builder.packageValue;
        this.dependencyType = builder.dependencyType;
        this.versionRequirement = builder.versionRequirement;
    }

    /**
     * <p>
     * The namespace of the package that this package depends on. The package component that specifies its namespace
     * depends on its type. For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The namespace of a Maven package version is its <code>groupId</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The namespace of an npm or Swift package version is its <code>scope</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The namespace of a generic package is its <code>namespace</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Python and NuGet package versions do not contain a corresponding component, package versions of those formats do
     * not have a namespace.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The namespace of the package that this package depends on. The package component that specifies its
     *         namespace depends on its type. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The namespace of a Maven package version is its <code>groupId</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The namespace of an npm or Swift package version is its <code>scope</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The namespace of a generic package is its <code>namespace</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Python and NuGet package versions do not contain a corresponding component, package versions of those
     *         formats do not have a namespace.
     *         </p>
     *         </li>
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the package that this package depends on.
     * </p>
     * 
     * @return The name of the package that this package depends on.
     */
    public final String packageValue() {
        return packageValue;
    }

    /**
     * <p>
     * The type of a package dependency. The possible values depend on the package type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * npm: <code>regular</code>, <code>dev</code>, <code>peer</code>, <code>optional</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * maven: <code>optional</code>, <code>parent</code>, <code>compile</code>, <code>runtime</code>, <code>test</code>,
     * <code>system</code>, <code>provided</code>.
     * </p>
     * <note>
     * <p>
     * Note that <code>parent</code> is not a regular Maven dependency type; instead this is extracted from the
     * <code>&lt;parent&gt;</code> element if one is defined in the package version's POM file.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * nuget: The <code>dependencyType</code> field is never set for NuGet packages.
     * </p>
     * </li>
     * <li>
     * <p>
     * pypi: <code>Requires-Dist</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of a package dependency. The possible values depend on the package type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         npm: <code>regular</code>, <code>dev</code>, <code>peer</code>, <code>optional</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         maven: <code>optional</code>, <code>parent</code>, <code>compile</code>, <code>runtime</code>,
     *         <code>test</code>, <code>system</code>, <code>provided</code>.
     *         </p>
     *         <note>
     *         <p>
     *         Note that <code>parent</code> is not a regular Maven dependency type; instead this is extracted from the
     *         <code>&lt;parent&gt;</code> element if one is defined in the package version's POM file.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         nuget: The <code>dependencyType</code> field is never set for NuGet packages.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         pypi: <code>Requires-Dist</code>
     *         </p>
     *         </li>
     */
    public final String dependencyType() {
        return dependencyType;
    }

    /**
     * <p>
     * The required version, or version range, of the package that this package depends on. The version format is
     * specific to the package type. For example, the following are possible valid required versions: <code>1.2.3</code>, <code>^2.3.4</code>, or <code>4.x</code>.
     * </p>
     * 
     * @return The required version, or version range, of the package that this package depends on. The version format
     *         is specific to the package type. For example, the following are possible valid required versions:
     *         <code>1.2.3</code>, <code>^2.3.4</code>, or <code>4.x</code>.
     */
    public final String versionRequirement() {
        return versionRequirement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(packageValue());
        hashCode = 31 * hashCode + Objects.hashCode(dependencyType());
        hashCode = 31 * hashCode + Objects.hashCode(versionRequirement());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageDependency)) {
            return false;
        }
        PackageDependency other = (PackageDependency) obj;
        return Objects.equals(namespace(), other.namespace()) && Objects.equals(packageValue(), other.packageValue())
                && Objects.equals(dependencyType(), other.dependencyType())
                && Objects.equals(versionRequirement(), other.versionRequirement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackageDependency").add("Namespace", namespace()).add("Package", packageValue())
                .add("DependencyType", dependencyType()).add("VersionRequirement", versionRequirement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "package":
            return Optional.ofNullable(clazz.cast(packageValue()));
        case "dependencyType":
            return Optional.ofNullable(clazz.cast(dependencyType()));
        case "versionRequirement":
            return Optional.ofNullable(clazz.cast(versionRequirement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageDependency, T> g) {
        return obj -> g.apply((PackageDependency) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackageDependency> {
        /**
         * <p>
         * The namespace of the package that this package depends on. The package component that specifies its namespace
         * depends on its type. For example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The namespace of a Maven package version is its <code>groupId</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The namespace of an npm or Swift package version is its <code>scope</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The namespace of a generic package is its <code>namespace</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Python and NuGet package versions do not contain a corresponding component, package versions of those formats
         * do not have a namespace.
         * </p>
         * </li>
         * </ul>
         * 
         * @param namespace
         *        The namespace of the package that this package depends on. The package component that specifies its
         *        namespace depends on its type. For example:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The namespace of a Maven package version is its <code>groupId</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The namespace of an npm or Swift package version is its <code>scope</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The namespace of a generic package is its <code>namespace</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Python and NuGet package versions do not contain a corresponding component, package versions of those
         *        formats do not have a namespace.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the package that this package depends on.
         * </p>
         * 
         * @param packageValue
         *        The name of the package that this package depends on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageValue(String packageValue);

        /**
         * <p>
         * The type of a package dependency. The possible values depend on the package type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * npm: <code>regular</code>, <code>dev</code>, <code>peer</code>, <code>optional</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * maven: <code>optional</code>, <code>parent</code>, <code>compile</code>, <code>runtime</code>,
         * <code>test</code>, <code>system</code>, <code>provided</code>.
         * </p>
         * <note>
         * <p>
         * Note that <code>parent</code> is not a regular Maven dependency type; instead this is extracted from the
         * <code>&lt;parent&gt;</code> element if one is defined in the package version's POM file.
         * </p>
         * </note></li>
         * <li>
         * <p>
         * nuget: The <code>dependencyType</code> field is never set for NuGet packages.
         * </p>
         * </li>
         * <li>
         * <p>
         * pypi: <code>Requires-Dist</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param dependencyType
         *        The type of a package dependency. The possible values depend on the package type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        npm: <code>regular</code>, <code>dev</code>, <code>peer</code>, <code>optional</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        maven: <code>optional</code>, <code>parent</code>, <code>compile</code>, <code>runtime</code>,
         *        <code>test</code>, <code>system</code>, <code>provided</code>.
         *        </p>
         *        <note>
         *        <p>
         *        Note that <code>parent</code> is not a regular Maven dependency type; instead this is extracted from
         *        the <code>&lt;parent&gt;</code> element if one is defined in the package version's POM file.
         *        </p>
         *        </note></li>
         *        <li>
         *        <p>
         *        nuget: The <code>dependencyType</code> field is never set for NuGet packages.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        pypi: <code>Requires-Dist</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencyType(String dependencyType);

        /**
         * <p>
         * The required version, or version range, of the package that this package depends on. The version format is
         * specific to the package type. For example, the following are possible valid required versions:
         * <code>1.2.3</code>, <code>^2.3.4</code>, or <code>4.x</code>.
         * </p>
         * 
         * @param versionRequirement
         *        The required version, or version range, of the package that this package depends on. The version
         *        format is specific to the package type. For example, the following are possible valid required
         *        versions: <code>1.2.3</code>, <code>^2.3.4</code>, or <code>4.x</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionRequirement(String versionRequirement);
    }

    static final class BuilderImpl implements Builder {
        private String namespace;

        private String packageValue;

        private String dependencyType;

        private String versionRequirement;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageDependency model) {
            namespace(model.namespace);
            packageValue(model.packageValue);
            dependencyType(model.dependencyType);
            versionRequirement(model.versionRequirement);
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getPackageValue() {
            return packageValue;
        }

        public final void setPackageValue(String packageValue) {
            this.packageValue = packageValue;
        }

        @Override
        public final Builder packageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public final String getDependencyType() {
            return dependencyType;
        }

        public final void setDependencyType(String dependencyType) {
            this.dependencyType = dependencyType;
        }

        @Override
        public final Builder dependencyType(String dependencyType) {
            this.dependencyType = dependencyType;
            return this;
        }

        public final String getVersionRequirement() {
            return versionRequirement;
        }

        public final void setVersionRequirement(String versionRequirement) {
            this.versionRequirement = versionRequirement;
        }

        @Override
        public final Builder versionRequirement(String versionRequirement) {
            this.versionRequirement = versionRequirement;
            return this;
        }

        @Override
        public PackageDependency build() {
            return new PackageDependency(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
