/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePackageGroupOriginConfigurationRequest extends CodeartifactRequest implements
        ToCopyableBuilder<UpdatePackageGroupOriginConfigurationRequest.Builder, UpdatePackageGroupOriginConfigurationRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(UpdatePackageGroupOriginConfigurationRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()).build();

    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainOwner").getter(getter(UpdatePackageGroupOriginConfigurationRequest::domainOwner))
            .setter(setter(Builder::domainOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain-owner").build()).build();

    private static final SdkField<String> PACKAGE_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("packageGroup").getter(getter(UpdatePackageGroupOriginConfigurationRequest::packageGroup))
            .setter(setter(Builder::packageGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("package-group").build()).build();

    private static final SdkField<Map<String, String>> RESTRICTIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("restrictions")
            .getter(getter(UpdatePackageGroupOriginConfigurationRequest::restrictionsAsStrings))
            .setter(setter(Builder::restrictionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restrictions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<PackageGroupAllowedRepository>> ADD_ALLOWED_REPOSITORIES_FIELD = SdkField
            .<List<PackageGroupAllowedRepository>> builder(MarshallingType.LIST)
            .memberName("addAllowedRepositories")
            .getter(getter(UpdatePackageGroupOriginConfigurationRequest::addAllowedRepositories))
            .setter(setter(Builder::addAllowedRepositories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addAllowedRepositories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PackageGroupAllowedRepository> builder(MarshallingType.SDK_POJO)
                                            .constructor(PackageGroupAllowedRepository::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PackageGroupAllowedRepository>> REMOVE_ALLOWED_REPOSITORIES_FIELD = SdkField
            .<List<PackageGroupAllowedRepository>> builder(MarshallingType.LIST)
            .memberName("removeAllowedRepositories")
            .getter(getter(UpdatePackageGroupOriginConfigurationRequest::removeAllowedRepositories))
            .setter(setter(Builder::removeAllowedRepositories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeAllowedRepositories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PackageGroupAllowedRepository> builder(MarshallingType.SDK_POJO)
                                            .constructor(PackageGroupAllowedRepository::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            DOMAIN_OWNER_FIELD, PACKAGE_GROUP_FIELD, RESTRICTIONS_FIELD, ADD_ALLOWED_REPOSITORIES_FIELD,
            REMOVE_ALLOWED_REPOSITORIES_FIELD));

    private final String domain;

    private final String domainOwner;

    private final String packageGroup;

    private final Map<String, String> restrictions;

    private final List<PackageGroupAllowedRepository> addAllowedRepositories;

    private final List<PackageGroupAllowedRepository> removeAllowedRepositories;

    private UpdatePackageGroupOriginConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainOwner = builder.domainOwner;
        this.packageGroup = builder.packageGroup;
        this.restrictions = builder.restrictions;
        this.addAllowedRepositories = builder.addAllowedRepositories;
        this.removeAllowedRepositories = builder.removeAllowedRepositories;
    }

    /**
     * <p>
     * The name of the domain which contains the package group for which to update the origin configuration.
     * </p>
     * 
     * @return The name of the domain which contains the package group for which to update the origin configuration.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes
     * or spaces.
     * </p>
     * 
     * @return The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include
     *         dashes or spaces.
     */
    public final String domainOwner() {
        return domainOwner;
    }

    /**
     * <p>
     * The pattern of the package group for which to update the origin configuration.
     * </p>
     * 
     * @return The pattern of the package group for which to update the origin configuration.
     */
    public final String packageGroup() {
        return packageGroup;
    }

    /**
     * <p>
     * The origin configuration settings that determine how package versions can enter repositories.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRestrictions} method.
     * </p>
     * 
     * @return The origin configuration settings that determine how package versions can enter repositories.
     */
    public final Map<PackageGroupOriginRestrictionType, PackageGroupOriginRestrictionMode> restrictions() {
        return OriginRestrictionsCopier.copyStringToEnum(restrictions);
    }

    /**
     * For responses, this returns true if the service returned a value for the Restrictions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRestrictions() {
        return restrictions != null && !(restrictions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The origin configuration settings that determine how package versions can enter repositories.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRestrictions} method.
     * </p>
     * 
     * @return The origin configuration settings that determine how package versions can enter repositories.
     */
    public final Map<String, String> restrictionsAsStrings() {
        return restrictions;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddAllowedRepositories property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAddAllowedRepositories() {
        return addAllowedRepositories != null && !(addAllowedRepositories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The repository name and restrictions to add to the allowed repository list of the specified package group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddAllowedRepositories} method.
     * </p>
     * 
     * @return The repository name and restrictions to add to the allowed repository list of the specified package
     *         group.
     */
    public final List<PackageGroupAllowedRepository> addAllowedRepositories() {
        return addAllowedRepositories;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveAllowedRepositories property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRemoveAllowedRepositories() {
        return removeAllowedRepositories != null && !(removeAllowedRepositories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The repository name and restrictions to remove from the allowed repository list of the specified package group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveAllowedRepositories} method.
     * </p>
     * 
     * @return The repository name and restrictions to remove from the allowed repository list of the specified package
     *         group.
     */
    public final List<PackageGroupAllowedRepository> removeAllowedRepositories() {
        return removeAllowedRepositories;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(packageGroup());
        hashCode = 31 * hashCode + Objects.hashCode(hasRestrictions() ? restrictionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAddAllowedRepositories() ? addAllowedRepositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveAllowedRepositories() ? removeAllowedRepositories() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePackageGroupOriginConfigurationRequest)) {
            return false;
        }
        UpdatePackageGroupOriginConfigurationRequest other = (UpdatePackageGroupOriginConfigurationRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(domainOwner(), other.domainOwner())
                && Objects.equals(packageGroup(), other.packageGroup()) && hasRestrictions() == other.hasRestrictions()
                && Objects.equals(restrictionsAsStrings(), other.restrictionsAsStrings())
                && hasAddAllowedRepositories() == other.hasAddAllowedRepositories()
                && Objects.equals(addAllowedRepositories(), other.addAllowedRepositories())
                && hasRemoveAllowedRepositories() == other.hasRemoveAllowedRepositories()
                && Objects.equals(removeAllowedRepositories(), other.removeAllowedRepositories());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePackageGroupOriginConfigurationRequest").add("Domain", domain())
                .add("DomainOwner", domainOwner()).add("PackageGroup", packageGroup())
                .add("Restrictions", hasRestrictions() ? restrictionsAsStrings() : null)
                .add("AddAllowedRepositories", hasAddAllowedRepositories() ? addAllowedRepositories() : null)
                .add("RemoveAllowedRepositories", hasRemoveAllowedRepositories() ? removeAllowedRepositories() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "domainOwner":
            return Optional.ofNullable(clazz.cast(domainOwner()));
        case "packageGroup":
            return Optional.ofNullable(clazz.cast(packageGroup()));
        case "restrictions":
            return Optional.ofNullable(clazz.cast(restrictionsAsStrings()));
        case "addAllowedRepositories":
            return Optional.ofNullable(clazz.cast(addAllowedRepositories()));
        case "removeAllowedRepositories":
            return Optional.ofNullable(clazz.cast(removeAllowedRepositories()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePackageGroupOriginConfigurationRequest, T> g) {
        return obj -> g.apply((UpdatePackageGroupOriginConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePackageGroupOriginConfigurationRequest> {
        /**
         * <p>
         * The name of the domain which contains the package group for which to update the origin configuration.
         * </p>
         * 
         * @param domain
         *        The name of the domain which contains the package group for which to update the origin configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include
         * dashes or spaces.
         * </p>
         * 
         * @param domainOwner
         *        The 12-digit account number of the Amazon Web Services account that owns the domain. It does not
         *        include dashes or spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainOwner(String domainOwner);

        /**
         * <p>
         * The pattern of the package group for which to update the origin configuration.
         * </p>
         * 
         * @param packageGroup
         *        The pattern of the package group for which to update the origin configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageGroup(String packageGroup);

        /**
         * <p>
         * The origin configuration settings that determine how package versions can enter repositories.
         * </p>
         * 
         * @param restrictions
         *        The origin configuration settings that determine how package versions can enter repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restrictionsWithStrings(Map<String, String> restrictions);

        /**
         * <p>
         * The origin configuration settings that determine how package versions can enter repositories.
         * </p>
         * 
         * @param restrictions
         *        The origin configuration settings that determine how package versions can enter repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restrictions(Map<PackageGroupOriginRestrictionType, PackageGroupOriginRestrictionMode> restrictions);

        /**
         * <p>
         * The repository name and restrictions to add to the allowed repository list of the specified package group.
         * </p>
         * 
         * @param addAllowedRepositories
         *        The repository name and restrictions to add to the allowed repository list of the specified package
         *        group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addAllowedRepositories(Collection<PackageGroupAllowedRepository> addAllowedRepositories);

        /**
         * <p>
         * The repository name and restrictions to add to the allowed repository list of the specified package group.
         * </p>
         * 
         * @param addAllowedRepositories
         *        The repository name and restrictions to add to the allowed repository list of the specified package
         *        group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addAllowedRepositories(PackageGroupAllowedRepository... addAllowedRepositories);

        /**
         * <p>
         * The repository name and restrictions to add to the allowed repository list of the specified package group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codeartifact.model.PackageGroupAllowedRepository.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.codeartifact.model.PackageGroupAllowedRepository#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codeartifact.model.PackageGroupAllowedRepository.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #addAllowedRepositories(List<PackageGroupAllowedRepository>)}.
         * 
         * @param addAllowedRepositories
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codeartifact.model.PackageGroupAllowedRepository.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addAllowedRepositories(java.util.Collection<PackageGroupAllowedRepository>)
         */
        Builder addAllowedRepositories(Consumer<PackageGroupAllowedRepository.Builder>... addAllowedRepositories);

        /**
         * <p>
         * The repository name and restrictions to remove from the allowed repository list of the specified package
         * group.
         * </p>
         * 
         * @param removeAllowedRepositories
         *        The repository name and restrictions to remove from the allowed repository list of the specified
         *        package group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeAllowedRepositories(Collection<PackageGroupAllowedRepository> removeAllowedRepositories);

        /**
         * <p>
         * The repository name and restrictions to remove from the allowed repository list of the specified package
         * group.
         * </p>
         * 
         * @param removeAllowedRepositories
         *        The repository name and restrictions to remove from the allowed repository list of the specified
         *        package group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeAllowedRepositories(PackageGroupAllowedRepository... removeAllowedRepositories);

        /**
         * <p>
         * The repository name and restrictions to remove from the allowed repository list of the specified package
         * group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codeartifact.model.PackageGroupAllowedRepository.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.codeartifact.model.PackageGroupAllowedRepository#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codeartifact.model.PackageGroupAllowedRepository.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #removeAllowedRepositories(List<PackageGroupAllowedRepository>)}.
         * 
         * @param removeAllowedRepositories
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codeartifact.model.PackageGroupAllowedRepository.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #removeAllowedRepositories(java.util.Collection<PackageGroupAllowedRepository>)
         */
        Builder removeAllowedRepositories(Consumer<PackageGroupAllowedRepository.Builder>... removeAllowedRepositories);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeartifactRequest.BuilderImpl implements Builder {
        private String domain;

        private String domainOwner;

        private String packageGroup;

        private Map<String, String> restrictions = DefaultSdkAutoConstructMap.getInstance();

        private List<PackageGroupAllowedRepository> addAllowedRepositories = DefaultSdkAutoConstructList.getInstance();

        private List<PackageGroupAllowedRepository> removeAllowedRepositories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePackageGroupOriginConfigurationRequest model) {
            super(model);
            domain(model.domain);
            domainOwner(model.domainOwner);
            packageGroup(model.packageGroup);
            restrictionsWithStrings(model.restrictions);
            addAllowedRepositories(model.addAllowedRepositories);
            removeAllowedRepositories(model.removeAllowedRepositories);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getDomainOwner() {
            return domainOwner;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final String getPackageGroup() {
            return packageGroup;
        }

        public final void setPackageGroup(String packageGroup) {
            this.packageGroup = packageGroup;
        }

        @Override
        public final Builder packageGroup(String packageGroup) {
            this.packageGroup = packageGroup;
            return this;
        }

        public final Map<String, String> getRestrictions() {
            if (restrictions instanceof SdkAutoConstructMap) {
                return null;
            }
            return restrictions;
        }

        public final void setRestrictions(Map<String, String> restrictions) {
            this.restrictions = OriginRestrictionsCopier.copy(restrictions);
        }

        @Override
        public final Builder restrictionsWithStrings(Map<String, String> restrictions) {
            this.restrictions = OriginRestrictionsCopier.copy(restrictions);
            return this;
        }

        @Override
        public final Builder restrictions(Map<PackageGroupOriginRestrictionType, PackageGroupOriginRestrictionMode> restrictions) {
            this.restrictions = OriginRestrictionsCopier.copyEnumToString(restrictions);
            return this;
        }

        public final List<PackageGroupAllowedRepository.Builder> getAddAllowedRepositories() {
            List<PackageGroupAllowedRepository.Builder> result = PackageGroupAllowedRepositoryListCopier
                    .copyToBuilder(this.addAllowedRepositories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddAllowedRepositories(Collection<PackageGroupAllowedRepository.BuilderImpl> addAllowedRepositories) {
            this.addAllowedRepositories = PackageGroupAllowedRepositoryListCopier.copyFromBuilder(addAllowedRepositories);
        }

        @Override
        public final Builder addAllowedRepositories(Collection<PackageGroupAllowedRepository> addAllowedRepositories) {
            this.addAllowedRepositories = PackageGroupAllowedRepositoryListCopier.copy(addAllowedRepositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addAllowedRepositories(PackageGroupAllowedRepository... addAllowedRepositories) {
            addAllowedRepositories(Arrays.asList(addAllowedRepositories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addAllowedRepositories(Consumer<PackageGroupAllowedRepository.Builder>... addAllowedRepositories) {
            addAllowedRepositories(Stream.of(addAllowedRepositories)
                    .map(c -> PackageGroupAllowedRepository.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PackageGroupAllowedRepository.Builder> getRemoveAllowedRepositories() {
            List<PackageGroupAllowedRepository.Builder> result = PackageGroupAllowedRepositoryListCopier
                    .copyToBuilder(this.removeAllowedRepositories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoveAllowedRepositories(
                Collection<PackageGroupAllowedRepository.BuilderImpl> removeAllowedRepositories) {
            this.removeAllowedRepositories = PackageGroupAllowedRepositoryListCopier.copyFromBuilder(removeAllowedRepositories);
        }

        @Override
        public final Builder removeAllowedRepositories(Collection<PackageGroupAllowedRepository> removeAllowedRepositories) {
            this.removeAllowedRepositories = PackageGroupAllowedRepositoryListCopier.copy(removeAllowedRepositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeAllowedRepositories(PackageGroupAllowedRepository... removeAllowedRepositories) {
            removeAllowedRepositories(Arrays.asList(removeAllowedRepositories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeAllowedRepositories(
                Consumer<PackageGroupAllowedRepository.Builder>... removeAllowedRepositories) {
            removeAllowedRepositories(Stream.of(removeAllowedRepositories)
                    .map(c -> PackageGroupAllowedRepository.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePackageGroupOriginConfigurationRequest build() {
            return new UpdatePackageGroupOriginConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
