/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePackageResponse extends CodeartifactResponse implements
        ToCopyableBuilder<DeletePackageResponse.Builder, DeletePackageResponse> {
    private static final SdkField<PackageSummary> DELETED_PACKAGE_FIELD = SdkField
            .<PackageSummary> builder(MarshallingType.SDK_POJO).memberName("deletedPackage")
            .getter(getter(DeletePackageResponse::deletedPackage)).setter(setter(Builder::deletedPackage))
            .constructor(PackageSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletedPackage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETED_PACKAGE_FIELD));

    private final PackageSummary deletedPackage;

    private DeletePackageResponse(BuilderImpl builder) {
        super(builder);
        this.deletedPackage = builder.deletedPackage;
    }

    /**
     * Returns the value of the DeletedPackage property for this object.
     * 
     * @return The value of the DeletedPackage property for this object.
     */
    public final PackageSummary deletedPackage() {
        return deletedPackage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deletedPackage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePackageResponse)) {
            return false;
        }
        DeletePackageResponse other = (DeletePackageResponse) obj;
        return Objects.equals(deletedPackage(), other.deletedPackage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeletePackageResponse").add("DeletedPackage", deletedPackage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deletedPackage":
            return Optional.ofNullable(clazz.cast(deletedPackage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletePackageResponse, T> g) {
        return obj -> g.apply((DeletePackageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeletePackageResponse> {
        /**
         * Sets the value of the DeletedPackage property for this object.
         *
         * @param deletedPackage
         *        The new value for the DeletedPackage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletedPackage(PackageSummary deletedPackage);

        /**
         * Sets the value of the DeletedPackage property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PackageSummary.Builder} avoiding the need
         * to create one manually via {@link PackageSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PackageSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #deletedPackage(PackageSummary)}.
         * 
         * @param deletedPackage
         *        a consumer that will call methods on {@link PackageSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deletedPackage(PackageSummary)
         */
        default Builder deletedPackage(Consumer<PackageSummary.Builder> deletedPackage) {
            return deletedPackage(PackageSummary.builder().applyMutation(deletedPackage).build());
        }
    }

    static final class BuilderImpl extends CodeartifactResponse.BuilderImpl implements Builder {
        private PackageSummary deletedPackage;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePackageResponse model) {
            super(model);
            deletedPackage(model.deletedPackage);
        }

        public final PackageSummary.Builder getDeletedPackage() {
            return deletedPackage != null ? deletedPackage.toBuilder() : null;
        }

        public final void setDeletedPackage(PackageSummary.BuilderImpl deletedPackage) {
            this.deletedPackage = deletedPackage != null ? deletedPackage.build() : null;
        }

        @Override
        public final Builder deletedPackage(PackageSummary deletedPackage) {
            this.deletedPackage = deletedPackage;
            return this;
        }

        @Override
        public DeletePackageResponse build() {
            return new DeletePackageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
