/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the configured restrictions of the origin controls of a package group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackageGroupOriginRestriction implements SdkPojo, Serializable,
        ToCopyableBuilder<PackageGroupOriginRestriction.Builder, PackageGroupOriginRestriction> {
    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("mode")
            .getter(getter(PackageGroupOriginRestriction::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()).build();

    private static final SdkField<String> EFFECTIVE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("effectiveMode").getter(getter(PackageGroupOriginRestriction::effectiveModeAsString))
            .setter(setter(Builder::effectiveMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveMode").build()).build();

    private static final SdkField<PackageGroupReference> INHERITED_FROM_FIELD = SdkField
            .<PackageGroupReference> builder(MarshallingType.SDK_POJO).memberName("inheritedFrom")
            .getter(getter(PackageGroupOriginRestriction::inheritedFrom)).setter(setter(Builder::inheritedFrom))
            .constructor(PackageGroupReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inheritedFrom").build()).build();

    private static final SdkField<Long> REPOSITORIES_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("repositoriesCount").getter(getter(PackageGroupOriginRestriction::repositoriesCount))
            .setter(setter(Builder::repositoriesCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoriesCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD,
            EFFECTIVE_MODE_FIELD, INHERITED_FROM_FIELD, REPOSITORIES_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mode;

    private final String effectiveMode;

    private final PackageGroupReference inheritedFrom;

    private final Long repositoriesCount;

    private PackageGroupOriginRestriction(BuilderImpl builder) {
        this.mode = builder.mode;
        this.effectiveMode = builder.effectiveMode;
        this.inheritedFrom = builder.inheritedFrom;
        this.repositoriesCount = builder.repositoriesCount;
    }

    /**
     * <p>
     * The package group origin restriction setting. If the value of <code>mode</code> is <code>ALLOW</code>,
     * <code>ALLOW_SPECIFIC_REPOSITORIES</code>, or <code>BLOCK</code>, then the value of <code>effectiveMode</code> is
     * the same. Otherwise, when the value is <code>INHERIT</code>, then the value of <code>effectiveMode</code> is the
     * value of <code>mode</code> of the first parent group which does not have a value of <code>INHERIT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link PackageGroupOriginRestrictionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #modeAsString}.
     * </p>
     * 
     * @return The package group origin restriction setting. If the value of <code>mode</code> is <code>ALLOW</code>,
     *         <code>ALLOW_SPECIFIC_REPOSITORIES</code>, or <code>BLOCK</code>, then the value of
     *         <code>effectiveMode</code> is the same. Otherwise, when the value is <code>INHERIT</code>, then the value
     *         of <code>effectiveMode</code> is the value of <code>mode</code> of the first parent group which does not
     *         have a value of <code>INHERIT</code>.
     * @see PackageGroupOriginRestrictionMode
     */
    public final PackageGroupOriginRestrictionMode mode() {
        return PackageGroupOriginRestrictionMode.fromValue(mode);
    }

    /**
     * <p>
     * The package group origin restriction setting. If the value of <code>mode</code> is <code>ALLOW</code>,
     * <code>ALLOW_SPECIFIC_REPOSITORIES</code>, or <code>BLOCK</code>, then the value of <code>effectiveMode</code> is
     * the same. Otherwise, when the value is <code>INHERIT</code>, then the value of <code>effectiveMode</code> is the
     * value of <code>mode</code> of the first parent group which does not have a value of <code>INHERIT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link PackageGroupOriginRestrictionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #modeAsString}.
     * </p>
     * 
     * @return The package group origin restriction setting. If the value of <code>mode</code> is <code>ALLOW</code>,
     *         <code>ALLOW_SPECIFIC_REPOSITORIES</code>, or <code>BLOCK</code>, then the value of
     *         <code>effectiveMode</code> is the same. Otherwise, when the value is <code>INHERIT</code>, then the value
     *         of <code>effectiveMode</code> is the value of <code>mode</code> of the first parent group which does not
     *         have a value of <code>INHERIT</code>.
     * @see PackageGroupOriginRestrictionMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * The effective package group origin restriction setting. If the value of <code>mode</code> is <code>ALLOW</code>,
     * <code>ALLOW_SPECIFIC_REPOSITORIES</code>, or <code>BLOCK</code>, then the value of <code>effectiveMode</code> is
     * the same. Otherwise, when the value of <code>mode</code> is <code>INHERIT</code>, then the value of
     * <code>effectiveMode</code> is the value of <code>mode</code> of the first parent group which does not have a
     * value of <code>INHERIT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #effectiveMode}
     * will return {@link PackageGroupOriginRestrictionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #effectiveModeAsString}.
     * </p>
     * 
     * @return The effective package group origin restriction setting. If the value of <code>mode</code> is
     *         <code>ALLOW</code>, <code>ALLOW_SPECIFIC_REPOSITORIES</code>, or <code>BLOCK</code>, then the value of
     *         <code>effectiveMode</code> is the same. Otherwise, when the value of <code>mode</code> is
     *         <code>INHERIT</code>, then the value of <code>effectiveMode</code> is the value of <code>mode</code> of
     *         the first parent group which does not have a value of <code>INHERIT</code>.
     * @see PackageGroupOriginRestrictionMode
     */
    public final PackageGroupOriginRestrictionMode effectiveMode() {
        return PackageGroupOriginRestrictionMode.fromValue(effectiveMode);
    }

    /**
     * <p>
     * The effective package group origin restriction setting. If the value of <code>mode</code> is <code>ALLOW</code>,
     * <code>ALLOW_SPECIFIC_REPOSITORIES</code>, or <code>BLOCK</code>, then the value of <code>effectiveMode</code> is
     * the same. Otherwise, when the value of <code>mode</code> is <code>INHERIT</code>, then the value of
     * <code>effectiveMode</code> is the value of <code>mode</code> of the first parent group which does not have a
     * value of <code>INHERIT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #effectiveMode}
     * will return {@link PackageGroupOriginRestrictionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #effectiveModeAsString}.
     * </p>
     * 
     * @return The effective package group origin restriction setting. If the value of <code>mode</code> is
     *         <code>ALLOW</code>, <code>ALLOW_SPECIFIC_REPOSITORIES</code>, or <code>BLOCK</code>, then the value of
     *         <code>effectiveMode</code> is the same. Otherwise, when the value of <code>mode</code> is
     *         <code>INHERIT</code>, then the value of <code>effectiveMode</code> is the value of <code>mode</code> of
     *         the first parent group which does not have a value of <code>INHERIT</code>.
     * @see PackageGroupOriginRestrictionMode
     */
    public final String effectiveModeAsString() {
        return effectiveMode;
    }

    /**
     * <p>
     * The parent package group that the package group origin restrictions are inherited from.
     * </p>
     * 
     * @return The parent package group that the package group origin restrictions are inherited from.
     */
    public final PackageGroupReference inheritedFrom() {
        return inheritedFrom;
    }

    /**
     * <p>
     * The number of repositories in the allowed repository list.
     * </p>
     * 
     * @return The number of repositories in the allowed repository list.
     */
    public final Long repositoriesCount() {
        return repositoriesCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inheritedFrom());
        hashCode = 31 * hashCode + Objects.hashCode(repositoriesCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageGroupOriginRestriction)) {
            return false;
        }
        PackageGroupOriginRestriction other = (PackageGroupOriginRestriction) obj;
        return Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(effectiveModeAsString(), other.effectiveModeAsString())
                && Objects.equals(inheritedFrom(), other.inheritedFrom())
                && Objects.equals(repositoriesCount(), other.repositoriesCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackageGroupOriginRestriction").add("Mode", modeAsString())
                .add("EffectiveMode", effectiveModeAsString()).add("InheritedFrom", inheritedFrom())
                .add("RepositoriesCount", repositoriesCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "effectiveMode":
            return Optional.ofNullable(clazz.cast(effectiveModeAsString()));
        case "inheritedFrom":
            return Optional.ofNullable(clazz.cast(inheritedFrom()));
        case "repositoriesCount":
            return Optional.ofNullable(clazz.cast(repositoriesCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageGroupOriginRestriction, T> g) {
        return obj -> g.apply((PackageGroupOriginRestriction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackageGroupOriginRestriction> {
        /**
         * <p>
         * The package group origin restriction setting. If the value of <code>mode</code> is <code>ALLOW</code>,
         * <code>ALLOW_SPECIFIC_REPOSITORIES</code>, or <code>BLOCK</code>, then the value of <code>effectiveMode</code>
         * is the same. Otherwise, when the value is <code>INHERIT</code>, then the value of <code>effectiveMode</code>
         * is the value of <code>mode</code> of the first parent group which does not have a value of
         * <code>INHERIT</code>.
         * </p>
         * 
         * @param mode
         *        The package group origin restriction setting. If the value of <code>mode</code> is <code>ALLOW</code>,
         *        <code>ALLOW_SPECIFIC_REPOSITORIES</code>, or <code>BLOCK</code>, then the value of
         *        <code>effectiveMode</code> is the same. Otherwise, when the value is <code>INHERIT</code>, then the
         *        value of <code>effectiveMode</code> is the value of <code>mode</code> of the first parent group which
         *        does not have a value of <code>INHERIT</code>.
         * @see PackageGroupOriginRestrictionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageGroupOriginRestrictionMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The package group origin restriction setting. If the value of <code>mode</code> is <code>ALLOW</code>,
         * <code>ALLOW_SPECIFIC_REPOSITORIES</code>, or <code>BLOCK</code>, then the value of <code>effectiveMode</code>
         * is the same. Otherwise, when the value is <code>INHERIT</code>, then the value of <code>effectiveMode</code>
         * is the value of <code>mode</code> of the first parent group which does not have a value of
         * <code>INHERIT</code>.
         * </p>
         * 
         * @param mode
         *        The package group origin restriction setting. If the value of <code>mode</code> is <code>ALLOW</code>,
         *        <code>ALLOW_SPECIFIC_REPOSITORIES</code>, or <code>BLOCK</code>, then the value of
         *        <code>effectiveMode</code> is the same. Otherwise, when the value is <code>INHERIT</code>, then the
         *        value of <code>effectiveMode</code> is the value of <code>mode</code> of the first parent group which
         *        does not have a value of <code>INHERIT</code>.
         * @see PackageGroupOriginRestrictionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageGroupOriginRestrictionMode
         */
        Builder mode(PackageGroupOriginRestrictionMode mode);

        /**
         * <p>
         * The effective package group origin restriction setting. If the value of <code>mode</code> is
         * <code>ALLOW</code>, <code>ALLOW_SPECIFIC_REPOSITORIES</code>, or <code>BLOCK</code>, then the value of
         * <code>effectiveMode</code> is the same. Otherwise, when the value of <code>mode</code> is
         * <code>INHERIT</code>, then the value of <code>effectiveMode</code> is the value of <code>mode</code> of the
         * first parent group which does not have a value of <code>INHERIT</code>.
         * </p>
         * 
         * @param effectiveMode
         *        The effective package group origin restriction setting. If the value of <code>mode</code> is
         *        <code>ALLOW</code>, <code>ALLOW_SPECIFIC_REPOSITORIES</code>, or <code>BLOCK</code>, then the value of
         *        <code>effectiveMode</code> is the same. Otherwise, when the value of <code>mode</code> is
         *        <code>INHERIT</code>, then the value of <code>effectiveMode</code> is the value of <code>mode</code>
         *        of the first parent group which does not have a value of <code>INHERIT</code>.
         * @see PackageGroupOriginRestrictionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageGroupOriginRestrictionMode
         */
        Builder effectiveMode(String effectiveMode);

        /**
         * <p>
         * The effective package group origin restriction setting. If the value of <code>mode</code> is
         * <code>ALLOW</code>, <code>ALLOW_SPECIFIC_REPOSITORIES</code>, or <code>BLOCK</code>, then the value of
         * <code>effectiveMode</code> is the same. Otherwise, when the value of <code>mode</code> is
         * <code>INHERIT</code>, then the value of <code>effectiveMode</code> is the value of <code>mode</code> of the
         * first parent group which does not have a value of <code>INHERIT</code>.
         * </p>
         * 
         * @param effectiveMode
         *        The effective package group origin restriction setting. If the value of <code>mode</code> is
         *        <code>ALLOW</code>, <code>ALLOW_SPECIFIC_REPOSITORIES</code>, or <code>BLOCK</code>, then the value of
         *        <code>effectiveMode</code> is the same. Otherwise, when the value of <code>mode</code> is
         *        <code>INHERIT</code>, then the value of <code>effectiveMode</code> is the value of <code>mode</code>
         *        of the first parent group which does not have a value of <code>INHERIT</code>.
         * @see PackageGroupOriginRestrictionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageGroupOriginRestrictionMode
         */
        Builder effectiveMode(PackageGroupOriginRestrictionMode effectiveMode);

        /**
         * <p>
         * The parent package group that the package group origin restrictions are inherited from.
         * </p>
         * 
         * @param inheritedFrom
         *        The parent package group that the package group origin restrictions are inherited from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inheritedFrom(PackageGroupReference inheritedFrom);

        /**
         * <p>
         * The parent package group that the package group origin restrictions are inherited from.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageGroupReference.Builder} avoiding
         * the need to create one manually via {@link PackageGroupReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PackageGroupReference.Builder#build()} is called immediately and
         * its result is passed to {@link #inheritedFrom(PackageGroupReference)}.
         * 
         * @param inheritedFrom
         *        a consumer that will call methods on {@link PackageGroupReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inheritedFrom(PackageGroupReference)
         */
        default Builder inheritedFrom(Consumer<PackageGroupReference.Builder> inheritedFrom) {
            return inheritedFrom(PackageGroupReference.builder().applyMutation(inheritedFrom).build());
        }

        /**
         * <p>
         * The number of repositories in the allowed repository list.
         * </p>
         * 
         * @param repositoriesCount
         *        The number of repositories in the allowed repository list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoriesCount(Long repositoriesCount);
    }

    static final class BuilderImpl implements Builder {
        private String mode;

        private String effectiveMode;

        private PackageGroupReference inheritedFrom;

        private Long repositoriesCount;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageGroupOriginRestriction model) {
            mode(model.mode);
            effectiveMode(model.effectiveMode);
            inheritedFrom(model.inheritedFrom);
            repositoriesCount(model.repositoriesCount);
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(PackageGroupOriginRestrictionMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getEffectiveMode() {
            return effectiveMode;
        }

        public final void setEffectiveMode(String effectiveMode) {
            this.effectiveMode = effectiveMode;
        }

        @Override
        public final Builder effectiveMode(String effectiveMode) {
            this.effectiveMode = effectiveMode;
            return this;
        }

        @Override
        public final Builder effectiveMode(PackageGroupOriginRestrictionMode effectiveMode) {
            this.effectiveMode(effectiveMode == null ? null : effectiveMode.toString());
            return this;
        }

        public final PackageGroupReference.Builder getInheritedFrom() {
            return inheritedFrom != null ? inheritedFrom.toBuilder() : null;
        }

        public final void setInheritedFrom(PackageGroupReference.BuilderImpl inheritedFrom) {
            this.inheritedFrom = inheritedFrom != null ? inheritedFrom.build() : null;
        }

        @Override
        public final Builder inheritedFrom(PackageGroupReference inheritedFrom) {
            this.inheritedFrom = inheritedFrom;
            return this;
        }

        public final Long getRepositoriesCount() {
            return repositoriesCount;
        }

        public final void setRepositoriesCount(Long repositoriesCount) {
            this.repositoriesCount = repositoriesCount;
        }

        @Override
        public final Builder repositoriesCount(Long repositoriesCount) {
            this.repositoriesCount = repositoriesCount;
            return this;
        }

        @Override
        public PackageGroupOriginRestriction build() {
            return new PackageGroupOriginRestriction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
