/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a package group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackageGroupSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<PackageGroupSummary.Builder, PackageGroupSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(PackageGroupSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("pattern")
            .getter(getter(PackageGroupSummary::pattern)).setter(setter(Builder::pattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pattern").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainName").getter(getter(PackageGroupSummary::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainOwner").getter(getter(PackageGroupSummary::domainOwner)).setter(setter(Builder::domainOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainOwner").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTime").getter(getter(PackageGroupSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()).build();

    private static final SdkField<String> CONTACT_INFO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contactInfo").getter(getter(PackageGroupSummary::contactInfo)).setter(setter(Builder::contactInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactInfo").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(PackageGroupSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<PackageGroupOriginConfiguration> ORIGIN_CONFIGURATION_FIELD = SdkField
            .<PackageGroupOriginConfiguration> builder(MarshallingType.SDK_POJO).memberName("originConfiguration")
            .getter(getter(PackageGroupSummary::originConfiguration)).setter(setter(Builder::originConfiguration))
            .constructor(PackageGroupOriginConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originConfiguration").build())
            .build();

    private static final SdkField<PackageGroupReference> PARENT_FIELD = SdkField
            .<PackageGroupReference> builder(MarshallingType.SDK_POJO).memberName("parent")
            .getter(getter(PackageGroupSummary::parent)).setter(setter(Builder::parent))
            .constructor(PackageGroupReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, PATTERN_FIELD,
            DOMAIN_NAME_FIELD, DOMAIN_OWNER_FIELD, CREATED_TIME_FIELD, CONTACT_INFO_FIELD, DESCRIPTION_FIELD,
            ORIGIN_CONFIGURATION_FIELD, PARENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String pattern;

    private final String domainName;

    private final String domainOwner;

    private final Instant createdTime;

    private final String contactInfo;

    private final String description;

    private final PackageGroupOriginConfiguration originConfiguration;

    private final PackageGroupReference parent;

    private PackageGroupSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.pattern = builder.pattern;
        this.domainName = builder.domainName;
        this.domainOwner = builder.domainOwner;
        this.createdTime = builder.createdTime;
        this.contactInfo = builder.contactInfo;
        this.description = builder.description;
        this.originConfiguration = builder.originConfiguration;
        this.parent = builder.parent;
    }

    /**
     * <p>
     * The ARN of the package group.
     * </p>
     * 
     * @return The ARN of the package group.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The pattern of the package group. The pattern determines which packages are associated with the package group.
     * </p>
     * 
     * @return The pattern of the package group. The pattern determines which packages are associated with the package
     *         group.
     */
    public final String pattern() {
        return pattern;
    }

    /**
     * <p>
     * The domain that contains the package group.
     * </p>
     * 
     * @return The domain that contains the package group.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes
     * or spaces.
     * </p>
     * 
     * @return The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include
     *         dashes or spaces.
     */
    public final String domainOwner() {
        return domainOwner;
    }

    /**
     * <p>
     * A timestamp that represents the date and time the repository was created.
     * </p>
     * 
     * @return A timestamp that represents the date and time the repository was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The contact information of the package group.
     * </p>
     * 
     * @return The contact information of the package group.
     */
    public final String contactInfo() {
        return contactInfo;
    }

    /**
     * <p>
     * The description of the package group.
     * </p>
     * 
     * @return The description of the package group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Details about the package origin configuration of a package group.
     * </p>
     * 
     * @return Details about the package origin configuration of a package group.
     */
    public final PackageGroupOriginConfiguration originConfiguration() {
        return originConfiguration;
    }

    /**
     * <p>
     * The direct parent package group of the package group.
     * </p>
     * 
     * @return The direct parent package group of the package group.
     */
    public final PackageGroupReference parent() {
        return parent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(pattern());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(contactInfo());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(originConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(parent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageGroupSummary)) {
            return false;
        }
        PackageGroupSummary other = (PackageGroupSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(pattern(), other.pattern())
                && Objects.equals(domainName(), other.domainName()) && Objects.equals(domainOwner(), other.domainOwner())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(contactInfo(), other.contactInfo())
                && Objects.equals(description(), other.description())
                && Objects.equals(originConfiguration(), other.originConfiguration()) && Objects.equals(parent(), other.parent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackageGroupSummary").add("Arn", arn()).add("Pattern", pattern())
                .add("DomainName", domainName()).add("DomainOwner", domainOwner()).add("CreatedTime", createdTime())
                .add("ContactInfo", contactInfo()).add("Description", description())
                .add("OriginConfiguration", originConfiguration()).add("Parent", parent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "pattern":
            return Optional.ofNullable(clazz.cast(pattern()));
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "domainOwner":
            return Optional.ofNullable(clazz.cast(domainOwner()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "contactInfo":
            return Optional.ofNullable(clazz.cast(contactInfo()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "originConfiguration":
            return Optional.ofNullable(clazz.cast(originConfiguration()));
        case "parent":
            return Optional.ofNullable(clazz.cast(parent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageGroupSummary, T> g) {
        return obj -> g.apply((PackageGroupSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackageGroupSummary> {
        /**
         * <p>
         * The ARN of the package group.
         * </p>
         * 
         * @param arn
         *        The ARN of the package group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The pattern of the package group. The pattern determines which packages are associated with the package
         * group.
         * </p>
         * 
         * @param pattern
         *        The pattern of the package group. The pattern determines which packages are associated with the
         *        package group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pattern(String pattern);

        /**
         * <p>
         * The domain that contains the package group.
         * </p>
         * 
         * @param domainName
         *        The domain that contains the package group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include
         * dashes or spaces.
         * </p>
         * 
         * @param domainOwner
         *        The 12-digit account number of the Amazon Web Services account that owns the domain. It does not
         *        include dashes or spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainOwner(String domainOwner);

        /**
         * <p>
         * A timestamp that represents the date and time the repository was created.
         * </p>
         * 
         * @param createdTime
         *        A timestamp that represents the date and time the repository was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The contact information of the package group.
         * </p>
         * 
         * @param contactInfo
         *        The contact information of the package group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactInfo(String contactInfo);

        /**
         * <p>
         * The description of the package group.
         * </p>
         * 
         * @param description
         *        The description of the package group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Details about the package origin configuration of a package group.
         * </p>
         * 
         * @param originConfiguration
         *        Details about the package origin configuration of a package group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originConfiguration(PackageGroupOriginConfiguration originConfiguration);

        /**
         * <p>
         * Details about the package origin configuration of a package group.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageGroupOriginConfiguration.Builder}
         * avoiding the need to create one manually via {@link PackageGroupOriginConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PackageGroupOriginConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #originConfiguration(PackageGroupOriginConfiguration)}.
         * 
         * @param originConfiguration
         *        a consumer that will call methods on {@link PackageGroupOriginConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #originConfiguration(PackageGroupOriginConfiguration)
         */
        default Builder originConfiguration(Consumer<PackageGroupOriginConfiguration.Builder> originConfiguration) {
            return originConfiguration(PackageGroupOriginConfiguration.builder().applyMutation(originConfiguration).build());
        }

        /**
         * <p>
         * The direct parent package group of the package group.
         * </p>
         * 
         * @param parent
         *        The direct parent package group of the package group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parent(PackageGroupReference parent);

        /**
         * <p>
         * The direct parent package group of the package group.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageGroupReference.Builder} avoiding
         * the need to create one manually via {@link PackageGroupReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PackageGroupReference.Builder#build()} is called immediately and
         * its result is passed to {@link #parent(PackageGroupReference)}.
         * 
         * @param parent
         *        a consumer that will call methods on {@link PackageGroupReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parent(PackageGroupReference)
         */
        default Builder parent(Consumer<PackageGroupReference.Builder> parent) {
            return parent(PackageGroupReference.builder().applyMutation(parent).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String pattern;

        private String domainName;

        private String domainOwner;

        private Instant createdTime;

        private String contactInfo;

        private String description;

        private PackageGroupOriginConfiguration originConfiguration;

        private PackageGroupReference parent;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageGroupSummary model) {
            arn(model.arn);
            pattern(model.pattern);
            domainName(model.domainName);
            domainOwner(model.domainOwner);
            createdTime(model.createdTime);
            contactInfo(model.contactInfo);
            description(model.description);
            originConfiguration(model.originConfiguration);
            parent(model.parent);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getPattern() {
            return pattern;
        }

        public final void setPattern(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public final Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getDomainOwner() {
            return domainOwner;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getContactInfo() {
            return contactInfo;
        }

        public final void setContactInfo(String contactInfo) {
            this.contactInfo = contactInfo;
        }

        @Override
        public final Builder contactInfo(String contactInfo) {
            this.contactInfo = contactInfo;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final PackageGroupOriginConfiguration.Builder getOriginConfiguration() {
            return originConfiguration != null ? originConfiguration.toBuilder() : null;
        }

        public final void setOriginConfiguration(PackageGroupOriginConfiguration.BuilderImpl originConfiguration) {
            this.originConfiguration = originConfiguration != null ? originConfiguration.build() : null;
        }

        @Override
        public final Builder originConfiguration(PackageGroupOriginConfiguration originConfiguration) {
            this.originConfiguration = originConfiguration;
            return this;
        }

        public final PackageGroupReference.Builder getParent() {
            return parent != null ? parent.toBuilder() : null;
        }

        public final void setParent(PackageGroupReference.BuilderImpl parent) {
            this.parent = parent != null ? parent.build() : null;
        }

        @Override
        public final Builder parent(PackageGroupReference parent) {
            this.parent = parent;
            return this;
        }

        @Override
        public PackageGroupSummary build() {
            return new PackageGroupSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
