/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssociatedPackagesRequest extends CodeartifactRequest implements
        ToCopyableBuilder<ListAssociatedPackagesRequest.Builder, ListAssociatedPackagesRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(ListAssociatedPackagesRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()).build();

    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainOwner").getter(getter(ListAssociatedPackagesRequest::domainOwner))
            .setter(setter(Builder::domainOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain-owner").build()).build();

    private static final SdkField<String> PACKAGE_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("packageGroup").getter(getter(ListAssociatedPackagesRequest::packageGroup))
            .setter(setter(Builder::packageGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("package-group").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListAssociatedPackagesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAssociatedPackagesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()).build();

    private static final SdkField<Boolean> PREVIEW_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("preview").getter(getter(ListAssociatedPackagesRequest::preview)).setter(setter(Builder::preview))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("preview").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            DOMAIN_OWNER_FIELD, PACKAGE_GROUP_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, PREVIEW_FIELD));

    private final String domain;

    private final String domainOwner;

    private final String packageGroup;

    private final Integer maxResults;

    private final String nextToken;

    private final Boolean preview;

    private ListAssociatedPackagesRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainOwner = builder.domainOwner;
        this.packageGroup = builder.packageGroup;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.preview = builder.preview;
    }

    /**
     * <p>
     * The name of the domain that contains the package group from which to list associated packages.
     * </p>
     * 
     * @return The name of the domain that contains the package group from which to list associated packages.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes
     * or spaces.
     * </p>
     * 
     * @return The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include
     *         dashes or spaces.
     */
    public final String domainOwner() {
        return domainOwner;
    }

    /**
     * <p>
     * The pattern of the package group from which to list associated packages.
     * </p>
     * 
     * @return The pattern of the package group from which to list associated packages.
     */
    public final String packageGroup() {
        return packageGroup;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @return The maximum number of results to return per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * When this flag is included, <code>ListAssociatedPackages</code> will return a list of packages that would be
     * associated with a package group, even if it does not exist.
     * </p>
     * 
     * @return When this flag is included, <code>ListAssociatedPackages</code> will return a list of packages that would
     *         be associated with a package group, even if it does not exist.
     */
    public final Boolean preview() {
        return preview;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(packageGroup());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(preview());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociatedPackagesRequest)) {
            return false;
        }
        ListAssociatedPackagesRequest other = (ListAssociatedPackagesRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(domainOwner(), other.domainOwner())
                && Objects.equals(packageGroup(), other.packageGroup()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(preview(), other.preview());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAssociatedPackagesRequest").add("Domain", domain()).add("DomainOwner", domainOwner())
                .add("PackageGroup", packageGroup()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("Preview", preview()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "domainOwner":
            return Optional.ofNullable(clazz.cast(domainOwner()));
        case "packageGroup":
            return Optional.ofNullable(clazz.cast(packageGroup()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "preview":
            return Optional.ofNullable(clazz.cast(preview()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssociatedPackagesRequest, T> g) {
        return obj -> g.apply((ListAssociatedPackagesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAssociatedPackagesRequest> {
        /**
         * <p>
         * The name of the domain that contains the package group from which to list associated packages.
         * </p>
         * 
         * @param domain
         *        The name of the domain that contains the package group from which to list associated packages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include
         * dashes or spaces.
         * </p>
         * 
         * @param domainOwner
         *        The 12-digit account number of the Amazon Web Services account that owns the domain. It does not
         *        include dashes or spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainOwner(String domainOwner);

        /**
         * <p>
         * The pattern of the package group from which to list associated packages.
         * </p>
         * 
         * @param packageGroup
         *        The pattern of the package group from which to list associated packages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageGroup(String packageGroup);

        /**
         * <p>
         * The maximum number of results to return per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * When this flag is included, <code>ListAssociatedPackages</code> will return a list of packages that would be
         * associated with a package group, even if it does not exist.
         * </p>
         * 
         * @param preview
         *        When this flag is included, <code>ListAssociatedPackages</code> will return a list of packages that
         *        would be associated with a package group, even if it does not exist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preview(Boolean preview);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeartifactRequest.BuilderImpl implements Builder {
        private String domain;

        private String domainOwner;

        private String packageGroup;

        private Integer maxResults;

        private String nextToken;

        private Boolean preview;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociatedPackagesRequest model) {
            super(model);
            domain(model.domain);
            domainOwner(model.domainOwner);
            packageGroup(model.packageGroup);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            preview(model.preview);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getDomainOwner() {
            return domainOwner;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final String getPackageGroup() {
            return packageGroup;
        }

        public final void setPackageGroup(String packageGroup) {
            this.packageGroup = packageGroup;
        }

        @Override
        public final Builder packageGroup(String packageGroup) {
            this.packageGroup = packageGroup;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getPreview() {
            return preview;
        }

        public final void setPreview(Boolean preview) {
            this.preview = preview;
        }

        @Override
        public final Builder preview(Boolean preview) {
            this.preview = preview;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAssociatedPackagesRequest build() {
            return new ListAssociatedPackagesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
