/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about how a package originally entered the CodeArtifact domain. For packages published directly to
 * CodeArtifact, the entry point is the repository it was published to. For packages ingested from an external
 * repository, the entry point is the external connection that it was ingested from. An external connection is a
 * CodeArtifact repository that is connected to an external repository such as the npm registry or NuGet gallery.
 * </p>
 * <note>
 * <p>
 * If a package version exists in a repository and is updated, for example if a package of the same version is added
 * with additional assets, the package version's <code>DomainEntryPoint</code> will not change from the original package
 * version's value.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainEntryPoint implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainEntryPoint.Builder, DomainEntryPoint> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(DomainEntryPoint::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> EXTERNAL_CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalConnectionName").getter(getter(DomainEntryPoint::externalConnectionName))
            .setter(setter(Builder::externalConnectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalConnectionName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            EXTERNAL_CONNECTION_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String repositoryName;

    private final String externalConnectionName;

    private DomainEntryPoint(BuilderImpl builder) {
        this.repositoryName = builder.repositoryName;
        this.externalConnectionName = builder.externalConnectionName;
    }

    /**
     * <p>
     * The name of the repository that a package was originally published to.
     * </p>
     * 
     * @return The name of the repository that a package was originally published to.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The name of the external connection that a package was ingested from.
     * </p>
     * 
     * @return The name of the external connection that a package was ingested from.
     */
    public final String externalConnectionName() {
        return externalConnectionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(externalConnectionName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainEntryPoint)) {
            return false;
        }
        DomainEntryPoint other = (DomainEntryPoint) obj;
        return Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(externalConnectionName(), other.externalConnectionName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainEntryPoint").add("RepositoryName", repositoryName())
                .add("ExternalConnectionName", externalConnectionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "externalConnectionName":
            return Optional.ofNullable(clazz.cast(externalConnectionName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainEntryPoint, T> g) {
        return obj -> g.apply((DomainEntryPoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainEntryPoint> {
        /**
         * <p>
         * The name of the repository that a package was originally published to.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository that a package was originally published to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The name of the external connection that a package was ingested from.
         * </p>
         * 
         * @param externalConnectionName
         *        The name of the external connection that a package was ingested from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalConnectionName(String externalConnectionName);
    }

    static final class BuilderImpl implements Builder {
        private String repositoryName;

        private String externalConnectionName;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainEntryPoint model) {
            repositoryName(model.repositoryName);
            externalConnectionName(model.externalConnectionName);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getExternalConnectionName() {
            return externalConnectionName;
        }

        public final void setExternalConnectionName(String externalConnectionName) {
            this.externalConnectionName = externalConnectionName;
        }

        @Override
        public final Builder externalConnectionName(String externalConnectionName) {
            this.externalConnectionName = externalConnectionName;
            return this;
        }

        @Override
        public DomainEntryPoint build() {
            return new DomainEntryPoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
