/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPackageVersionReadmeResponse extends CodeartifactResponse implements
        ToCopyableBuilder<GetPackageVersionReadmeResponse.Builder, GetPackageVersionReadmeResponse> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(GetPackageVersionReadmeResponse::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(GetPackageVersionReadmeResponse::namespace))
            .setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final SdkField<String> PACKAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("package")
            .getter(getter(GetPackageVersionReadmeResponse::packageValue)).setter(setter(Builder::packageValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("package").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(GetPackageVersionReadmeResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> VERSION_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionRevision").getter(getter(GetPackageVersionReadmeResponse::versionRevision))
            .setter(setter(Builder::versionRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionRevision").build()).build();

    private static final SdkField<String> README_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("readme")
            .getter(getter(GetPackageVersionReadmeResponse::readme)).setter(setter(Builder::readme))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readme").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, NAMESPACE_FIELD,
            PACKAGE_FIELD, VERSION_FIELD, VERSION_REVISION_FIELD, README_FIELD));

    private final String format;

    private final String namespace;

    private final String packageValue;

    private final String version;

    private final String versionRevision;

    private final String readme;

    private GetPackageVersionReadmeResponse(BuilderImpl builder) {
        super(builder);
        this.format = builder.format;
        this.namespace = builder.namespace;
        this.packageValue = builder.packageValue;
        this.version = builder.version;
        this.versionRevision = builder.versionRevision;
        this.readme = builder.readme;
    }

    /**
     * <p>
     * The format of the package with the requested readme file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link PackageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the package with the requested readme file.
     * @see PackageFormat
     */
    public final PackageFormat format() {
        return PackageFormat.fromValue(format);
    }

    /**
     * <p>
     * The format of the package with the requested readme file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link PackageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the package with the requested readme file.
     * @see PackageFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The namespace of the package version with the requested readme file. The package component that specifies its
     * namespace depends on its type. For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The namespace of a Maven package version is its <code>groupId</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The namespace of an npm or Swift package version is its <code>scope</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The namespace of a generic package is its <code>namespace</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of
     * those formats do not have a namespace.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The namespace of the package version with the requested readme file. The package component that specifies
     *         its namespace depends on its type. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The namespace of a Maven package version is its <code>groupId</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The namespace of an npm or Swift package version is its <code>scope</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The namespace of a generic package is its <code>namespace</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package
     *         versions of those formats do not have a namespace.
     *         </p>
     *         </li>
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the package that contains the returned readme file.
     * </p>
     * 
     * @return The name of the package that contains the returned readme file.
     */
    public final String packageValue() {
        return packageValue;
    }

    /**
     * <p>
     * The version of the package with the requested readme file.
     * </p>
     * 
     * @return The version of the package with the requested readme file.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The current revision associated with the package version.
     * </p>
     * 
     * @return The current revision associated with the package version.
     */
    public final String versionRevision() {
        return versionRevision;
    }

    /**
     * <p>
     * The text of the returned readme file.
     * </p>
     * 
     * @return The text of the returned readme file.
     */
    public final String readme() {
        return readme;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(packageValue());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(versionRevision());
        hashCode = 31 * hashCode + Objects.hashCode(readme());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPackageVersionReadmeResponse)) {
            return false;
        }
        GetPackageVersionReadmeResponse other = (GetPackageVersionReadmeResponse) obj;
        return Objects.equals(formatAsString(), other.formatAsString()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(packageValue(), other.packageValue()) && Objects.equals(version(), other.version())
                && Objects.equals(versionRevision(), other.versionRevision()) && Objects.equals(readme(), other.readme());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPackageVersionReadmeResponse").add("Format", formatAsString()).add("Namespace", namespace())
                .add("Package", packageValue()).add("Version", version()).add("VersionRevision", versionRevision())
                .add("Readme", readme()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "package":
            return Optional.ofNullable(clazz.cast(packageValue()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "versionRevision":
            return Optional.ofNullable(clazz.cast(versionRevision()));
        case "readme":
            return Optional.ofNullable(clazz.cast(readme()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPackageVersionReadmeResponse, T> g) {
        return obj -> g.apply((GetPackageVersionReadmeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPackageVersionReadmeResponse> {
        /**
         * <p>
         * The format of the package with the requested readme file.
         * </p>
         * 
         * @param format
         *        The format of the package with the requested readme file.
         * @see PackageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the package with the requested readme file.
         * </p>
         * 
         * @param format
         *        The format of the package with the requested readme file.
         * @see PackageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageFormat
         */
        Builder format(PackageFormat format);

        /**
         * <p>
         * The namespace of the package version with the requested readme file. The package component that specifies its
         * namespace depends on its type. For example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The namespace of a Maven package version is its <code>groupId</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The namespace of an npm or Swift package version is its <code>scope</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The namespace of a generic package is its <code>namespace</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of
         * those formats do not have a namespace.
         * </p>
         * </li>
         * </ul>
         * 
         * @param namespace
         *        The namespace of the package version with the requested readme file. The package component that
         *        specifies its namespace depends on its type. For example:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The namespace of a Maven package version is its <code>groupId</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The namespace of an npm or Swift package version is its <code>scope</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The namespace of a generic package is its <code>namespace</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package
         *        versions of those formats do not have a namespace.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the package that contains the returned readme file.
         * </p>
         * 
         * @param packageValue
         *        The name of the package that contains the returned readme file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageValue(String packageValue);

        /**
         * <p>
         * The version of the package with the requested readme file.
         * </p>
         * 
         * @param version
         *        The version of the package with the requested readme file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The current revision associated with the package version.
         * </p>
         * 
         * @param versionRevision
         *        The current revision associated with the package version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionRevision(String versionRevision);

        /**
         * <p>
         * The text of the returned readme file.
         * </p>
         * 
         * @param readme
         *        The text of the returned readme file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readme(String readme);
    }

    static final class BuilderImpl extends CodeartifactResponse.BuilderImpl implements Builder {
        private String format;

        private String namespace;

        private String packageValue;

        private String version;

        private String versionRevision;

        private String readme;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPackageVersionReadmeResponse model) {
            super(model);
            format(model.format);
            namespace(model.namespace);
            packageValue(model.packageValue);
            version(model.version);
            versionRevision(model.versionRevision);
            readme(model.readme);
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(PackageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getPackageValue() {
            return packageValue;
        }

        public final void setPackageValue(String packageValue) {
            this.packageValue = packageValue;
        }

        @Override
        public final Builder packageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getVersionRevision() {
            return versionRevision;
        }

        public final void setVersionRevision(String versionRevision) {
            this.versionRevision = versionRevision;
        }

        @Override
        public final Builder versionRevision(String versionRevision) {
            this.versionRevision = versionRevision;
            return this;
        }

        public final String getReadme() {
            return readme;
        }

        public final void setReadme(String readme) {
            this.readme = readme;
        }

        @Override
        public final Builder readme(String readme) {
            this.readme = readme;
            return this;
        }

        @Override
        public GetPackageVersionReadmeResponse build() {
            return new GetPackageVersionReadmeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
