/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAssociatedPackageGroupResponse extends CodeartifactResponse implements
        ToCopyableBuilder<GetAssociatedPackageGroupResponse.Builder, GetAssociatedPackageGroupResponse> {
    private static final SdkField<PackageGroupDescription> PACKAGE_GROUP_FIELD = SdkField
            .<PackageGroupDescription> builder(MarshallingType.SDK_POJO).memberName("packageGroup")
            .getter(getter(GetAssociatedPackageGroupResponse::packageGroup)).setter(setter(Builder::packageGroup))
            .constructor(PackageGroupDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageGroup").build()).build();

    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associationType").getter(getter(GetAssociatedPackageGroupResponse::associationTypeAsString))
            .setter(setter(Builder::associationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_GROUP_FIELD,
            ASSOCIATION_TYPE_FIELD));

    private final PackageGroupDescription packageGroup;

    private final String associationType;

    private GetAssociatedPackageGroupResponse(BuilderImpl builder) {
        super(builder);
        this.packageGroup = builder.packageGroup;
        this.associationType = builder.associationType;
    }

    /**
     * <p>
     * The package group that is associated with the requested package.
     * </p>
     * 
     * @return The package group that is associated with the requested package.
     */
    public final PackageGroupDescription packageGroup() {
        return packageGroup;
    }

    /**
     * <p>
     * Describes the strength of the association between the package and package group. A strong match is also known as
     * an exact match, and a weak match is known as a relative match.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link PackageGroupAssociationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return Describes the strength of the association between the package and package group. A strong match is also
     *         known as an exact match, and a weak match is known as a relative match.
     * @see PackageGroupAssociationType
     */
    public final PackageGroupAssociationType associationType() {
        return PackageGroupAssociationType.fromValue(associationType);
    }

    /**
     * <p>
     * Describes the strength of the association between the package and package group. A strong match is also known as
     * an exact match, and a weak match is known as a relative match.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link PackageGroupAssociationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return Describes the strength of the association between the package and package group. A strong match is also
     *         known as an exact match, and a weak match is known as a relative match.
     * @see PackageGroupAssociationType
     */
    public final String associationTypeAsString() {
        return associationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(packageGroup());
        hashCode = 31 * hashCode + Objects.hashCode(associationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssociatedPackageGroupResponse)) {
            return false;
        }
        GetAssociatedPackageGroupResponse other = (GetAssociatedPackageGroupResponse) obj;
        return Objects.equals(packageGroup(), other.packageGroup())
                && Objects.equals(associationTypeAsString(), other.associationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAssociatedPackageGroupResponse").add("PackageGroup", packageGroup())
                .add("AssociationType", associationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "packageGroup":
            return Optional.ofNullable(clazz.cast(packageGroup()));
        case "associationType":
            return Optional.ofNullable(clazz.cast(associationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAssociatedPackageGroupResponse, T> g) {
        return obj -> g.apply((GetAssociatedPackageGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAssociatedPackageGroupResponse> {
        /**
         * <p>
         * The package group that is associated with the requested package.
         * </p>
         * 
         * @param packageGroup
         *        The package group that is associated with the requested package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageGroup(PackageGroupDescription packageGroup);

        /**
         * <p>
         * The package group that is associated with the requested package.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageGroupDescription.Builder} avoiding
         * the need to create one manually via {@link PackageGroupDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PackageGroupDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #packageGroup(PackageGroupDescription)}.
         * 
         * @param packageGroup
         *        a consumer that will call methods on {@link PackageGroupDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageGroup(PackageGroupDescription)
         */
        default Builder packageGroup(Consumer<PackageGroupDescription.Builder> packageGroup) {
            return packageGroup(PackageGroupDescription.builder().applyMutation(packageGroup).build());
        }

        /**
         * <p>
         * Describes the strength of the association between the package and package group. A strong match is also known
         * as an exact match, and a weak match is known as a relative match.
         * </p>
         * 
         * @param associationType
         *        Describes the strength of the association between the package and package group. A strong match is
         *        also known as an exact match, and a weak match is known as a relative match.
         * @see PackageGroupAssociationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageGroupAssociationType
         */
        Builder associationType(String associationType);

        /**
         * <p>
         * Describes the strength of the association between the package and package group. A strong match is also known
         * as an exact match, and a weak match is known as a relative match.
         * </p>
         * 
         * @param associationType
         *        Describes the strength of the association between the package and package group. A strong match is
         *        also known as an exact match, and a weak match is known as a relative match.
         * @see PackageGroupAssociationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageGroupAssociationType
         */
        Builder associationType(PackageGroupAssociationType associationType);
    }

    static final class BuilderImpl extends CodeartifactResponse.BuilderImpl implements Builder {
        private PackageGroupDescription packageGroup;

        private String associationType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssociatedPackageGroupResponse model) {
            super(model);
            packageGroup(model.packageGroup);
            associationType(model.associationType);
        }

        public final PackageGroupDescription.Builder getPackageGroup() {
            return packageGroup != null ? packageGroup.toBuilder() : null;
        }

        public final void setPackageGroup(PackageGroupDescription.BuilderImpl packageGroup) {
            this.packageGroup = packageGroup != null ? packageGroup.build() : null;
        }

        @Override
        public final Builder packageGroup(PackageGroupDescription packageGroup) {
            this.packageGroup = packageGroup;
            return this;
        }

        public final String getAssociationType() {
            return associationType;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        @Override
        public final Builder associationType(PackageGroupAssociationType associationType) {
            this.associationType(associationType == null ? null : associationType.toString());
            return this;
        }

        @Override
        public GetAssociatedPackageGroupResponse build() {
            return new GetAssociatedPackageGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
