/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class PackageGroupOriginRestrictionsCopier {
    static Map<String, PackageGroupOriginRestriction> copy(
            Map<String, ? extends PackageGroupOriginRestriction> packageGroupOriginRestrictionsParam) {
        Map<String, PackageGroupOriginRestriction> map;
        if (packageGroupOriginRestrictionsParam == null || packageGroupOriginRestrictionsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, PackageGroupOriginRestriction> modifiableMap = new LinkedHashMap<>(
                    packageGroupOriginRestrictionsParam.size());
            packageGroupOriginRestrictionsParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, PackageGroupOriginRestriction> copyFromBuilder(
            Map<String, ? extends PackageGroupOriginRestriction.Builder> packageGroupOriginRestrictionsParam) {
        Map<String, PackageGroupOriginRestriction> map;
        if (packageGroupOriginRestrictionsParam == null || packageGroupOriginRestrictionsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, PackageGroupOriginRestriction> modifiableMap = new LinkedHashMap<>(
                    packageGroupOriginRestrictionsParam.size());
            packageGroupOriginRestrictionsParam.forEach((key, value) -> {
                PackageGroupOriginRestriction member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, PackageGroupOriginRestriction.Builder> copyToBuilder(
            Map<String, ? extends PackageGroupOriginRestriction> packageGroupOriginRestrictionsParam) {
        Map<String, PackageGroupOriginRestriction.Builder> map;
        if (packageGroupOriginRestrictionsParam == null || packageGroupOriginRestrictionsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, PackageGroupOriginRestriction.Builder> modifiableMap = new LinkedHashMap<>(
                    packageGroupOriginRestrictionsParam.size());
            packageGroupOriginRestrictionsParam.forEach((key, value) -> {
                PackageGroupOriginRestriction.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, PackageGroupOriginRestriction> copyEnumToString(
            Map<PackageGroupOriginRestrictionType, ? extends PackageGroupOriginRestriction> packageGroupOriginRestrictionsParam) {
        Map<String, PackageGroupOriginRestriction> map;
        if (packageGroupOriginRestrictionsParam == null || packageGroupOriginRestrictionsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, PackageGroupOriginRestriction> modifiableMap = new LinkedHashMap<>(
                    packageGroupOriginRestrictionsParam.size());
            packageGroupOriginRestrictionsParam.forEach((key, value) -> {
                String result = key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<PackageGroupOriginRestrictionType, PackageGroupOriginRestriction> copyStringToEnum(
            Map<String, ? extends PackageGroupOriginRestriction> packageGroupOriginRestrictionsParam) {
        Map<PackageGroupOriginRestrictionType, PackageGroupOriginRestriction> map;
        if (packageGroupOriginRestrictionsParam == null || packageGroupOriginRestrictionsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<PackageGroupOriginRestrictionType, PackageGroupOriginRestriction> modifiableMap = new LinkedHashMap<>(
                    packageGroupOriginRestrictionsParam.size());
            packageGroupOriginRestrictionsParam.forEach((key, value) -> {
                PackageGroupOriginRestrictionType result = PackageGroupOriginRestrictionType.fromValue(key);
                if (result != PackageGroupOriginRestrictionType.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
