/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactRequest;
import software.amazon.awssdk.services.codeartifact.model.OriginRestrictionsCopier;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupAllowedRepository;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupAllowedRepositoryListCopier;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupOriginRestrictionMode;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupOriginRestrictionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePackageGroupOriginConfigurationRequest
extends CodeartifactRequest
implements ToCopyableBuilder<Builder, UpdatePackageGroupOriginConfigurationRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domain").getter(UpdatePackageGroupOriginConfigurationRequest.getter(UpdatePackageGroupOriginConfigurationRequest::domain)).setter(UpdatePackageGroupOriginConfigurationRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()}).build();
    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainOwner").getter(UpdatePackageGroupOriginConfigurationRequest.getter(UpdatePackageGroupOriginConfigurationRequest::domainOwner)).setter(UpdatePackageGroupOriginConfigurationRequest.setter(Builder::domainOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain-owner").build()}).build();
    private static final SdkField<String> PACKAGE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("packageGroup").getter(UpdatePackageGroupOriginConfigurationRequest.getter(UpdatePackageGroupOriginConfigurationRequest::packageGroup)).setter(UpdatePackageGroupOriginConfigurationRequest.setter(Builder::packageGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("package-group").build()}).build();
    private static final SdkField<Map<String, String>> RESTRICTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("restrictions").getter(UpdatePackageGroupOriginConfigurationRequest.getter(UpdatePackageGroupOriginConfigurationRequest::restrictionsAsStrings)).setter(UpdatePackageGroupOriginConfigurationRequest.setter(Builder::restrictionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restrictions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<PackageGroupAllowedRepository>> ADD_ALLOWED_REPOSITORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("addAllowedRepositories").getter(UpdatePackageGroupOriginConfigurationRequest.getter(UpdatePackageGroupOriginConfigurationRequest::addAllowedRepositories)).setter(UpdatePackageGroupOriginConfigurationRequest.setter(Builder::addAllowedRepositories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addAllowedRepositories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PackageGroupAllowedRepository::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PackageGroupAllowedRepository>> REMOVE_ALLOWED_REPOSITORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("removeAllowedRepositories").getter(UpdatePackageGroupOriginConfigurationRequest.getter(UpdatePackageGroupOriginConfigurationRequest::removeAllowedRepositories)).setter(UpdatePackageGroupOriginConfigurationRequest.setter(Builder::removeAllowedRepositories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeAllowedRepositories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PackageGroupAllowedRepository::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, DOMAIN_OWNER_FIELD, PACKAGE_GROUP_FIELD, RESTRICTIONS_FIELD, ADD_ALLOWED_REPOSITORIES_FIELD, REMOVE_ALLOWED_REPOSITORIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("domain", DOMAIN_FIELD);
            this.put("domain-owner", DOMAIN_OWNER_FIELD);
            this.put("package-group", PACKAGE_GROUP_FIELD);
            this.put("restrictions", RESTRICTIONS_FIELD);
            this.put("addAllowedRepositories", ADD_ALLOWED_REPOSITORIES_FIELD);
            this.put("removeAllowedRepositories", REMOVE_ALLOWED_REPOSITORIES_FIELD);
        }
    });
    private final String domain;
    private final String domainOwner;
    private final String packageGroup;
    private final Map<String, String> restrictions;
    private final List<PackageGroupAllowedRepository> addAllowedRepositories;
    private final List<PackageGroupAllowedRepository> removeAllowedRepositories;

    private UpdatePackageGroupOriginConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainOwner = builder.domainOwner;
        this.packageGroup = builder.packageGroup;
        this.restrictions = builder.restrictions;
        this.addAllowedRepositories = builder.addAllowedRepositories;
        this.removeAllowedRepositories = builder.removeAllowedRepositories;
    }

    public final String domain() {
        return this.domain;
    }

    public final String domainOwner() {
        return this.domainOwner;
    }

    public final String packageGroup() {
        return this.packageGroup;
    }

    public final Map<PackageGroupOriginRestrictionType, PackageGroupOriginRestrictionMode> restrictions() {
        return OriginRestrictionsCopier.copyStringToEnum(this.restrictions);
    }

    public final boolean hasRestrictions() {
        return this.restrictions != null && !(this.restrictions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> restrictionsAsStrings() {
        return this.restrictions;
    }

    public final boolean hasAddAllowedRepositories() {
        return this.addAllowedRepositories != null && !(this.addAllowedRepositories instanceof SdkAutoConstructList);
    }

    public final List<PackageGroupAllowedRepository> addAllowedRepositories() {
        return this.addAllowedRepositories;
    }

    public final boolean hasRemoveAllowedRepositories() {
        return this.removeAllowedRepositories != null && !(this.removeAllowedRepositories instanceof SdkAutoConstructList);
    }

    public final List<PackageGroupAllowedRepository> removeAllowedRepositories() {
        return this.removeAllowedRepositories;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRestrictions() ? this.restrictionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddAllowedRepositories() ? this.addAllowedRepositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveAllowedRepositories() ? this.removeAllowedRepositories() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePackageGroupOriginConfigurationRequest)) {
            return false;
        }
        UpdatePackageGroupOriginConfigurationRequest other = (UpdatePackageGroupOriginConfigurationRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.domainOwner(), other.domainOwner()) && Objects.equals(this.packageGroup(), other.packageGroup()) && this.hasRestrictions() == other.hasRestrictions() && Objects.equals(this.restrictionsAsStrings(), other.restrictionsAsStrings()) && this.hasAddAllowedRepositories() == other.hasAddAllowedRepositories() && Objects.equals(this.addAllowedRepositories(), other.addAllowedRepositories()) && this.hasRemoveAllowedRepositories() == other.hasRemoveAllowedRepositories() && Objects.equals(this.removeAllowedRepositories(), other.removeAllowedRepositories());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePackageGroupOriginConfigurationRequest").add("Domain", (Object)this.domain()).add("DomainOwner", (Object)this.domainOwner()).add("PackageGroup", (Object)this.packageGroup()).add("Restrictions", this.hasRestrictions() ? this.restrictionsAsStrings() : null).add("AddAllowedRepositories", this.hasAddAllowedRepositories() ? this.addAllowedRepositories() : null).add("RemoveAllowedRepositories", this.hasRemoveAllowedRepositories() ? this.removeAllowedRepositories() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "domainOwner": {
                return Optional.ofNullable(clazz.cast(this.domainOwner()));
            }
            case "packageGroup": {
                return Optional.ofNullable(clazz.cast(this.packageGroup()));
            }
            case "restrictions": {
                return Optional.ofNullable(clazz.cast(this.restrictionsAsStrings()));
            }
            case "addAllowedRepositories": {
                return Optional.ofNullable(clazz.cast(this.addAllowedRepositories()));
            }
            case "removeAllowedRepositories": {
                return Optional.ofNullable(clazz.cast(this.removeAllowedRepositories()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePackageGroupOriginConfigurationRequest, T> g) {
        return obj -> g.apply((UpdatePackageGroupOriginConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeartifactRequest.BuilderImpl
    implements Builder {
        private String domain;
        private String domainOwner;
        private String packageGroup;
        private Map<String, String> restrictions = DefaultSdkAutoConstructMap.getInstance();
        private List<PackageGroupAllowedRepository> addAllowedRepositories = DefaultSdkAutoConstructList.getInstance();
        private List<PackageGroupAllowedRepository> removeAllowedRepositories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePackageGroupOriginConfigurationRequest model) {
            super(model);
            this.domain(model.domain);
            this.domainOwner(model.domainOwner);
            this.packageGroup(model.packageGroup);
            this.restrictionsWithStrings(model.restrictions);
            this.addAllowedRepositories(model.addAllowedRepositories);
            this.removeAllowedRepositories(model.removeAllowedRepositories);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getDomainOwner() {
            return this.domainOwner;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final String getPackageGroup() {
            return this.packageGroup;
        }

        public final void setPackageGroup(String packageGroup) {
            this.packageGroup = packageGroup;
        }

        @Override
        public final Builder packageGroup(String packageGroup) {
            this.packageGroup = packageGroup;
            return this;
        }

        public final Map<String, String> getRestrictions() {
            if (this.restrictions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.restrictions;
        }

        public final void setRestrictions(Map<String, String> restrictions) {
            this.restrictions = OriginRestrictionsCopier.copy(restrictions);
        }

        @Override
        public final Builder restrictionsWithStrings(Map<String, String> restrictions) {
            this.restrictions = OriginRestrictionsCopier.copy(restrictions);
            return this;
        }

        @Override
        public final Builder restrictions(Map<PackageGroupOriginRestrictionType, PackageGroupOriginRestrictionMode> restrictions) {
            this.restrictions = OriginRestrictionsCopier.copyEnumToString(restrictions);
            return this;
        }

        public final List<PackageGroupAllowedRepository.Builder> getAddAllowedRepositories() {
            List<PackageGroupAllowedRepository.Builder> result = PackageGroupAllowedRepositoryListCopier.copyToBuilder(this.addAllowedRepositories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddAllowedRepositories(Collection<PackageGroupAllowedRepository.BuilderImpl> addAllowedRepositories) {
            this.addAllowedRepositories = PackageGroupAllowedRepositoryListCopier.copyFromBuilder(addAllowedRepositories);
        }

        @Override
        public final Builder addAllowedRepositories(Collection<PackageGroupAllowedRepository> addAllowedRepositories) {
            this.addAllowedRepositories = PackageGroupAllowedRepositoryListCopier.copy(addAllowedRepositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addAllowedRepositories(PackageGroupAllowedRepository ... addAllowedRepositories) {
            this.addAllowedRepositories(Arrays.asList(addAllowedRepositories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addAllowedRepositories(Consumer<PackageGroupAllowedRepository.Builder> ... addAllowedRepositories) {
            this.addAllowedRepositories(Stream.of(addAllowedRepositories).map(c -> (PackageGroupAllowedRepository)((PackageGroupAllowedRepository.Builder)PackageGroupAllowedRepository.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PackageGroupAllowedRepository.Builder> getRemoveAllowedRepositories() {
            List<PackageGroupAllowedRepository.Builder> result = PackageGroupAllowedRepositoryListCopier.copyToBuilder(this.removeAllowedRepositories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoveAllowedRepositories(Collection<PackageGroupAllowedRepository.BuilderImpl> removeAllowedRepositories) {
            this.removeAllowedRepositories = PackageGroupAllowedRepositoryListCopier.copyFromBuilder(removeAllowedRepositories);
        }

        @Override
        public final Builder removeAllowedRepositories(Collection<PackageGroupAllowedRepository> removeAllowedRepositories) {
            this.removeAllowedRepositories = PackageGroupAllowedRepositoryListCopier.copy(removeAllowedRepositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeAllowedRepositories(PackageGroupAllowedRepository ... removeAllowedRepositories) {
            this.removeAllowedRepositories(Arrays.asList(removeAllowedRepositories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeAllowedRepositories(Consumer<PackageGroupAllowedRepository.Builder> ... removeAllowedRepositories) {
            this.removeAllowedRepositories(Stream.of(removeAllowedRepositories).map(c -> (PackageGroupAllowedRepository)((PackageGroupAllowedRepository.Builder)PackageGroupAllowedRepository.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePackageGroupOriginConfigurationRequest build() {
            return new UpdatePackageGroupOriginConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeartifactRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePackageGroupOriginConfigurationRequest> {
        public Builder domain(String var1);

        public Builder domainOwner(String var1);

        public Builder packageGroup(String var1);

        public Builder restrictionsWithStrings(Map<String, String> var1);

        public Builder restrictions(Map<PackageGroupOriginRestrictionType, PackageGroupOriginRestrictionMode> var1);

        public Builder addAllowedRepositories(Collection<PackageGroupAllowedRepository> var1);

        public Builder addAllowedRepositories(PackageGroupAllowedRepository ... var1);

        public Builder addAllowedRepositories(Consumer<PackageGroupAllowedRepository.Builder> ... var1);

        public Builder removeAllowedRepositories(Collection<PackageGroupAllowedRepository> var1);

        public Builder removeAllowedRepositories(PackageGroupAllowedRepository ... var1);

        public Builder removeAllowedRepositories(Consumer<PackageGroupAllowedRepository.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

