/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A package associated with a package group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociatedPackage implements SdkPojo, Serializable,
        ToCopyableBuilder<AssociatedPackage.Builder, AssociatedPackage> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(AssociatedPackage::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(AssociatedPackage::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final SdkField<String> PACKAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("package")
            .getter(getter(AssociatedPackage::packageValue)).setter(setter(Builder::packageValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("package").build()).build();

    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associationType").getter(getter(AssociatedPackage::associationTypeAsString))
            .setter(setter(Builder::associationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, NAMESPACE_FIELD,
            PACKAGE_FIELD, ASSOCIATION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String format;

    private final String namespace;

    private final String packageValue;

    private final String associationType;

    private AssociatedPackage(BuilderImpl builder) {
        this.format = builder.format;
        this.namespace = builder.namespace;
        this.packageValue = builder.packageValue;
        this.associationType = builder.associationType;
    }

    /**
     * <p>
     * A format that specifies the type of the associated package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link PackageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return A format that specifies the type of the associated package.
     * @see PackageFormat
     */
    public final PackageFormat format() {
        return PackageFormat.fromValue(format);
    }

    /**
     * <p>
     * A format that specifies the type of the associated package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link PackageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return A format that specifies the type of the associated package.
     * @see PackageFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The namespace of the associated package. The package component that specifies its namespace depends on its type.
     * For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The namespace of a Maven package version is its <code>groupId</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The namespace of an npm or Swift package version is its <code>scope</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The namespace of a generic package is its <code>namespace</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of
     * those formats do not have a namespace.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The namespace of the associated package. The package component that specifies its namespace depends on
     *         its type. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The namespace of a Maven package version is its <code>groupId</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The namespace of an npm or Swift package version is its <code>scope</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The namespace of a generic package is its <code>namespace</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package
     *         versions of those formats do not have a namespace.
     *         </p>
     *         </li>
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the associated package.
     * </p>
     * 
     * @return The name of the associated package.
     */
    public final String packageValue() {
        return packageValue;
    }

    /**
     * <p>
     * Describes the strength of the association between the package and package group. A strong match can be thought of
     * as an exact match, and a weak match can be thought of as a variation match, for example, the package name matches
     * a variation of the package group pattern. For more information about package group pattern matching, including
     * strong and weak matches, see <a href=
     * "https://docs.aws.amazon.com/codeartifact/latest/ug/package-group-definition-syntax-matching-behavior.html"
     * >Package group definition syntax and matching behavior</a> in the <i>CodeArtifact User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link PackageGroupAssociationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return Describes the strength of the association between the package and package group. A strong match can be
     *         thought of as an exact match, and a weak match can be thought of as a variation match, for example, the
     *         package name matches a variation of the package group pattern. For more information about package group
     *         pattern matching, including strong and weak matches, see <a href=
     *         "https://docs.aws.amazon.com/codeartifact/latest/ug/package-group-definition-syntax-matching-behavior.html"
     *         >Package group definition syntax and matching behavior</a> in the <i>CodeArtifact User Guide</i>.
     * @see PackageGroupAssociationType
     */
    public final PackageGroupAssociationType associationType() {
        return PackageGroupAssociationType.fromValue(associationType);
    }

    /**
     * <p>
     * Describes the strength of the association between the package and package group. A strong match can be thought of
     * as an exact match, and a weak match can be thought of as a variation match, for example, the package name matches
     * a variation of the package group pattern. For more information about package group pattern matching, including
     * strong and weak matches, see <a href=
     * "https://docs.aws.amazon.com/codeartifact/latest/ug/package-group-definition-syntax-matching-behavior.html"
     * >Package group definition syntax and matching behavior</a> in the <i>CodeArtifact User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link PackageGroupAssociationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return Describes the strength of the association between the package and package group. A strong match can be
     *         thought of as an exact match, and a weak match can be thought of as a variation match, for example, the
     *         package name matches a variation of the package group pattern. For more information about package group
     *         pattern matching, including strong and weak matches, see <a href=
     *         "https://docs.aws.amazon.com/codeartifact/latest/ug/package-group-definition-syntax-matching-behavior.html"
     *         >Package group definition syntax and matching behavior</a> in the <i>CodeArtifact User Guide</i>.
     * @see PackageGroupAssociationType
     */
    public final String associationTypeAsString() {
        return associationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(packageValue());
        hashCode = 31 * hashCode + Objects.hashCode(associationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatedPackage)) {
            return false;
        }
        AssociatedPackage other = (AssociatedPackage) obj;
        return Objects.equals(formatAsString(), other.formatAsString()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(packageValue(), other.packageValue())
                && Objects.equals(associationTypeAsString(), other.associationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociatedPackage").add("Format", formatAsString()).add("Namespace", namespace())
                .add("Package", packageValue()).add("AssociationType", associationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "package":
            return Optional.ofNullable(clazz.cast(packageValue()));
        case "associationType":
            return Optional.ofNullable(clazz.cast(associationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("format", FORMAT_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("package", PACKAGE_FIELD);
        map.put("associationType", ASSOCIATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociatedPackage, T> g) {
        return obj -> g.apply((AssociatedPackage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociatedPackage> {
        /**
         * <p>
         * A format that specifies the type of the associated package.
         * </p>
         * 
         * @param format
         *        A format that specifies the type of the associated package.
         * @see PackageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageFormat
         */
        Builder format(String format);

        /**
         * <p>
         * A format that specifies the type of the associated package.
         * </p>
         * 
         * @param format
         *        A format that specifies the type of the associated package.
         * @see PackageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageFormat
         */
        Builder format(PackageFormat format);

        /**
         * <p>
         * The namespace of the associated package. The package component that specifies its namespace depends on its
         * type. For example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The namespace of a Maven package version is its <code>groupId</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The namespace of an npm or Swift package version is its <code>scope</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The namespace of a generic package is its <code>namespace</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of
         * those formats do not have a namespace.
         * </p>
         * </li>
         * </ul>
         * 
         * @param namespace
         *        The namespace of the associated package. The package component that specifies its namespace depends on
         *        its type. For example:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The namespace of a Maven package version is its <code>groupId</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The namespace of an npm or Swift package version is its <code>scope</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The namespace of a generic package is its <code>namespace</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package
         *        versions of those formats do not have a namespace.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the associated package.
         * </p>
         * 
         * @param packageValue
         *        The name of the associated package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageValue(String packageValue);

        /**
         * <p>
         * Describes the strength of the association between the package and package group. A strong match can be
         * thought of as an exact match, and a weak match can be thought of as a variation match, for example, the
         * package name matches a variation of the package group pattern. For more information about package group
         * pattern matching, including strong and weak matches, see <a href=
         * "https://docs.aws.amazon.com/codeartifact/latest/ug/package-group-definition-syntax-matching-behavior.html"
         * >Package group definition syntax and matching behavior</a> in the <i>CodeArtifact User Guide</i>.
         * </p>
         * 
         * @param associationType
         *        Describes the strength of the association between the package and package group. A strong match can be
         *        thought of as an exact match, and a weak match can be thought of as a variation match, for example,
         *        the package name matches a variation of the package group pattern. For more information about package
         *        group pattern matching, including strong and weak matches, see <a href=
         *        "https://docs.aws.amazon.com/codeartifact/latest/ug/package-group-definition-syntax-matching-behavior.html"
         *        >Package group definition syntax and matching behavior</a> in the <i>CodeArtifact User Guide</i>.
         * @see PackageGroupAssociationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageGroupAssociationType
         */
        Builder associationType(String associationType);

        /**
         * <p>
         * Describes the strength of the association between the package and package group. A strong match can be
         * thought of as an exact match, and a weak match can be thought of as a variation match, for example, the
         * package name matches a variation of the package group pattern. For more information about package group
         * pattern matching, including strong and weak matches, see <a href=
         * "https://docs.aws.amazon.com/codeartifact/latest/ug/package-group-definition-syntax-matching-behavior.html"
         * >Package group definition syntax and matching behavior</a> in the <i>CodeArtifact User Guide</i>.
         * </p>
         * 
         * @param associationType
         *        Describes the strength of the association between the package and package group. A strong match can be
         *        thought of as an exact match, and a weak match can be thought of as a variation match, for example,
         *        the package name matches a variation of the package group pattern. For more information about package
         *        group pattern matching, including strong and weak matches, see <a href=
         *        "https://docs.aws.amazon.com/codeartifact/latest/ug/package-group-definition-syntax-matching-behavior.html"
         *        >Package group definition syntax and matching behavior</a> in the <i>CodeArtifact User Guide</i>.
         * @see PackageGroupAssociationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageGroupAssociationType
         */
        Builder associationType(PackageGroupAssociationType associationType);
    }

    static final class BuilderImpl implements Builder {
        private String format;

        private String namespace;

        private String packageValue;

        private String associationType;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatedPackage model) {
            format(model.format);
            namespace(model.namespace);
            packageValue(model.packageValue);
            associationType(model.associationType);
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(PackageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getPackageValue() {
            return packageValue;
        }

        public final void setPackageValue(String packageValue) {
            this.packageValue = packageValue;
        }

        @Override
        public final Builder packageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public final String getAssociationType() {
            return associationType;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        @Override
        public final Builder associationType(PackageGroupAssociationType associationType) {
            this.associationType(associationType == null ? null : associationType.toString());
            return this;
        }

        @Override
        public AssociatedPackage build() {
            return new AssociatedPackage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
