/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyPackageVersionsRequest extends CodeartifactRequest implements
        ToCopyableBuilder<CopyPackageVersionsRequest.Builder, CopyPackageVersionsRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(CopyPackageVersionsRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()).build();

    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainOwner").getter(getter(CopyPackageVersionsRequest::domainOwner))
            .setter(setter(Builder::domainOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain-owner").build()).build();

    private static final SdkField<String> SOURCE_REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceRepository").getter(getter(CopyPackageVersionsRequest::sourceRepository))
            .setter(setter(Builder::sourceRepository))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("source-repository").build())
            .build();

    private static final SdkField<String> DESTINATION_REPOSITORY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("destinationRepository")
            .getter(getter(CopyPackageVersionsRequest::destinationRepository))
            .setter(setter(Builder::destinationRepository))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("destination-repository").build())
            .build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(CopyPackageVersionsRequest::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("format").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(CopyPackageVersionsRequest::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("namespace").build()).build();

    private static final SdkField<String> PACKAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("package")
            .getter(getter(CopyPackageVersionsRequest::packageValue)).setter(setter(Builder::packageValue))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("package").build()).build();

    private static final SdkField<List<String>> VERSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("versions")
            .getter(getter(CopyPackageVersionsRequest::versions))
            .setter(setter(Builder::versions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> VERSION_REVISIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("versionRevisions")
            .getter(getter(CopyPackageVersionsRequest::versionRevisions))
            .setter(setter(Builder::versionRevisions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionRevisions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> ALLOW_OVERWRITE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowOverwrite").getter(getter(CopyPackageVersionsRequest::allowOverwrite))
            .setter(setter(Builder::allowOverwrite))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowOverwrite").build()).build();

    private static final SdkField<Boolean> INCLUDE_FROM_UPSTREAM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeFromUpstream").getter(getter(CopyPackageVersionsRequest::includeFromUpstream))
            .setter(setter(Builder::includeFromUpstream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeFromUpstream").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            DOMAIN_OWNER_FIELD, SOURCE_REPOSITORY_FIELD, DESTINATION_REPOSITORY_FIELD, FORMAT_FIELD, NAMESPACE_FIELD,
            PACKAGE_FIELD, VERSIONS_FIELD, VERSION_REVISIONS_FIELD, ALLOW_OVERWRITE_FIELD, INCLUDE_FROM_UPSTREAM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domain;

    private final String domainOwner;

    private final String sourceRepository;

    private final String destinationRepository;

    private final String format;

    private final String namespace;

    private final String packageValue;

    private final List<String> versions;

    private final Map<String, String> versionRevisions;

    private final Boolean allowOverwrite;

    private final Boolean includeFromUpstream;

    private CopyPackageVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainOwner = builder.domainOwner;
        this.sourceRepository = builder.sourceRepository;
        this.destinationRepository = builder.destinationRepository;
        this.format = builder.format;
        this.namespace = builder.namespace;
        this.packageValue = builder.packageValue;
        this.versions = builder.versions;
        this.versionRevisions = builder.versionRevisions;
        this.allowOverwrite = builder.allowOverwrite;
        this.includeFromUpstream = builder.includeFromUpstream;
    }

    /**
     * <p>
     * The name of the domain that contains the source and destination repositories.
     * </p>
     * 
     * @return The name of the domain that contains the source and destination repositories.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes
     * or spaces.
     * </p>
     * 
     * @return The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include
     *         dashes or spaces.
     */
    public final String domainOwner() {
        return domainOwner;
    }

    /**
     * <p>
     * The name of the repository that contains the package versions to be copied.
     * </p>
     * 
     * @return The name of the repository that contains the package versions to be copied.
     */
    public final String sourceRepository() {
        return sourceRepository;
    }

    /**
     * <p>
     * The name of the repository into which package versions are copied.
     * </p>
     * 
     * @return The name of the repository into which package versions are copied.
     */
    public final String destinationRepository() {
        return destinationRepository;
    }

    /**
     * <p>
     * The format of the package versions to be copied.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link PackageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the package versions to be copied.
     * @see PackageFormat
     */
    public final PackageFormat format() {
        return PackageFormat.fromValue(format);
    }

    /**
     * <p>
     * The format of the package versions to be copied.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link PackageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the package versions to be copied.
     * @see PackageFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The namespace of the package versions to be copied. The package component that specifies its namespace depends on
     * its type. For example:
     * </p>
     * <note>
     * <p>
     * The namespace is required when copying package versions of the following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maven
     * </p>
     * </li>
     * <li>
     * <p>
     * Swift
     * </p>
     * </li>
     * <li>
     * <p>
     * generic
     * </p>
     * </li>
     * </ul>
     * </note>
     * <ul>
     * <li>
     * <p>
     * The namespace of a Maven package version is its <code>groupId</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The namespace of an npm or Swift package version is its <code>scope</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The namespace of a generic package is its <code>namespace</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of
     * those formats do not have a namespace.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The namespace of the package versions to be copied. The package component that specifies its namespace
     *         depends on its type. For example:</p> <note>
     *         <p>
     *         The namespace is required when copying package versions of the following formats:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maven
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Swift
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         generic
     *         </p>
     *         </li>
     *         </ul>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         The namespace of a Maven package version is its <code>groupId</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The namespace of an npm or Swift package version is its <code>scope</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The namespace of a generic package is its <code>namespace</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package
     *         versions of those formats do not have a namespace.
     *         </p>
     *         </li>
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the package that contains the versions to be copied.
     * </p>
     * 
     * @return The name of the package that contains the versions to be copied.
     */
    public final String packageValue() {
        return packageValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the Versions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVersions() {
        return versions != null && !(versions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The versions of the package to be copied.
     * </p>
     * <note>
     * <p>
     * You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVersions} method.
     * </p>
     * 
     * @return The versions of the package to be copied. </p> <note>
     *         <p>
     *         You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
     *         </p>
     */
    public final List<String> versions() {
        return versions;
    }

    /**
     * For responses, this returns true if the service returned a value for the VersionRevisions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVersionRevisions() {
        return versionRevisions != null && !(versionRevisions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of key-value pairs. The keys are package versions and the values are package version revisions. A
     * <code>CopyPackageVersion</code> operation succeeds if the specified versions in the source repository match the
     * specified package version revision.
     * </p>
     * <note>
     * <p>
     * You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVersionRevisions} method.
     * </p>
     * 
     * @return A list of key-value pairs. The keys are package versions and the values are package version revisions. A
     *         <code>CopyPackageVersion</code> operation succeeds if the specified versions in the source repository
     *         match the specified package version revision. </p> <note>
     *         <p>
     *         You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
     *         </p>
     */
    public final Map<String, String> versionRevisions() {
        return versionRevisions;
    }

    /**
     * <p>
     * Set to true to overwrite a package version that already exists in the destination repository. If set to false and
     * the package version already exists in the destination repository, the package version is returned in the
     * <code>failedVersions</code> field of the response with an <code>ALREADY_EXISTS</code> error code.
     * </p>
     * 
     * @return Set to true to overwrite a package version that already exists in the destination repository. If set to
     *         false and the package version already exists in the destination repository, the package version is
     *         returned in the <code>failedVersions</code> field of the response with an <code>ALREADY_EXISTS</code>
     *         error code.
     */
    public final Boolean allowOverwrite() {
        return allowOverwrite;
    }

    /**
     * <p>
     * Set to true to copy packages from repositories that are upstream from the source repository to the destination
     * repository. The default setting is false. For more information, see <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream
     * repositories</a>.
     * </p>
     * 
     * @return Set to true to copy packages from repositories that are upstream from the source repository to the
     *         destination repository. The default setting is false. For more information, see <a
     *         href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream
     *         repositories</a>.
     */
    public final Boolean includeFromUpstream() {
        return includeFromUpstream;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRepository());
        hashCode = 31 * hashCode + Objects.hashCode(destinationRepository());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(packageValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasVersions() ? versions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVersionRevisions() ? versionRevisions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(allowOverwrite());
        hashCode = 31 * hashCode + Objects.hashCode(includeFromUpstream());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyPackageVersionsRequest)) {
            return false;
        }
        CopyPackageVersionsRequest other = (CopyPackageVersionsRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(domainOwner(), other.domainOwner())
                && Objects.equals(sourceRepository(), other.sourceRepository())
                && Objects.equals(destinationRepository(), other.destinationRepository())
                && Objects.equals(formatAsString(), other.formatAsString()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(packageValue(), other.packageValue()) && hasVersions() == other.hasVersions()
                && Objects.equals(versions(), other.versions()) && hasVersionRevisions() == other.hasVersionRevisions()
                && Objects.equals(versionRevisions(), other.versionRevisions())
                && Objects.equals(allowOverwrite(), other.allowOverwrite())
                && Objects.equals(includeFromUpstream(), other.includeFromUpstream());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyPackageVersionsRequest").add("Domain", domain()).add("DomainOwner", domainOwner())
                .add("SourceRepository", sourceRepository()).add("DestinationRepository", destinationRepository())
                .add("Format", formatAsString()).add("Namespace", namespace()).add("Package", packageValue())
                .add("Versions", hasVersions() ? versions() : null)
                .add("VersionRevisions", hasVersionRevisions() ? versionRevisions() : null)
                .add("AllowOverwrite", allowOverwrite()).add("IncludeFromUpstream", includeFromUpstream()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "domainOwner":
            return Optional.ofNullable(clazz.cast(domainOwner()));
        case "sourceRepository":
            return Optional.ofNullable(clazz.cast(sourceRepository()));
        case "destinationRepository":
            return Optional.ofNullable(clazz.cast(destinationRepository()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "package":
            return Optional.ofNullable(clazz.cast(packageValue()));
        case "versions":
            return Optional.ofNullable(clazz.cast(versions()));
        case "versionRevisions":
            return Optional.ofNullable(clazz.cast(versionRevisions()));
        case "allowOverwrite":
            return Optional.ofNullable(clazz.cast(allowOverwrite()));
        case "includeFromUpstream":
            return Optional.ofNullable(clazz.cast(includeFromUpstream()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domain", DOMAIN_FIELD);
        map.put("domain-owner", DOMAIN_OWNER_FIELD);
        map.put("source-repository", SOURCE_REPOSITORY_FIELD);
        map.put("destination-repository", DESTINATION_REPOSITORY_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("package", PACKAGE_FIELD);
        map.put("versions", VERSIONS_FIELD);
        map.put("versionRevisions", VERSION_REVISIONS_FIELD);
        map.put("allowOverwrite", ALLOW_OVERWRITE_FIELD);
        map.put("includeFromUpstream", INCLUDE_FROM_UPSTREAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopyPackageVersionsRequest, T> g) {
        return obj -> g.apply((CopyPackageVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactRequest.Builder, SdkPojo, CopyableBuilder<Builder, CopyPackageVersionsRequest> {
        /**
         * <p>
         * The name of the domain that contains the source and destination repositories.
         * </p>
         * 
         * @param domain
         *        The name of the domain that contains the source and destination repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include
         * dashes or spaces.
         * </p>
         * 
         * @param domainOwner
         *        The 12-digit account number of the Amazon Web Services account that owns the domain. It does not
         *        include dashes or spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainOwner(String domainOwner);

        /**
         * <p>
         * The name of the repository that contains the package versions to be copied.
         * </p>
         * 
         * @param sourceRepository
         *        The name of the repository that contains the package versions to be copied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRepository(String sourceRepository);

        /**
         * <p>
         * The name of the repository into which package versions are copied.
         * </p>
         * 
         * @param destinationRepository
         *        The name of the repository into which package versions are copied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationRepository(String destinationRepository);

        /**
         * <p>
         * The format of the package versions to be copied.
         * </p>
         * 
         * @param format
         *        The format of the package versions to be copied.
         * @see PackageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the package versions to be copied.
         * </p>
         * 
         * @param format
         *        The format of the package versions to be copied.
         * @see PackageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageFormat
         */
        Builder format(PackageFormat format);

        /**
         * <p>
         * The namespace of the package versions to be copied. The package component that specifies its namespace
         * depends on its type. For example:
         * </p>
         * <note>
         * <p>
         * The namespace is required when copying package versions of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maven
         * </p>
         * </li>
         * <li>
         * <p>
         * Swift
         * </p>
         * </li>
         * <li>
         * <p>
         * generic
         * </p>
         * </li>
         * </ul>
         * </note>
         * <ul>
         * <li>
         * <p>
         * The namespace of a Maven package version is its <code>groupId</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The namespace of an npm or Swift package version is its <code>scope</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The namespace of a generic package is its <code>namespace</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of
         * those formats do not have a namespace.
         * </p>
         * </li>
         * </ul>
         * 
         * @param namespace
         *        The namespace of the package versions to be copied. The package component that specifies its namespace
         *        depends on its type. For example:</p> <note>
         *        <p>
         *        The namespace is required when copying package versions of the following formats:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maven
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Swift
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        generic
         *        </p>
         *        </li>
         *        </ul>
         *        </note>
         *        <ul>
         *        <li>
         *        <p>
         *        The namespace of a Maven package version is its <code>groupId</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The namespace of an npm or Swift package version is its <code>scope</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The namespace of a generic package is its <code>namespace</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package
         *        versions of those formats do not have a namespace.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the package that contains the versions to be copied.
         * </p>
         * 
         * @param packageValue
         *        The name of the package that contains the versions to be copied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageValue(String packageValue);

        /**
         * <p>
         * The versions of the package to be copied.
         * </p>
         * <note>
         * <p>
         * You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
         * </p>
         * </note>
         * 
         * @param versions
         *        The versions of the package to be copied. </p> <note>
         *        <p>
         *        You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(Collection<String> versions);

        /**
         * <p>
         * The versions of the package to be copied.
         * </p>
         * <note>
         * <p>
         * You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
         * </p>
         * </note>
         * 
         * @param versions
         *        The versions of the package to be copied. </p> <note>
         *        <p>
         *        You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(String... versions);

        /**
         * <p>
         * A list of key-value pairs. The keys are package versions and the values are package version revisions. A
         * <code>CopyPackageVersion</code> operation succeeds if the specified versions in the source repository match
         * the specified package version revision.
         * </p>
         * <note>
         * <p>
         * You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
         * </p>
         * </note>
         * 
         * @param versionRevisions
         *        A list of key-value pairs. The keys are package versions and the values are package version revisions.
         *        A <code>CopyPackageVersion</code> operation succeeds if the specified versions in the source
         *        repository match the specified package version revision. </p> <note>
         *        <p>
         *        You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionRevisions(Map<String, String> versionRevisions);

        /**
         * <p>
         * Set to true to overwrite a package version that already exists in the destination repository. If set to false
         * and the package version already exists in the destination repository, the package version is returned in the
         * <code>failedVersions</code> field of the response with an <code>ALREADY_EXISTS</code> error code.
         * </p>
         * 
         * @param allowOverwrite
         *        Set to true to overwrite a package version that already exists in the destination repository. If set
         *        to false and the package version already exists in the destination repository, the package version is
         *        returned in the <code>failedVersions</code> field of the response with an <code>ALREADY_EXISTS</code>
         *        error code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowOverwrite(Boolean allowOverwrite);

        /**
         * <p>
         * Set to true to copy packages from repositories that are upstream from the source repository to the
         * destination repository. The default setting is false. For more information, see <a
         * href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream
         * repositories</a>.
         * </p>
         * 
         * @param includeFromUpstream
         *        Set to true to copy packages from repositories that are upstream from the source repository to the
         *        destination repository. The default setting is false. For more information, see <a
         *        href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream
         *        repositories</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeFromUpstream(Boolean includeFromUpstream);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeartifactRequest.BuilderImpl implements Builder {
        private String domain;

        private String domainOwner;

        private String sourceRepository;

        private String destinationRepository;

        private String format;

        private String namespace;

        private String packageValue;

        private List<String> versions = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> versionRevisions = DefaultSdkAutoConstructMap.getInstance();

        private Boolean allowOverwrite;

        private Boolean includeFromUpstream;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyPackageVersionsRequest model) {
            super(model);
            domain(model.domain);
            domainOwner(model.domainOwner);
            sourceRepository(model.sourceRepository);
            destinationRepository(model.destinationRepository);
            format(model.format);
            namespace(model.namespace);
            packageValue(model.packageValue);
            versions(model.versions);
            versionRevisions(model.versionRevisions);
            allowOverwrite(model.allowOverwrite);
            includeFromUpstream(model.includeFromUpstream);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getDomainOwner() {
            return domainOwner;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final String getSourceRepository() {
            return sourceRepository;
        }

        public final void setSourceRepository(String sourceRepository) {
            this.sourceRepository = sourceRepository;
        }

        @Override
        public final Builder sourceRepository(String sourceRepository) {
            this.sourceRepository = sourceRepository;
            return this;
        }

        public final String getDestinationRepository() {
            return destinationRepository;
        }

        public final void setDestinationRepository(String destinationRepository) {
            this.destinationRepository = destinationRepository;
        }

        @Override
        public final Builder destinationRepository(String destinationRepository) {
            this.destinationRepository = destinationRepository;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(PackageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getPackageValue() {
            return packageValue;
        }

        public final void setPackageValue(String packageValue) {
            this.packageValue = packageValue;
        }

        @Override
        public final Builder packageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public final Collection<String> getVersions() {
            if (versions instanceof SdkAutoConstructList) {
                return null;
            }
            return versions;
        }

        public final void setVersions(Collection<String> versions) {
            this.versions = PackageVersionListCopier.copy(versions);
        }

        @Override
        public final Builder versions(Collection<String> versions) {
            this.versions = PackageVersionListCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(String... versions) {
            versions(Arrays.asList(versions));
            return this;
        }

        public final Map<String, String> getVersionRevisions() {
            if (versionRevisions instanceof SdkAutoConstructMap) {
                return null;
            }
            return versionRevisions;
        }

        public final void setVersionRevisions(Map<String, String> versionRevisions) {
            this.versionRevisions = PackageVersionRevisionMapCopier.copy(versionRevisions);
        }

        @Override
        public final Builder versionRevisions(Map<String, String> versionRevisions) {
            this.versionRevisions = PackageVersionRevisionMapCopier.copy(versionRevisions);
            return this;
        }

        public final Boolean getAllowOverwrite() {
            return allowOverwrite;
        }

        public final void setAllowOverwrite(Boolean allowOverwrite) {
            this.allowOverwrite = allowOverwrite;
        }

        @Override
        public final Builder allowOverwrite(Boolean allowOverwrite) {
            this.allowOverwrite = allowOverwrite;
            return this;
        }

        public final Boolean getIncludeFromUpstream() {
            return includeFromUpstream;
        }

        public final void setIncludeFromUpstream(Boolean includeFromUpstream) {
            this.includeFromUpstream = includeFromUpstream;
        }

        @Override
        public final Builder includeFromUpstream(Boolean includeFromUpstream) {
            this.includeFromUpstream = includeFromUpstream;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyPackageVersionsRequest build() {
            return new CopyPackageVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
