/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePackageGroupResponse extends CodeartifactResponse implements
        ToCopyableBuilder<DeletePackageGroupResponse.Builder, DeletePackageGroupResponse> {
    private static final SdkField<PackageGroupDescription> PACKAGE_GROUP_FIELD = SdkField
            .<PackageGroupDescription> builder(MarshallingType.SDK_POJO).memberName("packageGroup")
            .getter(getter(DeletePackageGroupResponse::packageGroup)).setter(setter(Builder::packageGroup))
            .constructor(PackageGroupDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final PackageGroupDescription packageGroup;

    private DeletePackageGroupResponse(BuilderImpl builder) {
        super(builder);
        this.packageGroup = builder.packageGroup;
    }

    /**
     * <p>
     * Information about the deleted package group after processing the request.
     * </p>
     * 
     * @return Information about the deleted package group after processing the request.
     */
    public final PackageGroupDescription packageGroup() {
        return packageGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(packageGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePackageGroupResponse)) {
            return false;
        }
        DeletePackageGroupResponse other = (DeletePackageGroupResponse) obj;
        return Objects.equals(packageGroup(), other.packageGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeletePackageGroupResponse").add("PackageGroup", packageGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "packageGroup":
            return Optional.ofNullable(clazz.cast(packageGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("packageGroup", PACKAGE_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeletePackageGroupResponse, T> g) {
        return obj -> g.apply((DeletePackageGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeletePackageGroupResponse> {
        /**
         * <p>
         * Information about the deleted package group after processing the request.
         * </p>
         * 
         * @param packageGroup
         *        Information about the deleted package group after processing the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageGroup(PackageGroupDescription packageGroup);

        /**
         * <p>
         * Information about the deleted package group after processing the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageGroupDescription.Builder} avoiding
         * the need to create one manually via {@link PackageGroupDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PackageGroupDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #packageGroup(PackageGroupDescription)}.
         * 
         * @param packageGroup
         *        a consumer that will call methods on {@link PackageGroupDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageGroup(PackageGroupDescription)
         */
        default Builder packageGroup(Consumer<PackageGroupDescription.Builder> packageGroup) {
            return packageGroup(PackageGroupDescription.builder().applyMutation(packageGroup).build());
        }
    }

    static final class BuilderImpl extends CodeartifactResponse.BuilderImpl implements Builder {
        private PackageGroupDescription packageGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePackageGroupResponse model) {
            super(model);
            packageGroup(model.packageGroup);
        }

        public final PackageGroupDescription.Builder getPackageGroup() {
            return packageGroup != null ? packageGroup.toBuilder() : null;
        }

        public final void setPackageGroup(PackageGroupDescription.BuilderImpl packageGroup) {
            this.packageGroup = packageGroup != null ? packageGroup.build() : null;
        }

        @Override
        public final Builder packageGroup(PackageGroupDescription packageGroup) {
            this.packageGroup = packageGroup;
            return this;
        }

        @Override
        public DeletePackageGroupResponse build() {
            return new DeletePackageGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
