/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAllowedRepositoriesForGroupResponse extends CodeartifactResponse implements
        ToCopyableBuilder<ListAllowedRepositoriesForGroupResponse.Builder, ListAllowedRepositoriesForGroupResponse> {
    private static final SdkField<List<String>> ALLOWED_REPOSITORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedRepositories")
            .getter(getter(ListAllowedRepositoriesForGroupResponse::allowedRepositories))
            .setter(setter(Builder::allowedRepositories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedRepositories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAllowedRepositoriesForGroupResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_REPOSITORIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> allowedRepositories;

    private final String nextToken;

    private ListAllowedRepositoriesForGroupResponse(BuilderImpl builder) {
        super(builder);
        this.allowedRepositories = builder.allowedRepositories;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedRepositories property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedRepositories() {
        return allowedRepositories != null && !(allowedRepositories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of allowed repositories for the package group and origin configuration restriction type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedRepositories} method.
     * </p>
     * 
     * @return The list of allowed repositories for the package group and origin configuration restriction type.
     */
    public final List<String> allowedRepositories() {
        return allowedRepositories;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedRepositories() ? allowedRepositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAllowedRepositoriesForGroupResponse)) {
            return false;
        }
        ListAllowedRepositoriesForGroupResponse other = (ListAllowedRepositoriesForGroupResponse) obj;
        return hasAllowedRepositories() == other.hasAllowedRepositories()
                && Objects.equals(allowedRepositories(), other.allowedRepositories())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAllowedRepositoriesForGroupResponse")
                .add("AllowedRepositories", hasAllowedRepositories() ? allowedRepositories() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowedRepositories":
            return Optional.ofNullable(clazz.cast(allowedRepositories()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("allowedRepositories", ALLOWED_REPOSITORIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAllowedRepositoriesForGroupResponse, T> g) {
        return obj -> g.apply((ListAllowedRepositoriesForGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAllowedRepositoriesForGroupResponse> {
        /**
         * <p>
         * The list of allowed repositories for the package group and origin configuration restriction type.
         * </p>
         * 
         * @param allowedRepositories
         *        The list of allowed repositories for the package group and origin configuration restriction type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedRepositories(Collection<String> allowedRepositories);

        /**
         * <p>
         * The list of allowed repositories for the package group and origin configuration restriction type.
         * </p>
         * 
         * @param allowedRepositories
         *        The list of allowed repositories for the package group and origin configuration restriction type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedRepositories(String... allowedRepositories);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeartifactResponse.BuilderImpl implements Builder {
        private List<String> allowedRepositories = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAllowedRepositoriesForGroupResponse model) {
            super(model);
            allowedRepositories(model.allowedRepositories);
            nextToken(model.nextToken);
        }

        public final Collection<String> getAllowedRepositories() {
            if (allowedRepositories instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedRepositories;
        }

        public final void setAllowedRepositories(Collection<String> allowedRepositories) {
            this.allowedRepositories = RepositoryNameListCopier.copy(allowedRepositories);
        }

        @Override
        public final Builder allowedRepositories(Collection<String> allowedRepositories) {
            this.allowedRepositories = RepositoryNameListCopier.copy(allowedRepositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedRepositories(String... allowedRepositories) {
            allowedRepositories(Arrays.asList(allowedRepositories));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAllowedRepositoriesForGroupResponse build() {
            return new ListAllowedRepositoriesForGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
