/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class OriginRestrictionsCopier {
    static Map<String, String> copy(Map<String, String> originRestrictionsParam) {
        Map<String, String> map;
        if (originRestrictionsParam == null || originRestrictionsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, String> modifiableMap = new LinkedHashMap<>(originRestrictionsParam.size());
            originRestrictionsParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, String> copyEnumToString(
            Map<PackageGroupOriginRestrictionType, PackageGroupOriginRestrictionMode> originRestrictionsParam) {
        Map<String, String> map;
        if (originRestrictionsParam == null || originRestrictionsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, String> modifiableMap = new LinkedHashMap<>(originRestrictionsParam.size());
            originRestrictionsParam.forEach((key, value) -> {
                String result = key.toString();
                String result1 = value.toString();
                modifiableMap.put(result, result1);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<PackageGroupOriginRestrictionType, PackageGroupOriginRestrictionMode> copyStringToEnum(
            Map<String, String> originRestrictionsParam) {
        Map<PackageGroupOriginRestrictionType, PackageGroupOriginRestrictionMode> map;
        if (originRestrictionsParam == null || originRestrictionsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<PackageGroupOriginRestrictionType, PackageGroupOriginRestrictionMode> modifiableMap = new LinkedHashMap<>(
                    originRestrictionsParam.size());
            originRestrictionsParam.forEach((key, value) -> {
                PackageGroupOriginRestrictionType result = PackageGroupOriginRestrictionType.fromValue(key);
                PackageGroupOriginRestrictionMode result1 = PackageGroupOriginRestrictionMode.fromValue(value);
                if (result != PackageGroupOriginRestrictionType.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, result1);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
