/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a package.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackageDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<PackageDescription.Builder, PackageDescription> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(PackageDescription::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(PackageDescription::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(PackageDescription::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<PackageOriginConfiguration> ORIGIN_CONFIGURATION_FIELD = SdkField
            .<PackageOriginConfiguration> builder(MarshallingType.SDK_POJO).memberName("originConfiguration")
            .getter(getter(PackageDescription::originConfiguration)).setter(setter(Builder::originConfiguration))
            .constructor(PackageOriginConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, NAMESPACE_FIELD,
            NAME_FIELD, ORIGIN_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String format;

    private final String namespace;

    private final String name;

    private final PackageOriginConfiguration originConfiguration;

    private PackageDescription(BuilderImpl builder) {
        this.format = builder.format;
        this.namespace = builder.namespace;
        this.name = builder.name;
        this.originConfiguration = builder.originConfiguration;
    }

    /**
     * <p>
     * A format that specifies the type of the package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link PackageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return A format that specifies the type of the package.
     * @see PackageFormat
     */
    public final PackageFormat format() {
        return PackageFormat.fromValue(format);
    }

    /**
     * <p>
     * A format that specifies the type of the package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link PackageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return A format that specifies the type of the package.
     * @see PackageFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The namespace of the package. The package component that specifies its namespace depends on its type. For
     * example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The namespace of a Maven package version is its <code>groupId</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The namespace of an npm or Swift package version is its <code>scope</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The namespace of a generic package is its <code>namespace</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of
     * those formats do not have a namespace.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The namespace of the package. The package component that specifies its namespace depends on its type. For
     *         example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The namespace of a Maven package version is its <code>groupId</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The namespace of an npm or Swift package version is its <code>scope</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The namespace of a generic package is its <code>namespace</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package
     *         versions of those formats do not have a namespace.
     *         </p>
     *         </li>
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the package.
     * </p>
     * 
     * @return The name of the package.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The package origin configuration for the package.
     * </p>
     * 
     * @return The package origin configuration for the package.
     */
    public final PackageOriginConfiguration originConfiguration() {
        return originConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(originConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageDescription)) {
            return false;
        }
        PackageDescription other = (PackageDescription) obj;
        return Objects.equals(formatAsString(), other.formatAsString()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(name(), other.name()) && Objects.equals(originConfiguration(), other.originConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackageDescription").add("Format", formatAsString()).add("Namespace", namespace())
                .add("Name", name()).add("OriginConfiguration", originConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "originConfiguration":
            return Optional.ofNullable(clazz.cast(originConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("format", FORMAT_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("originConfiguration", ORIGIN_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PackageDescription, T> g) {
        return obj -> g.apply((PackageDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackageDescription> {
        /**
         * <p>
         * A format that specifies the type of the package.
         * </p>
         * 
         * @param format
         *        A format that specifies the type of the package.
         * @see PackageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageFormat
         */
        Builder format(String format);

        /**
         * <p>
         * A format that specifies the type of the package.
         * </p>
         * 
         * @param format
         *        A format that specifies the type of the package.
         * @see PackageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageFormat
         */
        Builder format(PackageFormat format);

        /**
         * <p>
         * The namespace of the package. The package component that specifies its namespace depends on its type. For
         * example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The namespace of a Maven package version is its <code>groupId</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The namespace of an npm or Swift package version is its <code>scope</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The namespace of a generic package is its <code>namespace</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package versions of
         * those formats do not have a namespace.
         * </p>
         * </li>
         * </ul>
         * 
         * @param namespace
         *        The namespace of the package. The package component that specifies its namespace depends on its type.
         *        For example:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The namespace of a Maven package version is its <code>groupId</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The namespace of an npm or Swift package version is its <code>scope</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The namespace of a generic package is its <code>namespace</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Python, NuGet, Ruby, and Cargo package versions do not contain a corresponding component, package
         *        versions of those formats do not have a namespace.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the package.
         * </p>
         * 
         * @param name
         *        The name of the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The package origin configuration for the package.
         * </p>
         * 
         * @param originConfiguration
         *        The package origin configuration for the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originConfiguration(PackageOriginConfiguration originConfiguration);

        /**
         * <p>
         * The package origin configuration for the package.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageOriginConfiguration.Builder}
         * avoiding the need to create one manually via {@link PackageOriginConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PackageOriginConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #originConfiguration(PackageOriginConfiguration)}.
         * 
         * @param originConfiguration
         *        a consumer that will call methods on {@link PackageOriginConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #originConfiguration(PackageOriginConfiguration)
         */
        default Builder originConfiguration(Consumer<PackageOriginConfiguration.Builder> originConfiguration) {
            return originConfiguration(PackageOriginConfiguration.builder().applyMutation(originConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String format;

        private String namespace;

        private String name;

        private PackageOriginConfiguration originConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageDescription model) {
            format(model.format);
            namespace(model.namespace);
            name(model.name);
            originConfiguration(model.originConfiguration);
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(PackageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PackageOriginConfiguration.Builder getOriginConfiguration() {
            return originConfiguration != null ? originConfiguration.toBuilder() : null;
        }

        public final void setOriginConfiguration(PackageOriginConfiguration.BuilderImpl originConfiguration) {
            this.originConfiguration = originConfiguration != null ? originConfiguration.build() : null;
        }

        @Override
        public final Builder originConfiguration(PackageOriginConfiguration originConfiguration) {
            this.originConfiguration = originConfiguration;
            return this;
        }

        @Override
        public PackageDescription build() {
            return new PackageDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
