/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an allowed repository for a package group, including its name and origin configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackageGroupAllowedRepository implements SdkPojo, Serializable,
        ToCopyableBuilder<PackageGroupAllowedRepository.Builder, PackageGroupAllowedRepository> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(PackageGroupAllowedRepository::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> ORIGIN_RESTRICTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("originRestrictionType").getter(getter(PackageGroupAllowedRepository::originRestrictionTypeAsString))
            .setter(setter(Builder::originRestrictionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originRestrictionType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            ORIGIN_RESTRICTION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String repositoryName;

    private final String originRestrictionType;

    private PackageGroupAllowedRepository(BuilderImpl builder) {
        this.repositoryName = builder.repositoryName;
        this.originRestrictionType = builder.originRestrictionType;
    }

    /**
     * <p>
     * The name of the allowed repository.
     * </p>
     * 
     * @return The name of the allowed repository.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The origin configuration restriction type of the allowed repository.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #originRestrictionType} will return {@link PackageGroupOriginRestrictionType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #originRestrictionTypeAsString}.
     * </p>
     * 
     * @return The origin configuration restriction type of the allowed repository.
     * @see PackageGroupOriginRestrictionType
     */
    public final PackageGroupOriginRestrictionType originRestrictionType() {
        return PackageGroupOriginRestrictionType.fromValue(originRestrictionType);
    }

    /**
     * <p>
     * The origin configuration restriction type of the allowed repository.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #originRestrictionType} will return {@link PackageGroupOriginRestrictionType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #originRestrictionTypeAsString}.
     * </p>
     * 
     * @return The origin configuration restriction type of the allowed repository.
     * @see PackageGroupOriginRestrictionType
     */
    public final String originRestrictionTypeAsString() {
        return originRestrictionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(originRestrictionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageGroupAllowedRepository)) {
            return false;
        }
        PackageGroupAllowedRepository other = (PackageGroupAllowedRepository) obj;
        return Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(originRestrictionTypeAsString(), other.originRestrictionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackageGroupAllowedRepository").add("RepositoryName", repositoryName())
                .add("OriginRestrictionType", originRestrictionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "originRestrictionType":
            return Optional.ofNullable(clazz.cast(originRestrictionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("originRestrictionType", ORIGIN_RESTRICTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PackageGroupAllowedRepository, T> g) {
        return obj -> g.apply((PackageGroupAllowedRepository) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackageGroupAllowedRepository> {
        /**
         * <p>
         * The name of the allowed repository.
         * </p>
         * 
         * @param repositoryName
         *        The name of the allowed repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The origin configuration restriction type of the allowed repository.
         * </p>
         * 
         * @param originRestrictionType
         *        The origin configuration restriction type of the allowed repository.
         * @see PackageGroupOriginRestrictionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageGroupOriginRestrictionType
         */
        Builder originRestrictionType(String originRestrictionType);

        /**
         * <p>
         * The origin configuration restriction type of the allowed repository.
         * </p>
         * 
         * @param originRestrictionType
         *        The origin configuration restriction type of the allowed repository.
         * @see PackageGroupOriginRestrictionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageGroupOriginRestrictionType
         */
        Builder originRestrictionType(PackageGroupOriginRestrictionType originRestrictionType);
    }

    static final class BuilderImpl implements Builder {
        private String repositoryName;

        private String originRestrictionType;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageGroupAllowedRepository model) {
            repositoryName(model.repositoryName);
            originRestrictionType(model.originRestrictionType);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getOriginRestrictionType() {
            return originRestrictionType;
        }

        public final void setOriginRestrictionType(String originRestrictionType) {
            this.originRestrictionType = originRestrictionType;
        }

        @Override
        public final Builder originRestrictionType(String originRestrictionType) {
            this.originRestrictionType = originRestrictionType;
            return this;
        }

        @Override
        public final Builder originRestrictionType(PackageGroupOriginRestrictionType originRestrictionType) {
            this.originRestrictionType(originRestrictionType == null ? null : originRestrictionType.toString());
            return this;
        }

        @Override
        public PackageGroupAllowedRepository build() {
            return new PackageGroupAllowedRepository(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
