/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The package group origin configuration that determines how package versions can enter repositories.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackageGroupOriginConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PackageGroupOriginConfiguration.Builder, PackageGroupOriginConfiguration> {
    private static final SdkField<Map<String, PackageGroupOriginRestriction>> RESTRICTIONS_FIELD = SdkField
            .<Map<String, PackageGroupOriginRestriction>> builder(MarshallingType.MAP)
            .memberName("restrictions")
            .getter(getter(PackageGroupOriginConfiguration::restrictionsAsStrings))
            .setter(setter(Builder::restrictionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restrictions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<PackageGroupOriginRestriction> builder(MarshallingType.SDK_POJO)
                                            .constructor(PackageGroupOriginRestriction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESTRICTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, PackageGroupOriginRestriction> restrictions;

    private PackageGroupOriginConfiguration(BuilderImpl builder) {
        this.restrictions = builder.restrictions;
    }

    /**
     * <p>
     * The origin configuration settings that determine how package versions can enter repositories.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRestrictions} method.
     * </p>
     * 
     * @return The origin configuration settings that determine how package versions can enter repositories.
     */
    public final Map<PackageGroupOriginRestrictionType, PackageGroupOriginRestriction> restrictions() {
        return PackageGroupOriginRestrictionsCopier.copyStringToEnum(restrictions);
    }

    /**
     * For responses, this returns true if the service returned a value for the Restrictions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRestrictions() {
        return restrictions != null && !(restrictions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The origin configuration settings that determine how package versions can enter repositories.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRestrictions} method.
     * </p>
     * 
     * @return The origin configuration settings that determine how package versions can enter repositories.
     */
    public final Map<String, PackageGroupOriginRestriction> restrictionsAsStrings() {
        return restrictions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRestrictions() ? restrictionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageGroupOriginConfiguration)) {
            return false;
        }
        PackageGroupOriginConfiguration other = (PackageGroupOriginConfiguration) obj;
        return hasRestrictions() == other.hasRestrictions()
                && Objects.equals(restrictionsAsStrings(), other.restrictionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackageGroupOriginConfiguration")
                .add("Restrictions", hasRestrictions() ? restrictionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restrictions":
            return Optional.ofNullable(clazz.cast(restrictionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("restrictions", RESTRICTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PackageGroupOriginConfiguration, T> g) {
        return obj -> g.apply((PackageGroupOriginConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackageGroupOriginConfiguration> {
        /**
         * <p>
         * The origin configuration settings that determine how package versions can enter repositories.
         * </p>
         * 
         * @param restrictions
         *        The origin configuration settings that determine how package versions can enter repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restrictionsWithStrings(Map<String, PackageGroupOriginRestriction> restrictions);

        /**
         * <p>
         * The origin configuration settings that determine how package versions can enter repositories.
         * </p>
         * 
         * @param restrictions
         *        The origin configuration settings that determine how package versions can enter repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restrictions(Map<PackageGroupOriginRestrictionType, PackageGroupOriginRestriction> restrictions);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, PackageGroupOriginRestriction> restrictions = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PackageGroupOriginConfiguration model) {
            restrictionsWithStrings(model.restrictions);
        }

        public final Map<String, PackageGroupOriginRestriction.Builder> getRestrictions() {
            Map<String, PackageGroupOriginRestriction.Builder> result = PackageGroupOriginRestrictionsCopier
                    .copyToBuilder(this.restrictions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setRestrictions(Map<String, PackageGroupOriginRestriction.BuilderImpl> restrictions) {
            this.restrictions = PackageGroupOriginRestrictionsCopier.copyFromBuilder(restrictions);
        }

        @Override
        public final Builder restrictionsWithStrings(Map<String, PackageGroupOriginRestriction> restrictions) {
            this.restrictions = PackageGroupOriginRestrictionsCopier.copy(restrictions);
            return this;
        }

        @Override
        public final Builder restrictions(Map<PackageGroupOriginRestrictionType, PackageGroupOriginRestriction> restrictions) {
            this.restrictions = PackageGroupOriginRestrictionsCopier.copyEnumToString(restrictions);
            return this;
        }

        @Override
        public PackageGroupOriginConfiguration build() {
            return new PackageGroupOriginConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
