/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about how a package version was added to a repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackageVersionOrigin implements SdkPojo, Serializable,
        ToCopyableBuilder<PackageVersionOrigin.Builder, PackageVersionOrigin> {
    private static final SdkField<DomainEntryPoint> DOMAIN_ENTRY_POINT_FIELD = SdkField
            .<DomainEntryPoint> builder(MarshallingType.SDK_POJO).memberName("domainEntryPoint")
            .getter(getter(PackageVersionOrigin::domainEntryPoint)).setter(setter(Builder::domainEntryPoint))
            .constructor(DomainEntryPoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainEntryPoint").build()).build();

    private static final SdkField<String> ORIGIN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("originType").getter(getter(PackageVersionOrigin::originTypeAsString))
            .setter(setter(Builder::originType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ENTRY_POINT_FIELD,
            ORIGIN_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DomainEntryPoint domainEntryPoint;

    private final String originType;

    private PackageVersionOrigin(BuilderImpl builder) {
        this.domainEntryPoint = builder.domainEntryPoint;
        this.originType = builder.originType;
    }

    /**
     * <p>
     * A <a
     * href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainEntryPoint.html">DomainEntryPoint
     * </a> object that contains information about from which repository or external connection the package version was
     * added to the domain.
     * </p>
     * 
     * @return A <a
     *         href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainEntryPoint.html">DomainEntryPoint
     *         </a> object that contains information about from which repository or external connection the package
     *         version was added to the domain.
     */
    public final DomainEntryPoint domainEntryPoint() {
        return domainEntryPoint;
    }

    /**
     * <p>
     * Describes how the package version was originally added to the domain. An <code>INTERNAL</code> origin type means
     * the package version was published directly to a repository in the domain. An <code>EXTERNAL</code> origin type
     * means the package version was ingested from an external connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #originType} will
     * return {@link PackageVersionOriginType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #originTypeAsString}.
     * </p>
     * 
     * @return Describes how the package version was originally added to the domain. An <code>INTERNAL</code> origin
     *         type means the package version was published directly to a repository in the domain. An
     *         <code>EXTERNAL</code> origin type means the package version was ingested from an external connection.
     * @see PackageVersionOriginType
     */
    public final PackageVersionOriginType originType() {
        return PackageVersionOriginType.fromValue(originType);
    }

    /**
     * <p>
     * Describes how the package version was originally added to the domain. An <code>INTERNAL</code> origin type means
     * the package version was published directly to a repository in the domain. An <code>EXTERNAL</code> origin type
     * means the package version was ingested from an external connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #originType} will
     * return {@link PackageVersionOriginType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #originTypeAsString}.
     * </p>
     * 
     * @return Describes how the package version was originally added to the domain. An <code>INTERNAL</code> origin
     *         type means the package version was published directly to a repository in the domain. An
     *         <code>EXTERNAL</code> origin type means the package version was ingested from an external connection.
     * @see PackageVersionOriginType
     */
    public final String originTypeAsString() {
        return originType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainEntryPoint());
        hashCode = 31 * hashCode + Objects.hashCode(originTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageVersionOrigin)) {
            return false;
        }
        PackageVersionOrigin other = (PackageVersionOrigin) obj;
        return Objects.equals(domainEntryPoint(), other.domainEntryPoint())
                && Objects.equals(originTypeAsString(), other.originTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackageVersionOrigin").add("DomainEntryPoint", domainEntryPoint())
                .add("OriginType", originTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainEntryPoint":
            return Optional.ofNullable(clazz.cast(domainEntryPoint()));
        case "originType":
            return Optional.ofNullable(clazz.cast(originTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainEntryPoint", DOMAIN_ENTRY_POINT_FIELD);
        map.put("originType", ORIGIN_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PackageVersionOrigin, T> g) {
        return obj -> g.apply((PackageVersionOrigin) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackageVersionOrigin> {
        /**
         * <p>
         * A <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainEntryPoint.html">
         * DomainEntryPoint</a> object that contains information about from which repository or external connection the
         * package version was added to the domain.
         * </p>
         * 
         * @param domainEntryPoint
         *        A <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainEntryPoint.html">
         *        DomainEntryPoint</a> object that contains information about from which repository or external
         *        connection the package version was added to the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainEntryPoint(DomainEntryPoint domainEntryPoint);

        /**
         * <p>
         * A <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainEntryPoint.html">
         * DomainEntryPoint</a> object that contains information about from which repository or external connection the
         * package version was added to the domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainEntryPoint.Builder} avoiding the
         * need to create one manually via {@link DomainEntryPoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainEntryPoint.Builder#build()} is called immediately and its
         * result is passed to {@link #domainEntryPoint(DomainEntryPoint)}.
         * 
         * @param domainEntryPoint
         *        a consumer that will call methods on {@link DomainEntryPoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainEntryPoint(DomainEntryPoint)
         */
        default Builder domainEntryPoint(Consumer<DomainEntryPoint.Builder> domainEntryPoint) {
            return domainEntryPoint(DomainEntryPoint.builder().applyMutation(domainEntryPoint).build());
        }

        /**
         * <p>
         * Describes how the package version was originally added to the domain. An <code>INTERNAL</code> origin type
         * means the package version was published directly to a repository in the domain. An <code>EXTERNAL</code>
         * origin type means the package version was ingested from an external connection.
         * </p>
         * 
         * @param originType
         *        Describes how the package version was originally added to the domain. An <code>INTERNAL</code> origin
         *        type means the package version was published directly to a repository in the domain. An
         *        <code>EXTERNAL</code> origin type means the package version was ingested from an external connection.
         * @see PackageVersionOriginType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageVersionOriginType
         */
        Builder originType(String originType);

        /**
         * <p>
         * Describes how the package version was originally added to the domain. An <code>INTERNAL</code> origin type
         * means the package version was published directly to a repository in the domain. An <code>EXTERNAL</code>
         * origin type means the package version was ingested from an external connection.
         * </p>
         * 
         * @param originType
         *        Describes how the package version was originally added to the domain. An <code>INTERNAL</code> origin
         *        type means the package version was published directly to a repository in the domain. An
         *        <code>EXTERNAL</code> origin type means the package version was ingested from an external connection.
         * @see PackageVersionOriginType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageVersionOriginType
         */
        Builder originType(PackageVersionOriginType originType);
    }

    static final class BuilderImpl implements Builder {
        private DomainEntryPoint domainEntryPoint;

        private String originType;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageVersionOrigin model) {
            domainEntryPoint(model.domainEntryPoint);
            originType(model.originType);
        }

        public final DomainEntryPoint.Builder getDomainEntryPoint() {
            return domainEntryPoint != null ? domainEntryPoint.toBuilder() : null;
        }

        public final void setDomainEntryPoint(DomainEntryPoint.BuilderImpl domainEntryPoint) {
            this.domainEntryPoint = domainEntryPoint != null ? domainEntryPoint.build() : null;
        }

        @Override
        public final Builder domainEntryPoint(DomainEntryPoint domainEntryPoint) {
            this.domainEntryPoint = domainEntryPoint;
            return this;
        }

        public final String getOriginType() {
            return originType;
        }

        public final void setOriginType(String originType) {
            this.originType = originType;
        }

        @Override
        public final Builder originType(String originType) {
            this.originType = originType;
            return this;
        }

        @Override
        public final Builder originType(PackageVersionOriginType originType) {
            this.originType(originType == null ? null : originType.toString());
            return this;
        }

        @Override
        public PackageVersionOrigin build() {
            return new PackageVersionOrigin(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
