/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a repository stored in CodeArtifact. A CodeArtifact repository contains a set of package versions,
 * each of which maps to a set of assets. Repositories are polyglot—a single repository can contain packages of any
 * supported type. Each repository exposes endpoints for fetching and publishing packages using tools like the
 * <code>npm</code> CLI, the Maven CLI (<code>mvn</code>), and <code>pip</code>. You can create up to 100 repositories
 * per Amazon Web Services account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RepositoryDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<RepositoryDescription.Builder, RepositoryDescription> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RepositoryDescription::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ADMINISTRATOR_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("administratorAccount").getter(getter(RepositoryDescription::administratorAccount))
            .setter(setter(Builder::administratorAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("administratorAccount").build())
            .build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainName").getter(getter(RepositoryDescription::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainOwner").getter(getter(RepositoryDescription::domainOwner)).setter(setter(Builder::domainOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainOwner").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(RepositoryDescription::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(RepositoryDescription::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<UpstreamRepositoryInfo>> UPSTREAMS_FIELD = SdkField
            .<List<UpstreamRepositoryInfo>> builder(MarshallingType.LIST)
            .memberName("upstreams")
            .getter(getter(RepositoryDescription::upstreams))
            .setter(setter(Builder::upstreams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreams").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpstreamRepositoryInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpstreamRepositoryInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RepositoryExternalConnectionInfo>> EXTERNAL_CONNECTIONS_FIELD = SdkField
            .<List<RepositoryExternalConnectionInfo>> builder(MarshallingType.LIST)
            .memberName("externalConnections")
            .getter(getter(RepositoryDescription::externalConnections))
            .setter(setter(Builder::externalConnections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalConnections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RepositoryExternalConnectionInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(RepositoryExternalConnectionInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTime").getter(getter(RepositoryDescription::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            ADMINISTRATOR_ACCOUNT_FIELD, DOMAIN_NAME_FIELD, DOMAIN_OWNER_FIELD, ARN_FIELD, DESCRIPTION_FIELD, UPSTREAMS_FIELD,
            EXTERNAL_CONNECTIONS_FIELD, CREATED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String administratorAccount;

    private final String domainName;

    private final String domainOwner;

    private final String arn;

    private final String description;

    private final List<UpstreamRepositoryInfo> upstreams;

    private final List<RepositoryExternalConnectionInfo> externalConnections;

    private final Instant createdTime;

    private RepositoryDescription(BuilderImpl builder) {
        this.name = builder.name;
        this.administratorAccount = builder.administratorAccount;
        this.domainName = builder.domainName;
        this.domainOwner = builder.domainOwner;
        this.arn = builder.arn;
        this.description = builder.description;
        this.upstreams = builder.upstreams;
        this.externalConnections = builder.externalConnections;
        this.createdTime = builder.createdTime;
    }

    /**
     * <p>
     * The name of the repository.
     * </p>
     * 
     * @return The name of the repository.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The 12-digit account number of the Amazon Web Services account that manages the repository.
     * </p>
     * 
     * @return The 12-digit account number of the Amazon Web Services account that manages the repository.
     */
    public final String administratorAccount() {
        return administratorAccount;
    }

    /**
     * <p>
     * The name of the domain that contains the repository.
     * </p>
     * 
     * @return The name of the domain that contains the repository.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The 12-digit account number of the Amazon Web Services account that owns the domain that contains the repository.
     * It does not include dashes or spaces.
     * </p>
     * 
     * @return The 12-digit account number of the Amazon Web Services account that owns the domain that contains the
     *         repository. It does not include dashes or spaces.
     */
    public final String domainOwner() {
        return domainOwner;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the repository.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the repository.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A text description of the repository.
     * </p>
     * 
     * @return A text description of the repository.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Upstreams property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUpstreams() {
        return upstreams != null && !(upstreams instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of upstream repositories to associate with the repository. The order of the upstream repositories in the
     * list determines their priority order when CodeArtifact looks for a requested package version. For more
     * information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with
     * upstream repositories</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpstreams} method.
     * </p>
     * 
     * @return A list of upstream repositories to associate with the repository. The order of the upstream repositories
     *         in the list determines their priority order when CodeArtifact looks for a requested package version. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream
     *         repositories</a>.
     */
    public final List<UpstreamRepositoryInfo> upstreams() {
        return upstreams;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExternalConnections property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExternalConnections() {
        return externalConnections != null && !(externalConnections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of external connections associated with the repository.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExternalConnections} method.
     * </p>
     * 
     * @return An array of external connections associated with the repository.
     */
    public final List<RepositoryExternalConnectionInfo> externalConnections() {
        return externalConnections;
    }

    /**
     * <p>
     * A timestamp that represents the date and time the repository was created.
     * </p>
     * 
     * @return A timestamp that represents the date and time the repository was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(administratorAccount());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasUpstreams() ? upstreams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExternalConnections() ? externalConnections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryDescription)) {
            return false;
        }
        RepositoryDescription other = (RepositoryDescription) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(administratorAccount(), other.administratorAccount())
                && Objects.equals(domainName(), other.domainName()) && Objects.equals(domainOwner(), other.domainOwner())
                && Objects.equals(arn(), other.arn()) && Objects.equals(description(), other.description())
                && hasUpstreams() == other.hasUpstreams() && Objects.equals(upstreams(), other.upstreams())
                && hasExternalConnections() == other.hasExternalConnections()
                && Objects.equals(externalConnections(), other.externalConnections())
                && Objects.equals(createdTime(), other.createdTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RepositoryDescription").add("Name", name()).add("AdministratorAccount", administratorAccount())
                .add("DomainName", domainName()).add("DomainOwner", domainOwner()).add("Arn", arn())
                .add("Description", description()).add("Upstreams", hasUpstreams() ? upstreams() : null)
                .add("ExternalConnections", hasExternalConnections() ? externalConnections() : null)
                .add("CreatedTime", createdTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "administratorAccount":
            return Optional.ofNullable(clazz.cast(administratorAccount()));
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "domainOwner":
            return Optional.ofNullable(clazz.cast(domainOwner()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "upstreams":
            return Optional.ofNullable(clazz.cast(upstreams()));
        case "externalConnections":
            return Optional.ofNullable(clazz.cast(externalConnections()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("administratorAccount", ADMINISTRATOR_ACCOUNT_FIELD);
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("domainOwner", DOMAIN_OWNER_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("upstreams", UPSTREAMS_FIELD);
        map.put("externalConnections", EXTERNAL_CONNECTIONS_FIELD);
        map.put("createdTime", CREATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RepositoryDescription, T> g) {
        return obj -> g.apply((RepositoryDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RepositoryDescription> {
        /**
         * <p>
         * The name of the repository.
         * </p>
         * 
         * @param name
         *        The name of the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The 12-digit account number of the Amazon Web Services account that manages the repository.
         * </p>
         * 
         * @param administratorAccount
         *        The 12-digit account number of the Amazon Web Services account that manages the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder administratorAccount(String administratorAccount);

        /**
         * <p>
         * The name of the domain that contains the repository.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that contains the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The 12-digit account number of the Amazon Web Services account that owns the domain that contains the
         * repository. It does not include dashes or spaces.
         * </p>
         * 
         * @param domainOwner
         *        The 12-digit account number of the Amazon Web Services account that owns the domain that contains the
         *        repository. It does not include dashes or spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainOwner(String domainOwner);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the repository.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A text description of the repository.
         * </p>
         * 
         * @param description
         *        A text description of the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of upstream repositories to associate with the repository. The order of the upstream repositories in
         * the list determines their priority order when CodeArtifact looks for a requested package version. For more
         * information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working
         * with upstream repositories</a>.
         * </p>
         * 
         * @param upstreams
         *        A list of upstream repositories to associate with the repository. The order of the upstream
         *        repositories in the list determines their priority order when CodeArtifact looks for a requested
         *        package version. For more information, see <a
         *        href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream
         *        repositories</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upstreams(Collection<UpstreamRepositoryInfo> upstreams);

        /**
         * <p>
         * A list of upstream repositories to associate with the repository. The order of the upstream repositories in
         * the list determines their priority order when CodeArtifact looks for a requested package version. For more
         * information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working
         * with upstream repositories</a>.
         * </p>
         * 
         * @param upstreams
         *        A list of upstream repositories to associate with the repository. The order of the upstream
         *        repositories in the list determines their priority order when CodeArtifact looks for a requested
         *        package version. For more information, see <a
         *        href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream
         *        repositories</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upstreams(UpstreamRepositoryInfo... upstreams);

        /**
         * <p>
         * A list of upstream repositories to associate with the repository. The order of the upstream repositories in
         * the list determines their priority order when CodeArtifact looks for a requested package version. For more
         * information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working
         * with upstream repositories</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codeartifact.model.UpstreamRepositoryInfo.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.codeartifact.model.UpstreamRepositoryInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codeartifact.model.UpstreamRepositoryInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #upstreams(List<UpstreamRepositoryInfo>)}.
         * 
         * @param upstreams
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codeartifact.model.UpstreamRepositoryInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #upstreams(java.util.Collection<UpstreamRepositoryInfo>)
         */
        Builder upstreams(Consumer<UpstreamRepositoryInfo.Builder>... upstreams);

        /**
         * <p>
         * An array of external connections associated with the repository.
         * </p>
         * 
         * @param externalConnections
         *        An array of external connections associated with the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalConnections(Collection<RepositoryExternalConnectionInfo> externalConnections);

        /**
         * <p>
         * An array of external connections associated with the repository.
         * </p>
         * 
         * @param externalConnections
         *        An array of external connections associated with the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalConnections(RepositoryExternalConnectionInfo... externalConnections);

        /**
         * <p>
         * An array of external connections associated with the repository.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codeartifact.model.RepositoryExternalConnectionInfo.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.codeartifact.model.RepositoryExternalConnectionInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codeartifact.model.RepositoryExternalConnectionInfo.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #externalConnections(List<RepositoryExternalConnectionInfo>)}.
         * 
         * @param externalConnections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codeartifact.model.RepositoryExternalConnectionInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalConnections(java.util.Collection<RepositoryExternalConnectionInfo>)
         */
        Builder externalConnections(Consumer<RepositoryExternalConnectionInfo.Builder>... externalConnections);

        /**
         * <p>
         * A timestamp that represents the date and time the repository was created.
         * </p>
         * 
         * @param createdTime
         *        A timestamp that represents the date and time the repository was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String administratorAccount;

        private String domainName;

        private String domainOwner;

        private String arn;

        private String description;

        private List<UpstreamRepositoryInfo> upstreams = DefaultSdkAutoConstructList.getInstance();

        private List<RepositoryExternalConnectionInfo> externalConnections = DefaultSdkAutoConstructList.getInstance();

        private Instant createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryDescription model) {
            name(model.name);
            administratorAccount(model.administratorAccount);
            domainName(model.domainName);
            domainOwner(model.domainOwner);
            arn(model.arn);
            description(model.description);
            upstreams(model.upstreams);
            externalConnections(model.externalConnections);
            createdTime(model.createdTime);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAdministratorAccount() {
            return administratorAccount;
        }

        public final void setAdministratorAccount(String administratorAccount) {
            this.administratorAccount = administratorAccount;
        }

        @Override
        public final Builder administratorAccount(String administratorAccount) {
            this.administratorAccount = administratorAccount;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getDomainOwner() {
            return domainOwner;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<UpstreamRepositoryInfo.Builder> getUpstreams() {
            List<UpstreamRepositoryInfo.Builder> result = UpstreamRepositoryInfoListCopier.copyToBuilder(this.upstreams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpstreams(Collection<UpstreamRepositoryInfo.BuilderImpl> upstreams) {
            this.upstreams = UpstreamRepositoryInfoListCopier.copyFromBuilder(upstreams);
        }

        @Override
        public final Builder upstreams(Collection<UpstreamRepositoryInfo> upstreams) {
            this.upstreams = UpstreamRepositoryInfoListCopier.copy(upstreams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder upstreams(UpstreamRepositoryInfo... upstreams) {
            upstreams(Arrays.asList(upstreams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder upstreams(Consumer<UpstreamRepositoryInfo.Builder>... upstreams) {
            upstreams(Stream.of(upstreams).map(c -> UpstreamRepositoryInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RepositoryExternalConnectionInfo.Builder> getExternalConnections() {
            List<RepositoryExternalConnectionInfo.Builder> result = RepositoryExternalConnectionInfoListCopier
                    .copyToBuilder(this.externalConnections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExternalConnections(Collection<RepositoryExternalConnectionInfo.BuilderImpl> externalConnections) {
            this.externalConnections = RepositoryExternalConnectionInfoListCopier.copyFromBuilder(externalConnections);
        }

        @Override
        public final Builder externalConnections(Collection<RepositoryExternalConnectionInfo> externalConnections) {
            this.externalConnections = RepositoryExternalConnectionInfoListCopier.copy(externalConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalConnections(RepositoryExternalConnectionInfo... externalConnections) {
            externalConnections(Arrays.asList(externalConnections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalConnections(Consumer<RepositoryExternalConnectionInfo.Builder>... externalConnections) {
            externalConnections(Stream.of(externalConnections)
                    .map(c -> RepositoryExternalConnectionInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Override
        public RepositoryDescription build() {
            return new RepositoryDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
