/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePackageGroupOriginConfigurationResponse extends CodeartifactResponse implements
        ToCopyableBuilder<UpdatePackageGroupOriginConfigurationResponse.Builder, UpdatePackageGroupOriginConfigurationResponse> {
    private static final SdkField<PackageGroupDescription> PACKAGE_GROUP_FIELD = SdkField
            .<PackageGroupDescription> builder(MarshallingType.SDK_POJO).memberName("packageGroup")
            .getter(getter(UpdatePackageGroupOriginConfigurationResponse::packageGroup)).setter(setter(Builder::packageGroup))
            .constructor(PackageGroupDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageGroup").build()).build();

    private static final SdkField<Map<String, Map<String, List<String>>>> ALLOWED_REPOSITORY_UPDATES_FIELD = SdkField
            .<Map<String, Map<String, List<String>>>> builder(MarshallingType.MAP)
            .memberName("allowedRepositoryUpdates")
            .getter(getter(UpdatePackageGroupOriginConfigurationResponse::allowedRepositoryUpdatesAsStrings))
            .setter(setter(Builder::allowedRepositoryUpdatesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedRepositoryUpdates").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, List<String>>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build(),
                                                                                    ListTrait
                                                                                            .builder()
                                                                                            .memberLocationName(null)
                                                                                            .memberFieldInfo(
                                                                                                    SdkField.<String> builder(
                                                                                                            MarshallingType.STRING)
                                                                                                            .traits(LocationTrait
                                                                                                                    .builder()
                                                                                                                    .location(
                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                    .locationName(
                                                                                                                            "member")
                                                                                                                    .build())
                                                                                                            .build()).build())
                                                                            .build()).build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_GROUP_FIELD,
            ALLOWED_REPOSITORY_UPDATES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final PackageGroupDescription packageGroup;

    private final Map<String, Map<String, List<String>>> allowedRepositoryUpdates;

    private UpdatePackageGroupOriginConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.packageGroup = builder.packageGroup;
        this.allowedRepositoryUpdates = builder.allowedRepositoryUpdates;
    }

    /**
     * <p>
     * The package group and information about it after processing the request.
     * </p>
     * 
     * @return The package group and information about it after processing the request.
     */
    public final PackageGroupDescription packageGroup() {
        return packageGroup;
    }

    /**
     * <p>
     * Information about the updated allowed repositories after processing the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedRepositoryUpdates} method.
     * </p>
     * 
     * @return Information about the updated allowed repositories after processing the request.
     */
    public final Map<PackageGroupOriginRestrictionType, Map<PackageGroupAllowedRepositoryUpdateType, List<String>>> allowedRepositoryUpdates() {
        return PackageGroupAllowedRepositoryUpdatesCopier.copyStringToEnum(allowedRepositoryUpdates);
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedRepositoryUpdates property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAllowedRepositoryUpdates() {
        return allowedRepositoryUpdates != null && !(allowedRepositoryUpdates instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Information about the updated allowed repositories after processing the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedRepositoryUpdates} method.
     * </p>
     * 
     * @return Information about the updated allowed repositories after processing the request.
     */
    public final Map<String, Map<String, List<String>>> allowedRepositoryUpdatesAsStrings() {
        return allowedRepositoryUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(packageGroup());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedRepositoryUpdates() ? allowedRepositoryUpdatesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePackageGroupOriginConfigurationResponse)) {
            return false;
        }
        UpdatePackageGroupOriginConfigurationResponse other = (UpdatePackageGroupOriginConfigurationResponse) obj;
        return Objects.equals(packageGroup(), other.packageGroup())
                && hasAllowedRepositoryUpdates() == other.hasAllowedRepositoryUpdates()
                && Objects.equals(allowedRepositoryUpdatesAsStrings(), other.allowedRepositoryUpdatesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePackageGroupOriginConfigurationResponse").add("PackageGroup", packageGroup())
                .add("AllowedRepositoryUpdates", hasAllowedRepositoryUpdates() ? allowedRepositoryUpdatesAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "packageGroup":
            return Optional.ofNullable(clazz.cast(packageGroup()));
        case "allowedRepositoryUpdates":
            return Optional.ofNullable(clazz.cast(allowedRepositoryUpdatesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("packageGroup", PACKAGE_GROUP_FIELD);
        map.put("allowedRepositoryUpdates", ALLOWED_REPOSITORY_UPDATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePackageGroupOriginConfigurationResponse, T> g) {
        return obj -> g.apply((UpdatePackageGroupOriginConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePackageGroupOriginConfigurationResponse> {
        /**
         * <p>
         * The package group and information about it after processing the request.
         * </p>
         * 
         * @param packageGroup
         *        The package group and information about it after processing the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageGroup(PackageGroupDescription packageGroup);

        /**
         * <p>
         * The package group and information about it after processing the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageGroupDescription.Builder} avoiding
         * the need to create one manually via {@link PackageGroupDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PackageGroupDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #packageGroup(PackageGroupDescription)}.
         * 
         * @param packageGroup
         *        a consumer that will call methods on {@link PackageGroupDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageGroup(PackageGroupDescription)
         */
        default Builder packageGroup(Consumer<PackageGroupDescription.Builder> packageGroup) {
            return packageGroup(PackageGroupDescription.builder().applyMutation(packageGroup).build());
        }

        /**
         * <p>
         * Information about the updated allowed repositories after processing the request.
         * </p>
         * 
         * @param allowedRepositoryUpdates
         *        Information about the updated allowed repositories after processing the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedRepositoryUpdatesWithStrings(
                Map<String, ? extends Map<String, ? extends Collection<String>>> allowedRepositoryUpdates);

        /**
         * <p>
         * Information about the updated allowed repositories after processing the request.
         * </p>
         * 
         * @param allowedRepositoryUpdates
         *        Information about the updated allowed repositories after processing the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedRepositoryUpdates(
                Map<PackageGroupOriginRestrictionType, ? extends Map<PackageGroupAllowedRepositoryUpdateType, ? extends Collection<String>>> allowedRepositoryUpdates);
    }

    static final class BuilderImpl extends CodeartifactResponse.BuilderImpl implements Builder {
        private PackageGroupDescription packageGroup;

        private Map<String, Map<String, List<String>>> allowedRepositoryUpdates = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePackageGroupOriginConfigurationResponse model) {
            super(model);
            packageGroup(model.packageGroup);
            allowedRepositoryUpdatesWithStrings(model.allowedRepositoryUpdates);
        }

        public final PackageGroupDescription.Builder getPackageGroup() {
            return packageGroup != null ? packageGroup.toBuilder() : null;
        }

        public final void setPackageGroup(PackageGroupDescription.BuilderImpl packageGroup) {
            this.packageGroup = packageGroup != null ? packageGroup.build() : null;
        }

        @Override
        public final Builder packageGroup(PackageGroupDescription packageGroup) {
            this.packageGroup = packageGroup;
            return this;
        }

        public final Map<String, ? extends Map<String, ? extends Collection<String>>> getAllowedRepositoryUpdates() {
            if (allowedRepositoryUpdates instanceof SdkAutoConstructMap) {
                return null;
            }
            return allowedRepositoryUpdates;
        }

        public final void setAllowedRepositoryUpdates(
                Map<String, ? extends Map<String, ? extends Collection<String>>> allowedRepositoryUpdates) {
            this.allowedRepositoryUpdates = PackageGroupAllowedRepositoryUpdatesCopier.copy(allowedRepositoryUpdates);
        }

        @Override
        public final Builder allowedRepositoryUpdatesWithStrings(
                Map<String, ? extends Map<String, ? extends Collection<String>>> allowedRepositoryUpdates) {
            this.allowedRepositoryUpdates = PackageGroupAllowedRepositoryUpdatesCopier.copy(allowedRepositoryUpdates);
            return this;
        }

        @Override
        public final Builder allowedRepositoryUpdates(
                Map<PackageGroupOriginRestrictionType, ? extends Map<PackageGroupAllowedRepositoryUpdateType, ? extends Collection<String>>> allowedRepositoryUpdates) {
            this.allowedRepositoryUpdates = PackageGroupAllowedRepositoryUpdatesCopier.copyEnumToString(allowedRepositoryUpdates);
            return this;
        }

        @Override
        public UpdatePackageGroupOriginConfigurationResponse build() {
            return new UpdatePackageGroupOriginConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
