/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePackageGroupRequest extends CodeartifactRequest implements
        ToCopyableBuilder<UpdatePackageGroupRequest.Builder, UpdatePackageGroupRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(UpdatePackageGroupRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()).build();

    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainOwner").getter(getter(UpdatePackageGroupRequest::domainOwner))
            .setter(setter(Builder::domainOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain-owner").build()).build();

    private static final SdkField<String> PACKAGE_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("packageGroup").getter(getter(UpdatePackageGroupRequest::packageGroup))
            .setter(setter(Builder::packageGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageGroup").build()).build();

    private static final SdkField<String> CONTACT_INFO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contactInfo").getter(getter(UpdatePackageGroupRequest::contactInfo))
            .setter(setter(Builder::contactInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactInfo").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdatePackageGroupRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            DOMAIN_OWNER_FIELD, PACKAGE_GROUP_FIELD, CONTACT_INFO_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domain;

    private final String domainOwner;

    private final String packageGroup;

    private final String contactInfo;

    private final String description;

    private UpdatePackageGroupRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainOwner = builder.domainOwner;
        this.packageGroup = builder.packageGroup;
        this.contactInfo = builder.contactInfo;
        this.description = builder.description;
    }

    /**
     * <p>
     * The name of the domain which contains the package group to be updated.
     * </p>
     * 
     * @return The name of the domain which contains the package group to be updated.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes
     * or spaces.
     * </p>
     * 
     * @return The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include
     *         dashes or spaces.
     */
    public final String domainOwner() {
        return domainOwner;
    }

    /**
     * <p>
     * The pattern of the package group to be updated.
     * </p>
     * 
     * @return The pattern of the package group to be updated.
     */
    public final String packageGroup() {
        return packageGroup;
    }

    /**
     * <p>
     * Contact information which you want to update the requested package group with.
     * </p>
     * 
     * @return Contact information which you want to update the requested package group with.
     */
    public final String contactInfo() {
        return contactInfo;
    }

    /**
     * <p>
     * The description you want to update the requested package group with.
     * </p>
     * 
     * @return The description you want to update the requested package group with.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(packageGroup());
        hashCode = 31 * hashCode + Objects.hashCode(contactInfo());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePackageGroupRequest)) {
            return false;
        }
        UpdatePackageGroupRequest other = (UpdatePackageGroupRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(domainOwner(), other.domainOwner())
                && Objects.equals(packageGroup(), other.packageGroup()) && Objects.equals(contactInfo(), other.contactInfo())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePackageGroupRequest").add("Domain", domain()).add("DomainOwner", domainOwner())
                .add("PackageGroup", packageGroup()).add("ContactInfo", contactInfo()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "domainOwner":
            return Optional.ofNullable(clazz.cast(domainOwner()));
        case "packageGroup":
            return Optional.ofNullable(clazz.cast(packageGroup()));
        case "contactInfo":
            return Optional.ofNullable(clazz.cast(contactInfo()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domain", DOMAIN_FIELD);
        map.put("domain-owner", DOMAIN_OWNER_FIELD);
        map.put("packageGroup", PACKAGE_GROUP_FIELD);
        map.put("contactInfo", CONTACT_INFO_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePackageGroupRequest, T> g) {
        return obj -> g.apply((UpdatePackageGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeartifactRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePackageGroupRequest> {
        /**
         * <p>
         * The name of the domain which contains the package group to be updated.
         * </p>
         * 
         * @param domain
         *        The name of the domain which contains the package group to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include
         * dashes or spaces.
         * </p>
         * 
         * @param domainOwner
         *        The 12-digit account number of the Amazon Web Services account that owns the domain. It does not
         *        include dashes or spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainOwner(String domainOwner);

        /**
         * <p>
         * The pattern of the package group to be updated.
         * </p>
         * 
         * @param packageGroup
         *        The pattern of the package group to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageGroup(String packageGroup);

        /**
         * <p>
         * Contact information which you want to update the requested package group with.
         * </p>
         * 
         * @param contactInfo
         *        Contact information which you want to update the requested package group with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactInfo(String contactInfo);

        /**
         * <p>
         * The description you want to update the requested package group with.
         * </p>
         * 
         * @param description
         *        The description you want to update the requested package group with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeartifactRequest.BuilderImpl implements Builder {
        private String domain;

        private String domainOwner;

        private String packageGroup;

        private String contactInfo;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePackageGroupRequest model) {
            super(model);
            domain(model.domain);
            domainOwner(model.domainOwner);
            packageGroup(model.packageGroup);
            contactInfo(model.contactInfo);
            description(model.description);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getDomainOwner() {
            return domainOwner;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final String getPackageGroup() {
            return packageGroup;
        }

        public final void setPackageGroup(String packageGroup) {
            this.packageGroup = packageGroup;
        }

        @Override
        public final Builder packageGroup(String packageGroup) {
            this.packageGroup = packageGroup;
            return this;
        }

        public final String getContactInfo() {
            return contactInfo;
        }

        public final void setContactInfo(String contactInfo) {
            this.contactInfo = contactInfo;
        }

        @Override
        public final Builder contactInfo(String contactInfo) {
            this.contactInfo = contactInfo;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePackageGroupRequest build() {
            return new UpdatePackageGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
