/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies restrictions for the batch build.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchRestrictions implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchRestrictions.Builder, BatchRestrictions> {
    private static final SdkField<Integer> MAXIMUM_BUILDS_ALLOWED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maximumBuildsAllowed").getter(getter(BatchRestrictions::maximumBuildsAllowed))
            .setter(setter(Builder::maximumBuildsAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumBuildsAllowed").build())
            .build();

    private static final SdkField<List<String>> COMPUTE_TYPES_ALLOWED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("computeTypesAllowed")
            .getter(getter(BatchRestrictions::computeTypesAllowed))
            .setter(setter(Builder::computeTypesAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeTypesAllowed").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_BUILDS_ALLOWED_FIELD,
            COMPUTE_TYPES_ALLOWED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maximumBuildsAllowed;

    private final List<String> computeTypesAllowed;

    private BatchRestrictions(BuilderImpl builder) {
        this.maximumBuildsAllowed = builder.maximumBuildsAllowed;
        this.computeTypesAllowed = builder.computeTypesAllowed;
    }

    /**
     * <p>
     * Specifies the maximum number of builds allowed.
     * </p>
     * 
     * @return Specifies the maximum number of builds allowed.
     */
    public final Integer maximumBuildsAllowed() {
        return maximumBuildsAllowed;
    }

    /**
     * Returns true if the ComputeTypesAllowed property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasComputeTypesAllowed() {
        return computeTypesAllowed != null && !(computeTypesAllowed instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings that specify the compute types that are allowed for the batch build. See <a
     * href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment
     * compute types</a> in the <i>CodeBuild User Guide</i> for these values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasComputeTypesAllowed()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of strings that specify the compute types that are allowed for the batch build. See <a
     *         href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build
     *         environment compute types</a> in the <i>CodeBuild User Guide</i> for these values.
     */
    public final List<String> computeTypesAllowed() {
        return computeTypesAllowed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumBuildsAllowed());
        hashCode = 31 * hashCode + Objects.hashCode(hasComputeTypesAllowed() ? computeTypesAllowed() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchRestrictions)) {
            return false;
        }
        BatchRestrictions other = (BatchRestrictions) obj;
        return Objects.equals(maximumBuildsAllowed(), other.maximumBuildsAllowed())
                && hasComputeTypesAllowed() == other.hasComputeTypesAllowed()
                && Objects.equals(computeTypesAllowed(), other.computeTypesAllowed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchRestrictions").add("MaximumBuildsAllowed", maximumBuildsAllowed())
                .add("ComputeTypesAllowed", hasComputeTypesAllowed() ? computeTypesAllowed() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maximumBuildsAllowed":
            return Optional.ofNullable(clazz.cast(maximumBuildsAllowed()));
        case "computeTypesAllowed":
            return Optional.ofNullable(clazz.cast(computeTypesAllowed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchRestrictions, T> g) {
        return obj -> g.apply((BatchRestrictions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchRestrictions> {
        /**
         * <p>
         * Specifies the maximum number of builds allowed.
         * </p>
         * 
         * @param maximumBuildsAllowed
         *        Specifies the maximum number of builds allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumBuildsAllowed(Integer maximumBuildsAllowed);

        /**
         * <p>
         * An array of strings that specify the compute types that are allowed for the batch build. See <a
         * href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build
         * environment compute types</a> in the <i>CodeBuild User Guide</i> for these values.
         * </p>
         * 
         * @param computeTypesAllowed
         *        An array of strings that specify the compute types that are allowed for the batch build. See <a
         *        href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build
         *        environment compute types</a> in the <i>CodeBuild User Guide</i> for these values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeTypesAllowed(Collection<String> computeTypesAllowed);

        /**
         * <p>
         * An array of strings that specify the compute types that are allowed for the batch build. See <a
         * href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build
         * environment compute types</a> in the <i>CodeBuild User Guide</i> for these values.
         * </p>
         * 
         * @param computeTypesAllowed
         *        An array of strings that specify the compute types that are allowed for the batch build. See <a
         *        href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build
         *        environment compute types</a> in the <i>CodeBuild User Guide</i> for these values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeTypesAllowed(String... computeTypesAllowed);
    }

    static final class BuilderImpl implements Builder {
        private Integer maximumBuildsAllowed;

        private List<String> computeTypesAllowed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchRestrictions model) {
            maximumBuildsAllowed(model.maximumBuildsAllowed);
            computeTypesAllowed(model.computeTypesAllowed);
        }

        public final Integer getMaximumBuildsAllowed() {
            return maximumBuildsAllowed;
        }

        @Override
        public final Builder maximumBuildsAllowed(Integer maximumBuildsAllowed) {
            this.maximumBuildsAllowed = maximumBuildsAllowed;
            return this;
        }

        public final void setMaximumBuildsAllowed(Integer maximumBuildsAllowed) {
            this.maximumBuildsAllowed = maximumBuildsAllowed;
        }

        public final Collection<String> getComputeTypesAllowed() {
            if (computeTypesAllowed instanceof SdkAutoConstructList) {
                return null;
            }
            return computeTypesAllowed;
        }

        @Override
        public final Builder computeTypesAllowed(Collection<String> computeTypesAllowed) {
            this.computeTypesAllowed = ComputeTypesAllowedCopier.copy(computeTypesAllowed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeTypesAllowed(String... computeTypesAllowed) {
            computeTypesAllowed(Arrays.asList(computeTypesAllowed));
            return this;
        }

        public final void setComputeTypesAllowed(Collection<String> computeTypesAllowed) {
            this.computeTypesAllowed = ComputeTypesAllowedCopier.copy(computeTypesAllowed);
        }

        @Override
        public BatchRestrictions build() {
            return new BatchRestrictions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
