/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCodeCoveragesResponse extends CodeBuildResponse implements
        ToCopyableBuilder<DescribeCodeCoveragesResponse.Builder, DescribeCodeCoveragesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeCodeCoveragesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<CodeCoverage>> CODE_COVERAGES_FIELD = SdkField
            .<List<CodeCoverage>> builder(MarshallingType.LIST)
            .memberName("codeCoverages")
            .getter(getter(DescribeCodeCoveragesResponse::codeCoverages))
            .setter(setter(Builder::codeCoverages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeCoverages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CodeCoverage> builder(MarshallingType.SDK_POJO)
                                            .constructor(CodeCoverage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            CODE_COVERAGES_FIELD));

    private final String nextToken;

    private final List<CodeCoverage> codeCoverages;

    private DescribeCodeCoveragesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.codeCoverages = builder.codeCoverages;
    }

    /**
     * <p>
     * If there are more items to return, this contains a token that is passed to a subsequent call to
     * <code>DescribeCodeCoverages</code> to retrieve the next set of items.
     * </p>
     * 
     * @return If there are more items to return, this contains a token that is passed to a subsequent call to
     *         <code>DescribeCodeCoverages</code> to retrieve the next set of items.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the CodeCoverages property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCodeCoverages() {
        return codeCoverages != null && !(codeCoverages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>CodeCoverage</code> objects that contain the results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCodeCoverages()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>CodeCoverage</code> objects that contain the results.
     */
    public final List<CodeCoverage> codeCoverages() {
        return codeCoverages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasCodeCoverages() ? codeCoverages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCodeCoveragesResponse)) {
            return false;
        }
        DescribeCodeCoveragesResponse other = (DescribeCodeCoveragesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasCodeCoverages() == other.hasCodeCoverages()
                && Objects.equals(codeCoverages(), other.codeCoverages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCodeCoveragesResponse").add("NextToken", nextToken())
                .add("CodeCoverages", hasCodeCoverages() ? codeCoverages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "codeCoverages":
            return Optional.ofNullable(clazz.cast(codeCoverages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCodeCoveragesResponse, T> g) {
        return obj -> g.apply((DescribeCodeCoveragesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCodeCoveragesResponse> {
        /**
         * <p>
         * If there are more items to return, this contains a token that is passed to a subsequent call to
         * <code>DescribeCodeCoverages</code> to retrieve the next set of items.
         * </p>
         * 
         * @param nextToken
         *        If there are more items to return, this contains a token that is passed to a subsequent call to
         *        <code>DescribeCodeCoverages</code> to retrieve the next set of items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of <code>CodeCoverage</code> objects that contain the results.
         * </p>
         * 
         * @param codeCoverages
         *        An array of <code>CodeCoverage</code> objects that contain the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeCoverages(Collection<CodeCoverage> codeCoverages);

        /**
         * <p>
         * An array of <code>CodeCoverage</code> objects that contain the results.
         * </p>
         * 
         * @param codeCoverages
         *        An array of <code>CodeCoverage</code> objects that contain the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeCoverages(CodeCoverage... codeCoverages);

        /**
         * <p>
         * An array of <code>CodeCoverage</code> objects that contain the results.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CodeCoverage>.Builder} avoiding the need to
         * create one manually via {@link List<CodeCoverage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CodeCoverage>.Builder#build()} is called immediately and its
         * result is passed to {@link #codeCoverages(List<CodeCoverage>)}.
         * 
         * @param codeCoverages
         *        a consumer that will call methods on {@link List<CodeCoverage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeCoverages(List<CodeCoverage>)
         */
        Builder codeCoverages(Consumer<CodeCoverage.Builder>... codeCoverages);
    }

    static final class BuilderImpl extends CodeBuildResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<CodeCoverage> codeCoverages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCodeCoveragesResponse model) {
            super(model);
            nextToken(model.nextToken);
            codeCoverages(model.codeCoverages);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final List<CodeCoverage.Builder> getCodeCoverages() {
            List<CodeCoverage.Builder> result = CodeCoveragesCopier.copyToBuilder(this.codeCoverages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder codeCoverages(Collection<CodeCoverage> codeCoverages) {
            this.codeCoverages = CodeCoveragesCopier.copy(codeCoverages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeCoverages(CodeCoverage... codeCoverages) {
            codeCoverages(Arrays.asList(codeCoverages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeCoverages(Consumer<CodeCoverage.Builder>... codeCoverages) {
            codeCoverages(Stream.of(codeCoverages).map(c -> CodeCoverage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCodeCoverages(Collection<CodeCoverage.BuilderImpl> codeCoverages) {
            this.codeCoverages = CodeCoveragesCopier.copyFromBuilder(codeCoverages);
        }

        @Override
        public DescribeCodeCoveragesResponse build() {
            return new DescribeCodeCoveragesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
