/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSharedReportGroupsRequest extends CodeBuildRequest implements
        ToCopyableBuilder<ListSharedReportGroupsRequest.Builder, ListSharedReportGroupsRequest> {
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(ListSharedReportGroupsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(ListSharedReportGroupsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSharedReportGroupsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListSharedReportGroupsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SORT_ORDER_FIELD,
            SORT_BY_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String sortOrder;

    private final String sortBy;

    private final String nextToken;

    private final Integer maxResults;

    private ListSharedReportGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.sortOrder = builder.sortOrder;
        this.sortBy = builder.sortBy;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The order in which to list shared report groups. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ASCENDING</code>: List in ascending order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DESCENDING</code>: List in descending order.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order in which to list shared report groups. Valid values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ASCENDING</code>: List in ascending order.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DESCENDING</code>: List in descending order.
     *         </p>
     *         </li>
     * @see SortOrderType
     */
    public final SortOrderType sortOrder() {
        return SortOrderType.fromValue(sortOrder);
    }

    /**
     * <p>
     * The order in which to list shared report groups. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ASCENDING</code>: List in ascending order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DESCENDING</code>: List in descending order.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order in which to list shared report groups. Valid values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ASCENDING</code>: List in ascending order.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DESCENDING</code>: List in descending order.
     *         </p>
     *         </li>
     * @see SortOrderType
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The criterion to be used to list report groups shared with the current Amazon Web Services account or user. Valid
     * values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ARN</code>: List based on the ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MODIFIED_TIME</code>: List based on when information about the shared report group was last changed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SharedResourceSortByType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The criterion to be used to list report groups shared with the current Amazon Web Services account or
     *         user. Valid values include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ARN</code>: List based on the ARN.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MODIFIED_TIME</code>: List based on when information about the shared report group was last
     *         changed.
     *         </p>
     *         </li>
     * @see SharedResourceSortByType
     */
    public final SharedResourceSortByType sortBy() {
        return SharedResourceSortByType.fromValue(sortBy);
    }

    /**
     * <p>
     * The criterion to be used to list report groups shared with the current Amazon Web Services account or user. Valid
     * values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ARN</code>: List based on the ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MODIFIED_TIME</code>: List based on when information about the shared report group was last changed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SharedResourceSortByType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The criterion to be used to list report groups shared with the current Amazon Web Services account or
     *         user. Valid values include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ARN</code>: List based on the ARN.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MODIFIED_TIME</code>: List based on when information about the shared report group was last
     *         changed.
     *         </p>
     *         </li>
     * @see SharedResourceSortByType
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * During a previous call, the maximum number of items that can be returned is the value specified in
     * <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is
     * returned. To get the next batch of items in the list, call this operation again, adding the next token to the
     * call. To get all of the items in the list, keep calling this operation with each subsequent next token that is
     * returned, until no more next tokens are returned.
     * </p>
     * 
     * @return During a previous call, the maximum number of items that can be returned is the value specified in
     *         <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
     *         is returned. To get the next batch of items in the list, call this operation again, adding the next token
     *         to the call. To get all of the items in the list, keep calling this operation with each subsequent next
     *         token that is returned, until no more next tokens are returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of paginated shared report groups per response. Use <code>nextToken</code> to iterate pages in
     * the list of returned <code>ReportGroup</code> objects. The default value is 100.
     * </p>
     * 
     * @return The maximum number of paginated shared report groups per response. Use <code>nextToken</code> to iterate
     *         pages in the list of returned <code>ReportGroup</code> objects. The default value is 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSharedReportGroupsRequest)) {
            return false;
        }
        ListSharedReportGroupsRequest other = (ListSharedReportGroupsRequest) obj;
        return Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(sortByAsString(), other.sortByAsString()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSharedReportGroupsRequest").add("SortOrder", sortOrderAsString())
                .add("SortBy", sortByAsString()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSharedReportGroupsRequest, T> g) {
        return obj -> g.apply((ListSharedReportGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSharedReportGroupsRequest> {
        /**
         * <p>
         * The order in which to list shared report groups. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ASCENDING</code>: List in ascending order.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DESCENDING</code>: List in descending order.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sortOrder
         *        The order in which to list shared report groups. Valid values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ASCENDING</code>: List in ascending order.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DESCENDING</code>: List in descending order.
         *        </p>
         *        </li>
         * @see SortOrderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrderType
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The order in which to list shared report groups. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ASCENDING</code>: List in ascending order.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DESCENDING</code>: List in descending order.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sortOrder
         *        The order in which to list shared report groups. Valid values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ASCENDING</code>: List in ascending order.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DESCENDING</code>: List in descending order.
         *        </p>
         *        </li>
         * @see SortOrderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrderType
         */
        Builder sortOrder(SortOrderType sortOrder);

        /**
         * <p>
         * The criterion to be used to list report groups shared with the current Amazon Web Services account or user.
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ARN</code>: List based on the ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MODIFIED_TIME</code>: List based on when information about the shared report group was last changed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sortBy
         *        The criterion to be used to list report groups shared with the current Amazon Web Services account or
         *        user. Valid values include: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ARN</code>: List based on the ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MODIFIED_TIME</code>: List based on when information about the shared report group was last
         *        changed.
         *        </p>
         *        </li>
         * @see SharedResourceSortByType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SharedResourceSortByType
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The criterion to be used to list report groups shared with the current Amazon Web Services account or user.
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ARN</code>: List based on the ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MODIFIED_TIME</code>: List based on when information about the shared report group was last changed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sortBy
         *        The criterion to be used to list report groups shared with the current Amazon Web Services account or
         *        user. Valid values include: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ARN</code>: List based on the ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MODIFIED_TIME</code>: List based on when information about the shared report group was last
         *        changed.
         *        </p>
         *        </li>
         * @see SharedResourceSortByType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SharedResourceSortByType
         */
        Builder sortBy(SharedResourceSortByType sortBy);

        /**
         * <p>
         * During a previous call, the maximum number of items that can be returned is the value specified in
         * <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is
         * returned. To get the next batch of items in the list, call this operation again, adding the next token to the
         * call. To get all of the items in the list, keep calling this operation with each subsequent next token that
         * is returned, until no more next tokens are returned.
         * </p>
         * 
         * @param nextToken
         *        During a previous call, the maximum number of items that can be returned is the value specified in
         *        <code>maxResults</code>. If there more items in the list, then a unique string called a
         *        <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again,
         *        adding the next token to the call. To get all of the items in the list, keep calling this operation
         *        with each subsequent next token that is returned, until no more next tokens are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of paginated shared report groups per response. Use <code>nextToken</code> to iterate
         * pages in the list of returned <code>ReportGroup</code> objects. The default value is 100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of paginated shared report groups per response. Use <code>nextToken</code> to
         *        iterate pages in the list of returned <code>ReportGroup</code> objects. The default value is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeBuildRequest.BuilderImpl implements Builder {
        private String sortOrder;

        private String sortBy;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSharedReportGroupsRequest model) {
            super(model);
            sortOrder(model.sortOrder);
            sortBy(model.sortBy);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrderType sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final String getSortBy() {
            return sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(SharedResourceSortByType sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSharedReportGroupsRequest build() {
            return new ListSharedReportGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
