/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a file system created by Amazon Elastic File System (EFS). For more information, see <a
 * href="https://docs.aws.amazon.com/efs/latest/ug/whatisefs.html">What Is Amazon Elastic File System?</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProjectFileSystemLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<ProjectFileSystemLocation.Builder, ProjectFileSystemLocation> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ProjectFileSystemLocation::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("location").getter(getter(ProjectFileSystemLocation::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> MOUNT_POINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mountPoint").getter(getter(ProjectFileSystemLocation::mountPoint)).setter(setter(Builder::mountPoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mountPoint").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(ProjectFileSystemLocation::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<String> MOUNT_OPTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mountOptions").getter(getter(ProjectFileSystemLocation::mountOptions))
            .setter(setter(Builder::mountOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mountOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, LOCATION_FIELD,
            MOUNT_POINT_FIELD, IDENTIFIER_FIELD, MOUNT_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String location;

    private final String mountPoint;

    private final String identifier;

    private final String mountOptions;

    private ProjectFileSystemLocation(BuilderImpl builder) {
        this.type = builder.type;
        this.location = builder.location;
        this.mountPoint = builder.mountPoint;
        this.identifier = builder.identifier;
        this.mountOptions = builder.mountOptions;
    }

    /**
     * <p>
     * The type of the file system. The one supported type is <code>EFS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FileSystemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the file system. The one supported type is <code>EFS</code>.
     * @see FileSystemType
     */
    public final FileSystemType type() {
        return FileSystemType.fromValue(type);
    }

    /**
     * <p>
     * The type of the file system. The one supported type is <code>EFS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FileSystemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the file system. The one supported type is <code>EFS</code>.
     * @see FileSystemType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A string that specifies the location of the file system created by Amazon EFS. Its format is
     * <code>efs-dns-name:/directory-path</code>. You can find the DNS name of file system when you view it in the
     * Amazon EFS console. The directory path is a path to a directory in the file system that CodeBuild mounts. For
     * example, if the DNS name of a file system is <code>fs-abcd1234.efs.us-west-2.amazonaws.com</code>, and its mount
     * directory is <code>my-efs-mount-directory</code>, then the <code>location</code> is
     * <code>fs-abcd1234.efs.us-west-2.amazonaws.com:/my-efs-mount-directory</code>.
     * </p>
     * <p>
     * The directory path in the format <code>efs-dns-name:/directory-path</code> is optional. If you do not specify a
     * directory path, the location is only the DNS name and CodeBuild mounts the entire file system.
     * </p>
     * 
     * @return A string that specifies the location of the file system created by Amazon EFS. Its format is
     *         <code>efs-dns-name:/directory-path</code>. You can find the DNS name of file system when you view it in
     *         the Amazon EFS console. The directory path is a path to a directory in the file system that CodeBuild
     *         mounts. For example, if the DNS name of a file system is
     *         <code>fs-abcd1234.efs.us-west-2.amazonaws.com</code>, and its mount directory is
     *         <code>my-efs-mount-directory</code>, then the <code>location</code> is
     *         <code>fs-abcd1234.efs.us-west-2.amazonaws.com:/my-efs-mount-directory</code>. </p>
     *         <p>
     *         The directory path in the format <code>efs-dns-name:/directory-path</code> is optional. If you do not
     *         specify a directory path, the location is only the DNS name and CodeBuild mounts the entire file system.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The location in the container where you mount the file system.
     * </p>
     * 
     * @return The location in the container where you mount the file system.
     */
    public final String mountPoint() {
        return mountPoint;
    }

    /**
     * <p>
     * The name used to access a file system created by Amazon EFS. CodeBuild creates an environment variable by
     * appending the <code>identifier</code> in all capital letters to <code>CODEBUILD_</code>. For example, if you
     * specify <code>my_efs</code> for <code>identifier</code>, a new environment variable is create named
     * <code>CODEBUILD_MY_EFS</code>.
     * </p>
     * <p>
     * The <code>identifier</code> is used to mount your file system.
     * </p>
     * 
     * @return The name used to access a file system created by Amazon EFS. CodeBuild creates an environment variable by
     *         appending the <code>identifier</code> in all capital letters to <code>CODEBUILD_</code>. For example, if
     *         you specify <code>my_efs</code> for <code>identifier</code>, a new environment variable is create named
     *         <code>CODEBUILD_MY_EFS</code>. </p>
     *         <p>
     *         The <code>identifier</code> is used to mount your file system.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The mount options for a file system created by Amazon EFS. The default mount options used by CodeBuild are
     * <code>nfsvers=4.1,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/mounting-fs-nfs-mount-settings.html">Recommended NFS Mount
     * Options</a>.
     * </p>
     * 
     * @return The mount options for a file system created by Amazon EFS. The default mount options used by CodeBuild
     *         are <code>nfsvers=4.1,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2</code>. For more information,
     *         see <a href="https://docs.aws.amazon.com/efs/latest/ug/mounting-fs-nfs-mount-settings.html">Recommended
     *         NFS Mount Options</a>.
     */
    public final String mountOptions() {
        return mountOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(mountPoint());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(mountOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectFileSystemLocation)) {
            return false;
        }
        ProjectFileSystemLocation other = (ProjectFileSystemLocation) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(location(), other.location())
                && Objects.equals(mountPoint(), other.mountPoint()) && Objects.equals(identifier(), other.identifier())
                && Objects.equals(mountOptions(), other.mountOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProjectFileSystemLocation").add("Type", typeAsString()).add("Location", location())
                .add("MountPoint", mountPoint()).add("Identifier", identifier()).add("MountOptions", mountOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "mountPoint":
            return Optional.ofNullable(clazz.cast(mountPoint()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "mountOptions":
            return Optional.ofNullable(clazz.cast(mountOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProjectFileSystemLocation, T> g) {
        return obj -> g.apply((ProjectFileSystemLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProjectFileSystemLocation> {
        /**
         * <p>
         * The type of the file system. The one supported type is <code>EFS</code>.
         * </p>
         * 
         * @param type
         *        The type of the file system. The one supported type is <code>EFS</code>.
         * @see FileSystemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileSystemType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the file system. The one supported type is <code>EFS</code>.
         * </p>
         * 
         * @param type
         *        The type of the file system. The one supported type is <code>EFS</code>.
         * @see FileSystemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileSystemType
         */
        Builder type(FileSystemType type);

        /**
         * <p>
         * A string that specifies the location of the file system created by Amazon EFS. Its format is
         * <code>efs-dns-name:/directory-path</code>. You can find the DNS name of file system when you view it in the
         * Amazon EFS console. The directory path is a path to a directory in the file system that CodeBuild mounts. For
         * example, if the DNS name of a file system is <code>fs-abcd1234.efs.us-west-2.amazonaws.com</code>, and its
         * mount directory is <code>my-efs-mount-directory</code>, then the <code>location</code> is
         * <code>fs-abcd1234.efs.us-west-2.amazonaws.com:/my-efs-mount-directory</code>.
         * </p>
         * <p>
         * The directory path in the format <code>efs-dns-name:/directory-path</code> is optional. If you do not specify
         * a directory path, the location is only the DNS name and CodeBuild mounts the entire file system.
         * </p>
         * 
         * @param location
         *        A string that specifies the location of the file system created by Amazon EFS. Its format is
         *        <code>efs-dns-name:/directory-path</code>. You can find the DNS name of file system when you view it
         *        in the Amazon EFS console. The directory path is a path to a directory in the file system that
         *        CodeBuild mounts. For example, if the DNS name of a file system is
         *        <code>fs-abcd1234.efs.us-west-2.amazonaws.com</code>, and its mount directory is
         *        <code>my-efs-mount-directory</code>, then the <code>location</code> is
         *        <code>fs-abcd1234.efs.us-west-2.amazonaws.com:/my-efs-mount-directory</code>. </p>
         *        <p>
         *        The directory path in the format <code>efs-dns-name:/directory-path</code> is optional. If you do not
         *        specify a directory path, the location is only the DNS name and CodeBuild mounts the entire file
         *        system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The location in the container where you mount the file system.
         * </p>
         * 
         * @param mountPoint
         *        The location in the container where you mount the file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountPoint(String mountPoint);

        /**
         * <p>
         * The name used to access a file system created by Amazon EFS. CodeBuild creates an environment variable by
         * appending the <code>identifier</code> in all capital letters to <code>CODEBUILD_</code>. For example, if you
         * specify <code>my_efs</code> for <code>identifier</code>, a new environment variable is create named
         * <code>CODEBUILD_MY_EFS</code>.
         * </p>
         * <p>
         * The <code>identifier</code> is used to mount your file system.
         * </p>
         * 
         * @param identifier
         *        The name used to access a file system created by Amazon EFS. CodeBuild creates an environment variable
         *        by appending the <code>identifier</code> in all capital letters to <code>CODEBUILD_</code>. For
         *        example, if you specify <code>my_efs</code> for <code>identifier</code>, a new environment variable is
         *        create named <code>CODEBUILD_MY_EFS</code>. </p>
         *        <p>
         *        The <code>identifier</code> is used to mount your file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The mount options for a file system created by Amazon EFS. The default mount options used by CodeBuild are
         * <code>nfsvers=4.1,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/efs/latest/ug/mounting-fs-nfs-mount-settings.html">Recommended NFS Mount
         * Options</a>.
         * </p>
         * 
         * @param mountOptions
         *        The mount options for a file system created by Amazon EFS. The default mount options used by CodeBuild
         *        are <code>nfsvers=4.1,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2</code>. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/efs/latest/ug/mounting-fs-nfs-mount-settings.html">Recommended NFS
         *        Mount Options</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountOptions(String mountOptions);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String location;

        private String mountPoint;

        private String identifier;

        private String mountOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectFileSystemLocation model) {
            type(model.type);
            location(model.location);
            mountPoint(model.mountPoint);
            identifier(model.identifier);
            mountOptions(model.mountOptions);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FileSystemType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getMountPoint() {
            return mountPoint;
        }

        @Override
        public final Builder mountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
            return this;
        }

        public final void setMountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
        }

        public final String getIdentifier() {
            return identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public final String getMountOptions() {
            return mountOptions;
        }

        @Override
        public final Builder mountOptions(String mountOptions) {
            this.mountOptions = mountOptions;
            return this;
        }

        public final void setMountOptions(String mountOptions) {
            this.mountOptions = mountOptions;
        }

        @Override
        public ProjectFileSystemLocation build() {
            return new ProjectFileSystemLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
