/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a stage for a build.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BuildPhase implements SdkPojo, Serializable, ToCopyableBuilder<BuildPhase.Builder, BuildPhase> {
    private static final SdkField<String> PHASE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("phaseType").getter(getter(BuildPhase::phaseTypeAsString)).setter(setter(Builder::phaseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phaseType").build()).build();

    private static final SdkField<String> PHASE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("phaseStatus").getter(getter(BuildPhase::phaseStatusAsString)).setter(setter(Builder::phaseStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phaseStatus").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(BuildPhase::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(BuildPhase::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<Long> DURATION_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("durationInSeconds").getter(getter(BuildPhase::durationInSeconds))
            .setter(setter(Builder::durationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationInSeconds").build()).build();

    private static final SdkField<List<PhaseContext>> CONTEXTS_FIELD = SdkField
            .<List<PhaseContext>> builder(MarshallingType.LIST)
            .memberName("contexts")
            .getter(getter(BuildPhase::contexts))
            .setter(setter(Builder::contexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhaseContext> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhaseContext::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHASE_TYPE_FIELD,
            PHASE_STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD, DURATION_IN_SECONDS_FIELD, CONTEXTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String phaseType;

    private final String phaseStatus;

    private final Instant startTime;

    private final Instant endTime;

    private final Long durationInSeconds;

    private final List<PhaseContext> contexts;

    private BuildPhase(BuilderImpl builder) {
        this.phaseType = builder.phaseType;
        this.phaseStatus = builder.phaseStatus;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.durationInSeconds = builder.durationInSeconds;
        this.contexts = builder.contexts;
    }

    /**
     * <p>
     * The name of the build phase. Valid values include:
     * </p>
     * <dl>
     * <dt>BUILD</dt>
     * <dd>
     * <p>
     * Core build activities typically occur in this build phase.
     * </p>
     * </dd>
     * <dt>COMPLETED</dt>
     * <dd>
     * <p>
     * The build has been completed.
     * </p>
     * </dd>
     * <dt>DOWNLOAD_SOURCE</dt>
     * <dd>
     * <p>
     * Source code is being downloaded in this build phase.
     * </p>
     * </dd>
     * <dt>FINALIZING</dt>
     * <dd>
     * <p>
     * The build process is completing in this build phase.
     * </p>
     * </dd>
     * <dt>INSTALL</dt>
     * <dd>
     * <p>
     * Installation activities typically occur in this build phase.
     * </p>
     * </dd>
     * <dt>POST_BUILD</dt>
     * <dd>
     * <p>
     * Post-build activities typically occur in this build phase.
     * </p>
     * </dd>
     * <dt>PRE_BUILD</dt>
     * <dd>
     * <p>
     * Pre-build activities typically occur in this build phase.
     * </p>
     * </dd>
     * <dt>PROVISIONING</dt>
     * <dd>
     * <p>
     * The build environment is being set up.
     * </p>
     * </dd>
     * <dt>QUEUED</dt>
     * <dd>
     * <p>
     * The build has been submitted and is queued behind other submitted builds.
     * </p>
     * </dd>
     * <dt>SUBMITTED</dt>
     * <dd>
     * <p>
     * The build has been submitted.
     * </p>
     * </dd>
     * <dt>UPLOAD_ARTIFACTS</dt>
     * <dd>
     * <p>
     * Build output artifacts are being uploaded to the output location.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #phaseType} will
     * return {@link BuildPhaseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #phaseTypeAsString}.
     * </p>
     * 
     * @return The name of the build phase. Valid values include:</p>
     *         <dl>
     *         <dt>BUILD</dt>
     *         <dd>
     *         <p>
     *         Core build activities typically occur in this build phase.
     *         </p>
     *         </dd>
     *         <dt>COMPLETED</dt>
     *         <dd>
     *         <p>
     *         The build has been completed.
     *         </p>
     *         </dd>
     *         <dt>DOWNLOAD_SOURCE</dt>
     *         <dd>
     *         <p>
     *         Source code is being downloaded in this build phase.
     *         </p>
     *         </dd>
     *         <dt>FINALIZING</dt>
     *         <dd>
     *         <p>
     *         The build process is completing in this build phase.
     *         </p>
     *         </dd>
     *         <dt>INSTALL</dt>
     *         <dd>
     *         <p>
     *         Installation activities typically occur in this build phase.
     *         </p>
     *         </dd>
     *         <dt>POST_BUILD</dt>
     *         <dd>
     *         <p>
     *         Post-build activities typically occur in this build phase.
     *         </p>
     *         </dd>
     *         <dt>PRE_BUILD</dt>
     *         <dd>
     *         <p>
     *         Pre-build activities typically occur in this build phase.
     *         </p>
     *         </dd>
     *         <dt>PROVISIONING</dt>
     *         <dd>
     *         <p>
     *         The build environment is being set up.
     *         </p>
     *         </dd>
     *         <dt>QUEUED</dt>
     *         <dd>
     *         <p>
     *         The build has been submitted and is queued behind other submitted builds.
     *         </p>
     *         </dd>
     *         <dt>SUBMITTED</dt>
     *         <dd>
     *         <p>
     *         The build has been submitted.
     *         </p>
     *         </dd>
     *         <dt>UPLOAD_ARTIFACTS</dt>
     *         <dd>
     *         <p>
     *         Build output artifacts are being uploaded to the output location.
     *         </p>
     *         </dd>
     * @see BuildPhaseType
     */
    public final BuildPhaseType phaseType() {
        return BuildPhaseType.fromValue(phaseType);
    }

    /**
     * <p>
     * The name of the build phase. Valid values include:
     * </p>
     * <dl>
     * <dt>BUILD</dt>
     * <dd>
     * <p>
     * Core build activities typically occur in this build phase.
     * </p>
     * </dd>
     * <dt>COMPLETED</dt>
     * <dd>
     * <p>
     * The build has been completed.
     * </p>
     * </dd>
     * <dt>DOWNLOAD_SOURCE</dt>
     * <dd>
     * <p>
     * Source code is being downloaded in this build phase.
     * </p>
     * </dd>
     * <dt>FINALIZING</dt>
     * <dd>
     * <p>
     * The build process is completing in this build phase.
     * </p>
     * </dd>
     * <dt>INSTALL</dt>
     * <dd>
     * <p>
     * Installation activities typically occur in this build phase.
     * </p>
     * </dd>
     * <dt>POST_BUILD</dt>
     * <dd>
     * <p>
     * Post-build activities typically occur in this build phase.
     * </p>
     * </dd>
     * <dt>PRE_BUILD</dt>
     * <dd>
     * <p>
     * Pre-build activities typically occur in this build phase.
     * </p>
     * </dd>
     * <dt>PROVISIONING</dt>
     * <dd>
     * <p>
     * The build environment is being set up.
     * </p>
     * </dd>
     * <dt>QUEUED</dt>
     * <dd>
     * <p>
     * The build has been submitted and is queued behind other submitted builds.
     * </p>
     * </dd>
     * <dt>SUBMITTED</dt>
     * <dd>
     * <p>
     * The build has been submitted.
     * </p>
     * </dd>
     * <dt>UPLOAD_ARTIFACTS</dt>
     * <dd>
     * <p>
     * Build output artifacts are being uploaded to the output location.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #phaseType} will
     * return {@link BuildPhaseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #phaseTypeAsString}.
     * </p>
     * 
     * @return The name of the build phase. Valid values include:</p>
     *         <dl>
     *         <dt>BUILD</dt>
     *         <dd>
     *         <p>
     *         Core build activities typically occur in this build phase.
     *         </p>
     *         </dd>
     *         <dt>COMPLETED</dt>
     *         <dd>
     *         <p>
     *         The build has been completed.
     *         </p>
     *         </dd>
     *         <dt>DOWNLOAD_SOURCE</dt>
     *         <dd>
     *         <p>
     *         Source code is being downloaded in this build phase.
     *         </p>
     *         </dd>
     *         <dt>FINALIZING</dt>
     *         <dd>
     *         <p>
     *         The build process is completing in this build phase.
     *         </p>
     *         </dd>
     *         <dt>INSTALL</dt>
     *         <dd>
     *         <p>
     *         Installation activities typically occur in this build phase.
     *         </p>
     *         </dd>
     *         <dt>POST_BUILD</dt>
     *         <dd>
     *         <p>
     *         Post-build activities typically occur in this build phase.
     *         </p>
     *         </dd>
     *         <dt>PRE_BUILD</dt>
     *         <dd>
     *         <p>
     *         Pre-build activities typically occur in this build phase.
     *         </p>
     *         </dd>
     *         <dt>PROVISIONING</dt>
     *         <dd>
     *         <p>
     *         The build environment is being set up.
     *         </p>
     *         </dd>
     *         <dt>QUEUED</dt>
     *         <dd>
     *         <p>
     *         The build has been submitted and is queued behind other submitted builds.
     *         </p>
     *         </dd>
     *         <dt>SUBMITTED</dt>
     *         <dd>
     *         <p>
     *         The build has been submitted.
     *         </p>
     *         </dd>
     *         <dt>UPLOAD_ARTIFACTS</dt>
     *         <dd>
     *         <p>
     *         Build output artifacts are being uploaded to the output location.
     *         </p>
     *         </dd>
     * @see BuildPhaseType
     */
    public final String phaseTypeAsString() {
        return phaseType;
    }

    /**
     * <p>
     * The current status of the build phase. Valid values include:
     * </p>
     * <dl>
     * <dt>FAILED</dt>
     * <dd>
     * <p>
     * The build phase failed.
     * </p>
     * </dd>
     * <dt>FAULT</dt>
     * <dd>
     * <p>
     * The build phase faulted.
     * </p>
     * </dd>
     * <dt>IN_PROGRESS</dt>
     * <dd>
     * <p>
     * The build phase is still in progress.
     * </p>
     * </dd>
     * <dt>STOPPED</dt>
     * <dd>
     * <p>
     * The build phase stopped.
     * </p>
     * </dd>
     * <dt>SUCCEEDED</dt>
     * <dd>
     * <p>
     * The build phase succeeded.
     * </p>
     * </dd>
     * <dt>TIMED_OUT</dt>
     * <dd>
     * <p>
     * The build phase timed out.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #phaseStatus} will
     * return {@link StatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #phaseStatusAsString}.
     * </p>
     * 
     * @return The current status of the build phase. Valid values include:</p>
     *         <dl>
     *         <dt>FAILED</dt>
     *         <dd>
     *         <p>
     *         The build phase failed.
     *         </p>
     *         </dd>
     *         <dt>FAULT</dt>
     *         <dd>
     *         <p>
     *         The build phase faulted.
     *         </p>
     *         </dd>
     *         <dt>IN_PROGRESS</dt>
     *         <dd>
     *         <p>
     *         The build phase is still in progress.
     *         </p>
     *         </dd>
     *         <dt>STOPPED</dt>
     *         <dd>
     *         <p>
     *         The build phase stopped.
     *         </p>
     *         </dd>
     *         <dt>SUCCEEDED</dt>
     *         <dd>
     *         <p>
     *         The build phase succeeded.
     *         </p>
     *         </dd>
     *         <dt>TIMED_OUT</dt>
     *         <dd>
     *         <p>
     *         The build phase timed out.
     *         </p>
     *         </dd>
     * @see StatusType
     */
    public final StatusType phaseStatus() {
        return StatusType.fromValue(phaseStatus);
    }

    /**
     * <p>
     * The current status of the build phase. Valid values include:
     * </p>
     * <dl>
     * <dt>FAILED</dt>
     * <dd>
     * <p>
     * The build phase failed.
     * </p>
     * </dd>
     * <dt>FAULT</dt>
     * <dd>
     * <p>
     * The build phase faulted.
     * </p>
     * </dd>
     * <dt>IN_PROGRESS</dt>
     * <dd>
     * <p>
     * The build phase is still in progress.
     * </p>
     * </dd>
     * <dt>STOPPED</dt>
     * <dd>
     * <p>
     * The build phase stopped.
     * </p>
     * </dd>
     * <dt>SUCCEEDED</dt>
     * <dd>
     * <p>
     * The build phase succeeded.
     * </p>
     * </dd>
     * <dt>TIMED_OUT</dt>
     * <dd>
     * <p>
     * The build phase timed out.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #phaseStatus} will
     * return {@link StatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #phaseStatusAsString}.
     * </p>
     * 
     * @return The current status of the build phase. Valid values include:</p>
     *         <dl>
     *         <dt>FAILED</dt>
     *         <dd>
     *         <p>
     *         The build phase failed.
     *         </p>
     *         </dd>
     *         <dt>FAULT</dt>
     *         <dd>
     *         <p>
     *         The build phase faulted.
     *         </p>
     *         </dd>
     *         <dt>IN_PROGRESS</dt>
     *         <dd>
     *         <p>
     *         The build phase is still in progress.
     *         </p>
     *         </dd>
     *         <dt>STOPPED</dt>
     *         <dd>
     *         <p>
     *         The build phase stopped.
     *         </p>
     *         </dd>
     *         <dt>SUCCEEDED</dt>
     *         <dd>
     *         <p>
     *         The build phase succeeded.
     *         </p>
     *         </dd>
     *         <dt>TIMED_OUT</dt>
     *         <dd>
     *         <p>
     *         The build phase timed out.
     *         </p>
     *         </dd>
     * @see StatusType
     */
    public final String phaseStatusAsString() {
        return phaseStatus;
    }

    /**
     * <p>
     * When the build phase started, expressed in Unix time format.
     * </p>
     * 
     * @return When the build phase started, expressed in Unix time format.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * When the build phase ended, expressed in Unix time format.
     * </p>
     * 
     * @return When the build phase ended, expressed in Unix time format.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * How long, in seconds, between the starting and ending times of the build's phase.
     * </p>
     * 
     * @return How long, in seconds, between the starting and ending times of the build's phase.
     */
    public final Long durationInSeconds() {
        return durationInSeconds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Contexts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContexts() {
        return contexts != null && !(contexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional information about a build phase, especially to help troubleshoot a failed build.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContexts} method.
     * </p>
     * 
     * @return Additional information about a build phase, especially to help troubleshoot a failed build.
     */
    public final List<PhaseContext> contexts() {
        return contexts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(phaseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(phaseStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(durationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasContexts() ? contexts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuildPhase)) {
            return false;
        }
        BuildPhase other = (BuildPhase) obj;
        return Objects.equals(phaseTypeAsString(), other.phaseTypeAsString())
                && Objects.equals(phaseStatusAsString(), other.phaseStatusAsString())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(durationInSeconds(), other.durationInSeconds()) && hasContexts() == other.hasContexts()
                && Objects.equals(contexts(), other.contexts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BuildPhase").add("PhaseType", phaseTypeAsString()).add("PhaseStatus", phaseStatusAsString())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("DurationInSeconds", durationInSeconds())
                .add("Contexts", hasContexts() ? contexts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "phaseType":
            return Optional.ofNullable(clazz.cast(phaseTypeAsString()));
        case "phaseStatus":
            return Optional.ofNullable(clazz.cast(phaseStatusAsString()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "durationInSeconds":
            return Optional.ofNullable(clazz.cast(durationInSeconds()));
        case "contexts":
            return Optional.ofNullable(clazz.cast(contexts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BuildPhase, T> g) {
        return obj -> g.apply((BuildPhase) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BuildPhase> {
        /**
         * <p>
         * The name of the build phase. Valid values include:
         * </p>
         * <dl>
         * <dt>BUILD</dt>
         * <dd>
         * <p>
         * Core build activities typically occur in this build phase.
         * </p>
         * </dd>
         * <dt>COMPLETED</dt>
         * <dd>
         * <p>
         * The build has been completed.
         * </p>
         * </dd>
         * <dt>DOWNLOAD_SOURCE</dt>
         * <dd>
         * <p>
         * Source code is being downloaded in this build phase.
         * </p>
         * </dd>
         * <dt>FINALIZING</dt>
         * <dd>
         * <p>
         * The build process is completing in this build phase.
         * </p>
         * </dd>
         * <dt>INSTALL</dt>
         * <dd>
         * <p>
         * Installation activities typically occur in this build phase.
         * </p>
         * </dd>
         * <dt>POST_BUILD</dt>
         * <dd>
         * <p>
         * Post-build activities typically occur in this build phase.
         * </p>
         * </dd>
         * <dt>PRE_BUILD</dt>
         * <dd>
         * <p>
         * Pre-build activities typically occur in this build phase.
         * </p>
         * </dd>
         * <dt>PROVISIONING</dt>
         * <dd>
         * <p>
         * The build environment is being set up.
         * </p>
         * </dd>
         * <dt>QUEUED</dt>
         * <dd>
         * <p>
         * The build has been submitted and is queued behind other submitted builds.
         * </p>
         * </dd>
         * <dt>SUBMITTED</dt>
         * <dd>
         * <p>
         * The build has been submitted.
         * </p>
         * </dd>
         * <dt>UPLOAD_ARTIFACTS</dt>
         * <dd>
         * <p>
         * Build output artifacts are being uploaded to the output location.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param phaseType
         *        The name of the build phase. Valid values include:</p>
         *        <dl>
         *        <dt>BUILD</dt>
         *        <dd>
         *        <p>
         *        Core build activities typically occur in this build phase.
         *        </p>
         *        </dd>
         *        <dt>COMPLETED</dt>
         *        <dd>
         *        <p>
         *        The build has been completed.
         *        </p>
         *        </dd>
         *        <dt>DOWNLOAD_SOURCE</dt>
         *        <dd>
         *        <p>
         *        Source code is being downloaded in this build phase.
         *        </p>
         *        </dd>
         *        <dt>FINALIZING</dt>
         *        <dd>
         *        <p>
         *        The build process is completing in this build phase.
         *        </p>
         *        </dd>
         *        <dt>INSTALL</dt>
         *        <dd>
         *        <p>
         *        Installation activities typically occur in this build phase.
         *        </p>
         *        </dd>
         *        <dt>POST_BUILD</dt>
         *        <dd>
         *        <p>
         *        Post-build activities typically occur in this build phase.
         *        </p>
         *        </dd>
         *        <dt>PRE_BUILD</dt>
         *        <dd>
         *        <p>
         *        Pre-build activities typically occur in this build phase.
         *        </p>
         *        </dd>
         *        <dt>PROVISIONING</dt>
         *        <dd>
         *        <p>
         *        The build environment is being set up.
         *        </p>
         *        </dd>
         *        <dt>QUEUED</dt>
         *        <dd>
         *        <p>
         *        The build has been submitted and is queued behind other submitted builds.
         *        </p>
         *        </dd>
         *        <dt>SUBMITTED</dt>
         *        <dd>
         *        <p>
         *        The build has been submitted.
         *        </p>
         *        </dd>
         *        <dt>UPLOAD_ARTIFACTS</dt>
         *        <dd>
         *        <p>
         *        Build output artifacts are being uploaded to the output location.
         *        </p>
         *        </dd>
         * @see BuildPhaseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BuildPhaseType
         */
        Builder phaseType(String phaseType);

        /**
         * <p>
         * The name of the build phase. Valid values include:
         * </p>
         * <dl>
         * <dt>BUILD</dt>
         * <dd>
         * <p>
         * Core build activities typically occur in this build phase.
         * </p>
         * </dd>
         * <dt>COMPLETED</dt>
         * <dd>
         * <p>
         * The build has been completed.
         * </p>
         * </dd>
         * <dt>DOWNLOAD_SOURCE</dt>
         * <dd>
         * <p>
         * Source code is being downloaded in this build phase.
         * </p>
         * </dd>
         * <dt>FINALIZING</dt>
         * <dd>
         * <p>
         * The build process is completing in this build phase.
         * </p>
         * </dd>
         * <dt>INSTALL</dt>
         * <dd>
         * <p>
         * Installation activities typically occur in this build phase.
         * </p>
         * </dd>
         * <dt>POST_BUILD</dt>
         * <dd>
         * <p>
         * Post-build activities typically occur in this build phase.
         * </p>
         * </dd>
         * <dt>PRE_BUILD</dt>
         * <dd>
         * <p>
         * Pre-build activities typically occur in this build phase.
         * </p>
         * </dd>
         * <dt>PROVISIONING</dt>
         * <dd>
         * <p>
         * The build environment is being set up.
         * </p>
         * </dd>
         * <dt>QUEUED</dt>
         * <dd>
         * <p>
         * The build has been submitted and is queued behind other submitted builds.
         * </p>
         * </dd>
         * <dt>SUBMITTED</dt>
         * <dd>
         * <p>
         * The build has been submitted.
         * </p>
         * </dd>
         * <dt>UPLOAD_ARTIFACTS</dt>
         * <dd>
         * <p>
         * Build output artifacts are being uploaded to the output location.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param phaseType
         *        The name of the build phase. Valid values include:</p>
         *        <dl>
         *        <dt>BUILD</dt>
         *        <dd>
         *        <p>
         *        Core build activities typically occur in this build phase.
         *        </p>
         *        </dd>
         *        <dt>COMPLETED</dt>
         *        <dd>
         *        <p>
         *        The build has been completed.
         *        </p>
         *        </dd>
         *        <dt>DOWNLOAD_SOURCE</dt>
         *        <dd>
         *        <p>
         *        Source code is being downloaded in this build phase.
         *        </p>
         *        </dd>
         *        <dt>FINALIZING</dt>
         *        <dd>
         *        <p>
         *        The build process is completing in this build phase.
         *        </p>
         *        </dd>
         *        <dt>INSTALL</dt>
         *        <dd>
         *        <p>
         *        Installation activities typically occur in this build phase.
         *        </p>
         *        </dd>
         *        <dt>POST_BUILD</dt>
         *        <dd>
         *        <p>
         *        Post-build activities typically occur in this build phase.
         *        </p>
         *        </dd>
         *        <dt>PRE_BUILD</dt>
         *        <dd>
         *        <p>
         *        Pre-build activities typically occur in this build phase.
         *        </p>
         *        </dd>
         *        <dt>PROVISIONING</dt>
         *        <dd>
         *        <p>
         *        The build environment is being set up.
         *        </p>
         *        </dd>
         *        <dt>QUEUED</dt>
         *        <dd>
         *        <p>
         *        The build has been submitted and is queued behind other submitted builds.
         *        </p>
         *        </dd>
         *        <dt>SUBMITTED</dt>
         *        <dd>
         *        <p>
         *        The build has been submitted.
         *        </p>
         *        </dd>
         *        <dt>UPLOAD_ARTIFACTS</dt>
         *        <dd>
         *        <p>
         *        Build output artifacts are being uploaded to the output location.
         *        </p>
         *        </dd>
         * @see BuildPhaseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BuildPhaseType
         */
        Builder phaseType(BuildPhaseType phaseType);

        /**
         * <p>
         * The current status of the build phase. Valid values include:
         * </p>
         * <dl>
         * <dt>FAILED</dt>
         * <dd>
         * <p>
         * The build phase failed.
         * </p>
         * </dd>
         * <dt>FAULT</dt>
         * <dd>
         * <p>
         * The build phase faulted.
         * </p>
         * </dd>
         * <dt>IN_PROGRESS</dt>
         * <dd>
         * <p>
         * The build phase is still in progress.
         * </p>
         * </dd>
         * <dt>STOPPED</dt>
         * <dd>
         * <p>
         * The build phase stopped.
         * </p>
         * </dd>
         * <dt>SUCCEEDED</dt>
         * <dd>
         * <p>
         * The build phase succeeded.
         * </p>
         * </dd>
         * <dt>TIMED_OUT</dt>
         * <dd>
         * <p>
         * The build phase timed out.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param phaseStatus
         *        The current status of the build phase. Valid values include:</p>
         *        <dl>
         *        <dt>FAILED</dt>
         *        <dd>
         *        <p>
         *        The build phase failed.
         *        </p>
         *        </dd>
         *        <dt>FAULT</dt>
         *        <dd>
         *        <p>
         *        The build phase faulted.
         *        </p>
         *        </dd>
         *        <dt>IN_PROGRESS</dt>
         *        <dd>
         *        <p>
         *        The build phase is still in progress.
         *        </p>
         *        </dd>
         *        <dt>STOPPED</dt>
         *        <dd>
         *        <p>
         *        The build phase stopped.
         *        </p>
         *        </dd>
         *        <dt>SUCCEEDED</dt>
         *        <dd>
         *        <p>
         *        The build phase succeeded.
         *        </p>
         *        </dd>
         *        <dt>TIMED_OUT</dt>
         *        <dd>
         *        <p>
         *        The build phase timed out.
         *        </p>
         *        </dd>
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder phaseStatus(String phaseStatus);

        /**
         * <p>
         * The current status of the build phase. Valid values include:
         * </p>
         * <dl>
         * <dt>FAILED</dt>
         * <dd>
         * <p>
         * The build phase failed.
         * </p>
         * </dd>
         * <dt>FAULT</dt>
         * <dd>
         * <p>
         * The build phase faulted.
         * </p>
         * </dd>
         * <dt>IN_PROGRESS</dt>
         * <dd>
         * <p>
         * The build phase is still in progress.
         * </p>
         * </dd>
         * <dt>STOPPED</dt>
         * <dd>
         * <p>
         * The build phase stopped.
         * </p>
         * </dd>
         * <dt>SUCCEEDED</dt>
         * <dd>
         * <p>
         * The build phase succeeded.
         * </p>
         * </dd>
         * <dt>TIMED_OUT</dt>
         * <dd>
         * <p>
         * The build phase timed out.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param phaseStatus
         *        The current status of the build phase. Valid values include:</p>
         *        <dl>
         *        <dt>FAILED</dt>
         *        <dd>
         *        <p>
         *        The build phase failed.
         *        </p>
         *        </dd>
         *        <dt>FAULT</dt>
         *        <dd>
         *        <p>
         *        The build phase faulted.
         *        </p>
         *        </dd>
         *        <dt>IN_PROGRESS</dt>
         *        <dd>
         *        <p>
         *        The build phase is still in progress.
         *        </p>
         *        </dd>
         *        <dt>STOPPED</dt>
         *        <dd>
         *        <p>
         *        The build phase stopped.
         *        </p>
         *        </dd>
         *        <dt>SUCCEEDED</dt>
         *        <dd>
         *        <p>
         *        The build phase succeeded.
         *        </p>
         *        </dd>
         *        <dt>TIMED_OUT</dt>
         *        <dd>
         *        <p>
         *        The build phase timed out.
         *        </p>
         *        </dd>
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder phaseStatus(StatusType phaseStatus);

        /**
         * <p>
         * When the build phase started, expressed in Unix time format.
         * </p>
         * 
         * @param startTime
         *        When the build phase started, expressed in Unix time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * When the build phase ended, expressed in Unix time format.
         * </p>
         * 
         * @param endTime
         *        When the build phase ended, expressed in Unix time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * How long, in seconds, between the starting and ending times of the build's phase.
         * </p>
         * 
         * @param durationInSeconds
         *        How long, in seconds, between the starting and ending times of the build's phase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInSeconds(Long durationInSeconds);

        /**
         * <p>
         * Additional information about a build phase, especially to help troubleshoot a failed build.
         * </p>
         * 
         * @param contexts
         *        Additional information about a build phase, especially to help troubleshoot a failed build.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contexts(Collection<PhaseContext> contexts);

        /**
         * <p>
         * Additional information about a build phase, especially to help troubleshoot a failed build.
         * </p>
         * 
         * @param contexts
         *        Additional information about a build phase, especially to help troubleshoot a failed build.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contexts(PhaseContext... contexts);

        /**
         * <p>
         * Additional information about a build phase, especially to help troubleshoot a failed build.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PhaseContext>.Builder} avoiding the need to
         * create one manually via {@link List<PhaseContext>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PhaseContext>.Builder#build()} is called immediately and its
         * result is passed to {@link #contexts(List<PhaseContext>)}.
         * 
         * @param contexts
         *        a consumer that will call methods on {@link List<PhaseContext>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contexts(List<PhaseContext>)
         */
        Builder contexts(Consumer<PhaseContext.Builder>... contexts);
    }

    static final class BuilderImpl implements Builder {
        private String phaseType;

        private String phaseStatus;

        private Instant startTime;

        private Instant endTime;

        private Long durationInSeconds;

        private List<PhaseContext> contexts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BuildPhase model) {
            phaseType(model.phaseType);
            phaseStatus(model.phaseStatus);
            startTime(model.startTime);
            endTime(model.endTime);
            durationInSeconds(model.durationInSeconds);
            contexts(model.contexts);
        }

        public final String getPhaseType() {
            return phaseType;
        }

        public final void setPhaseType(String phaseType) {
            this.phaseType = phaseType;
        }

        @Override
        @Transient
        public final Builder phaseType(String phaseType) {
            this.phaseType = phaseType;
            return this;
        }

        @Override
        @Transient
        public final Builder phaseType(BuildPhaseType phaseType) {
            this.phaseType(phaseType == null ? null : phaseType.toString());
            return this;
        }

        public final String getPhaseStatus() {
            return phaseStatus;
        }

        public final void setPhaseStatus(String phaseStatus) {
            this.phaseStatus = phaseStatus;
        }

        @Override
        @Transient
        public final Builder phaseStatus(String phaseStatus) {
            this.phaseStatus = phaseStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder phaseStatus(StatusType phaseStatus) {
            this.phaseStatus(phaseStatus == null ? null : phaseStatus.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Long getDurationInSeconds() {
            return durationInSeconds;
        }

        public final void setDurationInSeconds(Long durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        @Transient
        public final Builder durationInSeconds(Long durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final List<PhaseContext.Builder> getContexts() {
            List<PhaseContext.Builder> result = PhaseContextsCopier.copyToBuilder(this.contexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContexts(Collection<PhaseContext.BuilderImpl> contexts) {
            this.contexts = PhaseContextsCopier.copyFromBuilder(contexts);
        }

        @Override
        @Transient
        public final Builder contexts(Collection<PhaseContext> contexts) {
            this.contexts = PhaseContextsCopier.copy(contexts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder contexts(PhaseContext... contexts) {
            contexts(Arrays.asList(contexts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder contexts(Consumer<PhaseContext.Builder>... contexts) {
            contexts(Stream.of(contexts).map(c -> PhaseContext.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuildPhase build() {
            return new BuildPhase(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
