/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the debug session for a build. For more information, see <a
 * href="https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html">Viewing a running build in Session
 * Manager</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DebugSession implements SdkPojo, Serializable, ToCopyableBuilder<DebugSession.Builder, DebugSession> {
    private static final SdkField<Boolean> SESSION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("sessionEnabled").getter(getter(DebugSession::sessionEnabled)).setter(setter(Builder::sessionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionEnabled").build()).build();

    private static final SdkField<String> SESSION_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionTarget").getter(getter(DebugSession::sessionTarget)).setter(setter(Builder::sessionTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionTarget").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ENABLED_FIELD,
            SESSION_TARGET_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean sessionEnabled;

    private final String sessionTarget;

    private DebugSession(BuilderImpl builder) {
        this.sessionEnabled = builder.sessionEnabled;
        this.sessionTarget = builder.sessionTarget;
    }

    /**
     * <p>
     * Specifies if session debugging is enabled for this build.
     * </p>
     * 
     * @return Specifies if session debugging is enabled for this build.
     */
    public final Boolean sessionEnabled() {
        return sessionEnabled;
    }

    /**
     * <p>
     * Contains the identifier of the Session Manager session used for the build. To work with the paused build, you
     * open this session to examine, control, and resume the build.
     * </p>
     * 
     * @return Contains the identifier of the Session Manager session used for the build. To work with the paused build,
     *         you open this session to examine, control, and resume the build.
     */
    public final String sessionTarget() {
        return sessionTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sessionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(sessionTarget());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DebugSession)) {
            return false;
        }
        DebugSession other = (DebugSession) obj;
        return Objects.equals(sessionEnabled(), other.sessionEnabled()) && Objects.equals(sessionTarget(), other.sessionTarget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DebugSession").add("SessionEnabled", sessionEnabled()).add("SessionTarget", sessionTarget())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessionEnabled":
            return Optional.ofNullable(clazz.cast(sessionEnabled()));
        case "sessionTarget":
            return Optional.ofNullable(clazz.cast(sessionTarget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DebugSession, T> g) {
        return obj -> g.apply((DebugSession) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DebugSession> {
        /**
         * <p>
         * Specifies if session debugging is enabled for this build.
         * </p>
         * 
         * @param sessionEnabled
         *        Specifies if session debugging is enabled for this build.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionEnabled(Boolean sessionEnabled);

        /**
         * <p>
         * Contains the identifier of the Session Manager session used for the build. To work with the paused build, you
         * open this session to examine, control, and resume the build.
         * </p>
         * 
         * @param sessionTarget
         *        Contains the identifier of the Session Manager session used for the build. To work with the paused
         *        build, you open this session to examine, control, and resume the build.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionTarget(String sessionTarget);
    }

    static final class BuilderImpl implements Builder {
        private Boolean sessionEnabled;

        private String sessionTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(DebugSession model) {
            sessionEnabled(model.sessionEnabled);
            sessionTarget(model.sessionTarget);
        }

        public final Boolean getSessionEnabled() {
            return sessionEnabled;
        }

        public final void setSessionEnabled(Boolean sessionEnabled) {
            this.sessionEnabled = sessionEnabled;
        }

        @Override
        @Transient
        public final Builder sessionEnabled(Boolean sessionEnabled) {
            this.sessionEnabled = sessionEnabled;
            return this;
        }

        public final String getSessionTarget() {
            return sessionTarget;
        }

        public final void setSessionTarget(String sessionTarget) {
            this.sessionTarget = sessionTarget;
        }

        @Override
        @Transient
        public final Builder sessionTarget(String sessionTarget) {
            this.sessionTarget = sessionTarget;
            return this;
        }

        @Override
        public DebugSession build() {
            return new DebugSession(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
