/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configuration information about a batch build project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProjectBuildBatchConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ProjectBuildBatchConfig.Builder, ProjectBuildBatchConfig> {
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceRole").getter(getter(ProjectBuildBatchConfig::serviceRole)).setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()).build();

    private static final SdkField<Boolean> COMBINE_ARTIFACTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("combineArtifacts").getter(getter(ProjectBuildBatchConfig::combineArtifacts))
            .setter(setter(Builder::combineArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("combineArtifacts").build()).build();

    private static final SdkField<BatchRestrictions> RESTRICTIONS_FIELD = SdkField
            .<BatchRestrictions> builder(MarshallingType.SDK_POJO).memberName("restrictions")
            .getter(getter(ProjectBuildBatchConfig::restrictions)).setter(setter(Builder::restrictions))
            .constructor(BatchRestrictions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restrictions").build()).build();

    private static final SdkField<Integer> TIMEOUT_IN_MINS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeoutInMins").getter(getter(ProjectBuildBatchConfig::timeoutInMins))
            .setter(setter(Builder::timeoutInMins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInMins").build()).build();

    private static final SdkField<String> BATCH_REPORT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("batchReportMode").getter(getter(ProjectBuildBatchConfig::batchReportModeAsString))
            .setter(setter(Builder::batchReportMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchReportMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ROLE_FIELD,
            COMBINE_ARTIFACTS_FIELD, RESTRICTIONS_FIELD, TIMEOUT_IN_MINS_FIELD, BATCH_REPORT_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serviceRole;

    private final Boolean combineArtifacts;

    private final BatchRestrictions restrictions;

    private final Integer timeoutInMins;

    private final String batchReportMode;

    private ProjectBuildBatchConfig(BuilderImpl builder) {
        this.serviceRole = builder.serviceRole;
        this.combineArtifacts = builder.combineArtifacts;
        this.restrictions = builder.restrictions;
        this.timeoutInMins = builder.timeoutInMins;
        this.batchReportMode = builder.batchReportMode;
    }

    /**
     * <p>
     * Specifies the service role ARN for the batch build project.
     * </p>
     * 
     * @return Specifies the service role ARN for the batch build project.
     */
    public final String serviceRole() {
        return serviceRole;
    }

    /**
     * <p>
     * Specifies if the build artifacts for the batch build should be combined into a single artifact location.
     * </p>
     * 
     * @return Specifies if the build artifacts for the batch build should be combined into a single artifact location.
     */
    public final Boolean combineArtifacts() {
        return combineArtifacts;
    }

    /**
     * <p>
     * A <code>BatchRestrictions</code> object that specifies the restrictions for the batch build.
     * </p>
     * 
     * @return A <code>BatchRestrictions</code> object that specifies the restrictions for the batch build.
     */
    public final BatchRestrictions restrictions() {
        return restrictions;
    }

    /**
     * <p>
     * Specifies the maximum amount of time, in minutes, that the batch build must be completed in.
     * </p>
     * 
     * @return Specifies the maximum amount of time, in minutes, that the batch build must be completed in.
     */
    public final Integer timeoutInMins() {
        return timeoutInMins;
    }

    /**
     * <p>
     * Specifies how build status reports are sent to the source provider for the batch build. This property is only
     * used when the source provider for your project is Bitbucket, GitHub, or GitHub Enterprise, and your project is
     * configured to report build statuses to the source provider.
     * </p>
     * <dl>
     * <dt>REPORT_AGGREGATED_BATCH</dt>
     * <dd>
     * <p>
     * (Default) Aggregate all of the build statuses into a single status report.
     * </p>
     * </dd>
     * <dt>REPORT_INDIVIDUAL_BUILDS</dt>
     * <dd>
     * <p>
     * Send a separate status report for each individual build.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #batchReportMode}
     * will return {@link BatchReportModeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #batchReportModeAsString}.
     * </p>
     * 
     * @return Specifies how build status reports are sent to the source provider for the batch build. This property is
     *         only used when the source provider for your project is Bitbucket, GitHub, or GitHub Enterprise, and your
     *         project is configured to report build statuses to the source provider.</p>
     *         <dl>
     *         <dt>REPORT_AGGREGATED_BATCH</dt>
     *         <dd>
     *         <p>
     *         (Default) Aggregate all of the build statuses into a single status report.
     *         </p>
     *         </dd>
     *         <dt>REPORT_INDIVIDUAL_BUILDS</dt>
     *         <dd>
     *         <p>
     *         Send a separate status report for each individual build.
     *         </p>
     *         </dd>
     * @see BatchReportModeType
     */
    public final BatchReportModeType batchReportMode() {
        return BatchReportModeType.fromValue(batchReportMode);
    }

    /**
     * <p>
     * Specifies how build status reports are sent to the source provider for the batch build. This property is only
     * used when the source provider for your project is Bitbucket, GitHub, or GitHub Enterprise, and your project is
     * configured to report build statuses to the source provider.
     * </p>
     * <dl>
     * <dt>REPORT_AGGREGATED_BATCH</dt>
     * <dd>
     * <p>
     * (Default) Aggregate all of the build statuses into a single status report.
     * </p>
     * </dd>
     * <dt>REPORT_INDIVIDUAL_BUILDS</dt>
     * <dd>
     * <p>
     * Send a separate status report for each individual build.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #batchReportMode}
     * will return {@link BatchReportModeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #batchReportModeAsString}.
     * </p>
     * 
     * @return Specifies how build status reports are sent to the source provider for the batch build. This property is
     *         only used when the source provider for your project is Bitbucket, GitHub, or GitHub Enterprise, and your
     *         project is configured to report build statuses to the source provider.</p>
     *         <dl>
     *         <dt>REPORT_AGGREGATED_BATCH</dt>
     *         <dd>
     *         <p>
     *         (Default) Aggregate all of the build statuses into a single status report.
     *         </p>
     *         </dd>
     *         <dt>REPORT_INDIVIDUAL_BUILDS</dt>
     *         <dd>
     *         <p>
     *         Send a separate status report for each individual build.
     *         </p>
     *         </dd>
     * @see BatchReportModeType
     */
    public final String batchReportModeAsString() {
        return batchReportMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(combineArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(restrictions());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInMins());
        hashCode = 31 * hashCode + Objects.hashCode(batchReportModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectBuildBatchConfig)) {
            return false;
        }
        ProjectBuildBatchConfig other = (ProjectBuildBatchConfig) obj;
        return Objects.equals(serviceRole(), other.serviceRole()) && Objects.equals(combineArtifacts(), other.combineArtifacts())
                && Objects.equals(restrictions(), other.restrictions()) && Objects.equals(timeoutInMins(), other.timeoutInMins())
                && Objects.equals(batchReportModeAsString(), other.batchReportModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProjectBuildBatchConfig").add("ServiceRole", serviceRole())
                .add("CombineArtifacts", combineArtifacts()).add("Restrictions", restrictions())
                .add("TimeoutInMins", timeoutInMins()).add("BatchReportMode", batchReportModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        case "combineArtifacts":
            return Optional.ofNullable(clazz.cast(combineArtifacts()));
        case "restrictions":
            return Optional.ofNullable(clazz.cast(restrictions()));
        case "timeoutInMins":
            return Optional.ofNullable(clazz.cast(timeoutInMins()));
        case "batchReportMode":
            return Optional.ofNullable(clazz.cast(batchReportModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProjectBuildBatchConfig, T> g) {
        return obj -> g.apply((ProjectBuildBatchConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProjectBuildBatchConfig> {
        /**
         * <p>
         * Specifies the service role ARN for the batch build project.
         * </p>
         * 
         * @param serviceRole
         *        Specifies the service role ARN for the batch build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * Specifies if the build artifacts for the batch build should be combined into a single artifact location.
         * </p>
         * 
         * @param combineArtifacts
         *        Specifies if the build artifacts for the batch build should be combined into a single artifact
         *        location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder combineArtifacts(Boolean combineArtifacts);

        /**
         * <p>
         * A <code>BatchRestrictions</code> object that specifies the restrictions for the batch build.
         * </p>
         * 
         * @param restrictions
         *        A <code>BatchRestrictions</code> object that specifies the restrictions for the batch build.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restrictions(BatchRestrictions restrictions);

        /**
         * <p>
         * A <code>BatchRestrictions</code> object that specifies the restrictions for the batch build.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchRestrictions.Builder} avoiding the need to
         * create one manually via {@link BatchRestrictions#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchRestrictions.Builder#build()} is called immediately and its
         * result is passed to {@link #restrictions(BatchRestrictions)}.
         * 
         * @param restrictions
         *        a consumer that will call methods on {@link BatchRestrictions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restrictions(BatchRestrictions)
         */
        default Builder restrictions(Consumer<BatchRestrictions.Builder> restrictions) {
            return restrictions(BatchRestrictions.builder().applyMutation(restrictions).build());
        }

        /**
         * <p>
         * Specifies the maximum amount of time, in minutes, that the batch build must be completed in.
         * </p>
         * 
         * @param timeoutInMins
         *        Specifies the maximum amount of time, in minutes, that the batch build must be completed in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInMins(Integer timeoutInMins);

        /**
         * <p>
         * Specifies how build status reports are sent to the source provider for the batch build. This property is only
         * used when the source provider for your project is Bitbucket, GitHub, or GitHub Enterprise, and your project
         * is configured to report build statuses to the source provider.
         * </p>
         * <dl>
         * <dt>REPORT_AGGREGATED_BATCH</dt>
         * <dd>
         * <p>
         * (Default) Aggregate all of the build statuses into a single status report.
         * </p>
         * </dd>
         * <dt>REPORT_INDIVIDUAL_BUILDS</dt>
         * <dd>
         * <p>
         * Send a separate status report for each individual build.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param batchReportMode
         *        Specifies how build status reports are sent to the source provider for the batch build. This property
         *        is only used when the source provider for your project is Bitbucket, GitHub, or GitHub Enterprise, and
         *        your project is configured to report build statuses to the source provider.</p>
         *        <dl>
         *        <dt>REPORT_AGGREGATED_BATCH</dt>
         *        <dd>
         *        <p>
         *        (Default) Aggregate all of the build statuses into a single status report.
         *        </p>
         *        </dd>
         *        <dt>REPORT_INDIVIDUAL_BUILDS</dt>
         *        <dd>
         *        <p>
         *        Send a separate status report for each individual build.
         *        </p>
         *        </dd>
         * @see BatchReportModeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchReportModeType
         */
        Builder batchReportMode(String batchReportMode);

        /**
         * <p>
         * Specifies how build status reports are sent to the source provider for the batch build. This property is only
         * used when the source provider for your project is Bitbucket, GitHub, or GitHub Enterprise, and your project
         * is configured to report build statuses to the source provider.
         * </p>
         * <dl>
         * <dt>REPORT_AGGREGATED_BATCH</dt>
         * <dd>
         * <p>
         * (Default) Aggregate all of the build statuses into a single status report.
         * </p>
         * </dd>
         * <dt>REPORT_INDIVIDUAL_BUILDS</dt>
         * <dd>
         * <p>
         * Send a separate status report for each individual build.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param batchReportMode
         *        Specifies how build status reports are sent to the source provider for the batch build. This property
         *        is only used when the source provider for your project is Bitbucket, GitHub, or GitHub Enterprise, and
         *        your project is configured to report build statuses to the source provider.</p>
         *        <dl>
         *        <dt>REPORT_AGGREGATED_BATCH</dt>
         *        <dd>
         *        <p>
         *        (Default) Aggregate all of the build statuses into a single status report.
         *        </p>
         *        </dd>
         *        <dt>REPORT_INDIVIDUAL_BUILDS</dt>
         *        <dd>
         *        <p>
         *        Send a separate status report for each individual build.
         *        </p>
         *        </dd>
         * @see BatchReportModeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchReportModeType
         */
        Builder batchReportMode(BatchReportModeType batchReportMode);
    }

    static final class BuilderImpl implements Builder {
        private String serviceRole;

        private Boolean combineArtifacts;

        private BatchRestrictions restrictions;

        private Integer timeoutInMins;

        private String batchReportMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectBuildBatchConfig model) {
            serviceRole(model.serviceRole);
            combineArtifacts(model.combineArtifacts);
            restrictions(model.restrictions);
            timeoutInMins(model.timeoutInMins);
            batchReportMode(model.batchReportMode);
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        @Transient
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final Boolean getCombineArtifacts() {
            return combineArtifacts;
        }

        public final void setCombineArtifacts(Boolean combineArtifacts) {
            this.combineArtifacts = combineArtifacts;
        }

        @Override
        @Transient
        public final Builder combineArtifacts(Boolean combineArtifacts) {
            this.combineArtifacts = combineArtifacts;
            return this;
        }

        public final BatchRestrictions.Builder getRestrictions() {
            return restrictions != null ? restrictions.toBuilder() : null;
        }

        public final void setRestrictions(BatchRestrictions.BuilderImpl restrictions) {
            this.restrictions = restrictions != null ? restrictions.build() : null;
        }

        @Override
        @Transient
        public final Builder restrictions(BatchRestrictions restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        public final Integer getTimeoutInMins() {
            return timeoutInMins;
        }

        public final void setTimeoutInMins(Integer timeoutInMins) {
            this.timeoutInMins = timeoutInMins;
        }

        @Override
        @Transient
        public final Builder timeoutInMins(Integer timeoutInMins) {
            this.timeoutInMins = timeoutInMins;
            return this;
        }

        public final String getBatchReportMode() {
            return batchReportMode;
        }

        public final void setBatchReportMode(String batchReportMode) {
            this.batchReportMode = batchReportMode;
        }

        @Override
        @Transient
        public final Builder batchReportMode(String batchReportMode) {
            this.batchReportMode = batchReportMode;
            return this;
        }

        @Override
        @Transient
        public final Builder batchReportMode(BatchReportModeType batchReportMode) {
            this.batchReportMode(batchReportMode == null ? null : batchReportMode.toString());
            return this;
        }

        @Override
        public ProjectBuildBatchConfig build() {
            return new ProjectBuildBatchConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
