/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetryBuildBatchRequest extends CodeBuildRequest implements
        ToCopyableBuilder<RetryBuildBatchRequest.Builder, RetryBuildBatchRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(RetryBuildBatchRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("idempotencyToken").getter(getter(RetryBuildBatchRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idempotencyToken").build()).build();

    private static final SdkField<String> RETRY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("retryType").getter(getter(RetryBuildBatchRequest::retryTypeAsString)).setter(setter(Builder::retryType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            IDEMPOTENCY_TOKEN_FIELD, RETRY_TYPE_FIELD));

    private final String id;

    private final String idempotencyToken;

    private final String retryType;

    private RetryBuildBatchRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.idempotencyToken = builder.idempotencyToken;
        this.retryType = builder.retryType;
    }

    /**
     * <p>
     * Specifies the identifier of the batch build to restart.
     * </p>
     * 
     * @return Specifies the identifier of the batch build to restart.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A unique, case sensitive identifier you provide to ensure the idempotency of the <code>RetryBuildBatch</code>
     * request. The token is included in the <code>RetryBuildBatch</code> request and is valid for five minutes. If you
     * repeat the <code>RetryBuildBatch</code> request with the same token, but change a parameter, CodeBuild returns a
     * parameter mismatch error.
     * </p>
     * 
     * @return A unique, case sensitive identifier you provide to ensure the idempotency of the
     *         <code>RetryBuildBatch</code> request. The token is included in the <code>RetryBuildBatch</code> request
     *         and is valid for five minutes. If you repeat the <code>RetryBuildBatch</code> request with the same
     *         token, but change a parameter, CodeBuild returns a parameter mismatch error.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    /**
     * <p>
     * Specifies the type of retry to perform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #retryType} will
     * return {@link RetryBuildBatchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #retryTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of retry to perform.
     * @see RetryBuildBatchType
     */
    public final RetryBuildBatchType retryType() {
        return RetryBuildBatchType.fromValue(retryType);
    }

    /**
     * <p>
     * Specifies the type of retry to perform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #retryType} will
     * return {@link RetryBuildBatchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #retryTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of retry to perform.
     * @see RetryBuildBatchType
     */
    public final String retryTypeAsString() {
        return retryType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(retryTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryBuildBatchRequest)) {
            return false;
        }
        RetryBuildBatchRequest other = (RetryBuildBatchRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(idempotencyToken(), other.idempotencyToken())
                && Objects.equals(retryTypeAsString(), other.retryTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetryBuildBatchRequest").add("Id", id()).add("IdempotencyToken", idempotencyToken())
                .add("RetryType", retryTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "idempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        case "retryType":
            return Optional.ofNullable(clazz.cast(retryTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetryBuildBatchRequest, T> g) {
        return obj -> g.apply((RetryBuildBatchRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildRequest.Builder, SdkPojo, CopyableBuilder<Builder, RetryBuildBatchRequest> {
        /**
         * <p>
         * Specifies the identifier of the batch build to restart.
         * </p>
         * 
         * @param id
         *        Specifies the identifier of the batch build to restart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A unique, case sensitive identifier you provide to ensure the idempotency of the <code>RetryBuildBatch</code>
         * request. The token is included in the <code>RetryBuildBatch</code> request and is valid for five minutes. If
         * you repeat the <code>RetryBuildBatch</code> request with the same token, but change a parameter, CodeBuild
         * returns a parameter mismatch error.
         * </p>
         * 
         * @param idempotencyToken
         *        A unique, case sensitive identifier you provide to ensure the idempotency of the
         *        <code>RetryBuildBatch</code> request. The token is included in the <code>RetryBuildBatch</code>
         *        request and is valid for five minutes. If you repeat the <code>RetryBuildBatch</code> request with the
         *        same token, but change a parameter, CodeBuild returns a parameter mismatch error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        /**
         * <p>
         * Specifies the type of retry to perform.
         * </p>
         * 
         * @param retryType
         *        Specifies the type of retry to perform.
         * @see RetryBuildBatchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetryBuildBatchType
         */
        Builder retryType(String retryType);

        /**
         * <p>
         * Specifies the type of retry to perform.
         * </p>
         * 
         * @param retryType
         *        Specifies the type of retry to perform.
         * @see RetryBuildBatchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetryBuildBatchType
         */
        Builder retryType(RetryBuildBatchType retryType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeBuildRequest.BuilderImpl implements Builder {
        private String id;

        private String idempotencyToken;

        private String retryType;

        private BuilderImpl() {
        }

        private BuilderImpl(RetryBuildBatchRequest model) {
            super(model);
            id(model.id);
            idempotencyToken(model.idempotencyToken);
            retryType(model.retryType);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        @Transient
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final String getRetryType() {
            return retryType;
        }

        public final void setRetryType(String retryType) {
            this.retryType = retryType;
        }

        @Override
        @Transient
        public final Builder retryType(String retryType) {
            this.retryType = retryType;
            return this;
        }

        @Override
        @Transient
        public final Builder retryType(RetryBuildBatchType retryType) {
            this.retryType(retryType == null ? null : retryType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RetryBuildBatchRequest build() {
            return new RetryBuildBatchRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
