/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProjectVisibilityResponse extends CodeBuildResponse implements
        ToCopyableBuilder<UpdateProjectVisibilityResponse.Builder, UpdateProjectVisibilityResponse> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectArn").getter(getter(UpdateProjectVisibilityResponse::projectArn))
            .setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()).build();

    private static final SdkField<String> PUBLIC_PROJECT_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("publicProjectAlias").getter(getter(UpdateProjectVisibilityResponse::publicProjectAlias))
            .setter(setter(Builder::publicProjectAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicProjectAlias").build())
            .build();

    private static final SdkField<String> PROJECT_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectVisibility").getter(getter(UpdateProjectVisibilityResponse::projectVisibilityAsString))
            .setter(setter(Builder::projectVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectVisibility").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD,
            PUBLIC_PROJECT_ALIAS_FIELD, PROJECT_VISIBILITY_FIELD));

    private final String projectArn;

    private final String publicProjectAlias;

    private final String projectVisibility;

    private UpdateProjectVisibilityResponse(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.publicProjectAlias = builder.publicProjectAlias;
        this.projectVisibility = builder.projectVisibility;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the build project.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the build project.
     */
    public final String projectArn() {
        return projectArn;
    }

    /**
     * <p>
     * Contains the project identifier used with the public build APIs.
     * </p>
     * 
     * @return Contains the project identifier used with the public build APIs.
     */
    public final String publicProjectAlias() {
        return publicProjectAlias;
    }

    /**
     * Returns the value of the ProjectVisibility property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #projectVisibility}
     * will return {@link ProjectVisibilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #projectVisibilityAsString}.
     * </p>
     * 
     * @return The value of the ProjectVisibility property for this object.
     * @see ProjectVisibilityType
     */
    public final ProjectVisibilityType projectVisibility() {
        return ProjectVisibilityType.fromValue(projectVisibility);
    }

    /**
     * Returns the value of the ProjectVisibility property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #projectVisibility}
     * will return {@link ProjectVisibilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #projectVisibilityAsString}.
     * </p>
     * 
     * @return The value of the ProjectVisibility property for this object.
     * @see ProjectVisibilityType
     */
    public final String projectVisibilityAsString() {
        return projectVisibility;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(publicProjectAlias());
        hashCode = 31 * hashCode + Objects.hashCode(projectVisibilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProjectVisibilityResponse)) {
            return false;
        }
        UpdateProjectVisibilityResponse other = (UpdateProjectVisibilityResponse) obj;
        return Objects.equals(projectArn(), other.projectArn())
                && Objects.equals(publicProjectAlias(), other.publicProjectAlias())
                && Objects.equals(projectVisibilityAsString(), other.projectVisibilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProjectVisibilityResponse").add("ProjectArn", projectArn())
                .add("PublicProjectAlias", publicProjectAlias()).add("ProjectVisibility", projectVisibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        case "publicProjectAlias":
            return Optional.ofNullable(clazz.cast(publicProjectAlias()));
        case "projectVisibility":
            return Optional.ofNullable(clazz.cast(projectVisibilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProjectVisibilityResponse, T> g) {
        return obj -> g.apply((UpdateProjectVisibilityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateProjectVisibilityResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the build project.
         * </p>
         * 
         * @param projectArn
         *        The Amazon Resource Name (ARN) of the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * <p>
         * Contains the project identifier used with the public build APIs.
         * </p>
         * 
         * @param publicProjectAlias
         *        Contains the project identifier used with the public build APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicProjectAlias(String publicProjectAlias);

        /**
         * Sets the value of the ProjectVisibility property for this object.
         *
         * @param projectVisibility
         *        The new value for the ProjectVisibility property for this object.
         * @see ProjectVisibilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProjectVisibilityType
         */
        Builder projectVisibility(String projectVisibility);

        /**
         * Sets the value of the ProjectVisibility property for this object.
         *
         * @param projectVisibility
         *        The new value for the ProjectVisibility property for this object.
         * @see ProjectVisibilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProjectVisibilityType
         */
        Builder projectVisibility(ProjectVisibilityType projectVisibility);
    }

    static final class BuilderImpl extends CodeBuildResponse.BuilderImpl implements Builder {
        private String projectArn;

        private String publicProjectAlias;

        private String projectVisibility;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProjectVisibilityResponse model) {
            super(model);
            projectArn(model.projectArn);
            publicProjectAlias(model.publicProjectAlias);
            projectVisibility(model.projectVisibility);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        @Transient
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final String getPublicProjectAlias() {
            return publicProjectAlias;
        }

        public final void setPublicProjectAlias(String publicProjectAlias) {
            this.publicProjectAlias = publicProjectAlias;
        }

        @Override
        @Transient
        public final Builder publicProjectAlias(String publicProjectAlias) {
            this.publicProjectAlias = publicProjectAlias;
            return this;
        }

        public final String getProjectVisibility() {
            return projectVisibility;
        }

        public final void setProjectVisibility(String projectVisibility) {
            this.projectVisibility = projectVisibility;
        }

        @Override
        @Transient
        public final Builder projectVisibility(String projectVisibility) {
            this.projectVisibility = projectVisibility;
            return this;
        }

        @Override
        @Transient
        public final Builder projectVisibility(ProjectVisibilityType projectVisibility) {
            this.projectVisibility(projectVisibility == null ? null : projectVisibility.toString());
            return this;
        }

        @Override
        public UpdateProjectVisibilityResponse build() {
            return new UpdateProjectVisibilityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
