/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a batch build build group. Build groups are used to combine builds that can run in
 * parallel, while still being able to set dependencies on other build groups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BuildGroup implements SdkPojo, Serializable, ToCopyableBuilder<BuildGroup.Builder, BuildGroup> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(BuildGroup::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<List<String>> DEPENDS_ON_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("dependsOn")
            .getter(getter(BuildGroup::dependsOn))
            .setter(setter(Builder::dependsOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependsOn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IGNORE_FAILURE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ignoreFailure").getter(getter(BuildGroup::ignoreFailure)).setter(setter(Builder::ignoreFailure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignoreFailure").build()).build();

    private static final SdkField<BuildSummary> CURRENT_BUILD_SUMMARY_FIELD = SdkField
            .<BuildSummary> builder(MarshallingType.SDK_POJO).memberName("currentBuildSummary")
            .getter(getter(BuildGroup::currentBuildSummary)).setter(setter(Builder::currentBuildSummary))
            .constructor(BuildSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentBuildSummary").build())
            .build();

    private static final SdkField<List<BuildSummary>> PRIOR_BUILD_SUMMARY_LIST_FIELD = SdkField
            .<List<BuildSummary>> builder(MarshallingType.LIST)
            .memberName("priorBuildSummaryList")
            .getter(getter(BuildGroup::priorBuildSummaryList))
            .setter(setter(Builder::priorBuildSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priorBuildSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BuildSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(BuildSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            DEPENDS_ON_FIELD, IGNORE_FAILURE_FIELD, CURRENT_BUILD_SUMMARY_FIELD, PRIOR_BUILD_SUMMARY_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String identifier;

    private final List<String> dependsOn;

    private final Boolean ignoreFailure;

    private final BuildSummary currentBuildSummary;

    private final List<BuildSummary> priorBuildSummaryList;

    private BuildGroup(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.dependsOn = builder.dependsOn;
        this.ignoreFailure = builder.ignoreFailure;
        this.currentBuildSummary = builder.currentBuildSummary;
        this.priorBuildSummaryList = builder.priorBuildSummaryList;
    }

    /**
     * <p>
     * Contains the identifier of the build group.
     * </p>
     * 
     * @return Contains the identifier of the build group.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the DependsOn property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDependsOn() {
        return dependsOn != null && !(dependsOn instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings that contain the identifiers of the build groups that this build group depends on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDependsOn} method.
     * </p>
     * 
     * @return An array of strings that contain the identifiers of the build groups that this build group depends on.
     */
    public final List<String> dependsOn() {
        return dependsOn;
    }

    /**
     * <p>
     * Specifies if failures in this build group can be ignored.
     * </p>
     * 
     * @return Specifies if failures in this build group can be ignored.
     */
    public final Boolean ignoreFailure() {
        return ignoreFailure;
    }

    /**
     * <p>
     * A <code>BuildSummary</code> object that contains a summary of the current build group.
     * </p>
     * 
     * @return A <code>BuildSummary</code> object that contains a summary of the current build group.
     */
    public final BuildSummary currentBuildSummary() {
        return currentBuildSummary;
    }

    /**
     * For responses, this returns true if the service returned a value for the PriorBuildSummaryList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPriorBuildSummaryList() {
        return priorBuildSummaryList != null && !(priorBuildSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>BuildSummary</code> objects that contain summaries of previous build groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPriorBuildSummaryList} method.
     * </p>
     * 
     * @return An array of <code>BuildSummary</code> objects that contain summaries of previous build groups.
     */
    public final List<BuildSummary> priorBuildSummaryList() {
        return priorBuildSummaryList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasDependsOn() ? dependsOn() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ignoreFailure());
        hashCode = 31 * hashCode + Objects.hashCode(currentBuildSummary());
        hashCode = 31 * hashCode + Objects.hashCode(hasPriorBuildSummaryList() ? priorBuildSummaryList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuildGroup)) {
            return false;
        }
        BuildGroup other = (BuildGroup) obj;
        return Objects.equals(identifier(), other.identifier()) && hasDependsOn() == other.hasDependsOn()
                && Objects.equals(dependsOn(), other.dependsOn()) && Objects.equals(ignoreFailure(), other.ignoreFailure())
                && Objects.equals(currentBuildSummary(), other.currentBuildSummary())
                && hasPriorBuildSummaryList() == other.hasPriorBuildSummaryList()
                && Objects.equals(priorBuildSummaryList(), other.priorBuildSummaryList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BuildGroup").add("Identifier", identifier())
                .add("DependsOn", hasDependsOn() ? dependsOn() : null).add("IgnoreFailure", ignoreFailure())
                .add("CurrentBuildSummary", currentBuildSummary())
                .add("PriorBuildSummaryList", hasPriorBuildSummaryList() ? priorBuildSummaryList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "dependsOn":
            return Optional.ofNullable(clazz.cast(dependsOn()));
        case "ignoreFailure":
            return Optional.ofNullable(clazz.cast(ignoreFailure()));
        case "currentBuildSummary":
            return Optional.ofNullable(clazz.cast(currentBuildSummary()));
        case "priorBuildSummaryList":
            return Optional.ofNullable(clazz.cast(priorBuildSummaryList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BuildGroup, T> g) {
        return obj -> g.apply((BuildGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BuildGroup> {
        /**
         * <p>
         * Contains the identifier of the build group.
         * </p>
         * 
         * @param identifier
         *        Contains the identifier of the build group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * An array of strings that contain the identifiers of the build groups that this build group depends on.
         * </p>
         * 
         * @param dependsOn
         *        An array of strings that contain the identifiers of the build groups that this build group depends on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependsOn(Collection<String> dependsOn);

        /**
         * <p>
         * An array of strings that contain the identifiers of the build groups that this build group depends on.
         * </p>
         * 
         * @param dependsOn
         *        An array of strings that contain the identifiers of the build groups that this build group depends on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependsOn(String... dependsOn);

        /**
         * <p>
         * Specifies if failures in this build group can be ignored.
         * </p>
         * 
         * @param ignoreFailure
         *        Specifies if failures in this build group can be ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreFailure(Boolean ignoreFailure);

        /**
         * <p>
         * A <code>BuildSummary</code> object that contains a summary of the current build group.
         * </p>
         * 
         * @param currentBuildSummary
         *        A <code>BuildSummary</code> object that contains a summary of the current build group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentBuildSummary(BuildSummary currentBuildSummary);

        /**
         * <p>
         * A <code>BuildSummary</code> object that contains a summary of the current build group.
         * </p>
         * This is a convenience method that creates an instance of the {@link BuildSummary.Builder} avoiding the need
         * to create one manually via {@link BuildSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link BuildSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #currentBuildSummary(BuildSummary)}.
         * 
         * @param currentBuildSummary
         *        a consumer that will call methods on {@link BuildSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentBuildSummary(BuildSummary)
         */
        default Builder currentBuildSummary(Consumer<BuildSummary.Builder> currentBuildSummary) {
            return currentBuildSummary(BuildSummary.builder().applyMutation(currentBuildSummary).build());
        }

        /**
         * <p>
         * An array of <code>BuildSummary</code> objects that contain summaries of previous build groups.
         * </p>
         * 
         * @param priorBuildSummaryList
         *        An array of <code>BuildSummary</code> objects that contain summaries of previous build groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priorBuildSummaryList(Collection<BuildSummary> priorBuildSummaryList);

        /**
         * <p>
         * An array of <code>BuildSummary</code> objects that contain summaries of previous build groups.
         * </p>
         * 
         * @param priorBuildSummaryList
         *        An array of <code>BuildSummary</code> objects that contain summaries of previous build groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priorBuildSummaryList(BuildSummary... priorBuildSummaryList);

        /**
         * <p>
         * An array of <code>BuildSummary</code> objects that contain summaries of previous build groups.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<BuildSummary>.Builder} avoiding the
         * need to create one manually via {@link List<BuildSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BuildSummary>.Builder#build()} is called immediately and its
         * result is passed to {@link #priorBuildSummaryList(List<BuildSummary>)}.
         * 
         * @param priorBuildSummaryList
         *        a consumer that will call methods on {@link List<BuildSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #priorBuildSummaryList(List<BuildSummary>)
         */
        Builder priorBuildSummaryList(Consumer<BuildSummary.Builder>... priorBuildSummaryList);
    }

    static final class BuilderImpl implements Builder {
        private String identifier;

        private List<String> dependsOn = DefaultSdkAutoConstructList.getInstance();

        private Boolean ignoreFailure;

        private BuildSummary currentBuildSummary;

        private List<BuildSummary> priorBuildSummaryList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BuildGroup model) {
            identifier(model.identifier);
            dependsOn(model.dependsOn);
            ignoreFailure(model.ignoreFailure);
            currentBuildSummary(model.currentBuildSummary);
            priorBuildSummaryList(model.priorBuildSummaryList);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Collection<String> getDependsOn() {
            if (dependsOn instanceof SdkAutoConstructList) {
                return null;
            }
            return dependsOn;
        }

        public final void setDependsOn(Collection<String> dependsOn) {
            this.dependsOn = IdentifiersCopier.copy(dependsOn);
        }

        @Override
        public final Builder dependsOn(Collection<String> dependsOn) {
            this.dependsOn = IdentifiersCopier.copy(dependsOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(String... dependsOn) {
            dependsOn(Arrays.asList(dependsOn));
            return this;
        }

        public final Boolean getIgnoreFailure() {
            return ignoreFailure;
        }

        public final void setIgnoreFailure(Boolean ignoreFailure) {
            this.ignoreFailure = ignoreFailure;
        }

        @Override
        public final Builder ignoreFailure(Boolean ignoreFailure) {
            this.ignoreFailure = ignoreFailure;
            return this;
        }

        public final BuildSummary.Builder getCurrentBuildSummary() {
            return currentBuildSummary != null ? currentBuildSummary.toBuilder() : null;
        }

        public final void setCurrentBuildSummary(BuildSummary.BuilderImpl currentBuildSummary) {
            this.currentBuildSummary = currentBuildSummary != null ? currentBuildSummary.build() : null;
        }

        @Override
        public final Builder currentBuildSummary(BuildSummary currentBuildSummary) {
            this.currentBuildSummary = currentBuildSummary;
            return this;
        }

        public final List<BuildSummary.Builder> getPriorBuildSummaryList() {
            List<BuildSummary.Builder> result = BuildSummariesCopier.copyToBuilder(this.priorBuildSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPriorBuildSummaryList(Collection<BuildSummary.BuilderImpl> priorBuildSummaryList) {
            this.priorBuildSummaryList = BuildSummariesCopier.copyFromBuilder(priorBuildSummaryList);
        }

        @Override
        public final Builder priorBuildSummaryList(Collection<BuildSummary> priorBuildSummaryList) {
            this.priorBuildSummaryList = BuildSummariesCopier.copy(priorBuildSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priorBuildSummaryList(BuildSummary... priorBuildSummaryList) {
            priorBuildSummaryList(Arrays.asList(priorBuildSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priorBuildSummaryList(Consumer<BuildSummary.Builder>... priorBuildSummaryList) {
            priorBuildSummaryList(Stream.of(priorBuildSummaryList).map(c -> BuildSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuildGroup build() {
            return new BuildGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
