/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartBuildRequest extends CodeBuildRequest implements
        ToCopyableBuilder<StartBuildRequest.Builder, StartBuildRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectName").getter(getter(StartBuildRequest::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()).build();

    private static final SdkField<List<ProjectSource>> SECONDARY_SOURCES_OVERRIDE_FIELD = SdkField
            .<List<ProjectSource>> builder(MarshallingType.LIST)
            .memberName("secondarySourcesOverride")
            .getter(getter(StartBuildRequest::secondarySourcesOverride))
            .setter(setter(Builder::secondarySourcesOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySourcesOverride").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ProjectSourceVersion>> SECONDARY_SOURCES_VERSION_OVERRIDE_FIELD = SdkField
            .<List<ProjectSourceVersion>> builder(MarshallingType.LIST)
            .memberName("secondarySourcesVersionOverride")
            .getter(getter(StartBuildRequest::secondarySourcesVersionOverride))
            .setter(setter(Builder::secondarySourcesVersionOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySourcesVersionOverride")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectSourceVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectSourceVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceVersion").getter(getter(StartBuildRequest::sourceVersion)).setter(setter(Builder::sourceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVersion").build()).build();

    private static final SdkField<ProjectArtifacts> ARTIFACTS_OVERRIDE_FIELD = SdkField
            .<ProjectArtifacts> builder(MarshallingType.SDK_POJO).memberName("artifactsOverride")
            .getter(getter(StartBuildRequest::artifactsOverride)).setter(setter(Builder::artifactsOverride))
            .constructor(ProjectArtifacts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactsOverride").build()).build();

    private static final SdkField<List<ProjectArtifacts>> SECONDARY_ARTIFACTS_OVERRIDE_FIELD = SdkField
            .<List<ProjectArtifacts>> builder(MarshallingType.LIST)
            .memberName("secondaryArtifactsOverride")
            .getter(getter(StartBuildRequest::secondaryArtifactsOverride))
            .setter(setter(Builder::secondaryArtifactsOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondaryArtifactsOverride").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectArtifacts> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectArtifacts::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EnvironmentVariable>> ENVIRONMENT_VARIABLES_OVERRIDE_FIELD = SdkField
            .<List<EnvironmentVariable>> builder(MarshallingType.LIST)
            .memberName("environmentVariablesOverride")
            .getter(getter(StartBuildRequest::environmentVariablesOverride))
            .setter(setter(Builder::environmentVariablesOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariablesOverride")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentVariable> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentVariable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_TYPE_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceTypeOverride").getter(getter(StartBuildRequest::sourceTypeOverrideAsString))
            .setter(setter(Builder::sourceTypeOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceTypeOverride").build())
            .build();

    private static final SdkField<String> SOURCE_LOCATION_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceLocationOverride").getter(getter(StartBuildRequest::sourceLocationOverride))
            .setter(setter(Builder::sourceLocationOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceLocationOverride").build())
            .build();

    private static final SdkField<SourceAuth> SOURCE_AUTH_OVERRIDE_FIELD = SdkField
            .<SourceAuth> builder(MarshallingType.SDK_POJO).memberName("sourceAuthOverride")
            .getter(getter(StartBuildRequest::sourceAuthOverride)).setter(setter(Builder::sourceAuthOverride))
            .constructor(SourceAuth::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAuthOverride").build())
            .build();

    private static final SdkField<Integer> GIT_CLONE_DEPTH_OVERRIDE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("gitCloneDepthOverride").getter(getter(StartBuildRequest::gitCloneDepthOverride))
            .setter(setter(Builder::gitCloneDepthOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gitCloneDepthOverride").build())
            .build();

    private static final SdkField<GitSubmodulesConfig> GIT_SUBMODULES_CONFIG_OVERRIDE_FIELD = SdkField
            .<GitSubmodulesConfig> builder(MarshallingType.SDK_POJO)
            .memberName("gitSubmodulesConfigOverride")
            .getter(getter(StartBuildRequest::gitSubmodulesConfigOverride))
            .setter(setter(Builder::gitSubmodulesConfigOverride))
            .constructor(GitSubmodulesConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gitSubmodulesConfigOverride")
                    .build()).build();

    private static final SdkField<String> BUILDSPEC_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("buildspecOverride").getter(getter(StartBuildRequest::buildspecOverride))
            .setter(setter(Builder::buildspecOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildspecOverride").build()).build();

    private static final SdkField<Boolean> INSECURE_SSL_OVERRIDE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("insecureSslOverride").getter(getter(StartBuildRequest::insecureSslOverride))
            .setter(setter(Builder::insecureSslOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("insecureSslOverride").build())
            .build();

    private static final SdkField<Boolean> REPORT_BUILD_STATUS_OVERRIDE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("reportBuildStatusOverride")
            .getter(getter(StartBuildRequest::reportBuildStatusOverride)).setter(setter(Builder::reportBuildStatusOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportBuildStatusOverride").build())
            .build();

    private static final SdkField<BuildStatusConfig> BUILD_STATUS_CONFIG_OVERRIDE_FIELD = SdkField
            .<BuildStatusConfig> builder(MarshallingType.SDK_POJO).memberName("buildStatusConfigOverride")
            .getter(getter(StartBuildRequest::buildStatusConfigOverride)).setter(setter(Builder::buildStatusConfigOverride))
            .constructor(BuildStatusConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildStatusConfigOverride").build())
            .build();

    private static final SdkField<String> ENVIRONMENT_TYPE_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentTypeOverride").getter(getter(StartBuildRequest::environmentTypeOverrideAsString))
            .setter(setter(Builder::environmentTypeOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentTypeOverride").build())
            .build();

    private static final SdkField<String> IMAGE_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageOverride").getter(getter(StartBuildRequest::imageOverride)).setter(setter(Builder::imageOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageOverride").build()).build();

    private static final SdkField<String> COMPUTE_TYPE_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computeTypeOverride").getter(getter(StartBuildRequest::computeTypeOverrideAsString))
            .setter(setter(Builder::computeTypeOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeTypeOverride").build())
            .build();

    private static final SdkField<String> CERTIFICATE_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateOverride").getter(getter(StartBuildRequest::certificateOverride))
            .setter(setter(Builder::certificateOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateOverride").build())
            .build();

    private static final SdkField<ProjectCache> CACHE_OVERRIDE_FIELD = SdkField.<ProjectCache> builder(MarshallingType.SDK_POJO)
            .memberName("cacheOverride").getter(getter(StartBuildRequest::cacheOverride)).setter(setter(Builder::cacheOverride))
            .constructor(ProjectCache::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheOverride").build()).build();

    private static final SdkField<String> SERVICE_ROLE_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceRoleOverride").getter(getter(StartBuildRequest::serviceRoleOverride))
            .setter(setter(Builder::serviceRoleOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRoleOverride").build())
            .build();

    private static final SdkField<Boolean> PRIVILEGED_MODE_OVERRIDE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("privilegedModeOverride").getter(getter(StartBuildRequest::privilegedModeOverride))
            .setter(setter(Builder::privilegedModeOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privilegedModeOverride").build())
            .build();

    private static final SdkField<Integer> TIMEOUT_IN_MINUTES_OVERRIDE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("timeoutInMinutesOverride")
            .getter(getter(StartBuildRequest::timeoutInMinutesOverride)).setter(setter(Builder::timeoutInMinutesOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInMinutesOverride").build())
            .build();

    private static final SdkField<Integer> QUEUED_TIMEOUT_IN_MINUTES_OVERRIDE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("queuedTimeoutInMinutesOverride")
            .getter(getter(StartBuildRequest::queuedTimeoutInMinutesOverride))
            .setter(setter(Builder::queuedTimeoutInMinutesOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedTimeoutInMinutesOverride")
                    .build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encryptionKeyOverride").getter(getter(StartBuildRequest::encryptionKeyOverride))
            .setter(setter(Builder::encryptionKeyOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKeyOverride").build())
            .build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("idempotencyToken").getter(getter(StartBuildRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idempotencyToken").build()).build();

    private static final SdkField<LogsConfig> LOGS_CONFIG_OVERRIDE_FIELD = SdkField
            .<LogsConfig> builder(MarshallingType.SDK_POJO).memberName("logsConfigOverride")
            .getter(getter(StartBuildRequest::logsConfigOverride)).setter(setter(Builder::logsConfigOverride))
            .constructor(LogsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logsConfigOverride").build())
            .build();

    private static final SdkField<RegistryCredential> REGISTRY_CREDENTIAL_OVERRIDE_FIELD = SdkField
            .<RegistryCredential> builder(MarshallingType.SDK_POJO)
            .memberName("registryCredentialOverride")
            .getter(getter(StartBuildRequest::registryCredentialOverride))
            .setter(setter(Builder::registryCredentialOverride))
            .constructor(RegistryCredential::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryCredentialOverride").build())
            .build();

    private static final SdkField<String> IMAGE_PULL_CREDENTIALS_TYPE_OVERRIDE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("imagePullCredentialsTypeOverride")
            .getter(getter(StartBuildRequest::imagePullCredentialsTypeOverrideAsString))
            .setter(setter(Builder::imagePullCredentialsTypeOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePullCredentialsTypeOverride")
                    .build()).build();

    private static final SdkField<Boolean> DEBUG_SESSION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("debugSessionEnabled").getter(getter(StartBuildRequest::debugSessionEnabled))
            .setter(setter(Builder::debugSessionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("debugSessionEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            SECONDARY_SOURCES_OVERRIDE_FIELD, SECONDARY_SOURCES_VERSION_OVERRIDE_FIELD, SOURCE_VERSION_FIELD,
            ARTIFACTS_OVERRIDE_FIELD, SECONDARY_ARTIFACTS_OVERRIDE_FIELD, ENVIRONMENT_VARIABLES_OVERRIDE_FIELD,
            SOURCE_TYPE_OVERRIDE_FIELD, SOURCE_LOCATION_OVERRIDE_FIELD, SOURCE_AUTH_OVERRIDE_FIELD,
            GIT_CLONE_DEPTH_OVERRIDE_FIELD, GIT_SUBMODULES_CONFIG_OVERRIDE_FIELD, BUILDSPEC_OVERRIDE_FIELD,
            INSECURE_SSL_OVERRIDE_FIELD, REPORT_BUILD_STATUS_OVERRIDE_FIELD, BUILD_STATUS_CONFIG_OVERRIDE_FIELD,
            ENVIRONMENT_TYPE_OVERRIDE_FIELD, IMAGE_OVERRIDE_FIELD, COMPUTE_TYPE_OVERRIDE_FIELD, CERTIFICATE_OVERRIDE_FIELD,
            CACHE_OVERRIDE_FIELD, SERVICE_ROLE_OVERRIDE_FIELD, PRIVILEGED_MODE_OVERRIDE_FIELD, TIMEOUT_IN_MINUTES_OVERRIDE_FIELD,
            QUEUED_TIMEOUT_IN_MINUTES_OVERRIDE_FIELD, ENCRYPTION_KEY_OVERRIDE_FIELD, IDEMPOTENCY_TOKEN_FIELD,
            LOGS_CONFIG_OVERRIDE_FIELD, REGISTRY_CREDENTIAL_OVERRIDE_FIELD, IMAGE_PULL_CREDENTIALS_TYPE_OVERRIDE_FIELD,
            DEBUG_SESSION_ENABLED_FIELD));

    private final String projectName;

    private final List<ProjectSource> secondarySourcesOverride;

    private final List<ProjectSourceVersion> secondarySourcesVersionOverride;

    private final String sourceVersion;

    private final ProjectArtifacts artifactsOverride;

    private final List<ProjectArtifacts> secondaryArtifactsOverride;

    private final List<EnvironmentVariable> environmentVariablesOverride;

    private final String sourceTypeOverride;

    private final String sourceLocationOverride;

    private final SourceAuth sourceAuthOverride;

    private final Integer gitCloneDepthOverride;

    private final GitSubmodulesConfig gitSubmodulesConfigOverride;

    private final String buildspecOverride;

    private final Boolean insecureSslOverride;

    private final Boolean reportBuildStatusOverride;

    private final BuildStatusConfig buildStatusConfigOverride;

    private final String environmentTypeOverride;

    private final String imageOverride;

    private final String computeTypeOverride;

    private final String certificateOverride;

    private final ProjectCache cacheOverride;

    private final String serviceRoleOverride;

    private final Boolean privilegedModeOverride;

    private final Integer timeoutInMinutesOverride;

    private final Integer queuedTimeoutInMinutesOverride;

    private final String encryptionKeyOverride;

    private final String idempotencyToken;

    private final LogsConfig logsConfigOverride;

    private final RegistryCredential registryCredentialOverride;

    private final String imagePullCredentialsTypeOverride;

    private final Boolean debugSessionEnabled;

    private StartBuildRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.secondarySourcesOverride = builder.secondarySourcesOverride;
        this.secondarySourcesVersionOverride = builder.secondarySourcesVersionOverride;
        this.sourceVersion = builder.sourceVersion;
        this.artifactsOverride = builder.artifactsOverride;
        this.secondaryArtifactsOverride = builder.secondaryArtifactsOverride;
        this.environmentVariablesOverride = builder.environmentVariablesOverride;
        this.sourceTypeOverride = builder.sourceTypeOverride;
        this.sourceLocationOverride = builder.sourceLocationOverride;
        this.sourceAuthOverride = builder.sourceAuthOverride;
        this.gitCloneDepthOverride = builder.gitCloneDepthOverride;
        this.gitSubmodulesConfigOverride = builder.gitSubmodulesConfigOverride;
        this.buildspecOverride = builder.buildspecOverride;
        this.insecureSslOverride = builder.insecureSslOverride;
        this.reportBuildStatusOverride = builder.reportBuildStatusOverride;
        this.buildStatusConfigOverride = builder.buildStatusConfigOverride;
        this.environmentTypeOverride = builder.environmentTypeOverride;
        this.imageOverride = builder.imageOverride;
        this.computeTypeOverride = builder.computeTypeOverride;
        this.certificateOverride = builder.certificateOverride;
        this.cacheOverride = builder.cacheOverride;
        this.serviceRoleOverride = builder.serviceRoleOverride;
        this.privilegedModeOverride = builder.privilegedModeOverride;
        this.timeoutInMinutesOverride = builder.timeoutInMinutesOverride;
        this.queuedTimeoutInMinutesOverride = builder.queuedTimeoutInMinutesOverride;
        this.encryptionKeyOverride = builder.encryptionKeyOverride;
        this.idempotencyToken = builder.idempotencyToken;
        this.logsConfigOverride = builder.logsConfigOverride;
        this.registryCredentialOverride = builder.registryCredentialOverride;
        this.imagePullCredentialsTypeOverride = builder.imagePullCredentialsTypeOverride;
        this.debugSessionEnabled = builder.debugSessionEnabled;
    }

    /**
     * <p>
     * The name of the CodeBuild build project to start running a build.
     * </p>
     * 
     * @return The name of the CodeBuild build project to start running a build.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecondarySourcesOverride property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSecondarySourcesOverride() {
        return secondarySourcesOverride != null && !(secondarySourcesOverride instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ProjectSource</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecondarySourcesOverride} method.
     * </p>
     * 
     * @return An array of <code>ProjectSource</code> objects.
     */
    public final List<ProjectSource> secondarySourcesOverride() {
        return secondarySourcesOverride;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecondarySourcesVersionOverride
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasSecondarySourcesVersionOverride() {
        return secondarySourcesVersionOverride != null && !(secondarySourcesVersionOverride instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ProjectSourceVersion</code> objects that specify one or more versions of the project's
     * secondary sources to be used for this build only.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecondarySourcesVersionOverride}
     * method.
     * </p>
     * 
     * @return An array of <code>ProjectSourceVersion</code> objects that specify one or more versions of the project's
     *         secondary sources to be used for this build only.
     */
    public final List<ProjectSourceVersion> secondarySourcesVersionOverride() {
        return secondarySourcesVersionOverride;
    }

    /**
     * <p>
     * The version of the build input to be built, for this build only. If not specified, the latest version is used. If
     * specified, the contents depends on the source provider:
     * </p>
     * <dl>
     * <dt>CodeCommit</dt>
     * <dd>
     * <p>
     * The commit ID, branch, or Git tag to use.
     * </p>
     * </dd>
     * <dt>GitHub</dt>
     * <dd>
     * <p>
     * The commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you
     * want to build. If a pull request ID is specified, it must use the format <code>pr/pull-request-ID</code> (for
     * example <code>pr/25</code>). If a branch name is specified, the branch's HEAD commit ID is used. If not
     * specified, the default branch's HEAD commit ID is used.
     * </p>
     * </dd>
     * <dt>Bitbucket</dt>
     * <dd>
     * <p>
     * The commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If
     * a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD
     * commit ID is used.
     * </p>
     * </dd>
     * <dt>Amazon S3</dt>
     * <dd>
     * <p>
     * The version ID of the object that represents the build input ZIP file to use.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If <code>sourceVersion</code> is specified at the project level, then this <code>sourceVersion</code> (at the
     * build level) takes precedence.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample
     * with CodeBuild</a> in the <i>CodeBuild User Guide</i>.
     * </p>
     * 
     * @return The version of the build input to be built, for this build only. If not specified, the latest version is
     *         used. If specified, the contents depends on the source provider:</p>
     *         <dl>
     *         <dt>CodeCommit</dt>
     *         <dd>
     *         <p>
     *         The commit ID, branch, or Git tag to use.
     *         </p>
     *         </dd>
     *         <dt>GitHub</dt>
     *         <dd>
     *         <p>
     *         The commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source
     *         code you want to build. If a pull request ID is specified, it must use the format
     *         <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the
     *         branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
     *         </p>
     *         </dd>
     *         <dt>Bitbucket</dt>
     *         <dd>
     *         <p>
     *         The commit ID, branch name, or tag name that corresponds to the version of the source code you want to
     *         build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default
     *         branch's HEAD commit ID is used.
     *         </p>
     *         </dd>
     *         <dt>Amazon S3</dt>
     *         <dd>
     *         <p>
     *         The version ID of the object that represents the build input ZIP file to use.
     *         </p>
     *         </dd>
     *         </dl>
     *         <p>
     *         If <code>sourceVersion</code> is specified at the project level, then this <code>sourceVersion</code> (at
     *         the build level) takes precedence.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version
     *         Sample with CodeBuild</a> in the <i>CodeBuild User Guide</i>.
     */
    public final String sourceVersion() {
        return sourceVersion;
    }

    /**
     * <p>
     * Build output artifact settings that override, for this build only, the latest ones already defined in the build
     * project.
     * </p>
     * 
     * @return Build output artifact settings that override, for this build only, the latest ones already defined in the
     *         build project.
     */
    public final ProjectArtifacts artifactsOverride() {
        return artifactsOverride;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecondaryArtifactsOverride property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSecondaryArtifactsOverride() {
        return secondaryArtifactsOverride != null && !(secondaryArtifactsOverride instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ProjectArtifacts</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecondaryArtifactsOverride} method.
     * </p>
     * 
     * @return An array of <code>ProjectArtifacts</code> objects.
     */
    public final List<ProjectArtifacts> secondaryArtifactsOverride() {
        return secondaryArtifactsOverride;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentVariablesOverride property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnvironmentVariablesOverride() {
        return environmentVariablesOverride != null && !(environmentVariablesOverride instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of environment variables that overrides, for this build only, the latest ones already defined in the build
     * project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentVariablesOverride} method.
     * </p>
     * 
     * @return A set of environment variables that overrides, for this build only, the latest ones already defined in
     *         the build project.
     */
    public final List<EnvironmentVariable> environmentVariablesOverride() {
        return environmentVariablesOverride;
    }

    /**
     * <p>
     * A source input type, for this build, that overrides the source input defined in the build project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sourceTypeOverride} will return {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #sourceTypeOverrideAsString}.
     * </p>
     * 
     * @return A source input type, for this build, that overrides the source input defined in the build project.
     * @see SourceType
     */
    public final SourceType sourceTypeOverride() {
        return SourceType.fromValue(sourceTypeOverride);
    }

    /**
     * <p>
     * A source input type, for this build, that overrides the source input defined in the build project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sourceTypeOverride} will return {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #sourceTypeOverrideAsString}.
     * </p>
     * 
     * @return A source input type, for this build, that overrides the source input defined in the build project.
     * @see SourceType
     */
    public final String sourceTypeOverrideAsString() {
        return sourceTypeOverride;
    }

    /**
     * <p>
     * A location that overrides, for this build, the source location for the one defined in the build project.
     * </p>
     * 
     * @return A location that overrides, for this build, the source location for the one defined in the build project.
     */
    public final String sourceLocationOverride() {
        return sourceLocationOverride;
    }

    /**
     * <p>
     * An authorization type for this build that overrides the one defined in the build project. This override applies
     * only if the build project's source is BitBucket or GitHub.
     * </p>
     * 
     * @return An authorization type for this build that overrides the one defined in the build project. This override
     *         applies only if the build project's source is BitBucket or GitHub.
     */
    public final SourceAuth sourceAuthOverride() {
        return sourceAuthOverride;
    }

    /**
     * <p>
     * The user-defined depth of history, with a minimum value of 0, that overrides, for this build only, any previous
     * depth of history defined in the build project.
     * </p>
     * 
     * @return The user-defined depth of history, with a minimum value of 0, that overrides, for this build only, any
     *         previous depth of history defined in the build project.
     */
    public final Integer gitCloneDepthOverride() {
        return gitCloneDepthOverride;
    }

    /**
     * <p>
     * Information about the Git submodules configuration for this build of an CodeBuild build project.
     * </p>
     * 
     * @return Information about the Git submodules configuration for this build of an CodeBuild build project.
     */
    public final GitSubmodulesConfig gitSubmodulesConfigOverride() {
        return gitSubmodulesConfigOverride;
    }

    /**
     * <p>
     * A buildspec file declaration that overrides, for this build only, the latest one already defined in the build
     * project.
     * </p>
     * <p>
     * If this value is set, it can be either an inline buildspec definition, the path to an alternate buildspec file
     * relative to the value of the built-in <code>CODEBUILD_SRC_DIR</code> environment variable, or the path to an S3
     * bucket. The bucket must be in the same Amazon Web Services Region as the build project. Specify the buildspec
     * file using its ARN (for example, <code>arn:aws:s3:::my-codebuild-sample2/buildspec.yml</code>). If this value is
     * not provided or is set to an empty string, the source code must contain a buildspec file in its root directory.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage"
     * >Buildspec File Name and Storage Location</a>.
     * </p>
     * 
     * @return A buildspec file declaration that overrides, for this build only, the latest one already defined in the
     *         build project.</p>
     *         <p>
     *         If this value is set, it can be either an inline buildspec definition, the path to an alternate buildspec
     *         file relative to the value of the built-in <code>CODEBUILD_SRC_DIR</code> environment variable, or the
     *         path to an S3 bucket. The bucket must be in the same Amazon Web Services Region as the build project.
     *         Specify the buildspec file using its ARN (for example,
     *         <code>arn:aws:s3:::my-codebuild-sample2/buildspec.yml</code>). If this value is not provided or is set to
     *         an empty string, the source code must contain a buildspec file in its root directory. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage"
     *         >Buildspec File Name and Storage Location</a>.
     */
    public final String buildspecOverride() {
        return buildspecOverride;
    }

    /**
     * <p>
     * Enable this flag to override the insecure SSL setting that is specified in the build project. The insecure SSL
     * setting determines whether to ignore SSL warnings while connecting to the project source code. This override
     * applies only if the build's source is GitHub Enterprise.
     * </p>
     * 
     * @return Enable this flag to override the insecure SSL setting that is specified in the build project. The
     *         insecure SSL setting determines whether to ignore SSL warnings while connecting to the project source
     *         code. This override applies only if the build's source is GitHub Enterprise.
     */
    public final Boolean insecureSslOverride() {
        return insecureSslOverride;
    }

    /**
     * <p>
     * Set to true to report to your source provider the status of a build's start and completion. If you use this
     * option with a source provider other than GitHub, GitHub Enterprise, or Bitbucket, an
     * <code>invalidInputException</code> is thrown.
     * </p>
     * <p>
     * To be able to report the build status to the source provider, the user associated with the source provider must
     * have write access to the repo. If the user does not have write access, the build status cannot be updated. For
     * more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/access-tokens.html">Source
     * provider access</a> in the <i>CodeBuild User Guide</i>.
     * </p>
     * <note>
     * <p>
     * The status of a build triggered by a webhook is always reported to your source provider.
     * </p>
     * </note>
     * 
     * @return Set to true to report to your source provider the status of a build's start and completion. If you use
     *         this option with a source provider other than GitHub, GitHub Enterprise, or Bitbucket, an
     *         <code>invalidInputException</code> is thrown. </p>
     *         <p>
     *         To be able to report the build status to the source provider, the user associated with the source
     *         provider must have write access to the repo. If the user does not have write access, the build status
     *         cannot be updated. For more information, see <a
     *         href="https://docs.aws.amazon.com/codebuild/latest/userguide/access-tokens.html">Source provider
     *         access</a> in the <i>CodeBuild User Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         The status of a build triggered by a webhook is always reported to your source provider.
     *         </p>
     */
    public final Boolean reportBuildStatusOverride() {
        return reportBuildStatusOverride;
    }

    /**
     * <p>
     * Contains information that defines how the build project reports the build status to the source provider. This
     * option is only used when the source provider is <code>GITHUB</code>, <code>GITHUB_ENTERPRISE</code>, or
     * <code>BITBUCKET</code>.
     * </p>
     * 
     * @return Contains information that defines how the build project reports the build status to the source provider.
     *         This option is only used when the source provider is <code>GITHUB</code>, <code>GITHUB_ENTERPRISE</code>,
     *         or <code>BITBUCKET</code>.
     */
    public final BuildStatusConfig buildStatusConfigOverride() {
        return buildStatusConfigOverride;
    }

    /**
     * <p>
     * A container type for this build that overrides the one specified in the build project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #environmentTypeOverride} will return {@link EnvironmentType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #environmentTypeOverrideAsString}.
     * </p>
     * 
     * @return A container type for this build that overrides the one specified in the build project.
     * @see EnvironmentType
     */
    public final EnvironmentType environmentTypeOverride() {
        return EnvironmentType.fromValue(environmentTypeOverride);
    }

    /**
     * <p>
     * A container type for this build that overrides the one specified in the build project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #environmentTypeOverride} will return {@link EnvironmentType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #environmentTypeOverrideAsString}.
     * </p>
     * 
     * @return A container type for this build that overrides the one specified in the build project.
     * @see EnvironmentType
     */
    public final String environmentTypeOverrideAsString() {
        return environmentTypeOverride;
    }

    /**
     * <p>
     * The name of an image for this build that overrides the one specified in the build project.
     * </p>
     * 
     * @return The name of an image for this build that overrides the one specified in the build project.
     */
    public final String imageOverride() {
        return imageOverride;
    }

    /**
     * <p>
     * The name of a compute type for this build that overrides the one specified in the build project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #computeTypeOverride} will return {@link ComputeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #computeTypeOverrideAsString}.
     * </p>
     * 
     * @return The name of a compute type for this build that overrides the one specified in the build project.
     * @see ComputeType
     */
    public final ComputeType computeTypeOverride() {
        return ComputeType.fromValue(computeTypeOverride);
    }

    /**
     * <p>
     * The name of a compute type for this build that overrides the one specified in the build project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #computeTypeOverride} will return {@link ComputeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #computeTypeOverrideAsString}.
     * </p>
     * 
     * @return The name of a compute type for this build that overrides the one specified in the build project.
     * @see ComputeType
     */
    public final String computeTypeOverrideAsString() {
        return computeTypeOverride;
    }

    /**
     * <p>
     * The name of a certificate for this build that overrides the one specified in the build project.
     * </p>
     * 
     * @return The name of a certificate for this build that overrides the one specified in the build project.
     */
    public final String certificateOverride() {
        return certificateOverride;
    }

    /**
     * <p>
     * A ProjectCache object specified for this build that overrides the one defined in the build project.
     * </p>
     * 
     * @return A ProjectCache object specified for this build that overrides the one defined in the build project.
     */
    public final ProjectCache cacheOverride() {
        return cacheOverride;
    }

    /**
     * <p>
     * The name of a service role for this build that overrides the one specified in the build project.
     * </p>
     * 
     * @return The name of a service role for this build that overrides the one specified in the build project.
     */
    public final String serviceRoleOverride() {
        return serviceRoleOverride;
    }

    /**
     * <p>
     * Enable this flag to override privileged mode in the build project.
     * </p>
     * 
     * @return Enable this flag to override privileged mode in the build project.
     */
    public final Boolean privilegedModeOverride() {
        return privilegedModeOverride;
    }

    /**
     * <p>
     * The number of build timeout minutes, from 5 to 480 (8 hours), that overrides, for this build only, the latest
     * setting already defined in the build project.
     * </p>
     * 
     * @return The number of build timeout minutes, from 5 to 480 (8 hours), that overrides, for this build only, the
     *         latest setting already defined in the build project.
     */
    public final Integer timeoutInMinutesOverride() {
        return timeoutInMinutesOverride;
    }

    /**
     * <p>
     * The number of minutes a build is allowed to be queued before it times out.
     * </p>
     * 
     * @return The number of minutes a build is allowed to be queued before it times out.
     */
    public final Integer queuedTimeoutInMinutesOverride() {
        return queuedTimeoutInMinutesOverride;
    }

    /**
     * <p>
     * The Key Management Service customer master key (CMK) that overrides the one specified in the build project. The
     * CMK key encrypts the build output artifacts.
     * </p>
     * <note>
     * <p>
     * You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to
     * that key.
     * </p>
     * </note>
     * <p>
     * You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the
     * format <code>alias/&lt;alias-name&gt;</code>).
     * </p>
     * 
     * @return The Key Management Service customer master key (CMK) that overrides the one specified in the build
     *         project. The CMK key encrypts the build output artifacts.</p> <note>
     *         <p>
     *         You can use a cross-account KMS key to encrypt the build output artifacts if your service role has
     *         permission to that key.
     *         </p>
     *         </note>
     *         <p>
     *         You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using
     *         the format <code>alias/&lt;alias-name&gt;</code>).
     */
    public final String encryptionKeyOverride() {
        return encryptionKeyOverride;
    }

    /**
     * <p>
     * A unique, case sensitive identifier you provide to ensure the idempotency of the StartBuild request. The token is
     * included in the StartBuild request and is valid for 5 minutes. If you repeat the StartBuild request with the same
     * token, but change a parameter, CodeBuild returns a parameter mismatch error.
     * </p>
     * 
     * @return A unique, case sensitive identifier you provide to ensure the idempotency of the StartBuild request. The
     *         token is included in the StartBuild request and is valid for 5 minutes. If you repeat the StartBuild
     *         request with the same token, but change a parameter, CodeBuild returns a parameter mismatch error.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    /**
     * <p>
     * Log settings for this build that override the log settings defined in the build project.
     * </p>
     * 
     * @return Log settings for this build that override the log settings defined in the build project.
     */
    public final LogsConfig logsConfigOverride() {
        return logsConfigOverride;
    }

    /**
     * <p>
     * The credentials for access to a private registry.
     * </p>
     * 
     * @return The credentials for access to a private registry.
     */
    public final RegistryCredential registryCredentialOverride() {
        return registryCredentialOverride;
    }

    /**
     * <p>
     * The type of credentials CodeBuild uses to pull images in your build. There are two valid values:
     * </p>
     * <dl>
     * <dt>CODEBUILD</dt>
     * <dd>
     * <p>
     * Specifies that CodeBuild uses its own credentials. This requires that you modify your ECR repository policy to
     * trust CodeBuild's service principal.
     * </p>
     * </dd>
     * <dt>SERVICE_ROLE</dt>
     * <dd>
     * <p>
     * Specifies that CodeBuild uses your build project's service role.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * When using a cross-account or private registry image, you must use <code>SERVICE_ROLE</code> credentials. When
     * using an CodeBuild curated image, you must use <code>CODEBUILD</code> credentials.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imagePullCredentialsTypeOverride} will return {@link ImagePullCredentialsType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #imagePullCredentialsTypeOverrideAsString}.
     * </p>
     * 
     * @return The type of credentials CodeBuild uses to pull images in your build. There are two valid values: </p>
     *         <dl>
     *         <dt>CODEBUILD</dt>
     *         <dd>
     *         <p>
     *         Specifies that CodeBuild uses its own credentials. This requires that you modify your ECR repository
     *         policy to trust CodeBuild's service principal.
     *         </p>
     *         </dd>
     *         <dt>SERVICE_ROLE</dt>
     *         <dd>
     *         <p>
     *         Specifies that CodeBuild uses your build project's service role.
     *         </p>
     *         </dd>
     *         </dl>
     *         <p>
     *         When using a cross-account or private registry image, you must use <code>SERVICE_ROLE</code> credentials.
     *         When using an CodeBuild curated image, you must use <code>CODEBUILD</code> credentials.
     * @see ImagePullCredentialsType
     */
    public final ImagePullCredentialsType imagePullCredentialsTypeOverride() {
        return ImagePullCredentialsType.fromValue(imagePullCredentialsTypeOverride);
    }

    /**
     * <p>
     * The type of credentials CodeBuild uses to pull images in your build. There are two valid values:
     * </p>
     * <dl>
     * <dt>CODEBUILD</dt>
     * <dd>
     * <p>
     * Specifies that CodeBuild uses its own credentials. This requires that you modify your ECR repository policy to
     * trust CodeBuild's service principal.
     * </p>
     * </dd>
     * <dt>SERVICE_ROLE</dt>
     * <dd>
     * <p>
     * Specifies that CodeBuild uses your build project's service role.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * When using a cross-account or private registry image, you must use <code>SERVICE_ROLE</code> credentials. When
     * using an CodeBuild curated image, you must use <code>CODEBUILD</code> credentials.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imagePullCredentialsTypeOverride} will return {@link ImagePullCredentialsType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #imagePullCredentialsTypeOverrideAsString}.
     * </p>
     * 
     * @return The type of credentials CodeBuild uses to pull images in your build. There are two valid values: </p>
     *         <dl>
     *         <dt>CODEBUILD</dt>
     *         <dd>
     *         <p>
     *         Specifies that CodeBuild uses its own credentials. This requires that you modify your ECR repository
     *         policy to trust CodeBuild's service principal.
     *         </p>
     *         </dd>
     *         <dt>SERVICE_ROLE</dt>
     *         <dd>
     *         <p>
     *         Specifies that CodeBuild uses your build project's service role.
     *         </p>
     *         </dd>
     *         </dl>
     *         <p>
     *         When using a cross-account or private registry image, you must use <code>SERVICE_ROLE</code> credentials.
     *         When using an CodeBuild curated image, you must use <code>CODEBUILD</code> credentials.
     * @see ImagePullCredentialsType
     */
    public final String imagePullCredentialsTypeOverrideAsString() {
        return imagePullCredentialsTypeOverride;
    }

    /**
     * <p>
     * Specifies if session debugging is enabled for this build. For more information, see <a
     * href="https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html">Viewing a running build in
     * Session Manager</a>.
     * </p>
     * 
     * @return Specifies if session debugging is enabled for this build. For more information, see <a
     *         href="https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html">Viewing a running
     *         build in Session Manager</a>.
     */
    public final Boolean debugSessionEnabled() {
        return debugSessionEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecondarySourcesOverride() ? secondarySourcesOverride() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSecondarySourcesVersionOverride() ? secondarySourcesVersionOverride() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(artifactsOverride());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecondaryArtifactsOverride() ? secondaryArtifactsOverride() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentVariablesOverride() ? environmentVariablesOverride() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLocationOverride());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAuthOverride());
        hashCode = 31 * hashCode + Objects.hashCode(gitCloneDepthOverride());
        hashCode = 31 * hashCode + Objects.hashCode(gitSubmodulesConfigOverride());
        hashCode = 31 * hashCode + Objects.hashCode(buildspecOverride());
        hashCode = 31 * hashCode + Objects.hashCode(insecureSslOverride());
        hashCode = 31 * hashCode + Objects.hashCode(reportBuildStatusOverride());
        hashCode = 31 * hashCode + Objects.hashCode(buildStatusConfigOverride());
        hashCode = 31 * hashCode + Objects.hashCode(environmentTypeOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageOverride());
        hashCode = 31 * hashCode + Objects.hashCode(computeTypeOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(certificateOverride());
        hashCode = 31 * hashCode + Objects.hashCode(cacheOverride());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRoleOverride());
        hashCode = 31 * hashCode + Objects.hashCode(privilegedModeOverride());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInMinutesOverride());
        hashCode = 31 * hashCode + Objects.hashCode(queuedTimeoutInMinutesOverride());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyOverride());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(logsConfigOverride());
        hashCode = 31 * hashCode + Objects.hashCode(registryCredentialOverride());
        hashCode = 31 * hashCode + Objects.hashCode(imagePullCredentialsTypeOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(debugSessionEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBuildRequest)) {
            return false;
        }
        StartBuildRequest other = (StartBuildRequest) obj;
        return Objects.equals(projectName(), other.projectName())
                && hasSecondarySourcesOverride() == other.hasSecondarySourcesOverride()
                && Objects.equals(secondarySourcesOverride(), other.secondarySourcesOverride())
                && hasSecondarySourcesVersionOverride() == other.hasSecondarySourcesVersionOverride()
                && Objects.equals(secondarySourcesVersionOverride(), other.secondarySourcesVersionOverride())
                && Objects.equals(sourceVersion(), other.sourceVersion())
                && Objects.equals(artifactsOverride(), other.artifactsOverride())
                && hasSecondaryArtifactsOverride() == other.hasSecondaryArtifactsOverride()
                && Objects.equals(secondaryArtifactsOverride(), other.secondaryArtifactsOverride())
                && hasEnvironmentVariablesOverride() == other.hasEnvironmentVariablesOverride()
                && Objects.equals(environmentVariablesOverride(), other.environmentVariablesOverride())
                && Objects.equals(sourceTypeOverrideAsString(), other.sourceTypeOverrideAsString())
                && Objects.equals(sourceLocationOverride(), other.sourceLocationOverride())
                && Objects.equals(sourceAuthOverride(), other.sourceAuthOverride())
                && Objects.equals(gitCloneDepthOverride(), other.gitCloneDepthOverride())
                && Objects.equals(gitSubmodulesConfigOverride(), other.gitSubmodulesConfigOverride())
                && Objects.equals(buildspecOverride(), other.buildspecOverride())
                && Objects.equals(insecureSslOverride(), other.insecureSslOverride())
                && Objects.equals(reportBuildStatusOverride(), other.reportBuildStatusOverride())
                && Objects.equals(buildStatusConfigOverride(), other.buildStatusConfigOverride())
                && Objects.equals(environmentTypeOverrideAsString(), other.environmentTypeOverrideAsString())
                && Objects.equals(imageOverride(), other.imageOverride())
                && Objects.equals(computeTypeOverrideAsString(), other.computeTypeOverrideAsString())
                && Objects.equals(certificateOverride(), other.certificateOverride())
                && Objects.equals(cacheOverride(), other.cacheOverride())
                && Objects.equals(serviceRoleOverride(), other.serviceRoleOverride())
                && Objects.equals(privilegedModeOverride(), other.privilegedModeOverride())
                && Objects.equals(timeoutInMinutesOverride(), other.timeoutInMinutesOverride())
                && Objects.equals(queuedTimeoutInMinutesOverride(), other.queuedTimeoutInMinutesOverride())
                && Objects.equals(encryptionKeyOverride(), other.encryptionKeyOverride())
                && Objects.equals(idempotencyToken(), other.idempotencyToken())
                && Objects.equals(logsConfigOverride(), other.logsConfigOverride())
                && Objects.equals(registryCredentialOverride(), other.registryCredentialOverride())
                && Objects.equals(imagePullCredentialsTypeOverrideAsString(), other.imagePullCredentialsTypeOverrideAsString())
                && Objects.equals(debugSessionEnabled(), other.debugSessionEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("StartBuildRequest")
                .add("ProjectName", projectName())
                .add("SecondarySourcesOverride", hasSecondarySourcesOverride() ? secondarySourcesOverride() : null)
                .add("SecondarySourcesVersionOverride",
                        hasSecondarySourcesVersionOverride() ? secondarySourcesVersionOverride() : null)
                .add("SourceVersion", sourceVersion()).add("ArtifactsOverride", artifactsOverride())
                .add("SecondaryArtifactsOverride", hasSecondaryArtifactsOverride() ? secondaryArtifactsOverride() : null)
                .add("EnvironmentVariablesOverride", hasEnvironmentVariablesOverride() ? environmentVariablesOverride() : null)
                .add("SourceTypeOverride", sourceTypeOverrideAsString()).add("SourceLocationOverride", sourceLocationOverride())
                .add("SourceAuthOverride", sourceAuthOverride()).add("GitCloneDepthOverride", gitCloneDepthOverride())
                .add("GitSubmodulesConfigOverride", gitSubmodulesConfigOverride()).add("BuildspecOverride", buildspecOverride())
                .add("InsecureSslOverride", insecureSslOverride()).add("ReportBuildStatusOverride", reportBuildStatusOverride())
                .add("BuildStatusConfigOverride", buildStatusConfigOverride())
                .add("EnvironmentTypeOverride", environmentTypeOverrideAsString()).add("ImageOverride", imageOverride())
                .add("ComputeTypeOverride", computeTypeOverrideAsString()).add("CertificateOverride", certificateOverride())
                .add("CacheOverride", cacheOverride()).add("ServiceRoleOverride", serviceRoleOverride())
                .add("PrivilegedModeOverride", privilegedModeOverride())
                .add("TimeoutInMinutesOverride", timeoutInMinutesOverride())
                .add("QueuedTimeoutInMinutesOverride", queuedTimeoutInMinutesOverride())
                .add("EncryptionKeyOverride", encryptionKeyOverride()).add("IdempotencyToken", idempotencyToken())
                .add("LogsConfigOverride", logsConfigOverride()).add("RegistryCredentialOverride", registryCredentialOverride())
                .add("ImagePullCredentialsTypeOverride", imagePullCredentialsTypeOverrideAsString())
                .add("DebugSessionEnabled", debugSessionEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "secondarySourcesOverride":
            return Optional.ofNullable(clazz.cast(secondarySourcesOverride()));
        case "secondarySourcesVersionOverride":
            return Optional.ofNullable(clazz.cast(secondarySourcesVersionOverride()));
        case "sourceVersion":
            return Optional.ofNullable(clazz.cast(sourceVersion()));
        case "artifactsOverride":
            return Optional.ofNullable(clazz.cast(artifactsOverride()));
        case "secondaryArtifactsOverride":
            return Optional.ofNullable(clazz.cast(secondaryArtifactsOverride()));
        case "environmentVariablesOverride":
            return Optional.ofNullable(clazz.cast(environmentVariablesOverride()));
        case "sourceTypeOverride":
            return Optional.ofNullable(clazz.cast(sourceTypeOverrideAsString()));
        case "sourceLocationOverride":
            return Optional.ofNullable(clazz.cast(sourceLocationOverride()));
        case "sourceAuthOverride":
            return Optional.ofNullable(clazz.cast(sourceAuthOverride()));
        case "gitCloneDepthOverride":
            return Optional.ofNullable(clazz.cast(gitCloneDepthOverride()));
        case "gitSubmodulesConfigOverride":
            return Optional.ofNullable(clazz.cast(gitSubmodulesConfigOverride()));
        case "buildspecOverride":
            return Optional.ofNullable(clazz.cast(buildspecOverride()));
        case "insecureSslOverride":
            return Optional.ofNullable(clazz.cast(insecureSslOverride()));
        case "reportBuildStatusOverride":
            return Optional.ofNullable(clazz.cast(reportBuildStatusOverride()));
        case "buildStatusConfigOverride":
            return Optional.ofNullable(clazz.cast(buildStatusConfigOverride()));
        case "environmentTypeOverride":
            return Optional.ofNullable(clazz.cast(environmentTypeOverrideAsString()));
        case "imageOverride":
            return Optional.ofNullable(clazz.cast(imageOverride()));
        case "computeTypeOverride":
            return Optional.ofNullable(clazz.cast(computeTypeOverrideAsString()));
        case "certificateOverride":
            return Optional.ofNullable(clazz.cast(certificateOverride()));
        case "cacheOverride":
            return Optional.ofNullable(clazz.cast(cacheOverride()));
        case "serviceRoleOverride":
            return Optional.ofNullable(clazz.cast(serviceRoleOverride()));
        case "privilegedModeOverride":
            return Optional.ofNullable(clazz.cast(privilegedModeOverride()));
        case "timeoutInMinutesOverride":
            return Optional.ofNullable(clazz.cast(timeoutInMinutesOverride()));
        case "queuedTimeoutInMinutesOverride":
            return Optional.ofNullable(clazz.cast(queuedTimeoutInMinutesOverride()));
        case "encryptionKeyOverride":
            return Optional.ofNullable(clazz.cast(encryptionKeyOverride()));
        case "idempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        case "logsConfigOverride":
            return Optional.ofNullable(clazz.cast(logsConfigOverride()));
        case "registryCredentialOverride":
            return Optional.ofNullable(clazz.cast(registryCredentialOverride()));
        case "imagePullCredentialsTypeOverride":
            return Optional.ofNullable(clazz.cast(imagePullCredentialsTypeOverrideAsString()));
        case "debugSessionEnabled":
            return Optional.ofNullable(clazz.cast(debugSessionEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartBuildRequest, T> g) {
        return obj -> g.apply((StartBuildRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartBuildRequest> {
        /**
         * <p>
         * The name of the CodeBuild build project to start running a build.
         * </p>
         * 
         * @param projectName
         *        The name of the CodeBuild build project to start running a build.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * An array of <code>ProjectSource</code> objects.
         * </p>
         * 
         * @param secondarySourcesOverride
         *        An array of <code>ProjectSource</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySourcesOverride(Collection<ProjectSource> secondarySourcesOverride);

        /**
         * <p>
         * An array of <code>ProjectSource</code> objects.
         * </p>
         * 
         * @param secondarySourcesOverride
         *        An array of <code>ProjectSource</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySourcesOverride(ProjectSource... secondarySourcesOverride);

        /**
         * <p>
         * An array of <code>ProjectSource</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ProjectSource>.Builder} avoiding the
         * need to create one manually via {@link List<ProjectSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProjectSource>.Builder#build()} is called immediately and
         * its result is passed to {@link #secondarySourcesOverride(List<ProjectSource>)}.
         * 
         * @param secondarySourcesOverride
         *        a consumer that will call methods on {@link List<ProjectSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondarySourcesOverride(List<ProjectSource>)
         */
        Builder secondarySourcesOverride(Consumer<ProjectSource.Builder>... secondarySourcesOverride);

        /**
         * <p>
         * An array of <code>ProjectSourceVersion</code> objects that specify one or more versions of the project's
         * secondary sources to be used for this build only.
         * </p>
         * 
         * @param secondarySourcesVersionOverride
         *        An array of <code>ProjectSourceVersion</code> objects that specify one or more versions of the
         *        project's secondary sources to be used for this build only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySourcesVersionOverride(Collection<ProjectSourceVersion> secondarySourcesVersionOverride);

        /**
         * <p>
         * An array of <code>ProjectSourceVersion</code> objects that specify one or more versions of the project's
         * secondary sources to be used for this build only.
         * </p>
         * 
         * @param secondarySourcesVersionOverride
         *        An array of <code>ProjectSourceVersion</code> objects that specify one or more versions of the
         *        project's secondary sources to be used for this build only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySourcesVersionOverride(ProjectSourceVersion... secondarySourcesVersionOverride);

        /**
         * <p>
         * An array of <code>ProjectSourceVersion</code> objects that specify one or more versions of the project's
         * secondary sources to be used for this build only.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ProjectSourceVersion>.Builder}
         * avoiding the need to create one manually via {@link List<ProjectSourceVersion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProjectSourceVersion>.Builder#build()} is called immediately
         * and its result is passed to {@link #secondarySourcesVersionOverride(List<ProjectSourceVersion>)}.
         * 
         * @param secondarySourcesVersionOverride
         *        a consumer that will call methods on {@link List<ProjectSourceVersion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondarySourcesVersionOverride(List<ProjectSourceVersion>)
         */
        Builder secondarySourcesVersionOverride(Consumer<ProjectSourceVersion.Builder>... secondarySourcesVersionOverride);

        /**
         * <p>
         * The version of the build input to be built, for this build only. If not specified, the latest version is
         * used. If specified, the contents depends on the source provider:
         * </p>
         * <dl>
         * <dt>CodeCommit</dt>
         * <dd>
         * <p>
         * The commit ID, branch, or Git tag to use.
         * </p>
         * </dd>
         * <dt>GitHub</dt>
         * <dd>
         * <p>
         * The commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code
         * you want to build. If a pull request ID is specified, it must use the format <code>pr/pull-request-ID</code>
         * (for example <code>pr/25</code>). If a branch name is specified, the branch's HEAD commit ID is used. If not
         * specified, the default branch's HEAD commit ID is used.
         * </p>
         * </dd>
         * <dt>Bitbucket</dt>
         * <dd>
         * <p>
         * The commit ID, branch name, or tag name that corresponds to the version of the source code you want to build.
         * If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's
         * HEAD commit ID is used.
         * </p>
         * </dd>
         * <dt>Amazon S3</dt>
         * <dd>
         * <p>
         * The version ID of the object that represents the build input ZIP file to use.
         * </p>
         * </dd>
         * </dl>
         * <p>
         * If <code>sourceVersion</code> is specified at the project level, then this <code>sourceVersion</code> (at the
         * build level) takes precedence.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version
         * Sample with CodeBuild</a> in the <i>CodeBuild User Guide</i>.
         * </p>
         * 
         * @param sourceVersion
         *        The version of the build input to be built, for this build only. If not specified, the latest version
         *        is used. If specified, the contents depends on the source provider:</p>
         *        <dl>
         *        <dt>CodeCommit</dt>
         *        <dd>
         *        <p>
         *        The commit ID, branch, or Git tag to use.
         *        </p>
         *        </dd>
         *        <dt>GitHub</dt>
         *        <dd>
         *        <p>
         *        The commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source
         *        code you want to build. If a pull request ID is specified, it must use the format
         *        <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the
         *        branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
         *        </p>
         *        </dd>
         *        <dt>Bitbucket</dt>
         *        <dd>
         *        <p>
         *        The commit ID, branch name, or tag name that corresponds to the version of the source code you want to
         *        build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the
         *        default branch's HEAD commit ID is used.
         *        </p>
         *        </dd>
         *        <dt>Amazon S3</dt>
         *        <dd>
         *        <p>
         *        The version ID of the object that represents the build input ZIP file to use.
         *        </p>
         *        </dd>
         *        </dl>
         *        <p>
         *        If <code>sourceVersion</code> is specified at the project level, then this <code>sourceVersion</code>
         *        (at the build level) takes precedence.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source
         *        Version Sample with CodeBuild</a> in the <i>CodeBuild User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVersion(String sourceVersion);

        /**
         * <p>
         * Build output artifact settings that override, for this build only, the latest ones already defined in the
         * build project.
         * </p>
         * 
         * @param artifactsOverride
         *        Build output artifact settings that override, for this build only, the latest ones already defined in
         *        the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactsOverride(ProjectArtifacts artifactsOverride);

        /**
         * <p>
         * Build output artifact settings that override, for this build only, the latest ones already defined in the
         * build project.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProjectArtifacts.Builder} avoiding the
         * need to create one manually via {@link ProjectArtifacts#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProjectArtifacts.Builder#build()} is called immediately and its
         * result is passed to {@link #artifactsOverride(ProjectArtifacts)}.
         * 
         * @param artifactsOverride
         *        a consumer that will call methods on {@link ProjectArtifacts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #artifactsOverride(ProjectArtifacts)
         */
        default Builder artifactsOverride(Consumer<ProjectArtifacts.Builder> artifactsOverride) {
            return artifactsOverride(ProjectArtifacts.builder().applyMutation(artifactsOverride).build());
        }

        /**
         * <p>
         * An array of <code>ProjectArtifacts</code> objects.
         * </p>
         * 
         * @param secondaryArtifactsOverride
         *        An array of <code>ProjectArtifacts</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryArtifactsOverride(Collection<ProjectArtifacts> secondaryArtifactsOverride);

        /**
         * <p>
         * An array of <code>ProjectArtifacts</code> objects.
         * </p>
         * 
         * @param secondaryArtifactsOverride
         *        An array of <code>ProjectArtifacts</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryArtifactsOverride(ProjectArtifacts... secondaryArtifactsOverride);

        /**
         * <p>
         * An array of <code>ProjectArtifacts</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ProjectArtifacts>.Builder} avoiding
         * the need to create one manually via {@link List<ProjectArtifacts>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProjectArtifacts>.Builder#build()} is called immediately and
         * its result is passed to {@link #secondaryArtifactsOverride(List<ProjectArtifacts>)}.
         * 
         * @param secondaryArtifactsOverride
         *        a consumer that will call methods on {@link List<ProjectArtifacts>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondaryArtifactsOverride(List<ProjectArtifacts>)
         */
        Builder secondaryArtifactsOverride(Consumer<ProjectArtifacts.Builder>... secondaryArtifactsOverride);

        /**
         * <p>
         * A set of environment variables that overrides, for this build only, the latest ones already defined in the
         * build project.
         * </p>
         * 
         * @param environmentVariablesOverride
         *        A set of environment variables that overrides, for this build only, the latest ones already defined in
         *        the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVariablesOverride(Collection<EnvironmentVariable> environmentVariablesOverride);

        /**
         * <p>
         * A set of environment variables that overrides, for this build only, the latest ones already defined in the
         * build project.
         * </p>
         * 
         * @param environmentVariablesOverride
         *        A set of environment variables that overrides, for this build only, the latest ones already defined in
         *        the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVariablesOverride(EnvironmentVariable... environmentVariablesOverride);

        /**
         * <p>
         * A set of environment variables that overrides, for this build only, the latest ones already defined in the
         * build project.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<EnvironmentVariable>.Builder}
         * avoiding the need to create one manually via {@link List<EnvironmentVariable>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EnvironmentVariable>.Builder#build()} is called immediately
         * and its result is passed to {@link #environmentVariablesOverride(List<EnvironmentVariable>)}.
         * 
         * @param environmentVariablesOverride
         *        a consumer that will call methods on {@link List<EnvironmentVariable>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentVariablesOverride(List<EnvironmentVariable>)
         */
        Builder environmentVariablesOverride(Consumer<EnvironmentVariable.Builder>... environmentVariablesOverride);

        /**
         * <p>
         * A source input type, for this build, that overrides the source input defined in the build project.
         * </p>
         * 
         * @param sourceTypeOverride
         *        A source input type, for this build, that overrides the source input defined in the build project.
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder sourceTypeOverride(String sourceTypeOverride);

        /**
         * <p>
         * A source input type, for this build, that overrides the source input defined in the build project.
         * </p>
         * 
         * @param sourceTypeOverride
         *        A source input type, for this build, that overrides the source input defined in the build project.
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder sourceTypeOverride(SourceType sourceTypeOverride);

        /**
         * <p>
         * A location that overrides, for this build, the source location for the one defined in the build project.
         * </p>
         * 
         * @param sourceLocationOverride
         *        A location that overrides, for this build, the source location for the one defined in the build
         *        project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLocationOverride(String sourceLocationOverride);

        /**
         * <p>
         * An authorization type for this build that overrides the one defined in the build project. This override
         * applies only if the build project's source is BitBucket or GitHub.
         * </p>
         * 
         * @param sourceAuthOverride
         *        An authorization type for this build that overrides the one defined in the build project. This
         *        override applies only if the build project's source is BitBucket or GitHub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAuthOverride(SourceAuth sourceAuthOverride);

        /**
         * <p>
         * An authorization type for this build that overrides the one defined in the build project. This override
         * applies only if the build project's source is BitBucket or GitHub.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceAuth.Builder} avoiding the need to
         * create one manually via {@link SourceAuth#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceAuth.Builder#build()} is called immediately and its result
         * is passed to {@link #sourceAuthOverride(SourceAuth)}.
         * 
         * @param sourceAuthOverride
         *        a consumer that will call methods on {@link SourceAuth.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceAuthOverride(SourceAuth)
         */
        default Builder sourceAuthOverride(Consumer<SourceAuth.Builder> sourceAuthOverride) {
            return sourceAuthOverride(SourceAuth.builder().applyMutation(sourceAuthOverride).build());
        }

        /**
         * <p>
         * The user-defined depth of history, with a minimum value of 0, that overrides, for this build only, any
         * previous depth of history defined in the build project.
         * </p>
         * 
         * @param gitCloneDepthOverride
         *        The user-defined depth of history, with a minimum value of 0, that overrides, for this build only, any
         *        previous depth of history defined in the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitCloneDepthOverride(Integer gitCloneDepthOverride);

        /**
         * <p>
         * Information about the Git submodules configuration for this build of an CodeBuild build project.
         * </p>
         * 
         * @param gitSubmodulesConfigOverride
         *        Information about the Git submodules configuration for this build of an CodeBuild build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitSubmodulesConfigOverride(GitSubmodulesConfig gitSubmodulesConfigOverride);

        /**
         * <p>
         * Information about the Git submodules configuration for this build of an CodeBuild build project.
         * </p>
         * This is a convenience method that creates an instance of the {@link GitSubmodulesConfig.Builder} avoiding the
         * need to create one manually via {@link GitSubmodulesConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link GitSubmodulesConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #gitSubmodulesConfigOverride(GitSubmodulesConfig)}.
         * 
         * @param gitSubmodulesConfigOverride
         *        a consumer that will call methods on {@link GitSubmodulesConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gitSubmodulesConfigOverride(GitSubmodulesConfig)
         */
        default Builder gitSubmodulesConfigOverride(Consumer<GitSubmodulesConfig.Builder> gitSubmodulesConfigOverride) {
            return gitSubmodulesConfigOverride(GitSubmodulesConfig.builder().applyMutation(gitSubmodulesConfigOverride).build());
        }

        /**
         * <p>
         * A buildspec file declaration that overrides, for this build only, the latest one already defined in the build
         * project.
         * </p>
         * <p>
         * If this value is set, it can be either an inline buildspec definition, the path to an alternate buildspec
         * file relative to the value of the built-in <code>CODEBUILD_SRC_DIR</code> environment variable, or the path
         * to an S3 bucket. The bucket must be in the same Amazon Web Services Region as the build project. Specify the
         * buildspec file using its ARN (for example, <code>arn:aws:s3:::my-codebuild-sample2/buildspec.yml</code>). If
         * this value is not provided or is set to an empty string, the source code must contain a buildspec file in its
         * root directory. For more information, see <a href=
         * "https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage"
         * >Buildspec File Name and Storage Location</a>.
         * </p>
         * 
         * @param buildspecOverride
         *        A buildspec file declaration that overrides, for this build only, the latest one already defined in
         *        the build project.</p>
         *        <p>
         *        If this value is set, it can be either an inline buildspec definition, the path to an alternate
         *        buildspec file relative to the value of the built-in <code>CODEBUILD_SRC_DIR</code> environment
         *        variable, or the path to an S3 bucket. The bucket must be in the same Amazon Web Services Region as
         *        the build project. Specify the buildspec file using its ARN (for example,
         *        <code>arn:aws:s3:::my-codebuild-sample2/buildspec.yml</code>). If this value is not provided or is set
         *        to an empty string, the source code must contain a buildspec file in its root directory. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage"
         *        >Buildspec File Name and Storage Location</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildspecOverride(String buildspecOverride);

        /**
         * <p>
         * Enable this flag to override the insecure SSL setting that is specified in the build project. The insecure
         * SSL setting determines whether to ignore SSL warnings while connecting to the project source code. This
         * override applies only if the build's source is GitHub Enterprise.
         * </p>
         * 
         * @param insecureSslOverride
         *        Enable this flag to override the insecure SSL setting that is specified in the build project. The
         *        insecure SSL setting determines whether to ignore SSL warnings while connecting to the project source
         *        code. This override applies only if the build's source is GitHub Enterprise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insecureSslOverride(Boolean insecureSslOverride);

        /**
         * <p>
         * Set to true to report to your source provider the status of a build's start and completion. If you use this
         * option with a source provider other than GitHub, GitHub Enterprise, or Bitbucket, an
         * <code>invalidInputException</code> is thrown.
         * </p>
         * <p>
         * To be able to report the build status to the source provider, the user associated with the source provider
         * must have write access to the repo. If the user does not have write access, the build status cannot be
         * updated. For more information, see <a
         * href="https://docs.aws.amazon.com/codebuild/latest/userguide/access-tokens.html">Source provider access</a>
         * in the <i>CodeBuild User Guide</i>.
         * </p>
         * <note>
         * <p>
         * The status of a build triggered by a webhook is always reported to your source provider.
         * </p>
         * </note>
         * 
         * @param reportBuildStatusOverride
         *        Set to true to report to your source provider the status of a build's start and completion. If you use
         *        this option with a source provider other than GitHub, GitHub Enterprise, or Bitbucket, an
         *        <code>invalidInputException</code> is thrown. </p>
         *        <p>
         *        To be able to report the build status to the source provider, the user associated with the source
         *        provider must have write access to the repo. If the user does not have write access, the build status
         *        cannot be updated. For more information, see <a
         *        href="https://docs.aws.amazon.com/codebuild/latest/userguide/access-tokens.html">Source provider
         *        access</a> in the <i>CodeBuild User Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        The status of a build triggered by a webhook is always reported to your source provider.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportBuildStatusOverride(Boolean reportBuildStatusOverride);

        /**
         * <p>
         * Contains information that defines how the build project reports the build status to the source provider. This
         * option is only used when the source provider is <code>GITHUB</code>, <code>GITHUB_ENTERPRISE</code>, or
         * <code>BITBUCKET</code>.
         * </p>
         * 
         * @param buildStatusConfigOverride
         *        Contains information that defines how the build project reports the build status to the source
         *        provider. This option is only used when the source provider is <code>GITHUB</code>,
         *        <code>GITHUB_ENTERPRISE</code>, or <code>BITBUCKET</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildStatusConfigOverride(BuildStatusConfig buildStatusConfigOverride);

        /**
         * <p>
         * Contains information that defines how the build project reports the build status to the source provider. This
         * option is only used when the source provider is <code>GITHUB</code>, <code>GITHUB_ENTERPRISE</code>, or
         * <code>BITBUCKET</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link BuildStatusConfig.Builder} avoiding the
         * need to create one manually via {@link BuildStatusConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link BuildStatusConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #buildStatusConfigOverride(BuildStatusConfig)}.
         * 
         * @param buildStatusConfigOverride
         *        a consumer that will call methods on {@link BuildStatusConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #buildStatusConfigOverride(BuildStatusConfig)
         */
        default Builder buildStatusConfigOverride(Consumer<BuildStatusConfig.Builder> buildStatusConfigOverride) {
            return buildStatusConfigOverride(BuildStatusConfig.builder().applyMutation(buildStatusConfigOverride).build());
        }

        /**
         * <p>
         * A container type for this build that overrides the one specified in the build project.
         * </p>
         * 
         * @param environmentTypeOverride
         *        A container type for this build that overrides the one specified in the build project.
         * @see EnvironmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentType
         */
        Builder environmentTypeOverride(String environmentTypeOverride);

        /**
         * <p>
         * A container type for this build that overrides the one specified in the build project.
         * </p>
         * 
         * @param environmentTypeOverride
         *        A container type for this build that overrides the one specified in the build project.
         * @see EnvironmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentType
         */
        Builder environmentTypeOverride(EnvironmentType environmentTypeOverride);

        /**
         * <p>
         * The name of an image for this build that overrides the one specified in the build project.
         * </p>
         * 
         * @param imageOverride
         *        The name of an image for this build that overrides the one specified in the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageOverride(String imageOverride);

        /**
         * <p>
         * The name of a compute type for this build that overrides the one specified in the build project.
         * </p>
         * 
         * @param computeTypeOverride
         *        The name of a compute type for this build that overrides the one specified in the build project.
         * @see ComputeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeType
         */
        Builder computeTypeOverride(String computeTypeOverride);

        /**
         * <p>
         * The name of a compute type for this build that overrides the one specified in the build project.
         * </p>
         * 
         * @param computeTypeOverride
         *        The name of a compute type for this build that overrides the one specified in the build project.
         * @see ComputeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeType
         */
        Builder computeTypeOverride(ComputeType computeTypeOverride);

        /**
         * <p>
         * The name of a certificate for this build that overrides the one specified in the build project.
         * </p>
         * 
         * @param certificateOverride
         *        The name of a certificate for this build that overrides the one specified in the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateOverride(String certificateOverride);

        /**
         * <p>
         * A ProjectCache object specified for this build that overrides the one defined in the build project.
         * </p>
         * 
         * @param cacheOverride
         *        A ProjectCache object specified for this build that overrides the one defined in the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheOverride(ProjectCache cacheOverride);

        /**
         * <p>
         * A ProjectCache object specified for this build that overrides the one defined in the build project.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProjectCache.Builder} avoiding the need
         * to create one manually via {@link ProjectCache#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProjectCache.Builder#build()} is called immediately and its
         * result is passed to {@link #cacheOverride(ProjectCache)}.
         * 
         * @param cacheOverride
         *        a consumer that will call methods on {@link ProjectCache.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheOverride(ProjectCache)
         */
        default Builder cacheOverride(Consumer<ProjectCache.Builder> cacheOverride) {
            return cacheOverride(ProjectCache.builder().applyMutation(cacheOverride).build());
        }

        /**
         * <p>
         * The name of a service role for this build that overrides the one specified in the build project.
         * </p>
         * 
         * @param serviceRoleOverride
         *        The name of a service role for this build that overrides the one specified in the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleOverride(String serviceRoleOverride);

        /**
         * <p>
         * Enable this flag to override privileged mode in the build project.
         * </p>
         * 
         * @param privilegedModeOverride
         *        Enable this flag to override privileged mode in the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privilegedModeOverride(Boolean privilegedModeOverride);

        /**
         * <p>
         * The number of build timeout minutes, from 5 to 480 (8 hours), that overrides, for this build only, the latest
         * setting already defined in the build project.
         * </p>
         * 
         * @param timeoutInMinutesOverride
         *        The number of build timeout minutes, from 5 to 480 (8 hours), that overrides, for this build only, the
         *        latest setting already defined in the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInMinutesOverride(Integer timeoutInMinutesOverride);

        /**
         * <p>
         * The number of minutes a build is allowed to be queued before it times out.
         * </p>
         * 
         * @param queuedTimeoutInMinutesOverride
         *        The number of minutes a build is allowed to be queued before it times out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queuedTimeoutInMinutesOverride(Integer queuedTimeoutInMinutesOverride);

        /**
         * <p>
         * The Key Management Service customer master key (CMK) that overrides the one specified in the build project.
         * The CMK key encrypts the build output artifacts.
         * </p>
         * <note>
         * <p>
         * You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission
         * to that key.
         * </p>
         * </note>
         * <p>
         * You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the
         * format <code>alias/&lt;alias-name&gt;</code>).
         * </p>
         * 
         * @param encryptionKeyOverride
         *        The Key Management Service customer master key (CMK) that overrides the one specified in the build
         *        project. The CMK key encrypts the build output artifacts.</p> <note>
         *        <p>
         *        You can use a cross-account KMS key to encrypt the build output artifacts if your service role has
         *        permission to that key.
         *        </p>
         *        </note>
         *        <p>
         *        You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias
         *        (using the format <code>alias/&lt;alias-name&gt;</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyOverride(String encryptionKeyOverride);

        /**
         * <p>
         * A unique, case sensitive identifier you provide to ensure the idempotency of the StartBuild request. The
         * token is included in the StartBuild request and is valid for 5 minutes. If you repeat the StartBuild request
         * with the same token, but change a parameter, CodeBuild returns a parameter mismatch error.
         * </p>
         * 
         * @param idempotencyToken
         *        A unique, case sensitive identifier you provide to ensure the idempotency of the StartBuild request.
         *        The token is included in the StartBuild request and is valid for 5 minutes. If you repeat the
         *        StartBuild request with the same token, but change a parameter, CodeBuild returns a parameter mismatch
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        /**
         * <p>
         * Log settings for this build that override the log settings defined in the build project.
         * </p>
         * 
         * @param logsConfigOverride
         *        Log settings for this build that override the log settings defined in the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logsConfigOverride(LogsConfig logsConfigOverride);

        /**
         * <p>
         * Log settings for this build that override the log settings defined in the build project.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogsConfig.Builder} avoiding the need to
         * create one manually via {@link LogsConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link LogsConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #logsConfigOverride(LogsConfig)}.
         * 
         * @param logsConfigOverride
         *        a consumer that will call methods on {@link LogsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logsConfigOverride(LogsConfig)
         */
        default Builder logsConfigOverride(Consumer<LogsConfig.Builder> logsConfigOverride) {
            return logsConfigOverride(LogsConfig.builder().applyMutation(logsConfigOverride).build());
        }

        /**
         * <p>
         * The credentials for access to a private registry.
         * </p>
         * 
         * @param registryCredentialOverride
         *        The credentials for access to a private registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryCredentialOverride(RegistryCredential registryCredentialOverride);

        /**
         * <p>
         * The credentials for access to a private registry.
         * </p>
         * This is a convenience method that creates an instance of the {@link RegistryCredential.Builder} avoiding the
         * need to create one manually via {@link RegistryCredential#builder()}.
         *
         * When the {@link Consumer} completes, {@link RegistryCredential.Builder#build()} is called immediately and its
         * result is passed to {@link #registryCredentialOverride(RegistryCredential)}.
         * 
         * @param registryCredentialOverride
         *        a consumer that will call methods on {@link RegistryCredential.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registryCredentialOverride(RegistryCredential)
         */
        default Builder registryCredentialOverride(Consumer<RegistryCredential.Builder> registryCredentialOverride) {
            return registryCredentialOverride(RegistryCredential.builder().applyMutation(registryCredentialOverride).build());
        }

        /**
         * <p>
         * The type of credentials CodeBuild uses to pull images in your build. There are two valid values:
         * </p>
         * <dl>
         * <dt>CODEBUILD</dt>
         * <dd>
         * <p>
         * Specifies that CodeBuild uses its own credentials. This requires that you modify your ECR repository policy
         * to trust CodeBuild's service principal.
         * </p>
         * </dd>
         * <dt>SERVICE_ROLE</dt>
         * <dd>
         * <p>
         * Specifies that CodeBuild uses your build project's service role.
         * </p>
         * </dd>
         * </dl>
         * <p>
         * When using a cross-account or private registry image, you must use <code>SERVICE_ROLE</code> credentials.
         * When using an CodeBuild curated image, you must use <code>CODEBUILD</code> credentials.
         * </p>
         * 
         * @param imagePullCredentialsTypeOverride
         *        The type of credentials CodeBuild uses to pull images in your build. There are two valid values: </p>
         *        <dl>
         *        <dt>CODEBUILD</dt>
         *        <dd>
         *        <p>
         *        Specifies that CodeBuild uses its own credentials. This requires that you modify your ECR repository
         *        policy to trust CodeBuild's service principal.
         *        </p>
         *        </dd>
         *        <dt>SERVICE_ROLE</dt>
         *        <dd>
         *        <p>
         *        Specifies that CodeBuild uses your build project's service role.
         *        </p>
         *        </dd>
         *        </dl>
         *        <p>
         *        When using a cross-account or private registry image, you must use <code>SERVICE_ROLE</code>
         *        credentials. When using an CodeBuild curated image, you must use <code>CODEBUILD</code> credentials.
         * @see ImagePullCredentialsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImagePullCredentialsType
         */
        Builder imagePullCredentialsTypeOverride(String imagePullCredentialsTypeOverride);

        /**
         * <p>
         * The type of credentials CodeBuild uses to pull images in your build. There are two valid values:
         * </p>
         * <dl>
         * <dt>CODEBUILD</dt>
         * <dd>
         * <p>
         * Specifies that CodeBuild uses its own credentials. This requires that you modify your ECR repository policy
         * to trust CodeBuild's service principal.
         * </p>
         * </dd>
         * <dt>SERVICE_ROLE</dt>
         * <dd>
         * <p>
         * Specifies that CodeBuild uses your build project's service role.
         * </p>
         * </dd>
         * </dl>
         * <p>
         * When using a cross-account or private registry image, you must use <code>SERVICE_ROLE</code> credentials.
         * When using an CodeBuild curated image, you must use <code>CODEBUILD</code> credentials.
         * </p>
         * 
         * @param imagePullCredentialsTypeOverride
         *        The type of credentials CodeBuild uses to pull images in your build. There are two valid values: </p>
         *        <dl>
         *        <dt>CODEBUILD</dt>
         *        <dd>
         *        <p>
         *        Specifies that CodeBuild uses its own credentials. This requires that you modify your ECR repository
         *        policy to trust CodeBuild's service principal.
         *        </p>
         *        </dd>
         *        <dt>SERVICE_ROLE</dt>
         *        <dd>
         *        <p>
         *        Specifies that CodeBuild uses your build project's service role.
         *        </p>
         *        </dd>
         *        </dl>
         *        <p>
         *        When using a cross-account or private registry image, you must use <code>SERVICE_ROLE</code>
         *        credentials. When using an CodeBuild curated image, you must use <code>CODEBUILD</code> credentials.
         * @see ImagePullCredentialsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImagePullCredentialsType
         */
        Builder imagePullCredentialsTypeOverride(ImagePullCredentialsType imagePullCredentialsTypeOverride);

        /**
         * <p>
         * Specifies if session debugging is enabled for this build. For more information, see <a
         * href="https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html">Viewing a running build in
         * Session Manager</a>.
         * </p>
         * 
         * @param debugSessionEnabled
         *        Specifies if session debugging is enabled for this build. For more information, see <a
         *        href="https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html">Viewing a running
         *        build in Session Manager</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder debugSessionEnabled(Boolean debugSessionEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeBuildRequest.BuilderImpl implements Builder {
        private String projectName;

        private List<ProjectSource> secondarySourcesOverride = DefaultSdkAutoConstructList.getInstance();

        private List<ProjectSourceVersion> secondarySourcesVersionOverride = DefaultSdkAutoConstructList.getInstance();

        private String sourceVersion;

        private ProjectArtifacts artifactsOverride;

        private List<ProjectArtifacts> secondaryArtifactsOverride = DefaultSdkAutoConstructList.getInstance();

        private List<EnvironmentVariable> environmentVariablesOverride = DefaultSdkAutoConstructList.getInstance();

        private String sourceTypeOverride;

        private String sourceLocationOverride;

        private SourceAuth sourceAuthOverride;

        private Integer gitCloneDepthOverride;

        private GitSubmodulesConfig gitSubmodulesConfigOverride;

        private String buildspecOverride;

        private Boolean insecureSslOverride;

        private Boolean reportBuildStatusOverride;

        private BuildStatusConfig buildStatusConfigOverride;

        private String environmentTypeOverride;

        private String imageOverride;

        private String computeTypeOverride;

        private String certificateOverride;

        private ProjectCache cacheOverride;

        private String serviceRoleOverride;

        private Boolean privilegedModeOverride;

        private Integer timeoutInMinutesOverride;

        private Integer queuedTimeoutInMinutesOverride;

        private String encryptionKeyOverride;

        private String idempotencyToken;

        private LogsConfig logsConfigOverride;

        private RegistryCredential registryCredentialOverride;

        private String imagePullCredentialsTypeOverride;

        private Boolean debugSessionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(StartBuildRequest model) {
            super(model);
            projectName(model.projectName);
            secondarySourcesOverride(model.secondarySourcesOverride);
            secondarySourcesVersionOverride(model.secondarySourcesVersionOverride);
            sourceVersion(model.sourceVersion);
            artifactsOverride(model.artifactsOverride);
            secondaryArtifactsOverride(model.secondaryArtifactsOverride);
            environmentVariablesOverride(model.environmentVariablesOverride);
            sourceTypeOverride(model.sourceTypeOverride);
            sourceLocationOverride(model.sourceLocationOverride);
            sourceAuthOverride(model.sourceAuthOverride);
            gitCloneDepthOverride(model.gitCloneDepthOverride);
            gitSubmodulesConfigOverride(model.gitSubmodulesConfigOverride);
            buildspecOverride(model.buildspecOverride);
            insecureSslOverride(model.insecureSslOverride);
            reportBuildStatusOverride(model.reportBuildStatusOverride);
            buildStatusConfigOverride(model.buildStatusConfigOverride);
            environmentTypeOverride(model.environmentTypeOverride);
            imageOverride(model.imageOverride);
            computeTypeOverride(model.computeTypeOverride);
            certificateOverride(model.certificateOverride);
            cacheOverride(model.cacheOverride);
            serviceRoleOverride(model.serviceRoleOverride);
            privilegedModeOverride(model.privilegedModeOverride);
            timeoutInMinutesOverride(model.timeoutInMinutesOverride);
            queuedTimeoutInMinutesOverride(model.queuedTimeoutInMinutesOverride);
            encryptionKeyOverride(model.encryptionKeyOverride);
            idempotencyToken(model.idempotencyToken);
            logsConfigOverride(model.logsConfigOverride);
            registryCredentialOverride(model.registryCredentialOverride);
            imagePullCredentialsTypeOverride(model.imagePullCredentialsTypeOverride);
            debugSessionEnabled(model.debugSessionEnabled);
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final List<ProjectSource.Builder> getSecondarySourcesOverride() {
            List<ProjectSource.Builder> result = ProjectSourcesCopier.copyToBuilder(this.secondarySourcesOverride);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondarySourcesOverride(Collection<ProjectSource.BuilderImpl> secondarySourcesOverride) {
            this.secondarySourcesOverride = ProjectSourcesCopier.copyFromBuilder(secondarySourcesOverride);
        }

        @Override
        public final Builder secondarySourcesOverride(Collection<ProjectSource> secondarySourcesOverride) {
            this.secondarySourcesOverride = ProjectSourcesCopier.copy(secondarySourcesOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourcesOverride(ProjectSource... secondarySourcesOverride) {
            secondarySourcesOverride(Arrays.asList(secondarySourcesOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourcesOverride(Consumer<ProjectSource.Builder>... secondarySourcesOverride) {
            secondarySourcesOverride(Stream.of(secondarySourcesOverride)
                    .map(c -> ProjectSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ProjectSourceVersion.Builder> getSecondarySourcesVersionOverride() {
            List<ProjectSourceVersion.Builder> result = ProjectSecondarySourceVersionsCopier
                    .copyToBuilder(this.secondarySourcesVersionOverride);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondarySourcesVersionOverride(
                Collection<ProjectSourceVersion.BuilderImpl> secondarySourcesVersionOverride) {
            this.secondarySourcesVersionOverride = ProjectSecondarySourceVersionsCopier
                    .copyFromBuilder(secondarySourcesVersionOverride);
        }

        @Override
        public final Builder secondarySourcesVersionOverride(Collection<ProjectSourceVersion> secondarySourcesVersionOverride) {
            this.secondarySourcesVersionOverride = ProjectSecondarySourceVersionsCopier.copy(secondarySourcesVersionOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourcesVersionOverride(ProjectSourceVersion... secondarySourcesVersionOverride) {
            secondarySourcesVersionOverride(Arrays.asList(secondarySourcesVersionOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourcesVersionOverride(
                Consumer<ProjectSourceVersion.Builder>... secondarySourcesVersionOverride) {
            secondarySourcesVersionOverride(Stream.of(secondarySourcesVersionOverride)
                    .map(c -> ProjectSourceVersion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSourceVersion() {
            return sourceVersion;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final ProjectArtifacts.Builder getArtifactsOverride() {
            return artifactsOverride != null ? artifactsOverride.toBuilder() : null;
        }

        public final void setArtifactsOverride(ProjectArtifacts.BuilderImpl artifactsOverride) {
            this.artifactsOverride = artifactsOverride != null ? artifactsOverride.build() : null;
        }

        @Override
        public final Builder artifactsOverride(ProjectArtifacts artifactsOverride) {
            this.artifactsOverride = artifactsOverride;
            return this;
        }

        public final List<ProjectArtifacts.Builder> getSecondaryArtifactsOverride() {
            List<ProjectArtifacts.Builder> result = ProjectArtifactsListCopier.copyToBuilder(this.secondaryArtifactsOverride);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondaryArtifactsOverride(Collection<ProjectArtifacts.BuilderImpl> secondaryArtifactsOverride) {
            this.secondaryArtifactsOverride = ProjectArtifactsListCopier.copyFromBuilder(secondaryArtifactsOverride);
        }

        @Override
        public final Builder secondaryArtifactsOverride(Collection<ProjectArtifacts> secondaryArtifactsOverride) {
            this.secondaryArtifactsOverride = ProjectArtifactsListCopier.copy(secondaryArtifactsOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryArtifactsOverride(ProjectArtifacts... secondaryArtifactsOverride) {
            secondaryArtifactsOverride(Arrays.asList(secondaryArtifactsOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryArtifactsOverride(Consumer<ProjectArtifacts.Builder>... secondaryArtifactsOverride) {
            secondaryArtifactsOverride(Stream.of(secondaryArtifactsOverride)
                    .map(c -> ProjectArtifacts.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EnvironmentVariable.Builder> getEnvironmentVariablesOverride() {
            List<EnvironmentVariable.Builder> result = EnvironmentVariablesCopier
                    .copyToBuilder(this.environmentVariablesOverride);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentVariablesOverride(Collection<EnvironmentVariable.BuilderImpl> environmentVariablesOverride) {
            this.environmentVariablesOverride = EnvironmentVariablesCopier.copyFromBuilder(environmentVariablesOverride);
        }

        @Override
        public final Builder environmentVariablesOverride(Collection<EnvironmentVariable> environmentVariablesOverride) {
            this.environmentVariablesOverride = EnvironmentVariablesCopier.copy(environmentVariablesOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVariablesOverride(EnvironmentVariable... environmentVariablesOverride) {
            environmentVariablesOverride(Arrays.asList(environmentVariablesOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVariablesOverride(Consumer<EnvironmentVariable.Builder>... environmentVariablesOverride) {
            environmentVariablesOverride(Stream.of(environmentVariablesOverride)
                    .map(c -> EnvironmentVariable.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSourceTypeOverride() {
            return sourceTypeOverride;
        }

        public final void setSourceTypeOverride(String sourceTypeOverride) {
            this.sourceTypeOverride = sourceTypeOverride;
        }

        @Override
        public final Builder sourceTypeOverride(String sourceTypeOverride) {
            this.sourceTypeOverride = sourceTypeOverride;
            return this;
        }

        @Override
        public final Builder sourceTypeOverride(SourceType sourceTypeOverride) {
            this.sourceTypeOverride(sourceTypeOverride == null ? null : sourceTypeOverride.toString());
            return this;
        }

        public final String getSourceLocationOverride() {
            return sourceLocationOverride;
        }

        public final void setSourceLocationOverride(String sourceLocationOverride) {
            this.sourceLocationOverride = sourceLocationOverride;
        }

        @Override
        public final Builder sourceLocationOverride(String sourceLocationOverride) {
            this.sourceLocationOverride = sourceLocationOverride;
            return this;
        }

        public final SourceAuth.Builder getSourceAuthOverride() {
            return sourceAuthOverride != null ? sourceAuthOverride.toBuilder() : null;
        }

        public final void setSourceAuthOverride(SourceAuth.BuilderImpl sourceAuthOverride) {
            this.sourceAuthOverride = sourceAuthOverride != null ? sourceAuthOverride.build() : null;
        }

        @Override
        public final Builder sourceAuthOverride(SourceAuth sourceAuthOverride) {
            this.sourceAuthOverride = sourceAuthOverride;
            return this;
        }

        public final Integer getGitCloneDepthOverride() {
            return gitCloneDepthOverride;
        }

        public final void setGitCloneDepthOverride(Integer gitCloneDepthOverride) {
            this.gitCloneDepthOverride = gitCloneDepthOverride;
        }

        @Override
        public final Builder gitCloneDepthOverride(Integer gitCloneDepthOverride) {
            this.gitCloneDepthOverride = gitCloneDepthOverride;
            return this;
        }

        public final GitSubmodulesConfig.Builder getGitSubmodulesConfigOverride() {
            return gitSubmodulesConfigOverride != null ? gitSubmodulesConfigOverride.toBuilder() : null;
        }

        public final void setGitSubmodulesConfigOverride(GitSubmodulesConfig.BuilderImpl gitSubmodulesConfigOverride) {
            this.gitSubmodulesConfigOverride = gitSubmodulesConfigOverride != null ? gitSubmodulesConfigOverride.build() : null;
        }

        @Override
        public final Builder gitSubmodulesConfigOverride(GitSubmodulesConfig gitSubmodulesConfigOverride) {
            this.gitSubmodulesConfigOverride = gitSubmodulesConfigOverride;
            return this;
        }

        public final String getBuildspecOverride() {
            return buildspecOverride;
        }

        public final void setBuildspecOverride(String buildspecOverride) {
            this.buildspecOverride = buildspecOverride;
        }

        @Override
        public final Builder buildspecOverride(String buildspecOverride) {
            this.buildspecOverride = buildspecOverride;
            return this;
        }

        public final Boolean getInsecureSslOverride() {
            return insecureSslOverride;
        }

        public final void setInsecureSslOverride(Boolean insecureSslOverride) {
            this.insecureSslOverride = insecureSslOverride;
        }

        @Override
        public final Builder insecureSslOverride(Boolean insecureSslOverride) {
            this.insecureSslOverride = insecureSslOverride;
            return this;
        }

        public final Boolean getReportBuildStatusOverride() {
            return reportBuildStatusOverride;
        }

        public final void setReportBuildStatusOverride(Boolean reportBuildStatusOverride) {
            this.reportBuildStatusOverride = reportBuildStatusOverride;
        }

        @Override
        public final Builder reportBuildStatusOverride(Boolean reportBuildStatusOverride) {
            this.reportBuildStatusOverride = reportBuildStatusOverride;
            return this;
        }

        public final BuildStatusConfig.Builder getBuildStatusConfigOverride() {
            return buildStatusConfigOverride != null ? buildStatusConfigOverride.toBuilder() : null;
        }

        public final void setBuildStatusConfigOverride(BuildStatusConfig.BuilderImpl buildStatusConfigOverride) {
            this.buildStatusConfigOverride = buildStatusConfigOverride != null ? buildStatusConfigOverride.build() : null;
        }

        @Override
        public final Builder buildStatusConfigOverride(BuildStatusConfig buildStatusConfigOverride) {
            this.buildStatusConfigOverride = buildStatusConfigOverride;
            return this;
        }

        public final String getEnvironmentTypeOverride() {
            return environmentTypeOverride;
        }

        public final void setEnvironmentTypeOverride(String environmentTypeOverride) {
            this.environmentTypeOverride = environmentTypeOverride;
        }

        @Override
        public final Builder environmentTypeOverride(String environmentTypeOverride) {
            this.environmentTypeOverride = environmentTypeOverride;
            return this;
        }

        @Override
        public final Builder environmentTypeOverride(EnvironmentType environmentTypeOverride) {
            this.environmentTypeOverride(environmentTypeOverride == null ? null : environmentTypeOverride.toString());
            return this;
        }

        public final String getImageOverride() {
            return imageOverride;
        }

        public final void setImageOverride(String imageOverride) {
            this.imageOverride = imageOverride;
        }

        @Override
        public final Builder imageOverride(String imageOverride) {
            this.imageOverride = imageOverride;
            return this;
        }

        public final String getComputeTypeOverride() {
            return computeTypeOverride;
        }

        public final void setComputeTypeOverride(String computeTypeOverride) {
            this.computeTypeOverride = computeTypeOverride;
        }

        @Override
        public final Builder computeTypeOverride(String computeTypeOverride) {
            this.computeTypeOverride = computeTypeOverride;
            return this;
        }

        @Override
        public final Builder computeTypeOverride(ComputeType computeTypeOverride) {
            this.computeTypeOverride(computeTypeOverride == null ? null : computeTypeOverride.toString());
            return this;
        }

        public final String getCertificateOverride() {
            return certificateOverride;
        }

        public final void setCertificateOverride(String certificateOverride) {
            this.certificateOverride = certificateOverride;
        }

        @Override
        public final Builder certificateOverride(String certificateOverride) {
            this.certificateOverride = certificateOverride;
            return this;
        }

        public final ProjectCache.Builder getCacheOverride() {
            return cacheOverride != null ? cacheOverride.toBuilder() : null;
        }

        public final void setCacheOverride(ProjectCache.BuilderImpl cacheOverride) {
            this.cacheOverride = cacheOverride != null ? cacheOverride.build() : null;
        }

        @Override
        public final Builder cacheOverride(ProjectCache cacheOverride) {
            this.cacheOverride = cacheOverride;
            return this;
        }

        public final String getServiceRoleOverride() {
            return serviceRoleOverride;
        }

        public final void setServiceRoleOverride(String serviceRoleOverride) {
            this.serviceRoleOverride = serviceRoleOverride;
        }

        @Override
        public final Builder serviceRoleOverride(String serviceRoleOverride) {
            this.serviceRoleOverride = serviceRoleOverride;
            return this;
        }

        public final Boolean getPrivilegedModeOverride() {
            return privilegedModeOverride;
        }

        public final void setPrivilegedModeOverride(Boolean privilegedModeOverride) {
            this.privilegedModeOverride = privilegedModeOverride;
        }

        @Override
        public final Builder privilegedModeOverride(Boolean privilegedModeOverride) {
            this.privilegedModeOverride = privilegedModeOverride;
            return this;
        }

        public final Integer getTimeoutInMinutesOverride() {
            return timeoutInMinutesOverride;
        }

        public final void setTimeoutInMinutesOverride(Integer timeoutInMinutesOverride) {
            this.timeoutInMinutesOverride = timeoutInMinutesOverride;
        }

        @Override
        public final Builder timeoutInMinutesOverride(Integer timeoutInMinutesOverride) {
            this.timeoutInMinutesOverride = timeoutInMinutesOverride;
            return this;
        }

        public final Integer getQueuedTimeoutInMinutesOverride() {
            return queuedTimeoutInMinutesOverride;
        }

        public final void setQueuedTimeoutInMinutesOverride(Integer queuedTimeoutInMinutesOverride) {
            this.queuedTimeoutInMinutesOverride = queuedTimeoutInMinutesOverride;
        }

        @Override
        public final Builder queuedTimeoutInMinutesOverride(Integer queuedTimeoutInMinutesOverride) {
            this.queuedTimeoutInMinutesOverride = queuedTimeoutInMinutesOverride;
            return this;
        }

        public final String getEncryptionKeyOverride() {
            return encryptionKeyOverride;
        }

        public final void setEncryptionKeyOverride(String encryptionKeyOverride) {
            this.encryptionKeyOverride = encryptionKeyOverride;
        }

        @Override
        public final Builder encryptionKeyOverride(String encryptionKeyOverride) {
            this.encryptionKeyOverride = encryptionKeyOverride;
            return this;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final LogsConfig.Builder getLogsConfigOverride() {
            return logsConfigOverride != null ? logsConfigOverride.toBuilder() : null;
        }

        public final void setLogsConfigOverride(LogsConfig.BuilderImpl logsConfigOverride) {
            this.logsConfigOverride = logsConfigOverride != null ? logsConfigOverride.build() : null;
        }

        @Override
        public final Builder logsConfigOverride(LogsConfig logsConfigOverride) {
            this.logsConfigOverride = logsConfigOverride;
            return this;
        }

        public final RegistryCredential.Builder getRegistryCredentialOverride() {
            return registryCredentialOverride != null ? registryCredentialOverride.toBuilder() : null;
        }

        public final void setRegistryCredentialOverride(RegistryCredential.BuilderImpl registryCredentialOverride) {
            this.registryCredentialOverride = registryCredentialOverride != null ? registryCredentialOverride.build() : null;
        }

        @Override
        public final Builder registryCredentialOverride(RegistryCredential registryCredentialOverride) {
            this.registryCredentialOverride = registryCredentialOverride;
            return this;
        }

        public final String getImagePullCredentialsTypeOverride() {
            return imagePullCredentialsTypeOverride;
        }

        public final void setImagePullCredentialsTypeOverride(String imagePullCredentialsTypeOverride) {
            this.imagePullCredentialsTypeOverride = imagePullCredentialsTypeOverride;
        }

        @Override
        public final Builder imagePullCredentialsTypeOverride(String imagePullCredentialsTypeOverride) {
            this.imagePullCredentialsTypeOverride = imagePullCredentialsTypeOverride;
            return this;
        }

        @Override
        public final Builder imagePullCredentialsTypeOverride(ImagePullCredentialsType imagePullCredentialsTypeOverride) {
            this.imagePullCredentialsTypeOverride(imagePullCredentialsTypeOverride == null ? null
                    : imagePullCredentialsTypeOverride.toString());
            return this;
        }

        public final Boolean getDebugSessionEnabled() {
            return debugSessionEnabled;
        }

        public final void setDebugSessionEnabled(Boolean debugSessionEnabled) {
            this.debugSessionEnabled = debugSessionEnabled;
        }

        @Override
        public final Builder debugSessionEnabled(Boolean debugSessionEnabled) {
            this.debugSessionEnabled = debugSessionEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartBuildRequest build() {
            return new StartBuildRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
