/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateReportGroupResponse extends CodeBuildResponse implements
        ToCopyableBuilder<UpdateReportGroupResponse.Builder, UpdateReportGroupResponse> {
    private static final SdkField<ReportGroup> REPORT_GROUP_FIELD = SdkField.<ReportGroup> builder(MarshallingType.SDK_POJO)
            .memberName("reportGroup").getter(getter(UpdateReportGroupResponse::reportGroup))
            .setter(setter(Builder::reportGroup)).constructor(ReportGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_GROUP_FIELD));

    private final ReportGroup reportGroup;

    private UpdateReportGroupResponse(BuilderImpl builder) {
        super(builder);
        this.reportGroup = builder.reportGroup;
    }

    /**
     * <p>
     * Information about the updated report group.
     * </p>
     * 
     * @return Information about the updated report group.
     */
    public final ReportGroup reportGroup() {
        return reportGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reportGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReportGroupResponse)) {
            return false;
        }
        UpdateReportGroupResponse other = (UpdateReportGroupResponse) obj;
        return Objects.equals(reportGroup(), other.reportGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateReportGroupResponse").add("ReportGroup", reportGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reportGroup":
            return Optional.ofNullable(clazz.cast(reportGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateReportGroupResponse, T> g) {
        return obj -> g.apply((UpdateReportGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateReportGroupResponse> {
        /**
         * <p>
         * Information about the updated report group.
         * </p>
         * 
         * @param reportGroup
         *        Information about the updated report group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportGroup(ReportGroup reportGroup);

        /**
         * <p>
         * Information about the updated report group.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportGroup.Builder} avoiding the need to
         * create one manually via {@link ReportGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReportGroup.Builder#build()} is called immediately and its result
         * is passed to {@link #reportGroup(ReportGroup)}.
         * 
         * @param reportGroup
         *        a consumer that will call methods on {@link ReportGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportGroup(ReportGroup)
         */
        default Builder reportGroup(Consumer<ReportGroup.Builder> reportGroup) {
            return reportGroup(ReportGroup.builder().applyMutation(reportGroup).build());
        }
    }

    static final class BuilderImpl extends CodeBuildResponse.BuilderImpl implements Builder {
        private ReportGroup reportGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReportGroupResponse model) {
            super(model);
            reportGroup(model.reportGroup);
        }

        public final ReportGroup.Builder getReportGroup() {
            return reportGroup != null ? reportGroup.toBuilder() : null;
        }

        public final void setReportGroup(ReportGroup.BuilderImpl reportGroup) {
            this.reportGroup = reportGroup != null ? reportGroup.build() : null;
        }

        @Override
        public final Builder reportGroup(ReportGroup reportGroup) {
            this.reportGroup = reportGroup;
            return this;
        }

        @Override
        public UpdateReportGroupResponse build() {
            return new UpdateReportGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
