/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information that defines how the CodeBuild build project reports the build status to the source provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BuildStatusConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<BuildStatusConfig.Builder, BuildStatusConfig> {
    private static final SdkField<String> CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("context")
            .getter(getter(BuildStatusConfig::context)).setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build()).build();

    private static final SdkField<String> TARGET_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetUrl").getter(getter(BuildStatusConfig::targetUrl)).setter(setter(Builder::targetUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTEXT_FIELD,
            TARGET_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String context;

    private final String targetUrl;

    private BuildStatusConfig(BuilderImpl builder) {
        this.context = builder.context;
        this.targetUrl = builder.targetUrl;
    }

    /**
     * <p>
     * Specifies the context of the build status CodeBuild sends to the source provider. The usage of this parameter
     * depends on the source provider.
     * </p>
     * <dl>
     * <dt>Bitbucket</dt>
     * <dd>
     * <p>
     * This parameter is used for the <code>name</code> parameter in the Bitbucket commit status. For more information,
     * see <a href=
     * "https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build"
     * >build</a> in the Bitbucket API documentation.
     * </p>
     * </dd>
     * <dt>GitHub/GitHub Enterprise Server</dt>
     * <dd>
     * <p>
     * This parameter is used for the <code>context</code> parameter in the GitHub commit status. For more information,
     * see <a href="https://developer.github.com/v3/repos/statuses/#create-a-commit-status">Create a commit status</a>
     * in the GitHub developer guide.
     * </p>
     * </dd>
     * </dl>
     * 
     * @return Specifies the context of the build status CodeBuild sends to the source provider. The usage of this
     *         parameter depends on the source provider.</p>
     *         <dl>
     *         <dt>Bitbucket</dt>
     *         <dd>
     *         <p>
     *         This parameter is used for the <code>name</code> parameter in the Bitbucket commit status. For more
     *         information, see <a href=
     *         "https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build"
     *         >build</a> in the Bitbucket API documentation.
     *         </p>
     *         </dd>
     *         <dt>GitHub/GitHub Enterprise Server</dt>
     *         <dd>
     *         <p>
     *         This parameter is used for the <code>context</code> parameter in the GitHub commit status. For more
     *         information, see <a href="https://developer.github.com/v3/repos/statuses/#create-a-commit-status">Create
     *         a commit status</a> in the GitHub developer guide.
     *         </p>
     *         </dd>
     */
    public final String context() {
        return context;
    }

    /**
     * <p>
     * Specifies the target url of the build status CodeBuild sends to the source provider. The usage of this parameter
     * depends on the source provider.
     * </p>
     * <dl>
     * <dt>Bitbucket</dt>
     * <dd>
     * <p>
     * This parameter is used for the <code>url</code> parameter in the Bitbucket commit status. For more information,
     * see <a href=
     * "https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build"
     * >build</a> in the Bitbucket API documentation.
     * </p>
     * </dd>
     * <dt>GitHub/GitHub Enterprise Server</dt>
     * <dd>
     * <p>
     * This parameter is used for the <code>target_url</code> parameter in the GitHub commit status. For more
     * information, see <a href="https://developer.github.com/v3/repos/statuses/#create-a-commit-status">Create a commit
     * status</a> in the GitHub developer guide.
     * </p>
     * </dd>
     * </dl>
     * 
     * @return Specifies the target url of the build status CodeBuild sends to the source provider. The usage of this
     *         parameter depends on the source provider.</p>
     *         <dl>
     *         <dt>Bitbucket</dt>
     *         <dd>
     *         <p>
     *         This parameter is used for the <code>url</code> parameter in the Bitbucket commit status. For more
     *         information, see <a href=
     *         "https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build"
     *         >build</a> in the Bitbucket API documentation.
     *         </p>
     *         </dd>
     *         <dt>GitHub/GitHub Enterprise Server</dt>
     *         <dd>
     *         <p>
     *         This parameter is used for the <code>target_url</code> parameter in the GitHub commit status. For more
     *         information, see <a href="https://developer.github.com/v3/repos/statuses/#create-a-commit-status">Create
     *         a commit status</a> in the GitHub developer guide.
     *         </p>
     *         </dd>
     */
    public final String targetUrl() {
        return targetUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(context());
        hashCode = 31 * hashCode + Objects.hashCode(targetUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuildStatusConfig)) {
            return false;
        }
        BuildStatusConfig other = (BuildStatusConfig) obj;
        return Objects.equals(context(), other.context()) && Objects.equals(targetUrl(), other.targetUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BuildStatusConfig").add("Context", context()).add("TargetUrl", targetUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "context":
            return Optional.ofNullable(clazz.cast(context()));
        case "targetUrl":
            return Optional.ofNullable(clazz.cast(targetUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BuildStatusConfig, T> g) {
        return obj -> g.apply((BuildStatusConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BuildStatusConfig> {
        /**
         * <p>
         * Specifies the context of the build status CodeBuild sends to the source provider. The usage of this parameter
         * depends on the source provider.
         * </p>
         * <dl>
         * <dt>Bitbucket</dt>
         * <dd>
         * <p>
         * This parameter is used for the <code>name</code> parameter in the Bitbucket commit status. For more
         * information, see <a href=
         * "https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build"
         * >build</a> in the Bitbucket API documentation.
         * </p>
         * </dd>
         * <dt>GitHub/GitHub Enterprise Server</dt>
         * <dd>
         * <p>
         * This parameter is used for the <code>context</code> parameter in the GitHub commit status. For more
         * information, see <a href="https://developer.github.com/v3/repos/statuses/#create-a-commit-status">Create a
         * commit status</a> in the GitHub developer guide.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param context
         *        Specifies the context of the build status CodeBuild sends to the source provider. The usage of this
         *        parameter depends on the source provider.</p>
         *        <dl>
         *        <dt>Bitbucket</dt>
         *        <dd>
         *        <p>
         *        This parameter is used for the <code>name</code> parameter in the Bitbucket commit status. For more
         *        information, see <a href=
         *        "https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build"
         *        >build</a> in the Bitbucket API documentation.
         *        </p>
         *        </dd>
         *        <dt>GitHub/GitHub Enterprise Server</dt>
         *        <dd>
         *        <p>
         *        This parameter is used for the <code>context</code> parameter in the GitHub commit status. For more
         *        information, see <a
         *        href="https://developer.github.com/v3/repos/statuses/#create-a-commit-status">Create a commit
         *        status</a> in the GitHub developer guide.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(String context);

        /**
         * <p>
         * Specifies the target url of the build status CodeBuild sends to the source provider. The usage of this
         * parameter depends on the source provider.
         * </p>
         * <dl>
         * <dt>Bitbucket</dt>
         * <dd>
         * <p>
         * This parameter is used for the <code>url</code> parameter in the Bitbucket commit status. For more
         * information, see <a href=
         * "https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build"
         * >build</a> in the Bitbucket API documentation.
         * </p>
         * </dd>
         * <dt>GitHub/GitHub Enterprise Server</dt>
         * <dd>
         * <p>
         * This parameter is used for the <code>target_url</code> parameter in the GitHub commit status. For more
         * information, see <a href="https://developer.github.com/v3/repos/statuses/#create-a-commit-status">Create a
         * commit status</a> in the GitHub developer guide.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param targetUrl
         *        Specifies the target url of the build status CodeBuild sends to the source provider. The usage of this
         *        parameter depends on the source provider.</p>
         *        <dl>
         *        <dt>Bitbucket</dt>
         *        <dd>
         *        <p>
         *        This parameter is used for the <code>url</code> parameter in the Bitbucket commit status. For more
         *        information, see <a href=
         *        "https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build"
         *        >build</a> in the Bitbucket API documentation.
         *        </p>
         *        </dd>
         *        <dt>GitHub/GitHub Enterprise Server</dt>
         *        <dd>
         *        <p>
         *        This parameter is used for the <code>target_url</code> parameter in the GitHub commit status. For more
         *        information, see <a
         *        href="https://developer.github.com/v3/repos/statuses/#create-a-commit-status">Create a commit
         *        status</a> in the GitHub developer guide.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetUrl(String targetUrl);
    }

    static final class BuilderImpl implements Builder {
        private String context;

        private String targetUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(BuildStatusConfig model) {
            context(model.context);
            targetUrl(model.targetUrl);
        }

        public final String getContext() {
            return context;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        @Transient
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        public final String getTargetUrl() {
            return targetUrl;
        }

        public final void setTargetUrl(String targetUrl) {
            this.targetUrl = targetUrl;
        }

        @Override
        @Transient
        public final Builder targetUrl(String targetUrl) {
            this.targetUrl = targetUrl;
            return this;
        }

        @Override
        public BuildStatusConfig build() {
            return new BuildStatusConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
