/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReportGroupTrendRequest extends CodeBuildRequest implements
        ToCopyableBuilder<GetReportGroupTrendRequest.Builder, GetReportGroupTrendRequest> {
    private static final SdkField<String> REPORT_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reportGroupArn").getter(getter(GetReportGroupTrendRequest::reportGroupArn))
            .setter(setter(Builder::reportGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportGroupArn").build()).build();

    private static final SdkField<Integer> NUM_OF_REPORTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numOfReports").getter(getter(GetReportGroupTrendRequest::numOfReports))
            .setter(setter(Builder::numOfReports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numOfReports").build()).build();

    private static final SdkField<String> TREND_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trendField").getter(getter(GetReportGroupTrendRequest::trendFieldAsString))
            .setter(setter(Builder::trendField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trendField").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_GROUP_ARN_FIELD,
            NUM_OF_REPORTS_FIELD, TREND_FIELD_FIELD));

    private final String reportGroupArn;

    private final Integer numOfReports;

    private final String trendField;

    private GetReportGroupTrendRequest(BuilderImpl builder) {
        super(builder);
        this.reportGroupArn = builder.reportGroupArn;
        this.numOfReports = builder.numOfReports;
        this.trendField = builder.trendField;
    }

    /**
     * <p>
     * The ARN of the report group that contains the reports to analyze.
     * </p>
     * 
     * @return The ARN of the report group that contains the reports to analyze.
     */
    public final String reportGroupArn() {
        return reportGroupArn;
    }

    /**
     * <p>
     * The number of reports to analyze. This operation always retrieves the most recent reports.
     * </p>
     * <p>
     * If this parameter is omitted, the most recent 100 reports are analyzed.
     * </p>
     * 
     * @return The number of reports to analyze. This operation always retrieves the most recent reports.</p>
     *         <p>
     *         If this parameter is omitted, the most recent 100 reports are analyzed.
     */
    public final Integer numOfReports() {
        return numOfReports;
    }

    /**
     * <p>
     * The test report value to accumulate. This must be one of the following values:
     * </p>
     * <dl>
     * <dt>Test reports:</dt>
     * <dd>
     * <dl>
     * <dt>DURATION</dt>
     * <dd>
     * <p>
     * Accumulate the test run times for the specified reports.
     * </p>
     * </dd>
     * <dt>PASS_RATE</dt>
     * <dd>
     * <p>
     * Accumulate the percentage of tests that passed for the specified test reports.
     * </p>
     * </dd>
     * <dt>TOTAL</dt>
     * <dd>
     * <p>
     * Accumulate the total number of tests for the specified test reports.
     * </p>
     * </dd>
     * </dl>
     * </dd>
     * </dl>
     * <dl>
     * <dt>Code coverage reports:</dt>
     * <dd>
     * <dl>
     * <dt>BRANCH_COVERAGE</dt>
     * <dd>
     * <p>
     * Accumulate the branch coverage percentages for the specified test reports.
     * </p>
     * </dd>
     * <dt>BRANCHES_COVERED</dt>
     * <dd>
     * <p>
     * Accumulate the branches covered values for the specified test reports.
     * </p>
     * </dd>
     * <dt>BRANCHES_MISSED</dt>
     * <dd>
     * <p>
     * Accumulate the branches missed values for the specified test reports.
     * </p>
     * </dd>
     * <dt>LINE_COVERAGE</dt>
     * <dd>
     * <p>
     * Accumulate the line coverage percentages for the specified test reports.
     * </p>
     * </dd>
     * <dt>LINES_COVERED</dt>
     * <dd>
     * <p>
     * Accumulate the lines covered values for the specified test reports.
     * </p>
     * </dd>
     * <dt>LINES_MISSED</dt>
     * <dd>
     * <p>
     * Accumulate the lines not covered values for the specified test reports.
     * </p>
     * </dd>
     * </dl>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trendField} will
     * return {@link ReportGroupTrendFieldType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #trendFieldAsString}.
     * </p>
     * 
     * @return The test report value to accumulate. This must be one of the following values:</p>
     *         <dl>
     *         <dt>Test reports:</dt>
     *         <dd>
     *         <dl>
     *         <dt>DURATION</dt>
     *         <dd>
     *         <p>
     *         Accumulate the test run times for the specified reports.
     *         </p>
     *         </dd>
     *         <dt>PASS_RATE</dt>
     *         <dd>
     *         <p>
     *         Accumulate the percentage of tests that passed for the specified test reports.
     *         </p>
     *         </dd>
     *         <dt>TOTAL</dt>
     *         <dd>
     *         <p>
     *         Accumulate the total number of tests for the specified test reports.
     *         </p>
     *         </dd>
     *         </dl>
     *         </dd>
     *         </dl>
     *         <dl>
     *         <dt>Code coverage reports:</dt>
     *         <dd>
     *         <dl>
     *         <dt>BRANCH_COVERAGE</dt>
     *         <dd>
     *         <p>
     *         Accumulate the branch coverage percentages for the specified test reports.
     *         </p>
     *         </dd>
     *         <dt>BRANCHES_COVERED</dt>
     *         <dd>
     *         <p>
     *         Accumulate the branches covered values for the specified test reports.
     *         </p>
     *         </dd>
     *         <dt>BRANCHES_MISSED</dt>
     *         <dd>
     *         <p>
     *         Accumulate the branches missed values for the specified test reports.
     *         </p>
     *         </dd>
     *         <dt>LINE_COVERAGE</dt>
     *         <dd>
     *         <p>
     *         Accumulate the line coverage percentages for the specified test reports.
     *         </p>
     *         </dd>
     *         <dt>LINES_COVERED</dt>
     *         <dd>
     *         <p>
     *         Accumulate the lines covered values for the specified test reports.
     *         </p>
     *         </dd>
     *         <dt>LINES_MISSED</dt>
     *         <dd>
     *         <p>
     *         Accumulate the lines not covered values for the specified test reports.
     *         </p>
     *         </dd>
     *         </dl>
     *         </dd>
     * @see ReportGroupTrendFieldType
     */
    public final ReportGroupTrendFieldType trendField() {
        return ReportGroupTrendFieldType.fromValue(trendField);
    }

    /**
     * <p>
     * The test report value to accumulate. This must be one of the following values:
     * </p>
     * <dl>
     * <dt>Test reports:</dt>
     * <dd>
     * <dl>
     * <dt>DURATION</dt>
     * <dd>
     * <p>
     * Accumulate the test run times for the specified reports.
     * </p>
     * </dd>
     * <dt>PASS_RATE</dt>
     * <dd>
     * <p>
     * Accumulate the percentage of tests that passed for the specified test reports.
     * </p>
     * </dd>
     * <dt>TOTAL</dt>
     * <dd>
     * <p>
     * Accumulate the total number of tests for the specified test reports.
     * </p>
     * </dd>
     * </dl>
     * </dd>
     * </dl>
     * <dl>
     * <dt>Code coverage reports:</dt>
     * <dd>
     * <dl>
     * <dt>BRANCH_COVERAGE</dt>
     * <dd>
     * <p>
     * Accumulate the branch coverage percentages for the specified test reports.
     * </p>
     * </dd>
     * <dt>BRANCHES_COVERED</dt>
     * <dd>
     * <p>
     * Accumulate the branches covered values for the specified test reports.
     * </p>
     * </dd>
     * <dt>BRANCHES_MISSED</dt>
     * <dd>
     * <p>
     * Accumulate the branches missed values for the specified test reports.
     * </p>
     * </dd>
     * <dt>LINE_COVERAGE</dt>
     * <dd>
     * <p>
     * Accumulate the line coverage percentages for the specified test reports.
     * </p>
     * </dd>
     * <dt>LINES_COVERED</dt>
     * <dd>
     * <p>
     * Accumulate the lines covered values for the specified test reports.
     * </p>
     * </dd>
     * <dt>LINES_MISSED</dt>
     * <dd>
     * <p>
     * Accumulate the lines not covered values for the specified test reports.
     * </p>
     * </dd>
     * </dl>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trendField} will
     * return {@link ReportGroupTrendFieldType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #trendFieldAsString}.
     * </p>
     * 
     * @return The test report value to accumulate. This must be one of the following values:</p>
     *         <dl>
     *         <dt>Test reports:</dt>
     *         <dd>
     *         <dl>
     *         <dt>DURATION</dt>
     *         <dd>
     *         <p>
     *         Accumulate the test run times for the specified reports.
     *         </p>
     *         </dd>
     *         <dt>PASS_RATE</dt>
     *         <dd>
     *         <p>
     *         Accumulate the percentage of tests that passed for the specified test reports.
     *         </p>
     *         </dd>
     *         <dt>TOTAL</dt>
     *         <dd>
     *         <p>
     *         Accumulate the total number of tests for the specified test reports.
     *         </p>
     *         </dd>
     *         </dl>
     *         </dd>
     *         </dl>
     *         <dl>
     *         <dt>Code coverage reports:</dt>
     *         <dd>
     *         <dl>
     *         <dt>BRANCH_COVERAGE</dt>
     *         <dd>
     *         <p>
     *         Accumulate the branch coverage percentages for the specified test reports.
     *         </p>
     *         </dd>
     *         <dt>BRANCHES_COVERED</dt>
     *         <dd>
     *         <p>
     *         Accumulate the branches covered values for the specified test reports.
     *         </p>
     *         </dd>
     *         <dt>BRANCHES_MISSED</dt>
     *         <dd>
     *         <p>
     *         Accumulate the branches missed values for the specified test reports.
     *         </p>
     *         </dd>
     *         <dt>LINE_COVERAGE</dt>
     *         <dd>
     *         <p>
     *         Accumulate the line coverage percentages for the specified test reports.
     *         </p>
     *         </dd>
     *         <dt>LINES_COVERED</dt>
     *         <dd>
     *         <p>
     *         Accumulate the lines covered values for the specified test reports.
     *         </p>
     *         </dd>
     *         <dt>LINES_MISSED</dt>
     *         <dd>
     *         <p>
     *         Accumulate the lines not covered values for the specified test reports.
     *         </p>
     *         </dd>
     *         </dl>
     *         </dd>
     * @see ReportGroupTrendFieldType
     */
    public final String trendFieldAsString() {
        return trendField;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reportGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(numOfReports());
        hashCode = 31 * hashCode + Objects.hashCode(trendFieldAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReportGroupTrendRequest)) {
            return false;
        }
        GetReportGroupTrendRequest other = (GetReportGroupTrendRequest) obj;
        return Objects.equals(reportGroupArn(), other.reportGroupArn()) && Objects.equals(numOfReports(), other.numOfReports())
                && Objects.equals(trendFieldAsString(), other.trendFieldAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetReportGroupTrendRequest").add("ReportGroupArn", reportGroupArn())
                .add("NumOfReports", numOfReports()).add("TrendField", trendFieldAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reportGroupArn":
            return Optional.ofNullable(clazz.cast(reportGroupArn()));
        case "numOfReports":
            return Optional.ofNullable(clazz.cast(numOfReports()));
        case "trendField":
            return Optional.ofNullable(clazz.cast(trendFieldAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReportGroupTrendRequest, T> g) {
        return obj -> g.apply((GetReportGroupTrendRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetReportGroupTrendRequest> {
        /**
         * <p>
         * The ARN of the report group that contains the reports to analyze.
         * </p>
         * 
         * @param reportGroupArn
         *        The ARN of the report group that contains the reports to analyze.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportGroupArn(String reportGroupArn);

        /**
         * <p>
         * The number of reports to analyze. This operation always retrieves the most recent reports.
         * </p>
         * <p>
         * If this parameter is omitted, the most recent 100 reports are analyzed.
         * </p>
         * 
         * @param numOfReports
         *        The number of reports to analyze. This operation always retrieves the most recent reports.</p>
         *        <p>
         *        If this parameter is omitted, the most recent 100 reports are analyzed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numOfReports(Integer numOfReports);

        /**
         * <p>
         * The test report value to accumulate. This must be one of the following values:
         * </p>
         * <dl>
         * <dt>Test reports:</dt>
         * <dd>
         * <dl>
         * <dt>DURATION</dt>
         * <dd>
         * <p>
         * Accumulate the test run times for the specified reports.
         * </p>
         * </dd>
         * <dt>PASS_RATE</dt>
         * <dd>
         * <p>
         * Accumulate the percentage of tests that passed for the specified test reports.
         * </p>
         * </dd>
         * <dt>TOTAL</dt>
         * <dd>
         * <p>
         * Accumulate the total number of tests for the specified test reports.
         * </p>
         * </dd>
         * </dl>
         * </dd>
         * </dl>
         * <dl>
         * <dt>Code coverage reports:</dt>
         * <dd>
         * <dl>
         * <dt>BRANCH_COVERAGE</dt>
         * <dd>
         * <p>
         * Accumulate the branch coverage percentages for the specified test reports.
         * </p>
         * </dd>
         * <dt>BRANCHES_COVERED</dt>
         * <dd>
         * <p>
         * Accumulate the branches covered values for the specified test reports.
         * </p>
         * </dd>
         * <dt>BRANCHES_MISSED</dt>
         * <dd>
         * <p>
         * Accumulate the branches missed values for the specified test reports.
         * </p>
         * </dd>
         * <dt>LINE_COVERAGE</dt>
         * <dd>
         * <p>
         * Accumulate the line coverage percentages for the specified test reports.
         * </p>
         * </dd>
         * <dt>LINES_COVERED</dt>
         * <dd>
         * <p>
         * Accumulate the lines covered values for the specified test reports.
         * </p>
         * </dd>
         * <dt>LINES_MISSED</dt>
         * <dd>
         * <p>
         * Accumulate the lines not covered values for the specified test reports.
         * </p>
         * </dd>
         * </dl>
         * </dd>
         * </dl>
         * 
         * @param trendField
         *        The test report value to accumulate. This must be one of the following values:</p>
         *        <dl>
         *        <dt>Test reports:</dt>
         *        <dd>
         *        <dl>
         *        <dt>DURATION</dt>
         *        <dd>
         *        <p>
         *        Accumulate the test run times for the specified reports.
         *        </p>
         *        </dd>
         *        <dt>PASS_RATE</dt>
         *        <dd>
         *        <p>
         *        Accumulate the percentage of tests that passed for the specified test reports.
         *        </p>
         *        </dd>
         *        <dt>TOTAL</dt>
         *        <dd>
         *        <p>
         *        Accumulate the total number of tests for the specified test reports.
         *        </p>
         *        </dd>
         *        </dl>
         *        </dd>
         *        </dl>
         *        <dl>
         *        <dt>Code coverage reports:</dt>
         *        <dd>
         *        <dl>
         *        <dt>BRANCH_COVERAGE</dt>
         *        <dd>
         *        <p>
         *        Accumulate the branch coverage percentages for the specified test reports.
         *        </p>
         *        </dd>
         *        <dt>BRANCHES_COVERED</dt>
         *        <dd>
         *        <p>
         *        Accumulate the branches covered values for the specified test reports.
         *        </p>
         *        </dd>
         *        <dt>BRANCHES_MISSED</dt>
         *        <dd>
         *        <p>
         *        Accumulate the branches missed values for the specified test reports.
         *        </p>
         *        </dd>
         *        <dt>LINE_COVERAGE</dt>
         *        <dd>
         *        <p>
         *        Accumulate the line coverage percentages for the specified test reports.
         *        </p>
         *        </dd>
         *        <dt>LINES_COVERED</dt>
         *        <dd>
         *        <p>
         *        Accumulate the lines covered values for the specified test reports.
         *        </p>
         *        </dd>
         *        <dt>LINES_MISSED</dt>
         *        <dd>
         *        <p>
         *        Accumulate the lines not covered values for the specified test reports.
         *        </p>
         *        </dd>
         *        </dl>
         *        </dd>
         * @see ReportGroupTrendFieldType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportGroupTrendFieldType
         */
        Builder trendField(String trendField);

        /**
         * <p>
         * The test report value to accumulate. This must be one of the following values:
         * </p>
         * <dl>
         * <dt>Test reports:</dt>
         * <dd>
         * <dl>
         * <dt>DURATION</dt>
         * <dd>
         * <p>
         * Accumulate the test run times for the specified reports.
         * </p>
         * </dd>
         * <dt>PASS_RATE</dt>
         * <dd>
         * <p>
         * Accumulate the percentage of tests that passed for the specified test reports.
         * </p>
         * </dd>
         * <dt>TOTAL</dt>
         * <dd>
         * <p>
         * Accumulate the total number of tests for the specified test reports.
         * </p>
         * </dd>
         * </dl>
         * </dd>
         * </dl>
         * <dl>
         * <dt>Code coverage reports:</dt>
         * <dd>
         * <dl>
         * <dt>BRANCH_COVERAGE</dt>
         * <dd>
         * <p>
         * Accumulate the branch coverage percentages for the specified test reports.
         * </p>
         * </dd>
         * <dt>BRANCHES_COVERED</dt>
         * <dd>
         * <p>
         * Accumulate the branches covered values for the specified test reports.
         * </p>
         * </dd>
         * <dt>BRANCHES_MISSED</dt>
         * <dd>
         * <p>
         * Accumulate the branches missed values for the specified test reports.
         * </p>
         * </dd>
         * <dt>LINE_COVERAGE</dt>
         * <dd>
         * <p>
         * Accumulate the line coverage percentages for the specified test reports.
         * </p>
         * </dd>
         * <dt>LINES_COVERED</dt>
         * <dd>
         * <p>
         * Accumulate the lines covered values for the specified test reports.
         * </p>
         * </dd>
         * <dt>LINES_MISSED</dt>
         * <dd>
         * <p>
         * Accumulate the lines not covered values for the specified test reports.
         * </p>
         * </dd>
         * </dl>
         * </dd>
         * </dl>
         * 
         * @param trendField
         *        The test report value to accumulate. This must be one of the following values:</p>
         *        <dl>
         *        <dt>Test reports:</dt>
         *        <dd>
         *        <dl>
         *        <dt>DURATION</dt>
         *        <dd>
         *        <p>
         *        Accumulate the test run times for the specified reports.
         *        </p>
         *        </dd>
         *        <dt>PASS_RATE</dt>
         *        <dd>
         *        <p>
         *        Accumulate the percentage of tests that passed for the specified test reports.
         *        </p>
         *        </dd>
         *        <dt>TOTAL</dt>
         *        <dd>
         *        <p>
         *        Accumulate the total number of tests for the specified test reports.
         *        </p>
         *        </dd>
         *        </dl>
         *        </dd>
         *        </dl>
         *        <dl>
         *        <dt>Code coverage reports:</dt>
         *        <dd>
         *        <dl>
         *        <dt>BRANCH_COVERAGE</dt>
         *        <dd>
         *        <p>
         *        Accumulate the branch coverage percentages for the specified test reports.
         *        </p>
         *        </dd>
         *        <dt>BRANCHES_COVERED</dt>
         *        <dd>
         *        <p>
         *        Accumulate the branches covered values for the specified test reports.
         *        </p>
         *        </dd>
         *        <dt>BRANCHES_MISSED</dt>
         *        <dd>
         *        <p>
         *        Accumulate the branches missed values for the specified test reports.
         *        </p>
         *        </dd>
         *        <dt>LINE_COVERAGE</dt>
         *        <dd>
         *        <p>
         *        Accumulate the line coverage percentages for the specified test reports.
         *        </p>
         *        </dd>
         *        <dt>LINES_COVERED</dt>
         *        <dd>
         *        <p>
         *        Accumulate the lines covered values for the specified test reports.
         *        </p>
         *        </dd>
         *        <dt>LINES_MISSED</dt>
         *        <dd>
         *        <p>
         *        Accumulate the lines not covered values for the specified test reports.
         *        </p>
         *        </dd>
         *        </dl>
         *        </dd>
         * @see ReportGroupTrendFieldType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportGroupTrendFieldType
         */
        Builder trendField(ReportGroupTrendFieldType trendField);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeBuildRequest.BuilderImpl implements Builder {
        private String reportGroupArn;

        private Integer numOfReports;

        private String trendField;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReportGroupTrendRequest model) {
            super(model);
            reportGroupArn(model.reportGroupArn);
            numOfReports(model.numOfReports);
            trendField(model.trendField);
        }

        public final String getReportGroupArn() {
            return reportGroupArn;
        }

        public final void setReportGroupArn(String reportGroupArn) {
            this.reportGroupArn = reportGroupArn;
        }

        @Override
        @Transient
        public final Builder reportGroupArn(String reportGroupArn) {
            this.reportGroupArn = reportGroupArn;
            return this;
        }

        public final Integer getNumOfReports() {
            return numOfReports;
        }

        public final void setNumOfReports(Integer numOfReports) {
            this.numOfReports = numOfReports;
        }

        @Override
        @Transient
        public final Builder numOfReports(Integer numOfReports) {
            this.numOfReports = numOfReports;
            return this;
        }

        public final String getTrendField() {
            return trendField;
        }

        public final void setTrendField(String trendField) {
            this.trendField = trendField;
        }

        @Override
        @Transient
        public final Builder trendField(String trendField) {
            this.trendField = trendField;
            return this;
        }

        @Override
        @Transient
        public final Builder trendField(ReportGroupTrendFieldType trendField) {
            this.trendField(trendField == null ? null : trendField.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetReportGroupTrendRequest build() {
            return new GetReportGroupTrendRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
