/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportSourceCredentialsRequest extends CodeBuildRequest implements
        ToCopyableBuilder<ImportSourceCredentialsRequest.Builder, ImportSourceCredentialsRequest> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("username").getter(getter(ImportSourceCredentialsRequest::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()).build();

    private static final SdkField<String> TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("token")
            .getter(getter(ImportSourceCredentialsRequest::token)).setter(setter(Builder::token))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("token").build()).build();

    private static final SdkField<String> SERVER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serverType").getter(getter(ImportSourceCredentialsRequest::serverTypeAsString))
            .setter(setter(Builder::serverType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverType").build()).build();

    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authType").getter(getter(ImportSourceCredentialsRequest::authTypeAsString))
            .setter(setter(Builder::authType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()).build();

    private static final SdkField<Boolean> SHOULD_OVERWRITE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("shouldOverwrite").getter(getter(ImportSourceCredentialsRequest::shouldOverwrite))
            .setter(setter(Builder::shouldOverwrite))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shouldOverwrite").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD, TOKEN_FIELD,
            SERVER_TYPE_FIELD, AUTH_TYPE_FIELD, SHOULD_OVERWRITE_FIELD));

    private final String username;

    private final String token;

    private final String serverType;

    private final String authType;

    private final Boolean shouldOverwrite;

    private ImportSourceCredentialsRequest(BuilderImpl builder) {
        super(builder);
        this.username = builder.username;
        this.token = builder.token;
        this.serverType = builder.serverType;
        this.authType = builder.authType;
        this.shouldOverwrite = builder.shouldOverwrite;
    }

    /**
     * <p>
     * The Bitbucket username when the <code>authType</code> is BASIC_AUTH. This parameter is not valid for other types
     * of source providers or connections.
     * </p>
     * 
     * @return The Bitbucket username when the <code>authType</code> is BASIC_AUTH. This parameter is not valid for
     *         other types of source providers or connections.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * For GitHub or GitHub Enterprise, this is the personal access token. For Bitbucket, this is the app password.
     * </p>
     * 
     * @return For GitHub or GitHub Enterprise, this is the personal access token. For Bitbucket, this is the app
     *         password.
     */
    public final String token() {
        return token;
    }

    /**
     * <p>
     * The source provider used for this project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverType} will
     * return {@link ServerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serverTypeAsString}.
     * </p>
     * 
     * @return The source provider used for this project.
     * @see ServerType
     */
    public final ServerType serverType() {
        return ServerType.fromValue(serverType);
    }

    /**
     * <p>
     * The source provider used for this project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverType} will
     * return {@link ServerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serverTypeAsString}.
     * </p>
     * 
     * @return The source provider used for this project.
     * @see ServerType
     */
    public final String serverTypeAsString() {
        return serverType;
    }

    /**
     * <p>
     * The type of authentication used to connect to a GitHub, GitHub Enterprise, or Bitbucket repository. An OAUTH
     * connection is not supported by the API and must be created using the CodeBuild console.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The type of authentication used to connect to a GitHub, GitHub Enterprise, or Bitbucket repository. An
     *         OAUTH connection is not supported by the API and must be created using the CodeBuild console.
     * @see AuthType
     */
    public final AuthType authType() {
        return AuthType.fromValue(authType);
    }

    /**
     * <p>
     * The type of authentication used to connect to a GitHub, GitHub Enterprise, or Bitbucket repository. An OAUTH
     * connection is not supported by the API and must be created using the CodeBuild console.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The type of authentication used to connect to a GitHub, GitHub Enterprise, or Bitbucket repository. An
     *         OAUTH connection is not supported by the API and must be created using the CodeBuild console.
     * @see AuthType
     */
    public final String authTypeAsString() {
        return authType;
    }

    /**
     * <p>
     * Set to <code>false</code> to prevent overwriting the repository source credentials. Set to <code>true</code> to
     * overwrite the repository source credentials. The default value is <code>true</code>.
     * </p>
     * 
     * @return Set to <code>false</code> to prevent overwriting the repository source credentials. Set to
     *         <code>true</code> to overwrite the repository source credentials. The default value is <code>true</code>.
     */
    public final Boolean shouldOverwrite() {
        return shouldOverwrite;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(token());
        hashCode = 31 * hashCode + Objects.hashCode(serverTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(shouldOverwrite());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSourceCredentialsRequest)) {
            return false;
        }
        ImportSourceCredentialsRequest other = (ImportSourceCredentialsRequest) obj;
        return Objects.equals(username(), other.username()) && Objects.equals(token(), other.token())
                && Objects.equals(serverTypeAsString(), other.serverTypeAsString())
                && Objects.equals(authTypeAsString(), other.authTypeAsString())
                && Objects.equals(shouldOverwrite(), other.shouldOverwrite());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportSourceCredentialsRequest").add("Username", username())
                .add("Token", token() == null ? null : "*** Sensitive Data Redacted ***").add("ServerType", serverTypeAsString())
                .add("AuthType", authTypeAsString()).add("ShouldOverwrite", shouldOverwrite()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "username":
            return Optional.ofNullable(clazz.cast(username()));
        case "token":
            return Optional.ofNullable(clazz.cast(token()));
        case "serverType":
            return Optional.ofNullable(clazz.cast(serverTypeAsString()));
        case "authType":
            return Optional.ofNullable(clazz.cast(authTypeAsString()));
        case "shouldOverwrite":
            return Optional.ofNullable(clazz.cast(shouldOverwrite()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportSourceCredentialsRequest, T> g) {
        return obj -> g.apply((ImportSourceCredentialsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildRequest.Builder, SdkPojo, CopyableBuilder<Builder, ImportSourceCredentialsRequest> {
        /**
         * <p>
         * The Bitbucket username when the <code>authType</code> is BASIC_AUTH. This parameter is not valid for other
         * types of source providers or connections.
         * </p>
         * 
         * @param username
         *        The Bitbucket username when the <code>authType</code> is BASIC_AUTH. This parameter is not valid for
         *        other types of source providers or connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * For GitHub or GitHub Enterprise, this is the personal access token. For Bitbucket, this is the app password.
         * </p>
         * 
         * @param token
         *        For GitHub or GitHub Enterprise, this is the personal access token. For Bitbucket, this is the app
         *        password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder token(String token);

        /**
         * <p>
         * The source provider used for this project.
         * </p>
         * 
         * @param serverType
         *        The source provider used for this project.
         * @see ServerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerType
         */
        Builder serverType(String serverType);

        /**
         * <p>
         * The source provider used for this project.
         * </p>
         * 
         * @param serverType
         *        The source provider used for this project.
         * @see ServerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerType
         */
        Builder serverType(ServerType serverType);

        /**
         * <p>
         * The type of authentication used to connect to a GitHub, GitHub Enterprise, or Bitbucket repository. An OAUTH
         * connection is not supported by the API and must be created using the CodeBuild console.
         * </p>
         * 
         * @param authType
         *        The type of authentication used to connect to a GitHub, GitHub Enterprise, or Bitbucket repository. An
         *        OAUTH connection is not supported by the API and must be created using the CodeBuild console.
         * @see AuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthType
         */
        Builder authType(String authType);

        /**
         * <p>
         * The type of authentication used to connect to a GitHub, GitHub Enterprise, or Bitbucket repository. An OAUTH
         * connection is not supported by the API and must be created using the CodeBuild console.
         * </p>
         * 
         * @param authType
         *        The type of authentication used to connect to a GitHub, GitHub Enterprise, or Bitbucket repository. An
         *        OAUTH connection is not supported by the API and must be created using the CodeBuild console.
         * @see AuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthType
         */
        Builder authType(AuthType authType);

        /**
         * <p>
         * Set to <code>false</code> to prevent overwriting the repository source credentials. Set to <code>true</code>
         * to overwrite the repository source credentials. The default value is <code>true</code>.
         * </p>
         * 
         * @param shouldOverwrite
         *        Set to <code>false</code> to prevent overwriting the repository source credentials. Set to
         *        <code>true</code> to overwrite the repository source credentials. The default value is
         *        <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shouldOverwrite(Boolean shouldOverwrite);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeBuildRequest.BuilderImpl implements Builder {
        private String username;

        private String token;

        private String serverType;

        private String authType;

        private Boolean shouldOverwrite;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportSourceCredentialsRequest model) {
            super(model);
            username(model.username);
            token(model.token);
            serverType(model.serverType);
            authType(model.authType);
            shouldOverwrite(model.shouldOverwrite);
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        @Transient
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getToken() {
            return token;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        @Transient
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final String getServerType() {
            return serverType;
        }

        public final void setServerType(String serverType) {
            this.serverType = serverType;
        }

        @Override
        @Transient
        public final Builder serverType(String serverType) {
            this.serverType = serverType;
            return this;
        }

        @Override
        @Transient
        public final Builder serverType(ServerType serverType) {
            this.serverType(serverType == null ? null : serverType.toString());
            return this;
        }

        public final String getAuthType() {
            return authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        @Transient
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        @Transient
        public final Builder authType(AuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final Boolean getShouldOverwrite() {
            return shouldOverwrite;
        }

        public final void setShouldOverwrite(Boolean shouldOverwrite) {
            this.shouldOverwrite = shouldOverwrite;
        }

        @Override
        @Transient
        public final Builder shouldOverwrite(Boolean shouldOverwrite) {
            this.shouldOverwrite = shouldOverwrite;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportSourceCredentialsRequest build() {
            return new ImportSourceCredentialsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
