/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a build project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Project implements SdkPojo, Serializable, ToCopyableBuilder<Project.Builder, Project> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Project::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Project::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Project::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<ProjectSource> SOURCE_FIELD = SdkField.<ProjectSource> builder(MarshallingType.SDK_POJO)
            .memberName("source").getter(getter(Project::source)).setter(setter(Builder::source))
            .constructor(ProjectSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<List<ProjectSource>> SECONDARY_SOURCES_FIELD = SdkField
            .<List<ProjectSource>> builder(MarshallingType.LIST)
            .memberName("secondarySources")
            .getter(getter(Project::secondarySources))
            .setter(setter(Builder::secondarySources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceVersion").getter(getter(Project::sourceVersion)).setter(setter(Builder::sourceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVersion").build()).build();

    private static final SdkField<List<ProjectSourceVersion>> SECONDARY_SOURCE_VERSIONS_FIELD = SdkField
            .<List<ProjectSourceVersion>> builder(MarshallingType.LIST)
            .memberName("secondarySourceVersions")
            .getter(getter(Project::secondarySourceVersions))
            .setter(setter(Builder::secondarySourceVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySourceVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectSourceVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectSourceVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProjectArtifacts> ARTIFACTS_FIELD = SdkField
            .<ProjectArtifacts> builder(MarshallingType.SDK_POJO).memberName("artifacts").getter(getter(Project::artifacts))
            .setter(setter(Builder::artifacts)).constructor(ProjectArtifacts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifacts").build()).build();

    private static final SdkField<List<ProjectArtifacts>> SECONDARY_ARTIFACTS_FIELD = SdkField
            .<List<ProjectArtifacts>> builder(MarshallingType.LIST)
            .memberName("secondaryArtifacts")
            .getter(getter(Project::secondaryArtifacts))
            .setter(setter(Builder::secondaryArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondaryArtifacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectArtifacts> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectArtifacts::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProjectCache> CACHE_FIELD = SdkField.<ProjectCache> builder(MarshallingType.SDK_POJO)
            .memberName("cache").getter(getter(Project::cache)).setter(setter(Builder::cache)).constructor(ProjectCache::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cache").build()).build();

    private static final SdkField<ProjectEnvironment> ENVIRONMENT_FIELD = SdkField
            .<ProjectEnvironment> builder(MarshallingType.SDK_POJO).memberName("environment")
            .getter(getter(Project::environment)).setter(setter(Builder::environment)).constructor(ProjectEnvironment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build()).build();

    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceRole").getter(getter(Project::serviceRole)).setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()).build();

    private static final SdkField<Integer> TIMEOUT_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeoutInMinutes").getter(getter(Project::timeoutInMinutes)).setter(setter(Builder::timeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInMinutes").build()).build();

    private static final SdkField<Integer> QUEUED_TIMEOUT_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("queuedTimeoutInMinutes").getter(getter(Project::queuedTimeoutInMinutes))
            .setter(setter(Builder::queuedTimeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedTimeoutInMinutes").build())
            .build();

    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encryptionKey").getter(getter(Project::encryptionKey)).setter(setter(Builder::encryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(Project::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("created").getter(getter(Project::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModified").getter(getter(Project::lastModified)).setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModified").build()).build();

    private static final SdkField<Webhook> WEBHOOK_FIELD = SdkField.<Webhook> builder(MarshallingType.SDK_POJO)
            .memberName("webhook").getter(getter(Project::webhook)).setter(setter(Builder::webhook))
            .constructor(Webhook::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webhook").build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("vpcConfig").getter(getter(Project::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()).build();

    private static final SdkField<ProjectBadge> BADGE_FIELD = SdkField.<ProjectBadge> builder(MarshallingType.SDK_POJO)
            .memberName("badge").getter(getter(Project::badge)).setter(setter(Builder::badge)).constructor(ProjectBadge::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("badge").build()).build();

    private static final SdkField<LogsConfig> LOGS_CONFIG_FIELD = SdkField.<LogsConfig> builder(MarshallingType.SDK_POJO)
            .memberName("logsConfig").getter(getter(Project::logsConfig)).setter(setter(Builder::logsConfig))
            .constructor(LogsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logsConfig").build()).build();

    private static final SdkField<List<ProjectFileSystemLocation>> FILE_SYSTEM_LOCATIONS_FIELD = SdkField
            .<List<ProjectFileSystemLocation>> builder(MarshallingType.LIST)
            .memberName("fileSystemLocations")
            .getter(getter(Project::fileSystemLocations))
            .setter(setter(Builder::fileSystemLocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemLocations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectFileSystemLocation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectFileSystemLocation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProjectBuildBatchConfig> BUILD_BATCH_CONFIG_FIELD = SdkField
            .<ProjectBuildBatchConfig> builder(MarshallingType.SDK_POJO).memberName("buildBatchConfig")
            .getter(getter(Project::buildBatchConfig)).setter(setter(Builder::buildBatchConfig))
            .constructor(ProjectBuildBatchConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildBatchConfig").build()).build();

    private static final SdkField<Integer> CONCURRENT_BUILD_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("concurrentBuildLimit").getter(getter(Project::concurrentBuildLimit))
            .setter(setter(Builder::concurrentBuildLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("concurrentBuildLimit").build())
            .build();

    private static final SdkField<String> PROJECT_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectVisibility").getter(getter(Project::projectVisibilityAsString))
            .setter(setter(Builder::projectVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectVisibility").build()).build();

    private static final SdkField<String> PUBLIC_PROJECT_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("publicProjectAlias").getter(getter(Project::publicProjectAlias))
            .setter(setter(Builder::publicProjectAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicProjectAlias").build())
            .build();

    private static final SdkField<String> RESOURCE_ACCESS_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceAccessRole").getter(getter(Project::resourceAccessRole))
            .setter(setter(Builder::resourceAccessRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceAccessRole").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            DESCRIPTION_FIELD, SOURCE_FIELD, SECONDARY_SOURCES_FIELD, SOURCE_VERSION_FIELD, SECONDARY_SOURCE_VERSIONS_FIELD,
            ARTIFACTS_FIELD, SECONDARY_ARTIFACTS_FIELD, CACHE_FIELD, ENVIRONMENT_FIELD, SERVICE_ROLE_FIELD,
            TIMEOUT_IN_MINUTES_FIELD, QUEUED_TIMEOUT_IN_MINUTES_FIELD, ENCRYPTION_KEY_FIELD, TAGS_FIELD, CREATED_FIELD,
            LAST_MODIFIED_FIELD, WEBHOOK_FIELD, VPC_CONFIG_FIELD, BADGE_FIELD, LOGS_CONFIG_FIELD, FILE_SYSTEM_LOCATIONS_FIELD,
            BUILD_BATCH_CONFIG_FIELD, CONCURRENT_BUILD_LIMIT_FIELD, PROJECT_VISIBILITY_FIELD, PUBLIC_PROJECT_ALIAS_FIELD,
            RESOURCE_ACCESS_ROLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final String description;

    private final ProjectSource source;

    private final List<ProjectSource> secondarySources;

    private final String sourceVersion;

    private final List<ProjectSourceVersion> secondarySourceVersions;

    private final ProjectArtifacts artifacts;

    private final List<ProjectArtifacts> secondaryArtifacts;

    private final ProjectCache cache;

    private final ProjectEnvironment environment;

    private final String serviceRole;

    private final Integer timeoutInMinutes;

    private final Integer queuedTimeoutInMinutes;

    private final String encryptionKey;

    private final List<Tag> tags;

    private final Instant created;

    private final Instant lastModified;

    private final Webhook webhook;

    private final VpcConfig vpcConfig;

    private final ProjectBadge badge;

    private final LogsConfig logsConfig;

    private final List<ProjectFileSystemLocation> fileSystemLocations;

    private final ProjectBuildBatchConfig buildBatchConfig;

    private final Integer concurrentBuildLimit;

    private final String projectVisibility;

    private final String publicProjectAlias;

    private final String resourceAccessRole;

    private Project(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.description = builder.description;
        this.source = builder.source;
        this.secondarySources = builder.secondarySources;
        this.sourceVersion = builder.sourceVersion;
        this.secondarySourceVersions = builder.secondarySourceVersions;
        this.artifacts = builder.artifacts;
        this.secondaryArtifacts = builder.secondaryArtifacts;
        this.cache = builder.cache;
        this.environment = builder.environment;
        this.serviceRole = builder.serviceRole;
        this.timeoutInMinutes = builder.timeoutInMinutes;
        this.queuedTimeoutInMinutes = builder.queuedTimeoutInMinutes;
        this.encryptionKey = builder.encryptionKey;
        this.tags = builder.tags;
        this.created = builder.created;
        this.lastModified = builder.lastModified;
        this.webhook = builder.webhook;
        this.vpcConfig = builder.vpcConfig;
        this.badge = builder.badge;
        this.logsConfig = builder.logsConfig;
        this.fileSystemLocations = builder.fileSystemLocations;
        this.buildBatchConfig = builder.buildBatchConfig;
        this.concurrentBuildLimit = builder.concurrentBuildLimit;
        this.projectVisibility = builder.projectVisibility;
        this.publicProjectAlias = builder.publicProjectAlias;
        this.resourceAccessRole = builder.resourceAccessRole;
    }

    /**
     * <p>
     * The name of the build project.
     * </p>
     * 
     * @return The name of the build project.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the build project.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the build project.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A description that makes the build project easy to identify.
     * </p>
     * 
     * @return A description that makes the build project easy to identify.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Information about the build input source code for this build project.
     * </p>
     * 
     * @return Information about the build input source code for this build project.
     */
    public final ProjectSource source() {
        return source;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecondarySources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecondarySources() {
        return secondarySources != null && !(secondarySources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ProjectSource</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecondarySources} method.
     * </p>
     * 
     * @return An array of <code>ProjectSource</code> objects.
     */
    public final List<ProjectSource> secondarySources() {
        return secondarySources;
    }

    /**
     * <p>
     * A version of the build input to be built for this project. If not specified, the latest version is used. If
     * specified, it must be one of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For CodeCommit: the commit ID, branch, or Git tag to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the
     * source code you want to build. If a pull request ID is specified, it must use the format
     * <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the branch's
     * HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you
     * want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default
     * branch's HEAD commit ID is used.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Amazon S3: the version ID of the object that represents the build input ZIP file to use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If <code>sourceVersion</code> is specified at the build level, then that version takes precedence over this
     * <code>sourceVersion</code> (at the project level).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample
     * with CodeBuild</a> in the <i>CodeBuild User Guide</i>.
     * </p>
     * 
     * @return A version of the build input to be built for this project. If not specified, the latest version is used.
     *         If specified, it must be one of:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For CodeCommit: the commit ID, branch, or Git tag to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of
     *         the source code you want to build. If a pull request ID is specified, it must use the format
     *         <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the
     *         branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code
     *         you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified,
     *         the default branch's HEAD commit ID is used.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For Amazon S3: the version ID of the object that represents the build input ZIP file to use.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If <code>sourceVersion</code> is specified at the build level, then that version takes precedence over
     *         this <code>sourceVersion</code> (at the project level).
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version
     *         Sample with CodeBuild</a> in the <i>CodeBuild User Guide</i>.
     */
    public final String sourceVersion() {
        return sourceVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecondarySourceVersions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSecondarySourceVersions() {
        return secondarySourceVersions != null && !(secondarySourceVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ProjectSourceVersion</code> objects. If <code>secondarySourceVersions</code> is specified at
     * the build level, then they take over these <code>secondarySourceVersions</code> (at the project level).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecondarySourceVersions} method.
     * </p>
     * 
     * @return An array of <code>ProjectSourceVersion</code> objects. If <code>secondarySourceVersions</code> is
     *         specified at the build level, then they take over these <code>secondarySourceVersions</code> (at the
     *         project level).
     */
    public final List<ProjectSourceVersion> secondarySourceVersions() {
        return secondarySourceVersions;
    }

    /**
     * <p>
     * Information about the build output artifacts for the build project.
     * </p>
     * 
     * @return Information about the build output artifacts for the build project.
     */
    public final ProjectArtifacts artifacts() {
        return artifacts;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecondaryArtifacts property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecondaryArtifacts() {
        return secondaryArtifacts != null && !(secondaryArtifacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ProjectArtifacts</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecondaryArtifacts} method.
     * </p>
     * 
     * @return An array of <code>ProjectArtifacts</code> objects.
     */
    public final List<ProjectArtifacts> secondaryArtifacts() {
        return secondaryArtifacts;
    }

    /**
     * <p>
     * Information about the cache for the build project.
     * </p>
     * 
     * @return Information about the cache for the build project.
     */
    public final ProjectCache cache() {
        return cache;
    }

    /**
     * <p>
     * Information about the build environment for this build project.
     * </p>
     * 
     * @return Information about the build environment for this build project.
     */
    public final ProjectEnvironment environment() {
        return environment;
    }

    /**
     * <p>
     * The ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services on behalf
     * of the Amazon Web Services account.
     * </p>
     * 
     * @return The ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services on
     *         behalf of the Amazon Web Services account.
     */
    public final String serviceRole() {
        return serviceRole;
    }

    /**
     * <p>
     * How long, in minutes, from 5 to 480 (8 hours), for CodeBuild to wait before timing out any related build that did
     * not get marked as completed. The default is 60 minutes.
     * </p>
     * 
     * @return How long, in minutes, from 5 to 480 (8 hours), for CodeBuild to wait before timing out any related build
     *         that did not get marked as completed. The default is 60 minutes.
     */
    public final Integer timeoutInMinutes() {
        return timeoutInMinutes;
    }

    /**
     * <p>
     * The number of minutes a build is allowed to be queued before it times out.
     * </p>
     * 
     * @return The number of minutes a build is allowed to be queued before it times out.
     */
    public final Integer queuedTimeoutInMinutes() {
        return queuedTimeoutInMinutes;
    }

    /**
     * <p>
     * The Key Management Service customer master key (CMK) to be used for encrypting the build output artifacts.
     * </p>
     * <note>
     * <p>
     * You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to
     * that key.
     * </p>
     * </note>
     * <p>
     * You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the
     * format <code>alias/&lt;alias-name&gt;</code>). If you don't specify a value, CodeBuild uses the managed CMK for
     * Amazon Simple Storage Service (Amazon S3).
     * </p>
     * 
     * @return The Key Management Service customer master key (CMK) to be used for encrypting the build output
     *         artifacts.</p> <note>
     *         <p>
     *         You can use a cross-account KMS key to encrypt the build output artifacts if your service role has
     *         permission to that key.
     *         </p>
     *         </note>
     *         <p>
     *         You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using
     *         the format <code>alias/&lt;alias-name&gt;</code>). If you don't specify a value, CodeBuild uses the
     *         managed CMK for Amazon Simple Storage Service (Amazon S3).
     */
    public final String encryptionKey() {
        return encryptionKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tag key and value pairs associated with this build project.
     * </p>
     * <p>
     * These tags are available for use by Amazon Web Services services that support CodeBuild build project tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tag key and value pairs associated with this build project.</p>
     *         <p>
     *         These tags are available for use by Amazon Web Services services that support CodeBuild build project
     *         tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * When the build project was created, expressed in Unix time format.
     * </p>
     * 
     * @return When the build project was created, expressed in Unix time format.
     */
    public final Instant created() {
        return created;
    }

    /**
     * <p>
     * When the build project's settings were last modified, expressed in Unix time format.
     * </p>
     * 
     * @return When the build project's settings were last modified, expressed in Unix time format.
     */
    public final Instant lastModified() {
        return lastModified;
    }

    /**
     * <p>
     * Information about a webhook that connects repository events to a build project in CodeBuild.
     * </p>
     * 
     * @return Information about a webhook that connects repository events to a build project in CodeBuild.
     */
    public final Webhook webhook() {
        return webhook;
    }

    /**
     * <p>
     * Information about the VPC configuration that CodeBuild accesses.
     * </p>
     * 
     * @return Information about the VPC configuration that CodeBuild accesses.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * Information about the build badge for the build project.
     * </p>
     * 
     * @return Information about the build badge for the build project.
     */
    public final ProjectBadge badge() {
        return badge;
    }

    /**
     * <p>
     * Information about logs for the build project. A project can create logs in CloudWatch Logs, an S3 bucket, or
     * both.
     * </p>
     * 
     * @return Information about logs for the build project. A project can create logs in CloudWatch Logs, an S3 bucket,
     *         or both.
     */
    public final LogsConfig logsConfig() {
        return logsConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the FileSystemLocations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFileSystemLocations() {
        return fileSystemLocations != null && !(fileSystemLocations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A
     * <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code>, <code>location</code>,
     * <code>mountOptions</code>, <code>mountPoint</code>, and <code>type</code> of a file system created using Amazon
     * Elastic File System.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFileSystemLocations} method.
     * </p>
     * 
     * @return An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A
     *         <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code>,
     *         <code>location</code>, <code>mountOptions</code>, <code>mountPoint</code>, and <code>type</code> of a
     *         file system created using Amazon Elastic File System.
     */
    public final List<ProjectFileSystemLocation> fileSystemLocations() {
        return fileSystemLocations;
    }

    /**
     * <p>
     * A <a>ProjectBuildBatchConfig</a> object that defines the batch build options for the project.
     * </p>
     * 
     * @return A <a>ProjectBuildBatchConfig</a> object that defines the batch build options for the project.
     */
    public final ProjectBuildBatchConfig buildBatchConfig() {
        return buildBatchConfig;
    }

    /**
     * <p>
     * The maximum number of concurrent builds that are allowed for this project.
     * </p>
     * <p>
     * New builds are only started if the current number of builds is less than or equal to this limit. If the current
     * build count meets this limit, new builds are throttled and are not run.
     * </p>
     * 
     * @return The maximum number of concurrent builds that are allowed for this project.</p>
     *         <p>
     *         New builds are only started if the current number of builds is less than or equal to this limit. If the
     *         current build count meets this limit, new builds are throttled and are not run.
     */
    public final Integer concurrentBuildLimit() {
        return concurrentBuildLimit;
    }

    /**
     * Returns the value of the ProjectVisibility property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #projectVisibility}
     * will return {@link ProjectVisibilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #projectVisibilityAsString}.
     * </p>
     * 
     * @return The value of the ProjectVisibility property for this object.
     * @see ProjectVisibilityType
     */
    public final ProjectVisibilityType projectVisibility() {
        return ProjectVisibilityType.fromValue(projectVisibility);
    }

    /**
     * Returns the value of the ProjectVisibility property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #projectVisibility}
     * will return {@link ProjectVisibilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #projectVisibilityAsString}.
     * </p>
     * 
     * @return The value of the ProjectVisibility property for this object.
     * @see ProjectVisibilityType
     */
    public final String projectVisibilityAsString() {
        return projectVisibility;
    }

    /**
     * <p>
     * Contains the project identifier used with the public build APIs.
     * </p>
     * 
     * @return Contains the project identifier used with the public build APIs.
     */
    public final String publicProjectAlias() {
        return publicProjectAlias;
    }

    /**
     * <p>
     * The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the
     * project's builds.
     * </p>
     * 
     * @return The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for
     *         the project's builds.
     */
    public final String resourceAccessRole() {
        return resourceAccessRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecondarySources() ? secondarySources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecondarySourceVersions() ? secondarySourceVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(artifacts());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecondaryArtifacts() ? secondaryArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cache());
        hashCode = 31 * hashCode + Objects.hashCode(environment());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(queuedTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(webhook());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(badge());
        hashCode = 31 * hashCode + Objects.hashCode(logsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasFileSystemLocations() ? fileSystemLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(buildBatchConfig());
        hashCode = 31 * hashCode + Objects.hashCode(concurrentBuildLimit());
        hashCode = 31 * hashCode + Objects.hashCode(projectVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(publicProjectAlias());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAccessRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Project)) {
            return false;
        }
        Project other = (Project) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(description(), other.description()) && Objects.equals(source(), other.source())
                && hasSecondarySources() == other.hasSecondarySources()
                && Objects.equals(secondarySources(), other.secondarySources())
                && Objects.equals(sourceVersion(), other.sourceVersion())
                && hasSecondarySourceVersions() == other.hasSecondarySourceVersions()
                && Objects.equals(secondarySourceVersions(), other.secondarySourceVersions())
                && Objects.equals(artifacts(), other.artifacts()) && hasSecondaryArtifacts() == other.hasSecondaryArtifacts()
                && Objects.equals(secondaryArtifacts(), other.secondaryArtifacts()) && Objects.equals(cache(), other.cache())
                && Objects.equals(environment(), other.environment()) && Objects.equals(serviceRole(), other.serviceRole())
                && Objects.equals(timeoutInMinutes(), other.timeoutInMinutes())
                && Objects.equals(queuedTimeoutInMinutes(), other.queuedTimeoutInMinutes())
                && Objects.equals(encryptionKey(), other.encryptionKey()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(created(), other.created())
                && Objects.equals(lastModified(), other.lastModified()) && Objects.equals(webhook(), other.webhook())
                && Objects.equals(vpcConfig(), other.vpcConfig()) && Objects.equals(badge(), other.badge())
                && Objects.equals(logsConfig(), other.logsConfig()) && hasFileSystemLocations() == other.hasFileSystemLocations()
                && Objects.equals(fileSystemLocations(), other.fileSystemLocations())
                && Objects.equals(buildBatchConfig(), other.buildBatchConfig())
                && Objects.equals(concurrentBuildLimit(), other.concurrentBuildLimit())
                && Objects.equals(projectVisibilityAsString(), other.projectVisibilityAsString())
                && Objects.equals(publicProjectAlias(), other.publicProjectAlias())
                && Objects.equals(resourceAccessRole(), other.resourceAccessRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Project").add("Name", name()).add("Arn", arn()).add("Description", description())
                .add("Source", source()).add("SecondarySources", hasSecondarySources() ? secondarySources() : null)
                .add("SourceVersion", sourceVersion())
                .add("SecondarySourceVersions", hasSecondarySourceVersions() ? secondarySourceVersions() : null)
                .add("Artifacts", artifacts()).add("SecondaryArtifacts", hasSecondaryArtifacts() ? secondaryArtifacts() : null)
                .add("Cache", cache()).add("Environment", environment()).add("ServiceRole", serviceRole())
                .add("TimeoutInMinutes", timeoutInMinutes()).add("QueuedTimeoutInMinutes", queuedTimeoutInMinutes())
                .add("EncryptionKey", encryptionKey()).add("Tags", hasTags() ? tags() : null).add("Created", created())
                .add("LastModified", lastModified()).add("Webhook", webhook()).add("VpcConfig", vpcConfig())
                .add("Badge", badge()).add("LogsConfig", logsConfig())
                .add("FileSystemLocations", hasFileSystemLocations() ? fileSystemLocations() : null)
                .add("BuildBatchConfig", buildBatchConfig()).add("ConcurrentBuildLimit", concurrentBuildLimit())
                .add("ProjectVisibility", projectVisibilityAsString()).add("PublicProjectAlias", publicProjectAlias())
                .add("ResourceAccessRole", resourceAccessRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "secondarySources":
            return Optional.ofNullable(clazz.cast(secondarySources()));
        case "sourceVersion":
            return Optional.ofNullable(clazz.cast(sourceVersion()));
        case "secondarySourceVersions":
            return Optional.ofNullable(clazz.cast(secondarySourceVersions()));
        case "artifacts":
            return Optional.ofNullable(clazz.cast(artifacts()));
        case "secondaryArtifacts":
            return Optional.ofNullable(clazz.cast(secondaryArtifacts()));
        case "cache":
            return Optional.ofNullable(clazz.cast(cache()));
        case "environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "serviceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        case "timeoutInMinutes":
            return Optional.ofNullable(clazz.cast(timeoutInMinutes()));
        case "queuedTimeoutInMinutes":
            return Optional.ofNullable(clazz.cast(queuedTimeoutInMinutes()));
        case "encryptionKey":
            return Optional.ofNullable(clazz.cast(encryptionKey()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "created":
            return Optional.ofNullable(clazz.cast(created()));
        case "lastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        case "webhook":
            return Optional.ofNullable(clazz.cast(webhook()));
        case "vpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "badge":
            return Optional.ofNullable(clazz.cast(badge()));
        case "logsConfig":
            return Optional.ofNullable(clazz.cast(logsConfig()));
        case "fileSystemLocations":
            return Optional.ofNullable(clazz.cast(fileSystemLocations()));
        case "buildBatchConfig":
            return Optional.ofNullable(clazz.cast(buildBatchConfig()));
        case "concurrentBuildLimit":
            return Optional.ofNullable(clazz.cast(concurrentBuildLimit()));
        case "projectVisibility":
            return Optional.ofNullable(clazz.cast(projectVisibilityAsString()));
        case "publicProjectAlias":
            return Optional.ofNullable(clazz.cast(publicProjectAlias()));
        case "resourceAccessRole":
            return Optional.ofNullable(clazz.cast(resourceAccessRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Project, T> g) {
        return obj -> g.apply((Project) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Project> {
        /**
         * <p>
         * The name of the build project.
         * </p>
         * 
         * @param name
         *        The name of the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the build project.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A description that makes the build project easy to identify.
         * </p>
         * 
         * @param description
         *        A description that makes the build project easy to identify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the build input source code for this build project.
         * </p>
         * 
         * @param source
         *        Information about the build input source code for this build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(ProjectSource source);

        /**
         * <p>
         * Information about the build input source code for this build project.
         * </p>
         * This is a convenience that creates an instance of the {@link ProjectSource.Builder} avoiding the need to
         * create one manually via {@link ProjectSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProjectSource.Builder#build()} is called immediately and its
         * result is passed to {@link #source(ProjectSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link ProjectSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(ProjectSource)
         */
        default Builder source(Consumer<ProjectSource.Builder> source) {
            return source(ProjectSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * An array of <code>ProjectSource</code> objects.
         * </p>
         * 
         * @param secondarySources
         *        An array of <code>ProjectSource</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySources(Collection<ProjectSource> secondarySources);

        /**
         * <p>
         * An array of <code>ProjectSource</code> objects.
         * </p>
         * 
         * @param secondarySources
         *        An array of <code>ProjectSource</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySources(ProjectSource... secondarySources);

        /**
         * <p>
         * An array of <code>ProjectSource</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProjectSource>.Builder} avoiding the need
         * to create one manually via {@link List<ProjectSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProjectSource>.Builder#build()} is called immediately and
         * its result is passed to {@link #secondarySources(List<ProjectSource>)}.
         * 
         * @param secondarySources
         *        a consumer that will call methods on {@link List<ProjectSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondarySources(List<ProjectSource>)
         */
        Builder secondarySources(Consumer<ProjectSource.Builder>... secondarySources);

        /**
         * <p>
         * A version of the build input to be built for this project. If not specified, the latest version is used. If
         * specified, it must be one of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For CodeCommit: the commit ID, branch, or Git tag to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the
         * source code you want to build. If a pull request ID is specified, it must use the format
         * <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the branch's
         * HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
         * </p>
         * </li>
         * <li>
         * <p>
         * For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you
         * want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the
         * default branch's HEAD commit ID is used.
         * </p>
         * </li>
         * <li>
         * <p>
         * For Amazon S3: the version ID of the object that represents the build input ZIP file to use.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If <code>sourceVersion</code> is specified at the build level, then that version takes precedence over this
         * <code>sourceVersion</code> (at the project level).
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version
         * Sample with CodeBuild</a> in the <i>CodeBuild User Guide</i>.
         * </p>
         * 
         * @param sourceVersion
         *        A version of the build input to be built for this project. If not specified, the latest version is
         *        used. If specified, it must be one of:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For CodeCommit: the commit ID, branch, or Git tag to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version
         *        of the source code you want to build. If a pull request ID is specified, it must use the format
         *        <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the
         *        branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source
         *        code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not
         *        specified, the default branch's HEAD commit ID is used.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For Amazon S3: the version ID of the object that represents the build input ZIP file to use.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If <code>sourceVersion</code> is specified at the build level, then that version takes precedence over
         *        this <code>sourceVersion</code> (at the project level).
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source
         *        Version Sample with CodeBuild</a> in the <i>CodeBuild User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVersion(String sourceVersion);

        /**
         * <p>
         * An array of <code>ProjectSourceVersion</code> objects. If <code>secondarySourceVersions</code> is specified
         * at the build level, then they take over these <code>secondarySourceVersions</code> (at the project level).
         * </p>
         * 
         * @param secondarySourceVersions
         *        An array of <code>ProjectSourceVersion</code> objects. If <code>secondarySourceVersions</code> is
         *        specified at the build level, then they take over these <code>secondarySourceVersions</code> (at the
         *        project level).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySourceVersions(Collection<ProjectSourceVersion> secondarySourceVersions);

        /**
         * <p>
         * An array of <code>ProjectSourceVersion</code> objects. If <code>secondarySourceVersions</code> is specified
         * at the build level, then they take over these <code>secondarySourceVersions</code> (at the project level).
         * </p>
         * 
         * @param secondarySourceVersions
         *        An array of <code>ProjectSourceVersion</code> objects. If <code>secondarySourceVersions</code> is
         *        specified at the build level, then they take over these <code>secondarySourceVersions</code> (at the
         *        project level).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySourceVersions(ProjectSourceVersion... secondarySourceVersions);

        /**
         * <p>
         * An array of <code>ProjectSourceVersion</code> objects. If <code>secondarySourceVersions</code> is specified
         * at the build level, then they take over these <code>secondarySourceVersions</code> (at the project level).
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProjectSourceVersion>.Builder} avoiding the
         * need to create one manually via {@link List<ProjectSourceVersion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProjectSourceVersion>.Builder#build()} is called immediately
         * and its result is passed to {@link #secondarySourceVersions(List<ProjectSourceVersion>)}.
         * 
         * @param secondarySourceVersions
         *        a consumer that will call methods on {@link List<ProjectSourceVersion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondarySourceVersions(List<ProjectSourceVersion>)
         */
        Builder secondarySourceVersions(Consumer<ProjectSourceVersion.Builder>... secondarySourceVersions);

        /**
         * <p>
         * Information about the build output artifacts for the build project.
         * </p>
         * 
         * @param artifacts
         *        Information about the build output artifacts for the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifacts(ProjectArtifacts artifacts);

        /**
         * <p>
         * Information about the build output artifacts for the build project.
         * </p>
         * This is a convenience that creates an instance of the {@link ProjectArtifacts.Builder} avoiding the need to
         * create one manually via {@link ProjectArtifacts#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProjectArtifacts.Builder#build()} is called immediately and its
         * result is passed to {@link #artifacts(ProjectArtifacts)}.
         * 
         * @param artifacts
         *        a consumer that will call methods on {@link ProjectArtifacts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #artifacts(ProjectArtifacts)
         */
        default Builder artifacts(Consumer<ProjectArtifacts.Builder> artifacts) {
            return artifacts(ProjectArtifacts.builder().applyMutation(artifacts).build());
        }

        /**
         * <p>
         * An array of <code>ProjectArtifacts</code> objects.
         * </p>
         * 
         * @param secondaryArtifacts
         *        An array of <code>ProjectArtifacts</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryArtifacts(Collection<ProjectArtifacts> secondaryArtifacts);

        /**
         * <p>
         * An array of <code>ProjectArtifacts</code> objects.
         * </p>
         * 
         * @param secondaryArtifacts
         *        An array of <code>ProjectArtifacts</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryArtifacts(ProjectArtifacts... secondaryArtifacts);

        /**
         * <p>
         * An array of <code>ProjectArtifacts</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProjectArtifacts>.Builder} avoiding the
         * need to create one manually via {@link List<ProjectArtifacts>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProjectArtifacts>.Builder#build()} is called immediately and
         * its result is passed to {@link #secondaryArtifacts(List<ProjectArtifacts>)}.
         * 
         * @param secondaryArtifacts
         *        a consumer that will call methods on {@link List<ProjectArtifacts>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondaryArtifacts(List<ProjectArtifacts>)
         */
        Builder secondaryArtifacts(Consumer<ProjectArtifacts.Builder>... secondaryArtifacts);

        /**
         * <p>
         * Information about the cache for the build project.
         * </p>
         * 
         * @param cache
         *        Information about the cache for the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cache(ProjectCache cache);

        /**
         * <p>
         * Information about the cache for the build project.
         * </p>
         * This is a convenience that creates an instance of the {@link ProjectCache.Builder} avoiding the need to
         * create one manually via {@link ProjectCache#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProjectCache.Builder#build()} is called immediately and its
         * result is passed to {@link #cache(ProjectCache)}.
         * 
         * @param cache
         *        a consumer that will call methods on {@link ProjectCache.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cache(ProjectCache)
         */
        default Builder cache(Consumer<ProjectCache.Builder> cache) {
            return cache(ProjectCache.builder().applyMutation(cache).build());
        }

        /**
         * <p>
         * Information about the build environment for this build project.
         * </p>
         * 
         * @param environment
         *        Information about the build environment for this build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(ProjectEnvironment environment);

        /**
         * <p>
         * Information about the build environment for this build project.
         * </p>
         * This is a convenience that creates an instance of the {@link ProjectEnvironment.Builder} avoiding the need to
         * create one manually via {@link ProjectEnvironment#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProjectEnvironment.Builder#build()} is called immediately and its
         * result is passed to {@link #environment(ProjectEnvironment)}.
         * 
         * @param environment
         *        a consumer that will call methods on {@link ProjectEnvironment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environment(ProjectEnvironment)
         */
        default Builder environment(Consumer<ProjectEnvironment.Builder> environment) {
            return environment(ProjectEnvironment.builder().applyMutation(environment).build());
        }

        /**
         * <p>
         * The ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services on
         * behalf of the Amazon Web Services account.
         * </p>
         * 
         * @param serviceRole
         *        The ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services
         *        on behalf of the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * How long, in minutes, from 5 to 480 (8 hours), for CodeBuild to wait before timing out any related build that
         * did not get marked as completed. The default is 60 minutes.
         * </p>
         * 
         * @param timeoutInMinutes
         *        How long, in minutes, from 5 to 480 (8 hours), for CodeBuild to wait before timing out any related
         *        build that did not get marked as completed. The default is 60 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInMinutes(Integer timeoutInMinutes);

        /**
         * <p>
         * The number of minutes a build is allowed to be queued before it times out.
         * </p>
         * 
         * @param queuedTimeoutInMinutes
         *        The number of minutes a build is allowed to be queued before it times out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queuedTimeoutInMinutes(Integer queuedTimeoutInMinutes);

        /**
         * <p>
         * The Key Management Service customer master key (CMK) to be used for encrypting the build output artifacts.
         * </p>
         * <note>
         * <p>
         * You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission
         * to that key.
         * </p>
         * </note>
         * <p>
         * You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the
         * format <code>alias/&lt;alias-name&gt;</code>). If you don't specify a value, CodeBuild uses the managed CMK
         * for Amazon Simple Storage Service (Amazon S3).
         * </p>
         * 
         * @param encryptionKey
         *        The Key Management Service customer master key (CMK) to be used for encrypting the build output
         *        artifacts.</p> <note>
         *        <p>
         *        You can use a cross-account KMS key to encrypt the build output artifacts if your service role has
         *        permission to that key.
         *        </p>
         *        </note>
         *        <p>
         *        You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias
         *        (using the format <code>alias/&lt;alias-name&gt;</code>). If you don't specify a value, CodeBuild uses
         *        the managed CMK for Amazon Simple Storage Service (Amazon S3).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKey(String encryptionKey);

        /**
         * <p>
         * A list of tag key and value pairs associated with this build project.
         * </p>
         * <p>
         * These tags are available for use by Amazon Web Services services that support CodeBuild build project tags.
         * </p>
         * 
         * @param tags
         *        A list of tag key and value pairs associated with this build project.</p>
         *        <p>
         *        These tags are available for use by Amazon Web Services services that support CodeBuild build project
         *        tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tag key and value pairs associated with this build project.
         * </p>
         * <p>
         * These tags are available for use by Amazon Web Services services that support CodeBuild build project tags.
         * </p>
         * 
         * @param tags
         *        A list of tag key and value pairs associated with this build project.</p>
         *        <p>
         *        These tags are available for use by Amazon Web Services services that support CodeBuild build project
         *        tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tag key and value pairs associated with this build project.
         * </p>
         * <p>
         * These tags are available for use by Amazon Web Services services that support CodeBuild build project tags.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * When the build project was created, expressed in Unix time format.
         * </p>
         * 
         * @param created
         *        When the build project was created, expressed in Unix time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * When the build project's settings were last modified, expressed in Unix time format.
         * </p>
         * 
         * @param lastModified
         *        When the build project's settings were last modified, expressed in Unix time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);

        /**
         * <p>
         * Information about a webhook that connects repository events to a build project in CodeBuild.
         * </p>
         * 
         * @param webhook
         *        Information about a webhook that connects repository events to a build project in CodeBuild.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webhook(Webhook webhook);

        /**
         * <p>
         * Information about a webhook that connects repository events to a build project in CodeBuild.
         * </p>
         * This is a convenience that creates an instance of the {@link Webhook.Builder} avoiding the need to create one
         * manually via {@link Webhook#builder()}.
         *
         * When the {@link Consumer} completes, {@link Webhook.Builder#build()} is called immediately and its result is
         * passed to {@link #webhook(Webhook)}.
         * 
         * @param webhook
         *        a consumer that will call methods on {@link Webhook.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webhook(Webhook)
         */
        default Builder webhook(Consumer<Webhook.Builder> webhook) {
            return webhook(Webhook.builder().applyMutation(webhook).build());
        }

        /**
         * <p>
         * Information about the VPC configuration that CodeBuild accesses.
         * </p>
         * 
         * @param vpcConfig
         *        Information about the VPC configuration that CodeBuild accesses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * Information about the VPC configuration that CodeBuild accesses.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcConfig.Builder} avoiding the need to create
         * one manually via {@link VpcConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * Information about the build badge for the build project.
         * </p>
         * 
         * @param badge
         *        Information about the build badge for the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder badge(ProjectBadge badge);

        /**
         * <p>
         * Information about the build badge for the build project.
         * </p>
         * This is a convenience that creates an instance of the {@link ProjectBadge.Builder} avoiding the need to
         * create one manually via {@link ProjectBadge#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProjectBadge.Builder#build()} is called immediately and its
         * result is passed to {@link #badge(ProjectBadge)}.
         * 
         * @param badge
         *        a consumer that will call methods on {@link ProjectBadge.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #badge(ProjectBadge)
         */
        default Builder badge(Consumer<ProjectBadge.Builder> badge) {
            return badge(ProjectBadge.builder().applyMutation(badge).build());
        }

        /**
         * <p>
         * Information about logs for the build project. A project can create logs in CloudWatch Logs, an S3 bucket, or
         * both.
         * </p>
         * 
         * @param logsConfig
         *        Information about logs for the build project. A project can create logs in CloudWatch Logs, an S3
         *        bucket, or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logsConfig(LogsConfig logsConfig);

        /**
         * <p>
         * Information about logs for the build project. A project can create logs in CloudWatch Logs, an S3 bucket, or
         * both.
         * </p>
         * This is a convenience that creates an instance of the {@link LogsConfig.Builder} avoiding the need to create
         * one manually via {@link LogsConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link LogsConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #logsConfig(LogsConfig)}.
         * 
         * @param logsConfig
         *        a consumer that will call methods on {@link LogsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logsConfig(LogsConfig)
         */
        default Builder logsConfig(Consumer<LogsConfig.Builder> logsConfig) {
            return logsConfig(LogsConfig.builder().applyMutation(logsConfig).build());
        }

        /**
         * <p>
         * An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A
         * <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code>, <code>location</code>,
         * <code>mountOptions</code>, <code>mountPoint</code>, and <code>type</code> of a file system created using
         * Amazon Elastic File System.
         * </p>
         * 
         * @param fileSystemLocations
         *        An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A
         *        <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code>,
         *        <code>location</code>, <code>mountOptions</code>, <code>mountPoint</code>, and <code>type</code> of a
         *        file system created using Amazon Elastic File System.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemLocations(Collection<ProjectFileSystemLocation> fileSystemLocations);

        /**
         * <p>
         * An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A
         * <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code>, <code>location</code>,
         * <code>mountOptions</code>, <code>mountPoint</code>, and <code>type</code> of a file system created using
         * Amazon Elastic File System.
         * </p>
         * 
         * @param fileSystemLocations
         *        An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A
         *        <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code>,
         *        <code>location</code>, <code>mountOptions</code>, <code>mountPoint</code>, and <code>type</code> of a
         *        file system created using Amazon Elastic File System.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemLocations(ProjectFileSystemLocation... fileSystemLocations);

        /**
         * <p>
         * An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A
         * <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code>, <code>location</code>,
         * <code>mountOptions</code>, <code>mountPoint</code>, and <code>type</code> of a file system created using
         * Amazon Elastic File System.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProjectFileSystemLocation>.Builder}
         * avoiding the need to create one manually via {@link List<ProjectFileSystemLocation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProjectFileSystemLocation>.Builder#build()} is called
         * immediately and its result is passed to {@link #fileSystemLocations(List<ProjectFileSystemLocation>)}.
         * 
         * @param fileSystemLocations
         *        a consumer that will call methods on {@link List<ProjectFileSystemLocation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileSystemLocations(List<ProjectFileSystemLocation>)
         */
        Builder fileSystemLocations(Consumer<ProjectFileSystemLocation.Builder>... fileSystemLocations);

        /**
         * <p>
         * A <a>ProjectBuildBatchConfig</a> object that defines the batch build options for the project.
         * </p>
         * 
         * @param buildBatchConfig
         *        A <a>ProjectBuildBatchConfig</a> object that defines the batch build options for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildBatchConfig(ProjectBuildBatchConfig buildBatchConfig);

        /**
         * <p>
         * A <a>ProjectBuildBatchConfig</a> object that defines the batch build options for the project.
         * </p>
         * This is a convenience that creates an instance of the {@link ProjectBuildBatchConfig.Builder} avoiding the
         * need to create one manually via {@link ProjectBuildBatchConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProjectBuildBatchConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #buildBatchConfig(ProjectBuildBatchConfig)}.
         * 
         * @param buildBatchConfig
         *        a consumer that will call methods on {@link ProjectBuildBatchConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #buildBatchConfig(ProjectBuildBatchConfig)
         */
        default Builder buildBatchConfig(Consumer<ProjectBuildBatchConfig.Builder> buildBatchConfig) {
            return buildBatchConfig(ProjectBuildBatchConfig.builder().applyMutation(buildBatchConfig).build());
        }

        /**
         * <p>
         * The maximum number of concurrent builds that are allowed for this project.
         * </p>
         * <p>
         * New builds are only started if the current number of builds is less than or equal to this limit. If the
         * current build count meets this limit, new builds are throttled and are not run.
         * </p>
         * 
         * @param concurrentBuildLimit
         *        The maximum number of concurrent builds that are allowed for this project.</p>
         *        <p>
         *        New builds are only started if the current number of builds is less than or equal to this limit. If
         *        the current build count meets this limit, new builds are throttled and are not run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder concurrentBuildLimit(Integer concurrentBuildLimit);

        /**
         * Sets the value of the ProjectVisibility property for this object.
         *
         * @param projectVisibility
         *        The new value for the ProjectVisibility property for this object.
         * @see ProjectVisibilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProjectVisibilityType
         */
        Builder projectVisibility(String projectVisibility);

        /**
         * Sets the value of the ProjectVisibility property for this object.
         *
         * @param projectVisibility
         *        The new value for the ProjectVisibility property for this object.
         * @see ProjectVisibilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProjectVisibilityType
         */
        Builder projectVisibility(ProjectVisibilityType projectVisibility);

        /**
         * <p>
         * Contains the project identifier used with the public build APIs.
         * </p>
         * 
         * @param publicProjectAlias
         *        Contains the project identifier used with the public build APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicProjectAlias(String publicProjectAlias);

        /**
         * <p>
         * The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the
         * project's builds.
         * </p>
         * 
         * @param resourceAccessRole
         *        The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts
         *        for the project's builds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAccessRole(String resourceAccessRole);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String description;

        private ProjectSource source;

        private List<ProjectSource> secondarySources = DefaultSdkAutoConstructList.getInstance();

        private String sourceVersion;

        private List<ProjectSourceVersion> secondarySourceVersions = DefaultSdkAutoConstructList.getInstance();

        private ProjectArtifacts artifacts;

        private List<ProjectArtifacts> secondaryArtifacts = DefaultSdkAutoConstructList.getInstance();

        private ProjectCache cache;

        private ProjectEnvironment environment;

        private String serviceRole;

        private Integer timeoutInMinutes;

        private Integer queuedTimeoutInMinutes;

        private String encryptionKey;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Instant created;

        private Instant lastModified;

        private Webhook webhook;

        private VpcConfig vpcConfig;

        private ProjectBadge badge;

        private LogsConfig logsConfig;

        private List<ProjectFileSystemLocation> fileSystemLocations = DefaultSdkAutoConstructList.getInstance();

        private ProjectBuildBatchConfig buildBatchConfig;

        private Integer concurrentBuildLimit;

        private String projectVisibility;

        private String publicProjectAlias;

        private String resourceAccessRole;

        private BuilderImpl() {
        }

        private BuilderImpl(Project model) {
            name(model.name);
            arn(model.arn);
            description(model.description);
            source(model.source);
            secondarySources(model.secondarySources);
            sourceVersion(model.sourceVersion);
            secondarySourceVersions(model.secondarySourceVersions);
            artifacts(model.artifacts);
            secondaryArtifacts(model.secondaryArtifacts);
            cache(model.cache);
            environment(model.environment);
            serviceRole(model.serviceRole);
            timeoutInMinutes(model.timeoutInMinutes);
            queuedTimeoutInMinutes(model.queuedTimeoutInMinutes);
            encryptionKey(model.encryptionKey);
            tags(model.tags);
            created(model.created);
            lastModified(model.lastModified);
            webhook(model.webhook);
            vpcConfig(model.vpcConfig);
            badge(model.badge);
            logsConfig(model.logsConfig);
            fileSystemLocations(model.fileSystemLocations);
            buildBatchConfig(model.buildBatchConfig);
            concurrentBuildLimit(model.concurrentBuildLimit);
            projectVisibility(model.projectVisibility);
            publicProjectAlias(model.publicProjectAlias);
            resourceAccessRole(model.resourceAccessRole);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ProjectSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(ProjectSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        @Transient
        public final Builder source(ProjectSource source) {
            this.source = source;
            return this;
        }

        public final List<ProjectSource.Builder> getSecondarySources() {
            List<ProjectSource.Builder> result = ProjectSourcesCopier.copyToBuilder(this.secondarySources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondarySources(Collection<ProjectSource.BuilderImpl> secondarySources) {
            this.secondarySources = ProjectSourcesCopier.copyFromBuilder(secondarySources);
        }

        @Override
        @Transient
        public final Builder secondarySources(Collection<ProjectSource> secondarySources) {
            this.secondarySources = ProjectSourcesCopier.copy(secondarySources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder secondarySources(ProjectSource... secondarySources) {
            secondarySources(Arrays.asList(secondarySources));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder secondarySources(Consumer<ProjectSource.Builder>... secondarySources) {
            secondarySources(Stream.of(secondarySources).map(c -> ProjectSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSourceVersion() {
            return sourceVersion;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        @Transient
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final List<ProjectSourceVersion.Builder> getSecondarySourceVersions() {
            List<ProjectSourceVersion.Builder> result = ProjectSecondarySourceVersionsCopier
                    .copyToBuilder(this.secondarySourceVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondarySourceVersions(Collection<ProjectSourceVersion.BuilderImpl> secondarySourceVersions) {
            this.secondarySourceVersions = ProjectSecondarySourceVersionsCopier.copyFromBuilder(secondarySourceVersions);
        }

        @Override
        @Transient
        public final Builder secondarySourceVersions(Collection<ProjectSourceVersion> secondarySourceVersions) {
            this.secondarySourceVersions = ProjectSecondarySourceVersionsCopier.copy(secondarySourceVersions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder secondarySourceVersions(ProjectSourceVersion... secondarySourceVersions) {
            secondarySourceVersions(Arrays.asList(secondarySourceVersions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder secondarySourceVersions(Consumer<ProjectSourceVersion.Builder>... secondarySourceVersions) {
            secondarySourceVersions(Stream.of(secondarySourceVersions)
                    .map(c -> ProjectSourceVersion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProjectArtifacts.Builder getArtifacts() {
            return artifacts != null ? artifacts.toBuilder() : null;
        }

        public final void setArtifacts(ProjectArtifacts.BuilderImpl artifacts) {
            this.artifacts = artifacts != null ? artifacts.build() : null;
        }

        @Override
        @Transient
        public final Builder artifacts(ProjectArtifacts artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        public final List<ProjectArtifacts.Builder> getSecondaryArtifacts() {
            List<ProjectArtifacts.Builder> result = ProjectArtifactsListCopier.copyToBuilder(this.secondaryArtifacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondaryArtifacts(Collection<ProjectArtifacts.BuilderImpl> secondaryArtifacts) {
            this.secondaryArtifacts = ProjectArtifactsListCopier.copyFromBuilder(secondaryArtifacts);
        }

        @Override
        @Transient
        public final Builder secondaryArtifacts(Collection<ProjectArtifacts> secondaryArtifacts) {
            this.secondaryArtifacts = ProjectArtifactsListCopier.copy(secondaryArtifacts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder secondaryArtifacts(ProjectArtifacts... secondaryArtifacts) {
            secondaryArtifacts(Arrays.asList(secondaryArtifacts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder secondaryArtifacts(Consumer<ProjectArtifacts.Builder>... secondaryArtifacts) {
            secondaryArtifacts(Stream.of(secondaryArtifacts).map(c -> ProjectArtifacts.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ProjectCache.Builder getCache() {
            return cache != null ? cache.toBuilder() : null;
        }

        public final void setCache(ProjectCache.BuilderImpl cache) {
            this.cache = cache != null ? cache.build() : null;
        }

        @Override
        @Transient
        public final Builder cache(ProjectCache cache) {
            this.cache = cache;
            return this;
        }

        public final ProjectEnvironment.Builder getEnvironment() {
            return environment != null ? environment.toBuilder() : null;
        }

        public final void setEnvironment(ProjectEnvironment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        @Override
        @Transient
        public final Builder environment(ProjectEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        @Transient
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final Integer getTimeoutInMinutes() {
            return timeoutInMinutes;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        @Override
        @Transient
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public final Integer getQueuedTimeoutInMinutes() {
            return queuedTimeoutInMinutes;
        }

        public final void setQueuedTimeoutInMinutes(Integer queuedTimeoutInMinutes) {
            this.queuedTimeoutInMinutes = queuedTimeoutInMinutes;
        }

        @Override
        @Transient
        public final Builder queuedTimeoutInMinutes(Integer queuedTimeoutInMinutes) {
            this.queuedTimeoutInMinutes = queuedTimeoutInMinutes;
            return this;
        }

        public final String getEncryptionKey() {
            return encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        @Transient
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreated() {
            return created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        @Transient
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        @Transient
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final Webhook.Builder getWebhook() {
            return webhook != null ? webhook.toBuilder() : null;
        }

        public final void setWebhook(Webhook.BuilderImpl webhook) {
            this.webhook = webhook != null ? webhook.build() : null;
        }

        @Override
        @Transient
        public final Builder webhook(Webhook webhook) {
            this.webhook = webhook;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final ProjectBadge.Builder getBadge() {
            return badge != null ? badge.toBuilder() : null;
        }

        public final void setBadge(ProjectBadge.BuilderImpl badge) {
            this.badge = badge != null ? badge.build() : null;
        }

        @Override
        @Transient
        public final Builder badge(ProjectBadge badge) {
            this.badge = badge;
            return this;
        }

        public final LogsConfig.Builder getLogsConfig() {
            return logsConfig != null ? logsConfig.toBuilder() : null;
        }

        public final void setLogsConfig(LogsConfig.BuilderImpl logsConfig) {
            this.logsConfig = logsConfig != null ? logsConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder logsConfig(LogsConfig logsConfig) {
            this.logsConfig = logsConfig;
            return this;
        }

        public final List<ProjectFileSystemLocation.Builder> getFileSystemLocations() {
            List<ProjectFileSystemLocation.Builder> result = ProjectFileSystemLocationsCopier
                    .copyToBuilder(this.fileSystemLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileSystemLocations(Collection<ProjectFileSystemLocation.BuilderImpl> fileSystemLocations) {
            this.fileSystemLocations = ProjectFileSystemLocationsCopier.copyFromBuilder(fileSystemLocations);
        }

        @Override
        @Transient
        public final Builder fileSystemLocations(Collection<ProjectFileSystemLocation> fileSystemLocations) {
            this.fileSystemLocations = ProjectFileSystemLocationsCopier.copy(fileSystemLocations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder fileSystemLocations(ProjectFileSystemLocation... fileSystemLocations) {
            fileSystemLocations(Arrays.asList(fileSystemLocations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder fileSystemLocations(Consumer<ProjectFileSystemLocation.Builder>... fileSystemLocations) {
            fileSystemLocations(Stream.of(fileSystemLocations)
                    .map(c -> ProjectFileSystemLocation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProjectBuildBatchConfig.Builder getBuildBatchConfig() {
            return buildBatchConfig != null ? buildBatchConfig.toBuilder() : null;
        }

        public final void setBuildBatchConfig(ProjectBuildBatchConfig.BuilderImpl buildBatchConfig) {
            this.buildBatchConfig = buildBatchConfig != null ? buildBatchConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder buildBatchConfig(ProjectBuildBatchConfig buildBatchConfig) {
            this.buildBatchConfig = buildBatchConfig;
            return this;
        }

        public final Integer getConcurrentBuildLimit() {
            return concurrentBuildLimit;
        }

        public final void setConcurrentBuildLimit(Integer concurrentBuildLimit) {
            this.concurrentBuildLimit = concurrentBuildLimit;
        }

        @Override
        @Transient
        public final Builder concurrentBuildLimit(Integer concurrentBuildLimit) {
            this.concurrentBuildLimit = concurrentBuildLimit;
            return this;
        }

        public final String getProjectVisibility() {
            return projectVisibility;
        }

        public final void setProjectVisibility(String projectVisibility) {
            this.projectVisibility = projectVisibility;
        }

        @Override
        @Transient
        public final Builder projectVisibility(String projectVisibility) {
            this.projectVisibility = projectVisibility;
            return this;
        }

        @Override
        @Transient
        public final Builder projectVisibility(ProjectVisibilityType projectVisibility) {
            this.projectVisibility(projectVisibility == null ? null : projectVisibility.toString());
            return this;
        }

        public final String getPublicProjectAlias() {
            return publicProjectAlias;
        }

        public final void setPublicProjectAlias(String publicProjectAlias) {
            this.publicProjectAlias = publicProjectAlias;
        }

        @Override
        @Transient
        public final Builder publicProjectAlias(String publicProjectAlias) {
            this.publicProjectAlias = publicProjectAlias;
            return this;
        }

        public final String getResourceAccessRole() {
            return resourceAccessRole;
        }

        public final void setResourceAccessRole(String resourceAccessRole) {
            this.resourceAccessRole = resourceAccessRole;
        }

        @Override
        @Transient
        public final Builder resourceAccessRole(String resourceAccessRole) {
            this.resourceAccessRole = resourceAccessRole;
            return this;
        }

        @Override
        public Project build() {
            return new Project(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
