/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A series of reports. Each report contains information about the results from running a series of test cases. You
 * specify the test cases for a report group in the buildspec for a build project using one or more paths to the test
 * case files.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportGroup implements SdkPojo, Serializable, ToCopyableBuilder<ReportGroup.Builder, ReportGroup> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ReportGroup::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ReportGroup::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ReportGroup::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<ReportExportConfig> EXPORT_CONFIG_FIELD = SdkField
            .<ReportExportConfig> builder(MarshallingType.SDK_POJO).memberName("exportConfig")
            .getter(getter(ReportGroup::exportConfig)).setter(setter(Builder::exportConfig))
            .constructor(ReportExportConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportConfig").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("created").getter(getter(ReportGroup::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModified").getter(getter(ReportGroup::lastModified)).setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModified").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(ReportGroup::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ReportGroup::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            TYPE_FIELD, EXPORT_CONFIG_FIELD, CREATED_FIELD, LAST_MODIFIED_FIELD, TAGS_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String type;

    private final ReportExportConfig exportConfig;

    private final Instant created;

    private final Instant lastModified;

    private final List<Tag> tags;

    private final String status;

    private ReportGroup(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.exportConfig = builder.exportConfig;
        this.created = builder.created;
        this.lastModified = builder.lastModified;
        this.tags = builder.tags;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ARN of the <code>ReportGroup</code>.
     * </p>
     * 
     * @return The ARN of the <code>ReportGroup</code>.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the <code>ReportGroup</code>.
     * </p>
     * 
     * @return The name of the <code>ReportGroup</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of the <code>ReportGroup</code>. This can be one of the following values:
     * </p>
     * <dl>
     * <dt>CODE_COVERAGE</dt>
     * <dd>
     * <p>
     * The report group contains code coverage reports.
     * </p>
     * </dd>
     * <dt>TEST</dt>
     * <dd>
     * <p>
     * The report group contains test reports.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ReportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the <code>ReportGroup</code>. This can be one of the following values:</p>
     *         <dl>
     *         <dt>CODE_COVERAGE</dt>
     *         <dd>
     *         <p>
     *         The report group contains code coverage reports.
     *         </p>
     *         </dd>
     *         <dt>TEST</dt>
     *         <dd>
     *         <p>
     *         The report group contains test reports.
     *         </p>
     *         </dd>
     * @see ReportType
     */
    public final ReportType type() {
        return ReportType.fromValue(type);
    }

    /**
     * <p>
     * The type of the <code>ReportGroup</code>. This can be one of the following values:
     * </p>
     * <dl>
     * <dt>CODE_COVERAGE</dt>
     * <dd>
     * <p>
     * The report group contains code coverage reports.
     * </p>
     * </dd>
     * <dt>TEST</dt>
     * <dd>
     * <p>
     * The report group contains test reports.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ReportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the <code>ReportGroup</code>. This can be one of the following values:</p>
     *         <dl>
     *         <dt>CODE_COVERAGE</dt>
     *         <dd>
     *         <p>
     *         The report group contains code coverage reports.
     *         </p>
     *         </dd>
     *         <dt>TEST</dt>
     *         <dd>
     *         <p>
     *         The report group contains test reports.
     *         </p>
     *         </dd>
     * @see ReportType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Information about the destination where the raw data of this <code>ReportGroup</code> is exported.
     * </p>
     * 
     * @return Information about the destination where the raw data of this <code>ReportGroup</code> is exported.
     */
    public final ReportExportConfig exportConfig() {
        return exportConfig;
    }

    /**
     * <p>
     * The date and time this <code>ReportGroup</code> was created.
     * </p>
     * 
     * @return The date and time this <code>ReportGroup</code> was created.
     */
    public final Instant created() {
        return created;
    }

    /**
     * <p>
     * The date and time this <code>ReportGroup</code> was last modified.
     * </p>
     * 
     * @return The date and time this <code>ReportGroup</code> was last modified.
     */
    public final Instant lastModified() {
        return lastModified;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tag key and value pairs associated with this report group.
     * </p>
     * <p>
     * These tags are available for use by Amazon Web Services services that support CodeBuild report group tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tag key and value pairs associated with this report group. </p>
     *         <p>
     *         These tags are available for use by Amazon Web Services services that support CodeBuild report group
     *         tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The status of the report group. This property is read-only.
     * </p>
     * <p>
     * This can be one of the following values:
     * </p>
     * <dl>
     * <dt>ACTIVE</dt>
     * <dd>
     * <p>
     * The report group is active.
     * </p>
     * </dd>
     * <dt>DELETING</dt>
     * <dd>
     * <p>
     * The report group is in the process of being deleted.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReportGroupStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the report group. This property is read-only.</p>
     *         <p>
     *         This can be one of the following values:
     *         </p>
     *         <dl>
     *         <dt>ACTIVE</dt>
     *         <dd>
     *         <p>
     *         The report group is active.
     *         </p>
     *         </dd>
     *         <dt>DELETING</dt>
     *         <dd>
     *         <p>
     *         The report group is in the process of being deleted.
     *         </p>
     *         </dd>
     * @see ReportGroupStatusType
     */
    public final ReportGroupStatusType status() {
        return ReportGroupStatusType.fromValue(status);
    }

    /**
     * <p>
     * The status of the report group. This property is read-only.
     * </p>
     * <p>
     * This can be one of the following values:
     * </p>
     * <dl>
     * <dt>ACTIVE</dt>
     * <dd>
     * <p>
     * The report group is active.
     * </p>
     * </dd>
     * <dt>DELETING</dt>
     * <dd>
     * <p>
     * The report group is in the process of being deleted.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReportGroupStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the report group. This property is read-only.</p>
     *         <p>
     *         This can be one of the following values:
     *         </p>
     *         <dl>
     *         <dt>ACTIVE</dt>
     *         <dd>
     *         <p>
     *         The report group is active.
     *         </p>
     *         </dd>
     *         <dt>DELETING</dt>
     *         <dd>
     *         <p>
     *         The report group is in the process of being deleted.
     *         </p>
     *         </dd>
     * @see ReportGroupStatusType
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exportConfig());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportGroup)) {
            return false;
        }
        ReportGroup other = (ReportGroup) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(exportConfig(), other.exportConfig())
                && Objects.equals(created(), other.created()) && Objects.equals(lastModified(), other.lastModified())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportGroup").add("Arn", arn()).add("Name", name()).add("Type", typeAsString())
                .add("ExportConfig", exportConfig()).add("Created", created()).add("LastModified", lastModified())
                .add("Tags", hasTags() ? tags() : null).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "exportConfig":
            return Optional.ofNullable(clazz.cast(exportConfig()));
        case "created":
            return Optional.ofNullable(clazz.cast(created()));
        case "lastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportGroup, T> g) {
        return obj -> g.apply((ReportGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportGroup> {
        /**
         * <p>
         * The ARN of the <code>ReportGroup</code>.
         * </p>
         * 
         * @param arn
         *        The ARN of the <code>ReportGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the <code>ReportGroup</code>.
         * </p>
         * 
         * @param name
         *        The name of the <code>ReportGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the <code>ReportGroup</code>. This can be one of the following values:
         * </p>
         * <dl>
         * <dt>CODE_COVERAGE</dt>
         * <dd>
         * <p>
         * The report group contains code coverage reports.
         * </p>
         * </dd>
         * <dt>TEST</dt>
         * <dd>
         * <p>
         * The report group contains test reports.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param type
         *        The type of the <code>ReportGroup</code>. This can be one of the following values:</p>
         *        <dl>
         *        <dt>CODE_COVERAGE</dt>
         *        <dd>
         *        <p>
         *        The report group contains code coverage reports.
         *        </p>
         *        </dd>
         *        <dt>TEST</dt>
         *        <dd>
         *        <p>
         *        The report group contains test reports.
         *        </p>
         *        </dd>
         * @see ReportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the <code>ReportGroup</code>. This can be one of the following values:
         * </p>
         * <dl>
         * <dt>CODE_COVERAGE</dt>
         * <dd>
         * <p>
         * The report group contains code coverage reports.
         * </p>
         * </dd>
         * <dt>TEST</dt>
         * <dd>
         * <p>
         * The report group contains test reports.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param type
         *        The type of the <code>ReportGroup</code>. This can be one of the following values:</p>
         *        <dl>
         *        <dt>CODE_COVERAGE</dt>
         *        <dd>
         *        <p>
         *        The report group contains code coverage reports.
         *        </p>
         *        </dd>
         *        <dt>TEST</dt>
         *        <dd>
         *        <p>
         *        The report group contains test reports.
         *        </p>
         *        </dd>
         * @see ReportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportType
         */
        Builder type(ReportType type);

        /**
         * <p>
         * Information about the destination where the raw data of this <code>ReportGroup</code> is exported.
         * </p>
         * 
         * @param exportConfig
         *        Information about the destination where the raw data of this <code>ReportGroup</code> is exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportConfig(ReportExportConfig exportConfig);

        /**
         * <p>
         * Information about the destination where the raw data of this <code>ReportGroup</code> is exported.
         * </p>
         * This is a convenience that creates an instance of the {@link ReportExportConfig.Builder} avoiding the need to
         * create one manually via {@link ReportExportConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReportExportConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #exportConfig(ReportExportConfig)}.
         * 
         * @param exportConfig
         *        a consumer that will call methods on {@link ReportExportConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportConfig(ReportExportConfig)
         */
        default Builder exportConfig(Consumer<ReportExportConfig.Builder> exportConfig) {
            return exportConfig(ReportExportConfig.builder().applyMutation(exportConfig).build());
        }

        /**
         * <p>
         * The date and time this <code>ReportGroup</code> was created.
         * </p>
         * 
         * @param created
         *        The date and time this <code>ReportGroup</code> was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The date and time this <code>ReportGroup</code> was last modified.
         * </p>
         * 
         * @param lastModified
         *        The date and time this <code>ReportGroup</code> was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);

        /**
         * <p>
         * A list of tag key and value pairs associated with this report group.
         * </p>
         * <p>
         * These tags are available for use by Amazon Web Services services that support CodeBuild report group tags.
         * </p>
         * 
         * @param tags
         *        A list of tag key and value pairs associated with this report group. </p>
         *        <p>
         *        These tags are available for use by Amazon Web Services services that support CodeBuild report group
         *        tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tag key and value pairs associated with this report group.
         * </p>
         * <p>
         * These tags are available for use by Amazon Web Services services that support CodeBuild report group tags.
         * </p>
         * 
         * @param tags
         *        A list of tag key and value pairs associated with this report group. </p>
         *        <p>
         *        These tags are available for use by Amazon Web Services services that support CodeBuild report group
         *        tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tag key and value pairs associated with this report group.
         * </p>
         * <p>
         * These tags are available for use by Amazon Web Services services that support CodeBuild report group tags.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The status of the report group. This property is read-only.
         * </p>
         * <p>
         * This can be one of the following values:
         * </p>
         * <dl>
         * <dt>ACTIVE</dt>
         * <dd>
         * <p>
         * The report group is active.
         * </p>
         * </dd>
         * <dt>DELETING</dt>
         * <dd>
         * <p>
         * The report group is in the process of being deleted.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the report group. This property is read-only.</p>
         *        <p>
         *        This can be one of the following values:
         *        </p>
         *        <dl>
         *        <dt>ACTIVE</dt>
         *        <dd>
         *        <p>
         *        The report group is active.
         *        </p>
         *        </dd>
         *        <dt>DELETING</dt>
         *        <dd>
         *        <p>
         *        The report group is in the process of being deleted.
         *        </p>
         *        </dd>
         * @see ReportGroupStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportGroupStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the report group. This property is read-only.
         * </p>
         * <p>
         * This can be one of the following values:
         * </p>
         * <dl>
         * <dt>ACTIVE</dt>
         * <dd>
         * <p>
         * The report group is active.
         * </p>
         * </dd>
         * <dt>DELETING</dt>
         * <dd>
         * <p>
         * The report group is in the process of being deleted.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the report group. This property is read-only.</p>
         *        <p>
         *        This can be one of the following values:
         *        </p>
         *        <dl>
         *        <dt>ACTIVE</dt>
         *        <dd>
         *        <p>
         *        The report group is active.
         *        </p>
         *        </dd>
         *        <dt>DELETING</dt>
         *        <dd>
         *        <p>
         *        The report group is in the process of being deleted.
         *        </p>
         *        </dd>
         * @see ReportGroupStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportGroupStatusType
         */
        Builder status(ReportGroupStatusType status);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String type;

        private ReportExportConfig exportConfig;

        private Instant created;

        private Instant lastModified;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportGroup model) {
            arn(model.arn);
            name(model.name);
            type(model.type);
            exportConfig(model.exportConfig);
            created(model.created);
            lastModified(model.lastModified);
            tags(model.tags);
            status(model.status);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(ReportType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final ReportExportConfig.Builder getExportConfig() {
            return exportConfig != null ? exportConfig.toBuilder() : null;
        }

        public final void setExportConfig(ReportExportConfig.BuilderImpl exportConfig) {
            this.exportConfig = exportConfig != null ? exportConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder exportConfig(ReportExportConfig exportConfig) {
            this.exportConfig = exportConfig;
            return this;
        }

        public final Instant getCreated() {
            return created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        @Transient
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        @Transient
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ReportGroupStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ReportGroup build() {
            return new ReportGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
