/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains trend statistics for a set of reports. The actual values depend on the type of trend being collected. For
 * more information, see .
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportGroupTrendStats implements SdkPojo, Serializable,
        ToCopyableBuilder<ReportGroupTrendStats.Builder, ReportGroupTrendStats> {
    private static final SdkField<String> AVERAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("average")
            .getter(getter(ReportGroupTrendStats::average)).setter(setter(Builder::average))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("average").build()).build();

    private static final SdkField<String> MAX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("max")
            .getter(getter(ReportGroupTrendStats::max)).setter(setter(Builder::max))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("max").build()).build();

    private static final SdkField<String> MIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("min")
            .getter(getter(ReportGroupTrendStats::min)).setter(setter(Builder::min))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("min").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVERAGE_FIELD, MAX_FIELD,
            MIN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String average;

    private final String max;

    private final String min;

    private ReportGroupTrendStats(BuilderImpl builder) {
        this.average = builder.average;
        this.max = builder.max;
        this.min = builder.min;
    }

    /**
     * <p>
     * Contains the average of all values analyzed.
     * </p>
     * 
     * @return Contains the average of all values analyzed.
     */
    public final String average() {
        return average;
    }

    /**
     * <p>
     * Contains the maximum value analyzed.
     * </p>
     * 
     * @return Contains the maximum value analyzed.
     */
    public final String max() {
        return max;
    }

    /**
     * <p>
     * Contains the minimum value analyzed.
     * </p>
     * 
     * @return Contains the minimum value analyzed.
     */
    public final String min() {
        return min;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(average());
        hashCode = 31 * hashCode + Objects.hashCode(max());
        hashCode = 31 * hashCode + Objects.hashCode(min());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportGroupTrendStats)) {
            return false;
        }
        ReportGroupTrendStats other = (ReportGroupTrendStats) obj;
        return Objects.equals(average(), other.average()) && Objects.equals(max(), other.max())
                && Objects.equals(min(), other.min());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportGroupTrendStats").add("Average", average()).add("Max", max()).add("Min", min()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "average":
            return Optional.ofNullable(clazz.cast(average()));
        case "max":
            return Optional.ofNullable(clazz.cast(max()));
        case "min":
            return Optional.ofNullable(clazz.cast(min()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportGroupTrendStats, T> g) {
        return obj -> g.apply((ReportGroupTrendStats) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportGroupTrendStats> {
        /**
         * <p>
         * Contains the average of all values analyzed.
         * </p>
         * 
         * @param average
         *        Contains the average of all values analyzed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder average(String average);

        /**
         * <p>
         * Contains the maximum value analyzed.
         * </p>
         * 
         * @param max
         *        Contains the maximum value analyzed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder max(String max);

        /**
         * <p>
         * Contains the minimum value analyzed.
         * </p>
         * 
         * @param min
         *        Contains the minimum value analyzed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder min(String min);
    }

    static final class BuilderImpl implements Builder {
        private String average;

        private String max;

        private String min;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportGroupTrendStats model) {
            average(model.average);
            max(model.max);
            min(model.min);
        }

        public final String getAverage() {
            return average;
        }

        public final void setAverage(String average) {
            this.average = average;
        }

        @Override
        @Transient
        public final Builder average(String average) {
            this.average = average;
            return this;
        }

        public final String getMax() {
            return max;
        }

        public final void setMax(String max) {
            this.max = max;
        }

        @Override
        @Transient
        public final Builder max(String max) {
            this.max = max;
            return this;
        }

        public final String getMin() {
            return min;
        }

        public final void setMin(String min) {
            this.min = min;
        }

        @Override
        @Transient
        public final Builder min(String min) {
            this.min = min;
            return this;
        }

        @Override
        public ReportGroupTrendStats build() {
            return new ReportGroupTrendStats(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
