/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartBuildBatchResponse extends CodeBuildResponse implements
        ToCopyableBuilder<StartBuildBatchResponse.Builder, StartBuildBatchResponse> {
    private static final SdkField<BuildBatch> BUILD_BATCH_FIELD = SdkField.<BuildBatch> builder(MarshallingType.SDK_POJO)
            .memberName("buildBatch").getter(getter(StartBuildBatchResponse::buildBatch)).setter(setter(Builder::buildBatch))
            .constructor(BuildBatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildBatch").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUILD_BATCH_FIELD));

    private final BuildBatch buildBatch;

    private StartBuildBatchResponse(BuilderImpl builder) {
        super(builder);
        this.buildBatch = builder.buildBatch;
    }

    /**
     * <p>
     * A <code>BuildBatch</code> object that contains information about the batch build.
     * </p>
     * 
     * @return A <code>BuildBatch</code> object that contains information about the batch build.
     */
    public final BuildBatch buildBatch() {
        return buildBatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(buildBatch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBuildBatchResponse)) {
            return false;
        }
        StartBuildBatchResponse other = (StartBuildBatchResponse) obj;
        return Objects.equals(buildBatch(), other.buildBatch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartBuildBatchResponse").add("BuildBatch", buildBatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "buildBatch":
            return Optional.ofNullable(clazz.cast(buildBatch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartBuildBatchResponse, T> g) {
        return obj -> g.apply((StartBuildBatchResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartBuildBatchResponse> {
        /**
         * <p>
         * A <code>BuildBatch</code> object that contains information about the batch build.
         * </p>
         * 
         * @param buildBatch
         *        A <code>BuildBatch</code> object that contains information about the batch build.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildBatch(BuildBatch buildBatch);

        /**
         * <p>
         * A <code>BuildBatch</code> object that contains information about the batch build.
         * </p>
         * This is a convenience that creates an instance of the {@link BuildBatch.Builder} avoiding the need to create
         * one manually via {@link BuildBatch#builder()}.
         *
         * When the {@link Consumer} completes, {@link BuildBatch.Builder#build()} is called immediately and its result
         * is passed to {@link #buildBatch(BuildBatch)}.
         * 
         * @param buildBatch
         *        a consumer that will call methods on {@link BuildBatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #buildBatch(BuildBatch)
         */
        default Builder buildBatch(Consumer<BuildBatch.Builder> buildBatch) {
            return buildBatch(BuildBatch.builder().applyMutation(buildBatch).build());
        }
    }

    static final class BuilderImpl extends CodeBuildResponse.BuilderImpl implements Builder {
        private BuildBatch buildBatch;

        private BuilderImpl() {
        }

        private BuilderImpl(StartBuildBatchResponse model) {
            super(model);
            buildBatch(model.buildBatch);
        }

        public final BuildBatch.Builder getBuildBatch() {
            return buildBatch != null ? buildBatch.toBuilder() : null;
        }

        public final void setBuildBatch(BuildBatch.BuilderImpl buildBatch) {
            this.buildBatch = buildBatch != null ? buildBatch.build() : null;
        }

        @Override
        @Transient
        public final Builder buildBatch(BuildBatch buildBatch) {
            this.buildBatch = buildBatch;
            return this;
        }

        @Override
        public StartBuildBatchResponse build() {
            return new StartBuildBatchResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
